/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.Rectangle2D;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3DNative;
import java.util.ArrayList;

public class Volume3D {
    private Layer3D m_layer;
    private double m_bottom = 0.0;
    private double m_top = 0.0;
    private Rectangle2D m_bounds = new Rectangle2D(0.0, 0.0, 0.0, 0.0);
    private ArrayList<String> m_fileNames = new ArrayList();

    Volume3D(Layer3D layer3d) {
        this.m_layer = layer3d;
    }

    public double get_bottom() {
        return this.m_bottom;
    }

    public void setBottom(double bottom) {
        long l = InternalHandle.getHandle(this.m_layer);
        Layer3DNative.jni_SetVolumeBottom(l, bottom);
        this.m_bottom = bottom;
    }

    public double getTop() {
        return this.m_top;
    }

    public void setTop(double top) {
        long l = InternalHandle.getHandle(this.m_layer);
        Layer3DNative.jni_SetVolumeTop(l, top);
        this.m_top = top;
    }

    public Rectangle2D getBounds() {
        return this.m_bounds;
    }

    public void setBounds(Rectangle2D bounds) {
        long l = InternalHandle.getHandle(this.m_layer);
        Layer3DNative.jni_SetVolumeBounds(l, bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop());
        this.m_bounds = bounds;
    }

    public ArrayList<String> getFileNames() {
        return this.m_fileNames;
    }

    public void setFileNames(ArrayList<String> fileNames) {
        long l = InternalHandle.getHandle(this.m_layer);
        String[] stringArray = new String[fileNames.size()];
        if (fileNames.size() > 0) {
            for (int i = 0; i < fileNames.size(); ++i) {
                stringArray[i] = fileNames.get(i);
            }
        }
        Layer3DNative.jni_SetVolumeFileNames(l, stringArray);
        this.m_fileNames = fileNames;
    }
}

