/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.realspace.spatialanalyst.BufferEndType;
import com.supermap.realspace.spatialanalyst.InternalResource;

public class BufferAnalyst3DParameter {
    private double m_bufferDistance;
    private BufferEndType m_bufferEndType;
    private int m_bufferQuality;

    public BufferAnalyst3DParameter() {
        this.m_bufferDistance = 0.0;
        this.m_bufferEndType = BufferEndType.ROUND;
        this.m_bufferQuality = 18;
    }

    public BufferAnalyst3DParameter(BufferAnalyst3DParameter bufferAnalyst3DParameter) {
        this.m_bufferDistance = bufferAnalyst3DParameter.getBufferDistance();
        this.m_bufferEndType = bufferAnalyst3DParameter.getEndType();
        this.m_bufferQuality = bufferAnalyst3DParameter.getBufferQuality();
    }

    public double getBufferDistance() {
        return this.m_bufferDistance;
    }

    public void setBufferDistance(double bufferDistance) {
        if (bufferDistance < 0.0) {
            String string = InternalResource.loadString("bufferDistance", "BufferDistanceShouldBeGreaterThanZero", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_bufferDistance = bufferDistance;
    }

    public BufferEndType getEndType() {
        return this.m_bufferEndType;
    }

    public void setEndType(BufferEndType bufferEndType) {
        if (bufferEndType == null) {
            String string = InternalResource.loadString("bufferEndType", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_bufferEndType = bufferEndType;
    }

    public int getBufferQuality() {
        return this.m_bufferQuality;
    }

    public void setBufferQuality(int bufferQuality) {
        if (bufferQuality < 4 || bufferQuality > 200) {
            String string = InternalResource.loadString("bufferQuality", "SegmentShoudNotSmallerThanFourorGreaterThanTwoHundred ", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_bufferQuality = bufferQuality;
    }
}

