/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.GeoLine3D;
import com.supermap.data.Geometry3D;
import com.supermap.data.GeometryType;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.data.PrjCoordSys;
import com.supermap.realspace.spatialanalyst.BufferAnalyst3DParameter;
import com.supermap.realspace.spatialanalyst.BufferEndType;
import com.supermap.realspace.spatialanalyst.Geometrist3DNative;
import com.supermap.realspace.spatialanalyst.InternalGeometry;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalHandleDisposable;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import java.util.ArrayList;

public class Geometrist3D {
    private static License m_license;

    private Geometrist3D() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static Geometry3D union(Geometry3D geometry3D, Geometry3D unionGeometry3D) {
        Geometrist3D.verifyLicense();
        if (null == geometry3D) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry3D);
        if (0L == l) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == unionGeometry3D) {
            String string = InternalResource.loadString("unionGeometry3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)unionGeometry3D);
        if (0L == l2) {
            String string = InternalResource.loadString("unionGeometry3D", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = geometry3D.getType();
        GeometryType geometryType2 = unionGeometry3D.getType();
        if (geometryType != GeometryType.GEOMODEL && geometryType != GeometryType.GEOSPHERE && geometryType != GeometryType.GEOHEMISPHERE && geometryType != GeometryType.GEOBOX && geometryType != GeometryType.GEOCYLINDER && geometryType != GeometryType.GEOCONE && geometryType != GeometryType.GEOPYRAMID && geometryType != GeometryType.GEOPIECYLINDER && geometryType != GeometryType.GEOELLIPSOID) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentTypeInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryType2 != GeometryType.GEOMODEL && geometryType2 != GeometryType.GEOSPHERE && geometryType2 != GeometryType.GEOHEMISPHERE && geometryType2 != GeometryType.GEOBOX && geometryType2 != GeometryType.GEOCYLINDER && geometryType2 != GeometryType.GEOCONE && geometryType2 != GeometryType.GEOPYRAMID && geometryType2 != GeometryType.GEOPIECYLINDER && geometryType2 != GeometryType.GEOELLIPSOID) {
            String string = InternalResource.loadString("unionGeometry3D", "Global_ArgumentTypeInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist3DNative.jni_IsClosed(l)) {
            String string = InternalResource.loadString("geometry3D", "PolyhedronNotClosed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist3DNative.jni_IsClosed(l2)) {
            String string = InternalResource.loadString("unionGeometry3D", "PolyhedronNotClosed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = Geometrist3DNative.jni_Union(l, l2);
        Geometry3D geometry3D2 = null;
        if (l3 != 0L) {
            geometry3D2 = (Geometry3D)InternalGeometry.createInstance(l3);
        }
        return geometry3D2;
    }

    public static Geometry3D intersect(Geometry3D geometry3D, Geometry3D intersectGeometry3D) {
        Geometrist3D.verifyLicense();
        if (null == geometry3D) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry3D);
        if (0L == l) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == intersectGeometry3D) {
            String string = InternalResource.loadString("intersectGeometry3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)intersectGeometry3D);
        if (0L == l2) {
            String string = InternalResource.loadString("intersectGeometry3D", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = geometry3D.getType();
        GeometryType geometryType2 = intersectGeometry3D.getType();
        if (geometryType != GeometryType.GEOMODEL && geometryType != GeometryType.GEOSPHERE && geometryType != GeometryType.GEOHEMISPHERE && geometryType != GeometryType.GEOBOX && geometryType != GeometryType.GEOCYLINDER && geometryType != GeometryType.GEOCONE && geometryType != GeometryType.GEOPYRAMID && geometryType != GeometryType.GEOPIECYLINDER && geometryType != GeometryType.GEOELLIPSOID) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentTypeInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryType2 != GeometryType.GEOMODEL && geometryType2 != GeometryType.GEOSPHERE && geometryType2 != GeometryType.GEOHEMISPHERE && geometryType2 != GeometryType.GEOBOX && geometryType2 != GeometryType.GEOCYLINDER && geometryType2 != GeometryType.GEOCONE && geometryType2 != GeometryType.GEOPYRAMID && geometryType2 != GeometryType.GEOPIECYLINDER && geometryType2 != GeometryType.GEOELLIPSOID) {
            String string = InternalResource.loadString("intersectGeometry3D", "Global_ArgumentTypeInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = Geometrist3DNative.jni_Intersect(l, l2);
        Geometry3D geometry3D2 = null;
        if (l3 != 0L) {
            geometry3D2 = (Geometry3D)InternalGeometry.createInstance(l3);
        }
        return geometry3D2;
    }

    public static Geometry3D erase(Geometry3D geometry3D, Geometry3D eraseGeometry3D) {
        Geometrist3D.verifyLicense();
        if (null == geometry3D) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry3D);
        if (0L == l) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == eraseGeometry3D) {
            String string = InternalResource.loadString("eraseGeometry3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)eraseGeometry3D);
        if (0L == l2) {
            String string = InternalResource.loadString("eraseGeometry3D", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = geometry3D.getType();
        GeometryType geometryType2 = eraseGeometry3D.getType();
        if (geometryType != GeometryType.GEOMODEL && geometryType != GeometryType.GEOSPHERE && geometryType != GeometryType.GEOHEMISPHERE && geometryType != GeometryType.GEOBOX && geometryType != GeometryType.GEOCYLINDER && geometryType != GeometryType.GEOCONE && geometryType != GeometryType.GEOPYRAMID && geometryType != GeometryType.GEOPIECYLINDER && geometryType != GeometryType.GEOELLIPSOID) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentTypeInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryType2 != GeometryType.GEOMODEL && geometryType2 != GeometryType.GEOSPHERE && geometryType2 != GeometryType.GEOHEMISPHERE && geometryType2 != GeometryType.GEOBOX && geometryType2 != GeometryType.GEOCYLINDER && geometryType2 != GeometryType.GEOCONE && geometryType2 != GeometryType.GEOPYRAMID && geometryType2 != GeometryType.GEOPIECYLINDER && geometryType2 != GeometryType.GEOELLIPSOID) {
            String string = InternalResource.loadString("eraseGeometry3D", "Global_ArgumentTypeInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist3DNative.jni_IsClosed(l)) {
            String string = InternalResource.loadString("geometry3D", "PolyhedronNotClosed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist3DNative.jni_IsClosed(l2)) {
            String string = InternalResource.loadString("eraseGeometry3D", "PolyhedronNotClosed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = Geometrist3DNative.jni_Erase(l, l2);
        Geometry3D geometry3D2 = null;
        if (l3 != 0L) {
            geometry3D2 = (Geometry3D)InternalGeometry.createInstance(l3);
        }
        return geometry3D2;
    }

    public static Geometry3D xOR(Geometry3D geometry3D, Geometry3D xorGeometry3D) {
        Geometrist3D.verifyLicense();
        if (null == geometry3D) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry3D);
        if (0L == l) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == xorGeometry3D) {
            String string = InternalResource.loadString("xorGeometry3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)xorGeometry3D);
        if (0L == l2) {
            String string = InternalResource.loadString("xorGeometry3D", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = geometry3D.getType();
        GeometryType geometryType2 = xorGeometry3D.getType();
        if (geometryType != GeometryType.GEOMODEL && geometryType != GeometryType.GEOSPHERE && geometryType != GeometryType.GEOHEMISPHERE && geometryType != GeometryType.GEOBOX && geometryType != GeometryType.GEOCYLINDER && geometryType != GeometryType.GEOCONE && geometryType != GeometryType.GEOPYRAMID && geometryType != GeometryType.GEOPIECYLINDER && geometryType != GeometryType.GEOELLIPSOID) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentTypeInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryType2 != GeometryType.GEOMODEL && geometryType2 != GeometryType.GEOSPHERE && geometryType2 != GeometryType.GEOHEMISPHERE && geometryType2 != GeometryType.GEOBOX && geometryType2 != GeometryType.GEOCYLINDER && geometryType2 != GeometryType.GEOCONE && geometryType2 != GeometryType.GEOPYRAMID && geometryType2 != GeometryType.GEOPIECYLINDER && geometryType2 != GeometryType.GEOELLIPSOID) {
            String string = InternalResource.loadString("xorGeometry3D", "Global_ArgumentTypeInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist3DNative.jni_IsClosed(l)) {
            String string = InternalResource.loadString("geometry3D", "PolyhedronNotClosed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist3DNative.jni_IsClosed(l2)) {
            String string = InternalResource.loadString("xorGeometry3D", "PolyhedronNotClosed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = Geometrist3DNative.jni_XOR(l, l2);
        Geometry3D geometry3D2 = null;
        if (l3 != 0L) {
            geometry3D2 = (Geometry3D)InternalGeometry.createInstance(l3);
        }
        return geometry3D2;
    }

    private static boolean canContain(Geometry3D geometry3D, Geometry3D containGeometry3D) {
        Geometrist3D.verifyLicense();
        if (null == geometry3D) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry3D);
        if (0L == l) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == containGeometry3D) {
            String string = InternalResource.loadString("containGeometry3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)containGeometry3D);
        if (0L == l2) {
            String string = InternalResource.loadString("containGeometry3D", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = geometry3D.getType();
        GeometryType geometryType2 = containGeometry3D.getType();
        if (geometryType != GeometryType.GEOMODEL && geometryType != GeometryType.GEOSPHERE && geometryType != GeometryType.GEOHEMISPHERE && geometryType != GeometryType.GEOBOX && geometryType != GeometryType.GEOCYLINDER && geometryType != GeometryType.GEOCONE && geometryType != GeometryType.GEOPYRAMID && geometryType != GeometryType.GEOPIECYLINDER && geometryType != GeometryType.GEOELLIPSOID) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentTypeInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryType2 != GeometryType.GEOMODEL && geometryType2 != GeometryType.GEOSPHERE && geometryType2 != GeometryType.GEOHEMISPHERE && geometryType2 != GeometryType.GEOBOX && geometryType2 != GeometryType.GEOCYLINDER && geometryType2 != GeometryType.GEOCONE && geometryType2 != GeometryType.GEOPYRAMID && geometryType2 != GeometryType.GEOPIECYLINDER && geometryType2 != GeometryType.GEOELLIPSOID) {
            String string = InternalResource.loadString("containGeometry3D", "Global_ArgumentTypeInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist3DNative.jni_IsClosed(l)) {
            String string = InternalResource.loadString("geometry3D", "PolyhedronNotClosed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist3DNative.jni_IsClosed(l2)) {
            String string = InternalResource.loadString("containGeometry3D", "PolyhedronNotClosed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = Geometrist3DNative.jni_CanContain(l, l2);
        return bl;
    }

    public static boolean hasIntersection(Geometry3D geometry3D, Geometry3D intersectGeometry3D) {
        Geometrist3D.verifyLicense();
        if (null == geometry3D) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry3D);
        if (0L == l) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == intersectGeometry3D) {
            String string = InternalResource.loadString("intersectGeometry3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)intersectGeometry3D);
        if (0L == l2) {
            String string = InternalResource.loadString("intersectGeometry3D", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = geometry3D.getType();
        GeometryType geometryType2 = intersectGeometry3D.getType();
        long l3 = 0L;
        long l4 = 0L;
        if (geometryType == GeometryType.GEOLINE3D) {
            l3 = l;
            l4 = l2;
        } else if (geometryType != GeometryType.GEOMODEL && geometryType != GeometryType.GEOSPHERE && geometryType != GeometryType.GEOHEMISPHERE && geometryType != GeometryType.GEOBOX && geometryType != GeometryType.GEOCYLINDER && geometryType != GeometryType.GEOCONE && geometryType != GeometryType.GEOPYRAMID && geometryType != GeometryType.GEOPIECYLINDER && geometryType != GeometryType.GEOELLIPSOID) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentTypeInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryType2 == GeometryType.GEOLINE3D) {
            if (l3 != 0L) {
                String string = InternalResource.loadString("geometry3D or intersectGeometry3D", "Global_ArgumentTypeInvalid", "spatialanalyst3d_resources");
                throw new IllegalArgumentException(string);
            }
            l3 = l2;
            l4 = l;
        } else if (geometryType2 != GeometryType.GEOMODEL && geometryType2 != GeometryType.GEOSPHERE && geometryType2 != GeometryType.GEOHEMISPHERE && geometryType2 != GeometryType.GEOBOX && geometryType2 != GeometryType.GEOCYLINDER && geometryType2 != GeometryType.GEOCONE && geometryType2 != GeometryType.GEOPYRAMID && geometryType2 != GeometryType.GEOPIECYLINDER && geometryType2 != GeometryType.GEOELLIPSOID) {
            String string = InternalResource.loadString("intersectGeometry3D", "Global_ArgumentTypeInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = l3 == 0L ? Geometrist3DNative.jni_HasIntersection(l, l2) : Geometrist3DNative.jni_HasIntersection(l4, l3);
        return bl;
    }

    public static Geometry3D resample(Geometry3D geometry, double tolerance, PrjCoordSys prjCoordsys) {
        Geometrist3D.verifyLicense();
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance <= 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ToleranceShouldGreaterThanZero", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() != GeometryType.GEOLINE3D) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (prjCoordsys != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)prjCoordsys);
        }
        long l3 = Geometrist3DNative.jni_Resample(l, tolerance, l2);
        Geometry3D geometry3D = null;
        if (l3 != 0L) {
            geometry3D = (Geometry3D)InternalGeometry.createInstance(l3);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        return geometry3D;
    }

    public static Point3Ds smooth(Point3Ds points, int smoothness, PrjCoordSys prjCoordsys) {
        Geometrist3D.verifyLicense();
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (points.getCount() < 4) {
            String string = InternalResource.loadString("points", "Geometrist_SmoothPointsCountShouldNotSmallThanFour", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (smoothness < 2) {
            String string = InternalResource.loadString("smoothness", "Global_ArgumentShouldNotSmallerThanTwo", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (prjCoordsys != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)prjCoordsys);
        }
        GeoLine3D geoLine3D = new GeoLine3D(points);
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoLine3D, true);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLine3D);
        long l3 = Geometrist3DNative.jni_Smooth(l2, smoothness, l);
        Point3Ds point3Ds = null;
        if (l3 != 0L) {
            GeoLine3D geoLine3D2 = (GeoLine3D)InternalGeometry.createInstance(l3);
            int n = geoLine3D2.getPart(0).getCount();
            Point3D[] point3DArray = new Point3D[n];
            for (int i = 0; i < n; ++i) {
                Point3D point3D;
                point3DArray[i] = point3D = geoLine3D2.getPart(0).getItem(i);
            }
            point3Ds = new Point3Ds(point3DArray);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoLine3D2, true);
            geoLine3D2.dispose();
        }
        return point3Ds;
    }

    public static Geometry3D createBuffer(Geometry3D geometry, BufferAnalyst3DParameter bufferAnalyst3DParameter, PrjCoordSys prjCoordSys) {
        Geometrist3D.verifyLicense();
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        GeometryType geometryType = geometry.getType();
        if (geometryType != GeometryType.GEOPOINT3D && geometryType != GeometryType.GEOLINE3D) {
            String string = InternalResource.loadString("geometry", "UnsupportedGeometryType", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)prjCoordSys);
        if (l2 == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (bufferAnalyst3DParameter == null) {
            String string = InternalResource.loadString("bufferAnalyst3DParameter", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        double d = bufferAnalyst3DParameter.getBufferDistance();
        if (d <= 0.0) {
            String string = InternalResource.loadString("bufferAnalyst3DParameter.bufferDistance", "BufferDistanceShouldBeGreaterThanZero", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        int n = bufferAnalyst3DParameter.getBufferQuality();
        if (n < 4 || n > 200) {
            String string = InternalResource.loadString("bufferAnalyst3DParameter.bufferQuality", "SegmentShoudNotSmallerThanFourorGreaterThanTwoHundred ", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = 0;
        if (bufferAnalyst3DParameter.getEndType() == BufferEndType.ROUND) {
            n2 = 1;
        } else if (bufferAnalyst3DParameter.getEndType() == BufferEndType.FLAT) {
            n2 = 2;
        }
        long l3 = Geometrist3DNative.jni_CreateBuffer(l, d, n2, n, l2);
        Geometry3D geometry3D = null;
        if (l3 != 0L) {
            geometry3D = (Geometry3D)InternalGeometry.createInstance(l3);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)prjCoordSys);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)bufferAnalyst3DParameter);
        return geometry3D;
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

