/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.CellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.data.DatasetGrid;
import java.util.ArrayList;
import java.util.Map;

public class MCECellularAutomataParameter {
    private ArrayList[] m_AHPComparisonMatrix;
    private int m_nAlpha;
    private double m_dGlobalValue;
    private double m_dLocalValue;
    private Map<Integer, Boolean> m_arrConversionRule;
    private int m_dConversionTarget;
    private boolean m_bCheckResult;
    private DatasetGrid m_EndCellGrid;
    CellularAutomataParameter m_CellularAutomataParameter;

    public MCECellularAutomataParameter() {
        this.m_nAlpha = 2;
        this.m_dGlobalValue = 0.5;
        this.m_dLocalValue = 0.5;
        this.m_arrConversionRule = null;
        this.m_bCheckResult = false;
        this.m_EndCellGrid = null;
        this.m_CellularAutomataParameter = null;
    }

    public MCECellularAutomataParameter(MCECellularAutomataParameter para) {
        this.m_AHPComparisonMatrix = para.m_AHPComparisonMatrix;
        this.m_nAlpha = para.m_nAlpha;
        this.m_dGlobalValue = para.m_dGlobalValue;
        this.m_dLocalValue = para.m_dLocalValue;
        this.m_arrConversionRule = para.m_arrConversionRule;
        this.m_dConversionTarget = para.m_dConversionTarget;
        this.m_bCheckResult = para.m_bCheckResult;
        this.m_EndCellGrid = para.m_EndCellGrid;
        if (this.m_CellularAutomataParameter == null) {
            this.m_CellularAutomataParameter = new CellularAutomataParameter();
        }
        this.m_CellularAutomataParameter.Reset(para.m_CellularAutomataParameter);
    }

    public CellularAutomataParameter getCellularAutomataParameter() {
        return this.m_CellularAutomataParameter;
    }

    public void setCellularAutomataParameter(CellularAutomataParameter value) {
        if (value == null) {
            String string = InternalResource.loadString("CellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_CellularAutomataParameter == null) {
            this.m_CellularAutomataParameter = new CellularAutomataParameter();
        }
        this.m_CellularAutomataParameter.Reset(value);
    }

    public boolean isCheckResult() {
        return this.m_bCheckResult;
    }

    public void setCheckResult(boolean value) {
        this.m_bCheckResult = value;
    }

    public DatasetGrid getEndCellGrid() {
        return this.m_EndCellGrid;
    }

    public void setEndCellGrid(DatasetGrid value) {
        if (value == null) {
            String string = InternalResource.loadString("EndCellGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_EndCellGrid = value;
    }

    public double[][] getAHPComparisonMatrix() {
        if (this.m_AHPComparisonMatrix == null) {
            return null;
        }
        int n = this.m_AHPComparisonMatrix.length;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            double[] dArray = new double[n];
            for (int j = 0; j < n; ++j) {
                dArray[j] = (Double)this.m_AHPComparisonMatrix[i].get(j);
            }
            dArrayArray[i] = dArray;
        }
        return dArrayArray;
    }

    public void setAHPComparisonMatrix(double[][] value) {
        int n;
        int n2;
        if (value == null || value.length == 0) {
            String string = InternalResource.loadString("AHPComparisonMatrix", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (n2 = 0; n2 < value.length; ++n2) {
            if (value[n2] == null) {
                String string = InternalResource.loadString("AHPComparisonMatrix[" + n2 + "]", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (value.length == value[n2].length) continue;
            String string = InternalResource.loadString("AHPComparisonMatrix[" + n2 + "].length and AHPComparisonMatrix.length must be the same length.", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        n2 = value.length;
        if (this.m_AHPComparisonMatrix != null) {
            for (n = 0; n < this.m_AHPComparisonMatrix.length; ++n) {
                this.m_AHPComparisonMatrix[n].clear();
            }
        } else {
            this.m_AHPComparisonMatrix = new ArrayList[n2];
            for (n = 0; n < n2; ++n) {
                this.m_AHPComparisonMatrix[n] = new ArrayList();
            }
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                this.m_AHPComparisonMatrix[n].add(value[n][i]);
            }
        }
    }

    public double getGlobalValue() {
        return this.m_dGlobalValue;
    }

    public void setGlobalValue(double value) {
        if (value <= 0.0 || value >= 1.0) {
            String string = InternalResource.loadString("GlobalValue", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dGlobalValue = value;
    }

    public double getLocalValue() {
        return this.m_dLocalValue;
    }

    public void setLocalValue(double value) {
        if (value <= 0.0 || value >= 1.0) {
            String string = InternalResource.loadString("LocalValue", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dLocalValue = value;
    }

    public int getAlpha() {
        return this.m_nAlpha;
    }

    public void setAlpha(int value) {
        if (value <= 0 || value > 10) {
            String string = InternalResource.loadString("Alpha", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nAlpha = value;
    }

    public Map<Integer, Boolean> getConversionRules() {
        return this.m_arrConversionRule;
    }

    public void setConversionRules(Map<Integer, Boolean> value) {
        if (value == null || value.size() == 0) {
            String string = InternalResource.loadString("ConversionRules", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (Integer n : value.keySet()) {
            if (n != null && value.get(n) != null) continue;
            String string = InternalResource.loadString("ConversionRules key or value", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_arrConversionRule = value;
    }

    public int getConversionTarget() {
        return this.m_dConversionTarget;
    }

    public void setConversionTarget(int value) {
        this.m_dConversionTarget = value;
    }
}

