/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetImage;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.RasterJoinPixelFormat;
import com.supermap.analyst.spatialanalyst.RasterJoinType;
import com.supermap.analyst.spatialanalyst.RasterMosaicNative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetType;
import com.supermap.data.Datasource;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class RasterMosaic {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private RasterMosaic() {
    }

    public static Dataset mosaic(Dataset[] sourceDatasets, double backOrNoValue, double backTolerance, RasterJoinType rasterJoinMethod, RasterJoinPixelFormat rasterJoinPixelFormatType, double cellSize, EncodeType encodeType, Rectangle2D validRect, Datasource targetDatasource, String targetDatasetName) {
        int n;
        RasterMosaic.verifyLicense();
        if (sourceDatasets == null) {
            String string = InternalResource.loadString("sourceDatasets", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceDatasets.length < 2) {
            String string = InternalResource.loadString("sourceDatasets", "DatasetsCountLessThanTwo", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[sourceDatasets.length];
        for (n = 0; n < sourceDatasets.length; ++n) {
            if (sourceDatasets[n] == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasets[n]) == 0L) {
                String string = InternalResource.loadString("sourceDatasets", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasets[n]);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        n = InternalEnum.getUGCValue(rasterJoinMethod);
        int n2 = InternalEnum.getUGCValue(rasterJoinPixelFormatType);
        int n3 = InternalEnum.getUGCValue((Enum)encodeType);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        double[] dArray = new double[]{validRect.getLeft(), validRect.getRight(), validRect.getTop(), validRect.getBottom()};
        long l2 = RasterMosaicNative.jni_Mosaic(lArray, backOrNoValue, backTolerance, n, n2, cellSize, n3, dArray, l, targetDatasetName);
        if (l2 != 0L) {
            if (sourceDatasets[0].getType() == DatasetType.IMAGE) {
                DatasetImage datasetImage = InternalDatasetImage.createInstance(l2, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetImage);
                return datasetImage;
            }
            DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(l2, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            return datasetGrid;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "RasterMosaic";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        RasterMosaic.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

