/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalGeometry;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.IsoLineResult;
import com.supermap.analyst.spatialanalyst.IsoRegionResult;
import com.supermap.analyst.spatialanalyst.SurfaceAnalystNative;
import com.supermap.analyst.spatialanalyst.SurfaceExtractParameter;
import com.supermap.analyst.spatialanalyst.TerrainInterpolateType;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.Point2D;
import com.supermap.data.Point3Ds;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class SurfaceAnalyst {
    private static transient Vector m_steppedListeners;
    private static License m_license;

    private SurfaceAnalyst() {
    }

    public static DatasetVector extractIsoregion(SurfaceExtractParameter parameter, DatasetGrid extractedGrid, Datasource targetDatasource, String targetDatasetName, GeoRegion clipRegion) {
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedGrid) == 0L) {
            String string = InternalResource.loadString("extractedGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedGrid.getHeight() * extractedGrid.getWidth() > 400000000) {
            String string = InternalResource.loadString("GridDatasetIsTooLarge", "GridDatasetIsTooLarge", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedGrid);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l4 = 0L;
        l4 = parameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsoRegionWithOutZ(l2, l, l3, targetDatasetName, parameter.getInterval(), parameter.getDatumValue(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsoRegionWithZ(l2, l, l3, targetDatasetName, parameter.getExpectedZValues(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static IsoRegionResult[] extractIsoregionGeometry(SurfaceExtractParameter parameter, DatasetGrid extractedGrid, GeoRegion clipRegion) {
        int n;
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedGrid) == 0L) {
            String string = InternalResource.loadString("extractedGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedGrid.getHeight() * extractedGrid.getWidth() > 400000000) {
            String string = InternalResource.loadString("GridDatasetIsTooLarge", "GridDatasetIsTooLarge", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedGrid);
        long[] lArray = SurfaceAnalystNative.jni_ExtractIsoRegionGeometry(l2, l, parameter.getInterval(), parameter.getDatumValue(), parameter.getResampleTolerance(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        if (lArray == null) {
            return new IsoRegionResult[0];
        }
        int n2 = lArray.length - 1;
        GeoRegion[] geoRegionArray = new GeoRegion[n2];
        GeoLine geoLine = new GeoLine();
        for (n = 0; n < n2; ++n) {
            geoRegionArray[n] = (GeoRegion)InternalGeometry.createInstance(lArray[n]);
        }
        geoLine = (GeoLine)InternalGeometry.createInstance(lArray[n2]);
        n = geoLine.getPart(0).getCount();
        Point2D[] point2DArray = new Point2D[n2];
        for (int i = 0; i < n; ++i) {
            point2DArray[i] = geoLine.getPart(0).getItem(i);
        }
        geoLine.dispose();
        IsoRegionResult[] isoRegionResultArray = new IsoRegionResult[n2];
        for (int i = 0; i < n2; ++i) {
            IsoRegionResult isoRegionResult;
            isoRegionResultArray[i] = isoRegionResult = new IsoRegionResult(point2DArray[i].getX(), point2DArray[i].getY(), geoRegionArray[i]);
        }
        return isoRegionResultArray;
    }

    public static IsoLineResult[] extractIsolineGeometry(SurfaceExtractParameter parameter, DatasetGrid extractedGrid, GeoRegion clipRegion) {
        int n;
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedGrid) == 0L) {
            String string = InternalResource.loadString("extractedGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedGrid.getHeight() * extractedGrid.getWidth() > 400000000) {
            String string = InternalResource.loadString("GridDatasetIsTooLarge", "GridDatasetIsTooLarge", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedGrid);
        long[] lArray = SurfaceAnalystNative.jni_ExtractIsoLineGeometry(l2, l, parameter.getInterval(), parameter.getDatumValue(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        if (lArray == null) {
            return new IsoLineResult[0];
        }
        int n2 = lArray.length - 1;
        GeoLine[] geoLineArray = new GeoLine[n2];
        GeoLine geoLine = new GeoLine();
        for (n = 0; n < n2; ++n) {
            geoLineArray[n] = (GeoLine)InternalGeometry.createInstance(lArray[n]);
        }
        geoLine = (GeoLine)InternalGeometry.createInstance(lArray[n2]);
        n = geoLine.getPart(0).getCount();
        Point2D[] point2DArray = new Point2D[n2];
        for (int i = 0; i < n; ++i) {
            point2DArray[i] = geoLine.getPart(0).getItem(i);
        }
        geoLine.dispose();
        IsoLineResult[] isoLineResultArray = new IsoLineResult[n2];
        for (int i = 0; i < n2; ++i) {
            IsoLineResult isoLineResult;
            isoLineResultArray[i] = isoLineResult = new IsoLineResult(point2DArray[i].getX(), geoLineArray[i]);
        }
        return isoLineResultArray;
    }

    public static GeoRegion[] extractIsoregion(SurfaceExtractParameter parameter, DatasetGrid extractedGrid, GeoRegion clipRegion) {
        String string;
        if (parameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (extractedGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedGrid) == 0L) {
            String string3 = InternalResource.loadString("extractedGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (extractedGrid.getHeight() * extractedGrid.getWidth() > 400000000) {
            String string4 = InternalResource.loadString("GridDatasetIsTooLarge", "GridDatasetIsTooLarge", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        Datasource datasource = extractedGrid.getDatasource();
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoregion(parameter, extractedGrid, datasource, string = extractedGrid.getDatasource().getDatasets().getAvailableDatasetName("tempDataset"), clipRegion);
        if (datasetVector == null) {
            return new GeoRegion[0];
        }
        ArrayList<GeoRegion> arrayList = new ArrayList<GeoRegion>();
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        while (!recordset.isEOF()) {
            GeoRegion geoRegion = (GeoRegion)recordset.getGeometry();
            arrayList.add(geoRegion);
            recordset.moveNext();
        }
        int n = arrayList.size();
        GeoRegion[] geoRegionArray = new GeoRegion[n];
        for (int i = 0; i < n; ++i) {
            geoRegionArray[i] = (GeoRegion)arrayList.get(i);
        }
        recordset.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoRegionArray;
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter parameter, DatasetGrid extractedGrid, Datasource targetDatasource, String targetDatasetName) {
        return SurfaceAnalyst.extractIsoline(parameter, extractedGrid, targetDatasource, targetDatasetName, null);
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter parameter, DatasetGrid extractedGrid, Datasource targetDatasource, String targetDatasetName, GeoRegion clipRegion) {
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedGrid) == 0L) {
            String string = InternalResource.loadString("extractedGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedGrid);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l4 = 0L;
        l4 = parameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsoline1(l2, l, l3, targetDatasetName, parameter.getInterval(), parameter.getDatumValue(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsoline2(l2, l, l3, targetDatasetName, parameter.getExpectedZValues(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter parameter, DatasetVector extractedPoint, String zValueFieldName, Datasource targetDatasource, String targetDatasetName, double resolution, GeoRegion clipRegion) {
        if (extractedPoint == null) {
            String string = InternalResource.loadString("extractedPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        Recordset recordset = extractedPoint.getRecordset(false, CursorType.STATIC);
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoline(parameter, recordset, zValueFieldName, targetDatasource, targetDatasetName, resolution, clipRegion);
        recordset.dispose();
        return datasetVector;
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter parameter, DatasetVector extractedPoint, String zValueFieldName, TerrainInterpolateType terrainInterpolateType, Datasource targetDatasource, String targetDatasetName, double resolution, GeoRegion clipRegion) {
        if (extractedPoint == null) {
            String string = InternalResource.loadString("extractedPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        Recordset recordset = extractedPoint.getRecordset(false, CursorType.STATIC);
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoline(parameter, recordset, zValueFieldName, terrainInterpolateType, targetDatasource, targetDatasetName, resolution, clipRegion);
        recordset.dispose();
        return datasetVector;
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter parameter, Recordset extractedPointRecordset, String zValueFieldName, Datasource targetDatasource, String targetDatasetName, double resolution, GeoRegion clipRegion) {
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedPointRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedPointRecordset) == 0L) {
            String string = InternalResource.loadString("extractedPointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!extractedPointRecordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string = InternalResource.loadString("extractedPointRecordset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (extractedPointRecordset.getFieldInfos().indexOf(zValueFieldName) == -1) {
            String string = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resolution <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SurfaceAnalyst.verifyResolution(resolution, extractedPointRecordset.getBounds());
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedPointRecordset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l4 = 0L;
        int n = InternalEnum.getUGCValue(TerrainInterpolateType.IDW);
        l4 = parameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineByPoint1(l2, zValueFieldName, n, l, resolution, parameter.getInterval(), parameter.getDatumValue(), l3, targetDatasetName, parameter.getResampleTolerance(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod())) : SurfaceAnalystNative.jni_ExtractIsolineByPoint2(l2, zValueFieldName, n, l, resolution, parameter.getExpectedZValues(), l3, targetDatasetName, parameter.getResampleTolerance(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)extractedPointRecordset);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter parameter, Recordset extractedPointRecordset, String zValueFieldName, TerrainInterpolateType terrainInterpolateType, Datasource targetDatasource, String targetDatasetName, double resolution, GeoRegion clipRegion) {
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedPointRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedPointRecordset) == 0L) {
            String string = InternalResource.loadString("extractedPointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!extractedPointRecordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string = InternalResource.loadString("extractedPointRecordset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (extractedPointRecordset.getFieldInfos().indexOf(zValueFieldName) == -1) {
            String string = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resolution <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SurfaceAnalyst.verifyResolution(resolution, extractedPointRecordset.getBounds());
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedPointRecordset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l4 = 0L;
        int n = InternalEnum.getUGCValue(terrainInterpolateType);
        l4 = parameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineByPoint1(l2, zValueFieldName, n, l, resolution, parameter.getInterval(), parameter.getDatumValue(), l3, targetDatasetName, parameter.getResampleTolerance(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod())) : SurfaceAnalystNative.jni_ExtractIsolineByPoint2(l2, zValueFieldName, n, l, resolution, parameter.getExpectedZValues(), l3, targetDatasetName, parameter.getResampleTolerance(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)extractedPointRecordset);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter parameter, Point3Ds extractedPoints, Datasource targetDatasource, String targetDatasetName, double resolution, GeoRegion clipRegion) {
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedPoints == null || extractedPoints.getCount() == 0) {
            String string = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resolution <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = 0L;
        int n = extractedPoints.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = extractedPoints.getItem(i).getX();
            dArray2[i] = extractedPoints.getItem(i).getY();
            dArray3[i] = extractedPoints.getItem(i).getZ();
        }
        double d = dArray[0];
        double d2 = dArray[0];
        double d3 = dArray2[0];
        double d4 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d = d <= dArray[i] ? d : dArray[i];
            d2 = d2 >= dArray[i] ? d2 : dArray[i];
            d3 = d3 <= dArray2[i] ? d3 : dArray2[i];
            d4 = d4 >= dArray2[i] ? d4 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d, d3, d2, d4);
        SurfaceAnalyst.verifyResolution(resolution, rectangle2D);
        int n2 = InternalEnum.getUGCValue(TerrainInterpolateType.IDW);
        l3 = parameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineByPoint3D1(dArray, dArray2, dArray3, n2, l, l2, targetDatasetName, resolution, parameter.getInterval(), parameter.getDatumValue(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsolineByPoint3D2(dArray, dArray2, dArray3, n2, l, l2, targetDatasetName, resolution, parameter.getExpectedZValues(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter parameter, Point3Ds extractedPoints, TerrainInterpolateType terrainInterpolateType, Datasource targetDatasource, String targetDatasetName, double resolution, GeoRegion clipRegion) {
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedPoints == null || extractedPoints.getCount() == 0) {
            String string = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resolution <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = 0L;
        int n = extractedPoints.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = extractedPoints.getItem(i).getX();
            dArray2[i] = extractedPoints.getItem(i).getY();
            dArray3[i] = extractedPoints.getItem(i).getZ();
        }
        double d = dArray[0];
        double d2 = dArray[0];
        double d3 = dArray2[0];
        double d4 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d = d <= dArray[i] ? d : dArray[i];
            d2 = d2 >= dArray[i] ? d2 : dArray[i];
            d3 = d3 <= dArray2[i] ? d3 : dArray2[i];
            d4 = d4 >= dArray2[i] ? d4 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d, d3, d2, d4);
        SurfaceAnalyst.verifyResolution(resolution, rectangle2D);
        int n2 = InternalEnum.getUGCValue(terrainInterpolateType);
        l3 = parameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineByPoint3D1(dArray, dArray2, dArray3, n2, l, l2, targetDatasetName, resolution, parameter.getInterval(), parameter.getDatumValue(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsolineByPoint3D2(dArray, dArray2, dArray3, n2, l, l2, targetDatasetName, resolution, parameter.getExpectedZValues(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector extractIsoregion(SurfaceExtractParameter parameter, Point3Ds extractedPoints, Datasource targetDatasource, String targetDatasetName, double resolution, GeoRegion clipRegion) {
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedPoints == null || extractedPoints.getCount() == 0) {
            String string = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resolution <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = 0L;
        int n = extractedPoints.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = extractedPoints.getItem(i).getX();
            dArray2[i] = extractedPoints.getItem(i).getY();
            dArray3[i] = extractedPoints.getItem(i).getZ();
        }
        double d = dArray[0];
        double d2 = dArray[0];
        double d3 = dArray2[0];
        double d4 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d = d <= dArray[i] ? d : dArray[i];
            d2 = d2 >= dArray[i] ? d2 : dArray[i];
            d3 = d3 <= dArray2[i] ? d3 : dArray2[i];
            d4 = d4 >= dArray2[i] ? d4 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d, d3, d2, d4);
        SurfaceAnalyst.verifyResolution(resolution, rectangle2D);
        int n2 = InternalEnum.getUGCValue(TerrainInterpolateType.IDW);
        l3 = parameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsoregionByPoint3D(dArray, dArray2, dArray3, n2, l, l2, targetDatasetName, resolution, parameter.getInterval(), parameter.getDatumValue(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsoregionByPoint3DWithZ(dArray, dArray2, dArray3, n2, l, l2, targetDatasetName, resolution, parameter.getExpectedZValues(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector extractIsoregion(SurfaceExtractParameter parameter, Point3Ds extractedPoints, TerrainInterpolateType terrainInterpolateType, Datasource targetDatasource, String targetDatasetName, double resolution, GeoRegion clipRegion) {
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedPoints == null || extractedPoints.getCount() == 0) {
            String string = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resolution <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = 0L;
        int n = extractedPoints.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = extractedPoints.getItem(i).getX();
            dArray2[i] = extractedPoints.getItem(i).getY();
            dArray3[i] = extractedPoints.getItem(i).getZ();
        }
        double d = dArray[0];
        double d2 = dArray[0];
        double d3 = dArray2[0];
        double d4 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d = d <= dArray[i] ? d : dArray[i];
            d2 = d2 >= dArray[i] ? d2 : dArray[i];
            d3 = d3 <= dArray2[i] ? d3 : dArray2[i];
            d4 = d4 >= dArray2[i] ? d4 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d, d3, d2, d4);
        SurfaceAnalyst.verifyResolution(resolution, rectangle2D);
        int n2 = InternalEnum.getUGCValue(terrainInterpolateType);
        l3 = parameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsoregionByPoint3D(dArray, dArray2, dArray3, n2, l, l2, targetDatasetName, resolution, parameter.getInterval(), parameter.getDatumValue(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsoregionByPoint3DWithZ(dArray, dArray2, dArray3, n2, l, l2, targetDatasetName, resolution, parameter.getExpectedZValues(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector extractIsoregion(SurfaceExtractParameter parameter, DatasetVector extractedPoint, String zValueFieldName, Datasource targetDatasource, String targetDatasetName, double resolution, GeoRegion clipRegion) {
        Recordset recordset = extractedPoint.getRecordset(false, CursorType.STATIC);
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoregion(parameter, recordset, zValueFieldName, targetDatasource, targetDatasetName, resolution, clipRegion);
        recordset.dispose();
        return datasetVector;
    }

    public static DatasetVector extractIsoregion(SurfaceExtractParameter parameter, DatasetVector extractedPoint, String zValueFieldName, TerrainInterpolateType terrainInterpolateType, Datasource targetDatasource, String targetDatasetName, double resolution, GeoRegion clipRegion) {
        Recordset recordset = extractedPoint.getRecordset(false, CursorType.STATIC);
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoregion(parameter, recordset, zValueFieldName, terrainInterpolateType, targetDatasource, targetDatasetName, resolution, clipRegion);
        recordset.dispose();
        return datasetVector;
    }

    public static DatasetVector extractIsoregion(SurfaceExtractParameter parameter, Recordset extractedPointRecordset, String zValueFieldName, Datasource targetDatasource, String targetDatasetName, double resolution, GeoRegion clipRegion) {
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedPointRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedPointRecordset) == 0L) {
            String string = InternalResource.loadString("extractedPointRecrodset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedPointRecordset.getFieldInfos().indexOf(zValueFieldName) == -1) {
            String string = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVector datasetVector = extractedPointRecordset.getDataset();
        if (!datasetVector.getType().equals((Object)DatasetType.POINT)) {
            String string = InternalResource.loadString("extractedPointRecrodset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resolution <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SurfaceAnalyst.verifyResolution(resolution, extractedPointRecordset.getBounds());
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedPointRecordset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        int n = InternalEnum.getUGCValue(TerrainInterpolateType.IDW);
        long l4 = parameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsoregion(l2, zValueFieldName, n, l, resolution, parameter.getInterval(), parameter.getDatumValue(), l3, targetDatasetName, parameter.getResampleTolerance(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod())) : SurfaceAnalystNative.jni_ExtractIsoRegionByRsWithZ(l2, zValueFieldName, n, l, resolution, parameter.getExpectedZValues(), l3, targetDatasetName, parameter.getResampleTolerance(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)extractedPointRecordset);
        DatasetVector datasetVector2 = null;
        if (l4 != 0L) {
            datasetVector2 = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector2);
        }
        return datasetVector2;
    }

    public static DatasetVector extractIsoregion(SurfaceExtractParameter parameter, Recordset extractedPointRecordset, String zValueFieldName, TerrainInterpolateType terrainInterpolateType, Datasource targetDatasource, String targetDatasetName, double resolution, GeoRegion clipRegion) {
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedPointRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedPointRecordset) == 0L) {
            String string = InternalResource.loadString("extractedPointRecrodset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedPointRecordset.getFieldInfos().indexOf(zValueFieldName) == -1) {
            String string = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVector datasetVector = extractedPointRecordset.getDataset();
        if (!datasetVector.getType().equals((Object)DatasetType.POINT)) {
            String string = InternalResource.loadString("extractedPointRecrodset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resolution <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SurfaceAnalyst.verifyResolution(resolution, extractedPointRecordset.getBounds());
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedPointRecordset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        int n = InternalEnum.getUGCValue(terrainInterpolateType);
        long l4 = parameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsoregion(l2, zValueFieldName, n, l, resolution, parameter.getInterval(), parameter.getDatumValue(), l3, targetDatasetName, parameter.getResampleTolerance(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod())) : SurfaceAnalystNative.jni_ExtractIsoRegionByRsWithZ(l2, zValueFieldName, n, l, resolution, parameter.getExpectedZValues(), l3, targetDatasetName, parameter.getResampleTolerance(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)extractedPointRecordset);
        DatasetVector datasetVector2 = null;
        if (l4 != 0L) {
            datasetVector2 = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector2);
        }
        return datasetVector2;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter parameter, DatasetGrid extractedGrid) {
        String string;
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (extractedGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedGrid) == 0L) {
            String string3 = InternalResource.loadString("extractedGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        Datasource datasource = extractedGrid.getDatasource();
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoline(parameter, extractedGrid, datasource, string = extractedGrid.getDatasource().getDatasets().getAvailableDatasetName("tempDataset"));
        if (datasetVector == null) {
            return new GeoLine[0];
        }
        ArrayList<GeoLine> arrayList = new ArrayList<GeoLine>();
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        while (!recordset.isEOF()) {
            GeoLine geoLine = (GeoLine)recordset.getGeometry();
            arrayList.add(geoLine);
            recordset.moveNext();
        }
        int n = arrayList.size();
        GeoLine[] geoLineArray = new GeoLine[n];
        for (int i = 0; i < n; ++i) {
            geoLineArray[i] = (GeoLine)arrayList.get(i);
        }
        recordset.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoLineArray;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter parameter, DatasetGrid extractedGrid, GeoRegion clipRegion) {
        String string;
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (extractedGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedGrid) == 0L) {
            String string3 = InternalResource.loadString("extractedGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        Datasource datasource = extractedGrid.getDatasource();
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoline(parameter, extractedGrid, datasource, string = extractedGrid.getDatasource().getDatasets().getAvailableDatasetName("tempDataset"), clipRegion);
        if (datasetVector == null) {
            return new GeoLine[0];
        }
        ArrayList<GeoLine> arrayList = new ArrayList<GeoLine>();
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        while (!recordset.isEOF()) {
            GeoLine geoLine = (GeoLine)recordset.getGeometry();
            arrayList.add(geoLine);
            recordset.moveNext();
        }
        int n = arrayList.size();
        GeoLine[] geoLineArray = new GeoLine[n];
        for (int i = 0; i < n; ++i) {
            geoLineArray[i] = (GeoLine)arrayList.get(i);
        }
        recordset.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoLineArray;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter parameter, DatasetVector extractedPoint, String zValueFieldName, double resolution, GeoRegion clipRegion) {
        if (extractedPoint == null) {
            String string = InternalResource.loadString("extractedPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        Recordset recordset = extractedPoint.getRecordset(false, CursorType.STATIC);
        GeoLine[] geoLineArray = SurfaceAnalyst.extractIsoline(parameter, recordset, zValueFieldName, resolution, clipRegion);
        recordset.dispose();
        return geoLineArray;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter parameter, DatasetVector extractedPoint, String zValueFieldName, TerrainInterpolateType terrainInterpolateType, double resolution, GeoRegion clipRegion) {
        if (extractedPoint == null) {
            String string = InternalResource.loadString("extractedPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        Recordset recordset = extractedPoint.getRecordset(false, CursorType.STATIC);
        GeoLine[] geoLineArray = SurfaceAnalyst.extractIsoline(parameter, recordset, zValueFieldName, resolution, clipRegion);
        recordset.dispose();
        return geoLineArray;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter parameter, Recordset extractedPointRecordset, String zValueFieldName, double resolution, GeoRegion clipRegion) {
        String string;
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (extractedPointRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedPointRecordset) == 0L) {
            String string3 = InternalResource.loadString("extractedPointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (!extractedPointRecordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string4 = InternalResource.loadString("extractedPointRecordset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (extractedPointRecordset.getFieldInfos().indexOf(zValueFieldName) == -1) {
            String string5 = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (resolution <= 0.0) {
            String string6 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        Datasource datasource = extractedPointRecordset.getDataset().getDatasource();
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoline(parameter, extractedPointRecordset, zValueFieldName, datasource, string = extractedPointRecordset.getDataset().getDatasource().getDatasets().getAvailableDatasetName("tempDataset"), resolution, clipRegion);
        if (datasetVector == null) {
            return new GeoLine[0];
        }
        ArrayList<GeoLine> arrayList = new ArrayList<GeoLine>();
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        while (!recordset.isEOF()) {
            GeoLine geoLine = (GeoLine)recordset.getGeometry();
            arrayList.add(geoLine);
            recordset.moveNext();
        }
        int n = arrayList.size();
        GeoLine[] geoLineArray = new GeoLine[n];
        for (int i = 0; i < n; ++i) {
            geoLineArray[i] = (GeoLine)arrayList.get(i);
        }
        recordset.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoLineArray;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter parameter, Recordset extractedPointRecordset, String zValueFieldName, TerrainInterpolateType terrainInterpolateType, double resolution, GeoRegion clipRegion) {
        String string;
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (extractedPointRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedPointRecordset) == 0L) {
            String string3 = InternalResource.loadString("extractedPointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (!extractedPointRecordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string4 = InternalResource.loadString("extractedPointRecordset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (extractedPointRecordset.getFieldInfos().indexOf(zValueFieldName) == -1) {
            String string5 = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (resolution <= 0.0) {
            String string6 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        Datasource datasource = extractedPointRecordset.getDataset().getDatasource();
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoline(parameter, extractedPointRecordset, zValueFieldName, terrainInterpolateType, datasource, string = extractedPointRecordset.getDataset().getDatasource().getDatasets().getAvailableDatasetName("tempDataset"), resolution, clipRegion);
        if (datasetVector == null) {
            return new GeoLine[0];
        }
        ArrayList<GeoLine> arrayList = new ArrayList<GeoLine>();
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        while (!recordset.isEOF()) {
            GeoLine geoLine = (GeoLine)recordset.getGeometry();
            arrayList.add(geoLine);
            recordset.moveNext();
        }
        int n = arrayList.size();
        GeoLine[] geoLineArray = new GeoLine[n];
        for (int i = 0; i < n; ++i) {
            geoLineArray[i] = (GeoLine)arrayList.get(i);
        }
        recordset.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoLineArray;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter parameter, Point3Ds extractedPoints, double resolution, GeoRegion clipRegion) {
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedPoints == null || extractedPoints.getCount() == 0) {
            String string = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resolution <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        int n = extractedPoints.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = extractedPoints.getItem(i).getX();
            dArray2[i] = extractedPoints.getItem(i).getY();
            dArray3[i] = extractedPoints.getItem(i).getZ();
        }
        double d = dArray[0];
        double d2 = dArray[0];
        double d3 = dArray2[0];
        double d4 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d = d <= dArray[i] ? d : dArray[i];
            d2 = d2 >= dArray[i] ? d2 : dArray[i];
            d3 = d3 <= dArray2[i] ? d3 : dArray2[i];
            d4 = d4 >= dArray2[i] ? d4 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d, d3, d2, d4);
        SurfaceAnalyst.verifyResolution(resolution, rectangle2D);
        int n2 = InternalEnum.getUGCValue(TerrainInterpolateType.IDW);
        long[] lArray = parameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineRGeoLine1(dArray, dArray2, dArray3, n2, l, resolution, parameter.getInterval(), parameter.getDatumValue(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsolineRGeoLine2(dArray, dArray2, dArray3, n2, l, resolution, parameter.getExpectedZValues(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        if (lArray == null) {
            return new GeoLine[0];
        }
        int n3 = lArray.length;
        GeoLine[] geoLineArray = new GeoLine[n3];
        for (int i = 0; i < n3; ++i) {
            geoLineArray[i] = (GeoLine)InternalGeometry.createInstance(lArray[i]);
        }
        return geoLineArray;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter parameter, Point3Ds extractedPoints, TerrainInterpolateType terrainInterpolateType, double resolution, GeoRegion clipRegion) {
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedPoints == null || extractedPoints.getCount() == 0) {
            String string = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resolution <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        int n = extractedPoints.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = extractedPoints.getItem(i).getX();
            dArray2[i] = extractedPoints.getItem(i).getY();
            dArray3[i] = extractedPoints.getItem(i).getZ();
        }
        double d = dArray[0];
        double d2 = dArray[0];
        double d3 = dArray2[0];
        double d4 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d = d <= dArray[i] ? d : dArray[i];
            d2 = d2 >= dArray[i] ? d2 : dArray[i];
            d3 = d3 <= dArray2[i] ? d3 : dArray2[i];
            d4 = d4 >= dArray2[i] ? d4 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d, d3, d2, d4);
        SurfaceAnalyst.verifyResolution(resolution, rectangle2D);
        int n2 = InternalEnum.getUGCValue(terrainInterpolateType);
        long[] lArray = parameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineRGeoLine1(dArray, dArray2, dArray3, n2, l, resolution, parameter.getInterval(), parameter.getDatumValue(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsolineRGeoLine2(dArray, dArray2, dArray3, n2, l, resolution, parameter.getExpectedZValues(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        if (lArray == null) {
            return new GeoLine[0];
        }
        int n3 = lArray.length;
        GeoLine[] geoLineArray = new GeoLine[n3];
        for (int i = 0; i < n3; ++i) {
            geoLineArray[i] = (GeoLine)InternalGeometry.createInstance(lArray[i]);
        }
        return geoLineArray;
    }

    public static GeoRegion[] extractIsoregion(SurfaceExtractParameter parameter, DatasetVector extractedPoint, String zValueFieldName, double resolution, GeoRegion clipRegion) {
        if (extractedPoint == null) {
            String string = InternalResource.loadString("extractedPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        Recordset recordset = extractedPoint.getRecordset(false, CursorType.STATIC);
        GeoRegion[] geoRegionArray = SurfaceAnalyst.extractIsoregion(parameter, recordset, zValueFieldName, resolution, clipRegion);
        recordset.dispose();
        return geoRegionArray;
    }

    public static GeoRegion[] extractIsoregion(SurfaceExtractParameter parameter, DatasetVector extractedPoint, String zValueFieldName, TerrainInterpolateType terrainInterpolateType, double resolution, GeoRegion clipRegion) {
        if (extractedPoint == null) {
            String string = InternalResource.loadString("extractedPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        Recordset recordset = extractedPoint.getRecordset(false, CursorType.STATIC);
        GeoRegion[] geoRegionArray = SurfaceAnalyst.extractIsoregion(parameter, recordset, zValueFieldName, terrainInterpolateType, resolution, clipRegion);
        recordset.dispose();
        return geoRegionArray;
    }

    public static GeoRegion[] extractIsoregion(SurfaceExtractParameter parameter, Point3Ds extractedPoints, double resolution, GeoRegion clipRegion) {
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedPoints == null || extractedPoints.getCount() == 0) {
            String string = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resolution <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        int n = extractedPoints.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = extractedPoints.getItem(i).getX();
            dArray2[i] = extractedPoints.getItem(i).getY();
            dArray3[i] = extractedPoints.getItem(i).getZ();
        }
        double d = dArray[0];
        double d2 = dArray[0];
        double d3 = dArray2[0];
        double d4 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d = d <= dArray[i] ? d : dArray[i];
            d2 = d2 >= dArray[i] ? d2 : dArray[i];
            d3 = d3 <= dArray2[i] ? d3 : dArray2[i];
            d4 = d4 >= dArray2[i] ? d4 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d, d3, d2, d4);
        SurfaceAnalyst.verifyResolution(resolution, rectangle2D);
        int n2 = InternalEnum.getUGCValue(TerrainInterpolateType.IDW);
        long[] lArray = parameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineRGeoRegion1(dArray, dArray2, dArray3, n2, l, resolution, parameter.getInterval(), parameter.getDatumValue(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsolineRGeoRegion1WithZ(dArray, dArray2, dArray3, n2, l, resolution, parameter.getExpectedZValues(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        if (lArray == null) {
            return new GeoRegion[0];
        }
        int n3 = lArray.length;
        GeoRegion[] geoRegionArray = new GeoRegion[n3];
        for (int i = 0; i < n3; ++i) {
            geoRegionArray[i] = (GeoRegion)InternalGeometry.createInstance(lArray[i]);
        }
        return geoRegionArray;
    }

    public static GeoRegion[] extractIsoregion(SurfaceExtractParameter parameter, Point3Ds extractedPoints, TerrainInterpolateType terrainInterpolateType, double resolution, GeoRegion clipRegion) {
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (extractedPoints == null || extractedPoints.getCount() == 0) {
            String string = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (resolution <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (clipRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)clipRegion);
        }
        int n = extractedPoints.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = extractedPoints.getItem(i).getX();
            dArray2[i] = extractedPoints.getItem(i).getY();
            dArray3[i] = extractedPoints.getItem(i).getZ();
        }
        double d = dArray[0];
        double d2 = dArray[0];
        double d3 = dArray2[0];
        double d4 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d = d <= dArray[i] ? d : dArray[i];
            d2 = d2 >= dArray[i] ? d2 : dArray[i];
            d3 = d3 <= dArray2[i] ? d3 : dArray2[i];
            d4 = d4 >= dArray2[i] ? d4 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d, d3, d2, d4);
        SurfaceAnalyst.verifyResolution(resolution, rectangle2D);
        int n2 = InternalEnum.getUGCValue(terrainInterpolateType);
        long[] lArray = parameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineRGeoRegion1(dArray, dArray2, dArray3, n2, l, resolution, parameter.getInterval(), parameter.getDatumValue(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsolineRGeoRegion1WithZ(dArray, dArray2, dArray3, n2, l, resolution, parameter.getExpectedZValues(), parameter.getSmoothness(), InternalEnum.getUGCValue(parameter.getSmoothMethod()), parameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
        if (lArray == null) {
            return new GeoRegion[0];
        }
        int n3 = lArray.length;
        GeoRegion[] geoRegionArray = new GeoRegion[n3];
        for (int i = 0; i < n3; ++i) {
            geoRegionArray[i] = (GeoRegion)InternalGeometry.createInstance(lArray[i]);
        }
        return geoRegionArray;
    }

    public static GeoRegion[] extractIsoregion(SurfaceExtractParameter parameter, Recordset extractedPointRecordset, String zValueFieldName, double resolution, GeoRegion clipRegion) {
        String string;
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (extractedPointRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedPointRecordset) == 0L) {
            String string3 = InternalResource.loadString("extractedPointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (!extractedPointRecordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string4 = InternalResource.loadString("extractedPointRecordset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (extractedPointRecordset.getFieldInfos().indexOf(zValueFieldName) == -1) {
            String string5 = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (resolution <= 0.0) {
            String string6 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        Datasource datasource = extractedPointRecordset.getDataset().getDatasource();
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoregion(parameter, extractedPointRecordset, zValueFieldName, datasource, string = extractedPointRecordset.getDataset().getDatasource().getDatasets().getAvailableDatasetName("tempDataset"), resolution, clipRegion);
        if (datasetVector == null) {
            return new GeoRegion[0];
        }
        ArrayList<GeoRegion> arrayList = new ArrayList<GeoRegion>();
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        while (!recordset.isEOF()) {
            GeoRegion geoRegion = (GeoRegion)recordset.getGeometry();
            arrayList.add(geoRegion);
            recordset.moveNext();
        }
        int n = arrayList.size();
        GeoRegion[] geoRegionArray = new GeoRegion[n];
        for (int i = 0; i < n; ++i) {
            geoRegionArray[i] = (GeoRegion)arrayList.get(i);
        }
        recordset.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoRegionArray;
    }

    public static GeoRegion[] extractIsoregion(SurfaceExtractParameter parameter, Recordset extractedPointRecordset, String zValueFieldName, TerrainInterpolateType terrainInterpolateType, double resolution, GeoRegion clipRegion) {
        String string;
        SurfaceAnalyst.verifyLicense();
        if (parameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (extractedPointRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)extractedPointRecordset) == 0L) {
            String string3 = InternalResource.loadString("extractedPointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (!extractedPointRecordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string4 = InternalResource.loadString("extractedPointRecordset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (extractedPointRecordset.getFieldInfos().indexOf(zValueFieldName) == -1) {
            String string5 = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (resolution <= 0.0) {
            String string6 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        Datasource datasource = extractedPointRecordset.getDataset().getDatasource();
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoregion(parameter, extractedPointRecordset, zValueFieldName, terrainInterpolateType, datasource, string = extractedPointRecordset.getDataset().getDatasource().getDatasets().getAvailableDatasetName("tempDataset"), resolution, clipRegion);
        if (datasetVector == null) {
            return new GeoRegion[0];
        }
        ArrayList<GeoRegion> arrayList = new ArrayList<GeoRegion>();
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        while (!recordset.isEOF()) {
            GeoRegion geoRegion = (GeoRegion)recordset.getGeometry();
            arrayList.add(geoRegion);
            recordset.moveNext();
        }
        int n = arrayList.size();
        GeoRegion[] geoRegionArray = new GeoRegion[n];
        for (int i = 0; i < n; ++i) {
            geoRegionArray[i] = (GeoRegion)arrayList.get(i);
        }
        recordset.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoRegionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "SurfaceAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SurfaceAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    private static void verifyResolution(double resolution, Rectangle2D bounds) {
        double d = bounds.getWidth();
        double d2 = bounds.getHeight();
        int n = (int)(d / resolution);
        int n2 = (int)(d2 / resolution);
        if (n > 10000 || n2 > 10000) {
            String string = InternalResource.loadString("Resolution", "InterPolator_Resolution_TooSmall", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

