/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.DissolveParameterNative;
import com.supermap.analyst.spatialanalyst.DissolveType;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.StatisticsType;
import java.util.ArrayList;

public class DissolveParameter
extends InternalHandleDisposable {
    private DissolveType m_dissolveType = DissolveType.SINGLE;
    private boolean m_bTopoIniProcess = true;
    private boolean m_bDissolveNullValue = false;
    private double m_dTolerance;
    private String m_sFilterString;
    private ArrayList m_sFieldNames;
    private ArrayList m_sStatisticsFieldNames;
    private ArrayList m_statisticsTypes;

    public DissolveParameter() {
        long l = DissolveParameterNative.jni_New();
        this.setHandle(l, true);
        this.Reset();
    }

    void Reset() {
        long l = super.getHandle();
        if (l != 0L) {
            DissolveParameterNative.jni_Reset(l);
        }
    }

    public DissolveParameter(DissolveParameter dissolveParameter) {
        if (dissolveParameter == null) {
            String string = InternalResource.loadString("DissolveParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = DissolveParameterNative.jni_New();
        this.setHandle(l, true);
        this.Reset();
        this.setPreProcess(dissolveParameter.isPreProcess());
        this.setDissolveType(dissolveParameter.getDissolveType());
        this.setNullValue(dissolveParameter.isNullValue());
        this.setTolerance(dissolveParameter.getTolerance());
        this.setFilterString(dissolveParameter.getFilterString());
        this.setFieldNames(dissolveParameter.getFieldNames());
        this.setStatisticsFieldNames(dissolveParameter.getStatisticsFieldNames());
        this.setStatisticsTypes(dissolveParameter.getStatisticsTypes());
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            int n;
            Object[] objectArray;
            int n2;
            DissolveParameterNative.jni_SetPreProcess(l, this.m_bTopoIniProcess);
            int n3 = InternalEnum.getUGCValue(this.m_dissolveType);
            DissolveParameterNative.jni_SetDissolveType(l, n3);
            DissolveParameterNative.jni_SetNullValue(l, this.m_bDissolveNullValue);
            DissolveParameterNative.jni_SetTolerance(l, this.m_dTolerance);
            DissolveParameterNative.jni_SetFilterString(l, this.m_sFilterString);
            if (this.m_sFieldNames != null) {
                n2 = this.m_sFieldNames.size();
                objectArray = new String[n2];
                for (n = 0; n < n2; ++n) {
                    objectArray[n] = this.m_sFieldNames.get(n).toString();
                }
                DissolveParameterNative.jni_SetFieldNames(l, objectArray);
            }
            if (this.m_sStatisticsFieldNames != null) {
                n2 = this.m_sStatisticsFieldNames.size();
                objectArray = new String[n2];
                for (n = 0; n < n2; ++n) {
                    objectArray[n] = this.m_sStatisticsFieldNames.get(n).toString();
                }
                DissolveParameterNative.jni_SetStatisticsFieldNames(l, objectArray);
            } else {
                DissolveParameterNative.jni_SetStatisticsFieldNames(l, new String[0]);
            }
            if (this.m_statisticsTypes != null) {
                n2 = this.m_statisticsTypes.size();
                objectArray = new int[n2];
                for (n = 0; n < n2; ++n) {
                    objectArray[n] = (String)InternalEnum.getUGCValue((StatisticsType)((Object)this.m_statisticsTypes.get(n)));
                }
                DissolveParameterNative.jni_SetStatisticsTypes(l, (int[])objectArray);
            } else {
                DissolveParameterNative.jni_SetStatisticsTypes(l, new int[0]);
            }
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            DissolveParameterNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    public boolean isPreProcess() {
        return this.m_bTopoIniProcess;
    }

    public void setPreProcess(boolean value) {
        this.m_bTopoIniProcess = value;
    }

    public boolean isNullValue() {
        return this.m_bDissolveNullValue;
    }

    public void setNullValue(boolean value) {
        this.m_bDissolveNullValue = value;
    }

    public DissolveType getDissolveType() {
        return this.m_dissolveType;
    }

    public void setDissolveType(DissolveType value) {
        this.m_dissolveType = value;
    }

    public double getTolerance() {
        return this.m_dTolerance;
    }

    public void setTolerance(double value) {
        this.m_dTolerance = value;
    }

    public String getFilterString() {
        return this.m_sFilterString;
    }

    public void setFilterString(String value) {
        this.m_sFilterString = value;
    }

    public String[] getFieldNames() {
        int n = this.m_sFieldNames.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_sFieldNames.get(i).toString();
        }
        return stringArray;
    }

    public void setFieldNames(String[] value) {
        int n;
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        int n2 = value.length;
        for (n = 0; n < n2; ++n) {
            if (value[n] != null && !value[n].trim().equalsIgnoreCase("")) continue;
            String string = InternalResource.loadString("value[" + n + "]", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_sFieldNames != null) {
            this.m_sFieldNames.clear();
        }
        this.m_sFieldNames = new ArrayList();
        for (n = 0; n < n2; ++n) {
            this.m_sFieldNames.add(value[n]);
        }
    }

    public String[] getStatisticsFieldNames() {
        int n = this.m_sStatisticsFieldNames.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_sStatisticsFieldNames.get(i).toString();
        }
        return stringArray;
    }

    public void setStatisticsFieldNames(String[] value) {
        if (value == null) {
            this.m_sStatisticsFieldNames = null;
        } else {
            int n;
            int n2 = value.length;
            for (n = 0; n < n2; ++n) {
                if (value[n] != null && !value[n].trim().equalsIgnoreCase("")) continue;
                String string = InternalResource.loadString("value[" + n + "]", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.m_sStatisticsFieldNames != null) {
                this.m_sStatisticsFieldNames.clear();
            }
            this.m_sStatisticsFieldNames = new ArrayList();
            for (n = 0; n < n2; ++n) {
                this.m_sStatisticsFieldNames.add(value[n]);
            }
        }
    }

    public StatisticsType[] getStatisticsTypes() {
        int n = this.m_statisticsTypes.size();
        StatisticsType[] statisticsTypeArray = new StatisticsType[n];
        for (int i = 0; i < n; ++i) {
            statisticsTypeArray[i] = (StatisticsType)((Object)this.m_statisticsTypes.get(i));
        }
        return statisticsTypeArray;
    }

    public void setStatisticsTypes(StatisticsType[] value) {
        if (value == null) {
            this.m_statisticsTypes = null;
        } else {
            int n;
            int n2 = value.length;
            for (n = 0; n < n2; ++n) {
                if (value[n] != null) continue;
                String string = InternalResource.loadString("value[" + n + "]", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.m_statisticsTypes != null) {
                this.m_statisticsTypes.clear();
            }
            this.m_statisticsTypes = new ArrayList();
            for (n = 0; n < n2; ++n) {
                this.m_statisticsTypes.add(value[n]);
            }
        }
    }
}

