/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CloudLicenseError;
import com.supermap.data.ContentType;
import com.supermap.data.HttpRequestMethod;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class HttpUtils {
    private HttpURLConnection m_httpConnection = null;

    public boolean createHttpsConnction(String strURL, HttpRequestMethod method, ContentType type, boolean isSSL, String cookie) {
        URL url = null;
        try {
            url = new URL(strURL);
            this.m_httpConnection = (HttpURLConnection)url.openConnection();
            if (method == HttpRequestMethod.Post) {
                this.m_httpConnection.setRequestMethod("POST");
            } else if (method == HttpRequestMethod.Put) {
                this.m_httpConnection.setRequestMethod("PUT");
            }
            this.m_httpConnection.setDoInput(true);
            this.m_httpConnection.setDoOutput(true);
            this.m_httpConnection.setUseCaches(false);
            if (!cookie.isEmpty()) {
                this.m_httpConnection.setRequestProperty("Cookie", cookie);
            }
            if (type == ContentType.WWW) {
                this.m_httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            } else if (type == ContentType.JSON) {
                this.m_httpConnection.setRequestProperty("Content-Type", "application/json");
            }
            this.m_httpConnection.setRequestProperty("Charset", "utf-8");
            this.m_httpConnection.setInstanceFollowRedirects(false);
            HttpsURLConnection.setFollowRedirects(false);
            this.m_httpConnection.setConnectTimeout(10000);
        }
        catch (Exception e) {
            CloudLicenseError.setLastError("create https connect error...");
            CloudLicenseError.setLastError(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        String result = "";
        InputStreamReader in = null;
        if (this.m_httpConnection != null) {
            try {
                String line;
                in = new InputStreamReader(this.m_httpConnection.getInputStream());
                BufferedReader bufferedReader = new BufferedReader(in);
                StringBuffer strBuffer = new StringBuffer();
                while ((line = bufferedReader.readLine()) != null) {
                    strBuffer.append(line);
                }
                result = strBuffer.toString();
            }
            catch (Exception e) {
                CloudLicenseError.setLastError("post msg to https connect error...");
                CloudLicenseError.setLastError(e);
            }
            finally {
                if (this.m_httpConnection != null) {
                    this.m_httpConnection.disconnect();
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(String sendMessage) {
        String result = "";
        InputStreamReader in = null;
        if (this.m_httpConnection != null) {
            try {
                String line;
                DataOutputStream dop = new DataOutputStream(this.m_httpConnection.getOutputStream());
                dop.writeBytes(sendMessage);
                dop.flush();
                dop.close();
                in = new InputStreamReader(this.m_httpConnection.getInputStream());
                BufferedReader bufferedReader = new BufferedReader(in);
                StringBuffer strBuffer = new StringBuffer();
                while ((line = bufferedReader.readLine()) != null) {
                    strBuffer.append(line);
                }
                result = strBuffer.toString();
            }
            catch (Exception e) {
                CloudLicenseError.setLastError("post msg to https connect error...");
                CloudLicenseError.setLastError(e);
            }
            finally {
                if (this.m_httpConnection != null) {
                    this.m_httpConnection.disconnect();
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTicket(String sendMessage) {
        String result = "";
        if (this.m_httpConnection != null) {
            try {
                this.m_httpConnection.connect();
                DataOutputStream dop = new DataOutputStream(this.m_httpConnection.getOutputStream());
                dop.writeBytes(sendMessage);
                dop.flush();
                dop.close();
                result = this.m_httpConnection.getHeaderField("Location");
            }
            catch (Exception e) {
                CloudLicenseError.setLastError("get connect ticket error...");
                CloudLicenseError.setLastError(e);
            }
            finally {
                if (this.m_httpConnection != null) {
                    this.m_httpConnection.disconnect();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCookie(String id) {
        String result = "";
        if (this.m_httpConnection != null) {
            try {
                this.m_httpConnection.connect();
                int code = this.m_httpConnection.getResponseCode();
                for (int i = 0; i < this.m_httpConnection.getHeaderFields().size(); ++i) {
                    String[] cookieStrs;
                    if (!"Set-Cookie".equalsIgnoreCase(this.m_httpConnection.getHeaderFieldKey(i))) continue;
                    String setCookies = this.m_httpConnection.getHeaderField(i);
                    for (String cookieStr : cookieStrs = setCookies.split(";")) {
                        String tempCookieStr = cookieStr.trim();
                        if (!tempCookieStr.startsWith("JSESSIONID=")) continue;
                        String string = result = tempCookieStr;
                        return string;
                    }
                }
            }
            catch (Exception e) {
                CloudLicenseError.setLastError("get connect cookie error...");
                CloudLicenseError.setLastError(e);
            }
            finally {
                if (this.m_httpConnection != null) {
                    this.m_httpConnection.disconnect();
                }
            }
        }
        return result;
    }
}

