/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CloudLicenseError;
import com.supermap.data.ContentType;
import com.supermap.data.HttpRequestMethod;
import com.supermap.data.MySSLTrustManager;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public class HttpsUtils {
    private HttpsURLConnection m_httpsConnection = null;

    public boolean createHttpsConnction(String strURL, HttpRequestMethod method, ContentType type, boolean isSSL, String cookie) {
        URL url = null;
        try {
            url = new URL(strURL);
            this.m_httpsConnection = (HttpsURLConnection)url.openConnection();
            if (method == HttpRequestMethod.Post) {
                this.m_httpsConnection.setRequestMethod("POST");
            } else if (method == HttpRequestMethod.Put) {
                this.m_httpsConnection.setRequestMethod("PUT");
            }
            this.m_httpsConnection.setDoInput(true);
            this.m_httpsConnection.setDoOutput(true);
            this.m_httpsConnection.setUseCaches(false);
            if (type == ContentType.WWW) {
                this.m_httpsConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            } else if (type == ContentType.JSON) {
                this.m_httpsConnection.setRequestProperty("Content-Type", "application/json");
            }
            this.m_httpsConnection.setRequestProperty("Charset", "utf-8");
            this.m_httpsConnection.setInstanceFollowRedirects(false);
            HttpsURLConnection.setFollowRedirects(false);
            this.m_httpsConnection.setConnectTimeout(10000);
        }
        catch (Exception e) {
            CloudLicenseError.setLastError("create https connect error...");
            CloudLicenseError.setLastError(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        String result = "";
        InputStreamReader in = null;
        if (this.m_httpsConnection != null) {
            try {
                String line;
                in = new InputStreamReader(this.m_httpsConnection.getInputStream());
                BufferedReader bufferedReader = new BufferedReader(in);
                StringBuffer strBuffer = new StringBuffer();
                while ((line = bufferedReader.readLine()) != null) {
                    strBuffer.append(line);
                }
                result = strBuffer.toString();
            }
            catch (Exception e) {
                CloudLicenseError.setLastError("post msg to https connect error...");
                CloudLicenseError.setLastError(e);
            }
            finally {
                if (this.m_httpsConnection != null) {
                    this.m_httpsConnection.disconnect();
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(String sendMessage) {
        String result = "";
        InputStreamReader in = null;
        if (this.m_httpsConnection != null) {
            try {
                String line;
                DataOutputStream dop = new DataOutputStream(this.m_httpsConnection.getOutputStream());
                dop.writeBytes(sendMessage);
                dop.flush();
                dop.close();
                in = new InputStreamReader(this.m_httpsConnection.getInputStream());
                BufferedReader bufferedReader = new BufferedReader(in);
                StringBuffer strBuffer = new StringBuffer();
                while ((line = bufferedReader.readLine()) != null) {
                    strBuffer.append(line);
                }
                result = strBuffer.toString();
            }
            catch (Exception e) {
                CloudLicenseError.setLastError("post msg to https connect error...");
                CloudLicenseError.setLastError(e);
            }
            finally {
                if (this.m_httpsConnection != null) {
                    this.m_httpsConnection.disconnect();
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTicket(String sendMessage) {
        String result = "";
        if (this.m_httpsConnection != null) {
            try {
                this.m_httpsConnection.connect();
                DataOutputStream dop = new DataOutputStream(this.m_httpsConnection.getOutputStream());
                dop.writeBytes(sendMessage);
                dop.flush();
                dop.close();
                result = this.m_httpsConnection.getHeaderField("Location");
            }
            catch (Exception e) {
                CloudLicenseError.setLastError("get connect ticket error...");
                CloudLicenseError.setLastError(e);
            }
            finally {
                if (this.m_httpsConnection != null) {
                    this.m_httpsConnection.disconnect();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCookie(String id) {
        String result = "";
        if (this.m_httpsConnection != null) {
            try {
                this.m_httpsConnection.connect();
                int code = this.m_httpsConnection.getResponseCode();
                for (int i = 0; i < this.m_httpsConnection.getHeaderFields().size(); ++i) {
                    String[] cookieStrs;
                    if (!"Set-Cookie".equalsIgnoreCase(this.m_httpsConnection.getHeaderFieldKey(i))) continue;
                    String setCookies = this.m_httpsConnection.getHeaderField(i);
                    for (String cookieStr : cookieStrs = setCookies.split(";")) {
                        String tempCookieStr = cookieStr.trim();
                        if (!tempCookieStr.startsWith("JSESSIONID=")) continue;
                        String string = result = tempCookieStr;
                        return string;
                    }
                }
            }
            catch (Exception e) {
                CloudLicenseError.setLastError("get connect cookie error...");
                CloudLicenseError.setLastError(e);
            }
            finally {
                if (this.m_httpsConnection != null) {
                    this.m_httpsConnection.disconnect();
                }
            }
        }
        return result;
    }

    static {
        try {
            SSLContext sslCTX = SSLContext.getInstance("SSL");
            sslCTX.init(null, new X509TrustManager[]{new MySSLTrustManager()}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslCTX.getSocketFactory());
        }
        catch (Exception e) {
            CloudLicenseError.setLastError("create ssl connect error...");
            CloudLicenseError.setLastError(e);
        }
    }
}

