/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.EncodeType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Workspace;
import com.supermap.data.WorkspaceConnectionInfo;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.ImportDataInfos;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingWORNative;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.InternalWorkspaceConnectionInfo;

public class ImportSettingWOR
extends ImportSetting {
    WorkspaceConnectionInfo m_info;
    Workspace m_workspace;

    public ImportSettingWOR() {
        this.setHandle(ImportSettingWORNative.jni_New(), true);
        super.setDataType(DataType.WOR);
    }

    public ImportSettingWOR(ImportSettingWOR importSettingWOR) {
        this();
        super.setSourceFilePath(importSettingWOR.getSourceFilePath());
        this.setTargetWorkspaceConnectionInfo(importSettingWOR.getTargetWorkspaceConnectionInfo());
        super.setTargetDatasourceConnectionInfo(importSettingWOR.getTargetDatasourceConnectionInfo());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingWOR));
    }

    public ImportSettingWOR(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo, WorkspaceConnectionInfo targetWorkspaceConnectionInfo) {
        this();
        super.setSourceFilePath(sourceFilePath);
        this.setTargetWorkspaceConnectionInfo(targetWorkspaceConnectionInfo);
        super.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetWorkspaceConnectionInfo);
    }

    public ImportSettingWOR(String sourceFilePath, Datasource targetDatasource, Workspace targetWorkspace) {
        this();
        super.setSourceFilePath(sourceFilePath);
        this.setTargetWorkspace(targetWorkspace);
        super.setTargetDatasource(targetDatasource);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetWorkspace);
    }

    public WorkspaceConnectionInfo getTargetWorkspaceConnectionInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetWorkspaceConnectionInfo()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this.m_info;
    }

    public void setTargetWorkspaceConnectionInfo(WorkspaceConnectionInfo info) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetWorkspaceConnectionInfo(WorkspaceConnectionInfo info)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (info == null) {
            if (this.m_info != null) {
                InternalWorkspaceConnectionInfo.clearHandle(this.m_info);
                this.m_info = null;
            }
        } else {
            this.setTargetWorkspace(null);
            this.m_info = this.cloneWorkspaceConnectionInfo(info);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)info);
    }

    public Workspace getTargetWorkspace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetWorkspace()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this.m_workspace;
    }

    public void setTargetWorkspace(Workspace workspace) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetWorkspace(Workspace workspace)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_workspace = workspace;
        if (this.m_workspace != null) {
            this.setTargetWorkspaceConnectionInfo(null);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)workspace);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingWORNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    public ImportDataInfos getTargetDataInfos(String targetNamePrefix) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceDataInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_dataInfos == null) {
            this.m_dataInfos = new ImportDataInfos(this.getHandle(), this.getSourceFileType(), DataType.WOR, this.getSourceFilePath(), "");
        }
        return this.m_dataInfos;
    }

    @Override
    public ImportDataInfos getTargetDataInfos(String targetNamePrefix, EncodeType targetEncodeType, PrjCoordSys targetPrjCoordSy) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceDataInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_dataInfos == null) {
            this.m_dataInfos = new ImportDataInfos(this.getHandle(), this.getSourceFileType(), DataType.WOR, this.getSourceFilePath(), "");
        }
        return this.m_dataInfos;
    }

    @Override
    public void setTargetDataInfos(ImportDataInfos targetDataInfos) {
        this.m_dataInfos = targetDataInfos;
    }

    @Override
    @Deprecated
    public PrjCoordSys getTargetPrjCoordSys() {
        return null;
    }

    @Override
    @Deprecated
    public void setTargetPrjCoordSys(PrjCoordSys prjCoordSys) {
    }

    @Override
    @Deprecated
    public EncodeType getEncodeType() {
        return null;
    }

    @Override
    @Deprecated
    public void setEncodeType(EncodeType type) {
    }

    WorkspaceConnectionInfo cloneWorkspaceConnectionInfo(WorkspaceConnectionInfo connectionInfo) {
        long l = InternalHandle.getHandle((InternalHandle)connectionInfo);
        long l2 = ImportSettingWORNative.jni_CloneWorkspaceConnectionInfo(l);
        WorkspaceConnectionInfo workspaceConnectionInfo = InternalWorkspaceConnectionInfo.createInstance(l2);
        InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)workspaceConnectionInfo, (boolean)true);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)connectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)workspaceConnectionInfo);
        return workspaceConnectionInfo;
    }

    public void setImportEmptyDataset(boolean bImportEmptyDT) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingWORNative.jni_SetImportEmptyDT(this.getHandle(), bImportEmptyDT);
    }

    public boolean isImportEmptyDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingWORNative.jni_IsImportEmptyDT(this.getHandle());
    }
}

