/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.chart.conversion;

import com.supermap.chart.conversion.FileTypeChart;
import com.supermap.chart.conversion.InternalResource;
import java.io.File;

public class ExportSettingChart {
    String m_targetFilePath;
    boolean m_overwrite;
    FileTypeChart m_type;

    protected ExportSettingChart() {
        this.m_overwrite = false;
        this.m_type = FileTypeChart.NONE;
        this.m_targetFilePath = null;
    }

    protected ExportSettingChart(ExportSettingChart exportSettingChart) {
        if (exportSettingChart == null) {
            String string = InternalResource.loadString("exportSettingChart", "Global_ArgumentNull", "conversion_resources");
            throw new NullPointerException(string);
        }
        this.setTargetFilePath(exportSettingChart.getTargetFilePath());
        this.setTargetFileTypeChart(exportSettingChart.getTargetFileTypeChart());
        this.setOverwrite(exportSettingChart.isOverwrite());
    }

    protected ExportSettingChart(Object sourceData, String targetFilePath, FileTypeChart targetFileType) {
        this();
        this.setTargetFilePath(targetFilePath);
        this.setTargetFileTypeChart(targetFileType);
    }

    public String getTargetFilePath() {
        return this.m_targetFilePath;
    }

    public void setTargetFilePath(String filePath) {
        if (filePath == null || !this.isDirectoryExisted(filePath)) {
            String string = InternalResource.loadString("filePath:" + filePath, "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_targetFilePath = filePath;
    }

    public boolean isOverwrite() {
        return this.m_overwrite;
    }

    public void setOverwrite(boolean value) {
        this.m_overwrite = value;
    }

    public FileTypeChart getTargetFileTypeChart() {
        return this.m_type;
    }

    public void setTargetFileTypeChart(FileTypeChart fileType) {
        this.m_type = fileType;
    }

    private boolean isDirectoryExisted(String fileName) {
        File file = new File(fileName);
        boolean bl = false;
        if (file.getParent() == null) {
            bl = true;
        } else {
            File file2 = new File(file.getParent());
            if (file2.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    boolean check() {
        boolean bl = true;
        if (this.m_targetFilePath.length() == 0 || this.m_type.equals((Object)FileTypeChart.NONE)) {
            bl = false;
        }
        return bl;
    }
}

