/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.layout;

import com.supermap.layout.InternalHandle;
import com.supermap.layout.InternalResource;
import com.supermap.layout.MapLayout;
import com.supermap.layout.RulerLine;
import com.supermap.layout.RulerLinesNative;
import java.util.ArrayList;

public class RulerLines {
    private MapLayout m_mapLayout;
    private ArrayList<RulerLine> m_rulerLines;

    RulerLines(MapLayout mapLayout) {
        this.m_mapLayout = mapLayout;
        this.m_rulerLines = new ArrayList();
        this.reset();
    }

    public int getCount() {
        if (this.m_mapLayout == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
            String string = InternalResource.loadString("getCount()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return this.m_rulerLines.size();
    }

    public RulerLine get(int index) {
        if (this.m_mapLayout == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
            String string = InternalResource.loadString("get(int index)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_rulerLines.get(index);
    }

    public boolean isVisible() {
        if (this.m_mapLayout == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
            String string = InternalResource.loadString("isVisible()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return RulerLinesNative.jni_IsVisible(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout));
    }

    public void setVisible(boolean value) {
        if (this.m_mapLayout == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
            String string = InternalResource.loadString("setVisible(boolean value)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        RulerLinesNative.jni_SetVisible(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout), value);
    }

    public int add(RulerLine rulerLine) {
        if (this.m_mapLayout == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
            String string = InternalResource.loadString("add(RulerLine rulerLine)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (rulerLine == null) {
            String string = InternalResource.loadString("rulerLine", "Global_ArgumentNull", "layout_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)rulerLine);
        if (l == 0L) {
            String string = InternalResource.loadString("rulerLine", "Global_ArgumentObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = RulerLinesNative.jni_Add(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout), l);
        int n = -1;
        if (l2 != 0L) {
            RulerLine rulerLine2 = new RulerLine(l2);
            this.m_rulerLines.add(rulerLine2);
            n = this.m_rulerLines.size() - 1;
        }
        return n;
    }

    public int addRange(RulerLine[] rulerLines) {
        if (this.m_mapLayout == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
            String string = InternalResource.loadString("addRange(RulerLine[] rulerLines)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        for (int i = 0; i < rulerLines.length; ++i) {
            this.add(rulerLines[i]);
        }
        return rulerLines.length;
    }

    public boolean remove(int index) {
        if (this.m_mapLayout == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = RulerLinesNative.jni_Remove(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout), index);
        if (bl) {
            RulerLine rulerLine = this.m_rulerLines.remove(index);
            rulerLine.clearHandle();
        }
        return bl;
    }

    public int removeRange(int index, int count) {
        if (this.m_mapLayout == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
            String string = InternalResource.loadString("removeRange(int index, int count)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (index + count < index || index + count > n) {
            String string = InternalResource.loadString("count", "Selection_TheArgumentOfCountIsInvalid", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = RulerLinesNative.jni_RemoveRange(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout), index, count);
        if (bl) {
            for (int i = 0; i < count; ++i) {
                RulerLine rulerLine = this.m_rulerLines.remove(index);
                rulerLine.clearHandle();
            }
        }
        return count;
    }

    public void clear() {
        if (this.m_mapLayout == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
            String string = InternalResource.loadString("clear()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        RulerLinesNative.jni_Clear(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout));
        int n = this.m_rulerLines.size();
        for (int i = 0; i < n; ++i) {
            RulerLine rulerLine = this.m_rulerLines.remove(0);
            rulerLine.clearHandle();
        }
    }

    public RulerLine[] toArray() {
        RulerLine[] rulerLineArray = new RulerLine[this.m_rulerLines.size()];
        for (int i = 0; i < rulerLineArray.length; ++i) {
            rulerLineArray[i] = new RulerLine(this.m_rulerLines.get(i));
        }
        return rulerLineArray;
    }

    void reset() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout);
        int n = RulerLinesNative.jni_GetCount(l);
        long[] lArray = new long[n];
        RulerLinesNative.jni_GetLines(l, lArray);
        RulerLine rulerLine = null;
        for (int i = 0; i < lArray.length; ++i) {
            rulerLine = new RulerLine(lArray[i]);
            this.m_rulerLines.add(rulerLine);
        }
    }

    void clearHandle() {
        this.clear();
        this.m_mapLayout = null;
        this.m_rulerLines = null;
    }
}

