/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoEllipseNative;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRectangle;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;

public class GeoEllipse
extends Geometry {
    public GeoEllipse() {
        long l = GeoEllipseNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoEllipse(GeoEllipse geoEllipse) {
        if (geoEllipse == null) {
            String string = InternalResource.loadString("geoEllipse", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoEllipse);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoEllipse geoEllipse", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = GeoEllipseNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoEllipse);
    }

    public GeoEllipse(Point2D center, double semimajorAxis, double semiminorAxis, double rotation) {
        if (semimajorAxis <= 0.0) {
            String string = InternalResource.loadString("semimajorAxis", "GeoEllipse_SemimajorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (semiminorAxis <= 0.0) {
            String string = InternalResource.loadString("semiminorAxis", "GeoEllipse_SemiMinorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoEllipseNative.jni_New1(center.getX(), center.getY(), semimajorAxis, semiminorAxis, rotation);
        this.setHandle(l, true);
    }

    public GeoEllipse(GeoRectangle geoRectangle) {
        if (geoRectangle == null) {
            String string = InternalResource.loadString("geoRectangle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoRectangle);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoRectangle geoRectangle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = GeoEllipseNative.jni_New2(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoRectangle);
    }

    public GeoEllipse(Rectangle2D rectangle) {
        if (rectangle == null) {
            String string = InternalResource.loadString("rectangle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoEllipseNative.jni_New3(rectangle.getLeft(), rectangle.getRight(), rectangle.getTop(), rectangle.getBottom());
        this.setHandle(l, true);
    }

    GeoEllipse(long handle) {
        this.setHandle(handle, false);
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoEllipseNative.jni_getCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetCenter(Point2D point2D)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipseNative.jni_setCenter(this.getHandle(), point2D.getX(), point2D.getY());
    }

    public double getSemimajorAxis() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetSemimajorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipseNative.jni_getSemimajorAxis(this.getHandle());
    }

    public void setSemimajorAxis(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetSemimajorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoEllipse_SemimajorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoEllipseNative.jni_setSemimajorAxis(this.getHandle(), value);
    }

    public double getSemiminorAxis() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetSemiminorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipseNative.jni_getSemiminorAxis(this.getHandle());
    }

    public void setSemiminorAxis(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetSemiminorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoEllipse_SemiMinorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoEllipseNative.jni_setSemiminorAxis(this.getHandle(), value);
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipseNative.jni_getAngle(this.getHandle());
    }

    public void setRotation(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotation(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipseNative.jni_setAngle(this.getHandle(), value);
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipseNative.jni_getPerimeter(this.getHandle());
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipseNative.jni_getArea(this.getHandle());
    }

    public GeoLine convertToLine(int segmentCount) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ConvertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (segmentCount < 2) {
            String string = InternalResource.loadString("ConvertToLine(int segmentCount)", "GeoEllipse_GeoLineSegmentCountShouldGreaterThanOne", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoEllipseNative.jni_convertToLine(this.getHandle(), segmentCount);
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setHandle(l, true);
        }
        return geoLine;
    }

    public GeoRegion convertToRegion(int segmentCount) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ConvertToRegion(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (segmentCount < 2) {
            String string = InternalResource.loadString("convertToRegion(int segmentCount)", "GeoEllipse_GeoRegionSegmentCountShouldGreaterThanOne", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoEllipseNative.jni_convertToRegion(this.getHandle(), segmentCount);
        GeoRegion geoRegion = null;
        if (l != 0L) {
            geoRegion = new GeoRegion(l);
            geoRegion.setHandle(l, true);
        }
        return geoRegion;
    }

    @Override
    public GeoEllipse clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoEllipse(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoEllipseNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }
}

