/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegionNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import java.util.ArrayList;

public class GeoRegion
extends Geometry {
    private ArrayList m_geoRegionParts;

    public GeoRegion() {
        super.setHandle(GeoRegionNative.jni_New(), true);
        this.m_geoRegionParts = new ArrayList();
    }

    public GeoRegion(GeoRegion region) {
        if (region == null) {
            String string = InternalResource.loadString("region", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (region.getHandle() == 0L) {
            String string = InternalResource.loadString("region", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoRegionNative.jni_Clone(region.getHandle());
        super.setHandle(l, true);
        this.m_geoRegionParts = new ArrayList(region.getPartsList().size());
        for (int i = 0; i < region.getPartsList().size(); ++i) {
            Point2Ds point2Ds = (Point2Ds)region.getPartsList().get(i);
            this.m_geoRegionParts.add(point2Ds.clone());
        }
        InternalHandleDisposable.makeSureNativeObjectLive(region);
    }

    public GeoRegion(Point2Ds points) {
        this();
        if (points.getCount() < 3) {
            String string = InternalResource.loadString("convertToRegion", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.addPart(points);
    }

    public int addPart(Point2Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart(Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = points.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
        }
        int n2 = GeoRegionNative.jni_AddPart(this.getHandle(), dArray, dArray2);
        Point2Ds point2Ds = new Point2Ds(this.getPartFromUGC(n2));
        Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
        this.m_geoRegionParts.add(point2Ds2);
        return n2;
    }

    public GeoLine convertToLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoRegionNative.jni_ConvertToLine(this.getHandle());
        if (l != 0L) {
            GeoLine geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
            return geoLine;
        }
        return null;
    }

    public Point2Ds getPart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return (Point2Ds)this.m_geoRegionParts.get(index);
    }

    public boolean insertPart(int index, Point2Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = points.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index > this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
        }
        if (index == this.getPartCount()) {
            int n2 = GeoRegionNative.jni_AddPart(this.getHandle(), dArray, dArray2);
            Point2Ds point2Ds = new Point2Ds(this.getPartFromUGC(n2));
            Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
            this.m_geoRegionParts.add(index, point2Ds2);
            return n2 != -1;
        }
        boolean bl = GeoRegionNative.jni_InsertPart(this.getHandle(), index, dArray, dArray2);
        Point2Ds point2Ds = new Point2Ds(this.getPartFromUGC(index));
        Point2Ds point2Ds3 = new Point2Ds(point2Ds, this);
        this.m_geoRegionParts.add(index, point2Ds3);
        return bl;
    }

    public boolean removePart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoRegionNative.jni_RemovePart(this.getHandle(), index);
        if (bl) {
            this.m_geoRegionParts.remove(index);
        }
        return bl;
    }

    public boolean setPart(int index, Point2Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = points.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
        }
        boolean bl = GeoRegionNative.jni_SetPart(this.getHandle(), index, dArray, dArray2);
        if (bl) {
            Point2Ds point2Ds = (Point2Ds)this.m_geoRegionParts.get(index);
            Point2Ds point2Ds2 = new Point2Ds(this.getPartFromUGC(index));
            Point2Ds point2Ds3 = new Point2Ds(point2Ds2, this);
            this.m_geoRegionParts.set(index, point2Ds3);
            point2Ds.setUserType(Point2Ds.UserType.NONE);
        }
        return bl;
    }

    boolean setPartJustToUGC(int index, Point2Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = points.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
        }
        boolean bl = GeoRegionNative.jni_SetPart(this.getHandle(), index, dArray, dArray2);
        return bl;
    }

    public int indexOf(Point2Ds part) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_geoRegionParts.indexOf(part);
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionNative.jni_GetArea(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionNative.jni_GetPartCount(this.getHandle());
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionNative.jni_GetPerimeter(this.getHandle());
    }

    public boolean isCounterClockwise(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isCounterClockwise(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return GeoRegionNative.jni_IsCounterClockwise(this.getHandle(), index) > 0;
    }

    @Override
    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = super.fromXML(xml);
        if (bl) {
            this.refrashPartsList();
        }
        return bl;
    }

    @Override
    public Geometry mirror(Point2D startPoint, Point2D endPoint) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mirror(Point2D startPoint, Point2D endPoint)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRegion geoRegion = (GeoRegion)super.mirror(startPoint, endPoint);
        int n = geoRegion.getPartCount();
        geoRegion.m_geoRegionParts = new ArrayList();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = new Point2Ds(geoRegion.getPartFromUGC(i));
            Point2Ds point2Ds2 = new Point2Ds(point2Ds, geoRegion);
            geoRegion.m_geoRegionParts.add(point2Ds2);
        }
        return geoRegion;
    }

    @Override
    public void offset(double dx, double dy) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.offset(dx, dy);
        this.refreshFromUGC();
    }

    @Override
    public void resize(Rectangle2D bounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("resize(Rectangle2D bounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.resize(bounds);
        this.refreshFromUGC();
    }

    @Override
    public void rotate(Point2D basePoint, double angle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rotate(Point2D basePoint, double angle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.rotate(basePoint, angle);
        this.refreshFromUGC();
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.m_geoRegionParts != null) {
            this.m_geoRegionParts.clear();
            this.m_geoRegionParts = null;
        }
        this.setHandle(0L);
    }

    protected static void clearHandle(GeoRegion region) {
        region.clearHandle();
    }

    protected void changeHandle(long regionHandle) {
        if (regionHandle == 0L) {
            String string = InternalResource.loadString("regionHandle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setIsDisposable(true);
        this.dispose();
        this.setHandle(regionHandle, false);
    }

    protected static void changeHandle(GeoRegion region, long regionHandle) {
        region.changeHandle(regionHandle);
    }

    ArrayList getPartsList() {
        return this.m_geoRegionParts;
    }

    private Point2D[] getPartFromUGC(int index) {
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = GeoRegionNative.jni_GetPartPointCount(this.getHandle(), index);
        if (n > 2) {
            Point2D[] point2DArray = new Point2D[n];
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            GeoRegionNative.jni_GetPart(this.getHandle(), index, dArray, dArray2);
            for (int i = 0; i < n; ++i) {
                point2DArray[i] = new Point2D(dArray[i], dArray2[i]);
            }
            return point2DArray;
        }
        return null;
    }

    private void refreshFromUGC() {
        int n = this.getPartCount();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = (Point2Ds)this.m_geoRegionParts.get(i);
            point2Ds.setUserType(Point2Ds.UserType.NONE);
            point2Ds.clear();
            point2Ds.addRange(this.getPartFromUGC(i));
            point2Ds.setUserType(Point2Ds.UserType.GEOREGION);
        }
    }

    void refrashPartsList() {
        int n = this.getPartCount();
        this.m_geoRegionParts.clear();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = new Point2Ds(this.getPartFromUGC(i));
            Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
            this.m_geoRegionParts.add(point2Ds2);
        }
    }

    @Override
    public GeoRegion clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoRegion(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoRegionNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRegionNative.jni_Clear(this.getHandle());
        this.m_geoRegionParts.clear();
    }

    GeoRegion(long handle) {
        this.setHandle(handle, false);
        this.m_geoRegionParts = new ArrayList();
        this.refrashPartsList();
    }

    @Override
    protected void refreshHandle(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle, false);
    }

    protected static void refreshHandle(GeoRegion geoRegion, long handle) {
        geoRegion.refreshHandle(handle);
    }

    public GeoRegion[] protectedDecompose() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("protectedDecompose()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = GeoRegionNative.jni_ProtectedDecompose(this.getHandle());
        if (lArray != null && lArray.length > 0) {
            GeoRegion[] geoRegionArray = new GeoRegion[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                geoRegionArray[i] = new GeoRegion(lArray[i]);
                geoRegionArray[i].setIsDisposable(true);
            }
            return geoRegionArray;
        }
        return null;
    }

    public double getPreciseArea(PrjCoordSys prjCoordSys) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPreciseArea(PrjCoordSys prjCoordSys)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d = GeoRegionNative.jni_GetPreciseArea(this.getHandle(), prjCoordSys.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        return d;
    }

    public int[] getPartTopo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartTopo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isEmpty()) {
            return null;
        }
        int[] nArray = GeoRegionNative.jni_GetPartTopo(this.getHandle());
        return nArray;
    }
}

