/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoRegionEPSNative;
import com.supermap.data.GeometryParametric;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;

public class GeoRegionParametric
extends GeometryParametric {
    public GeoRegionParametric() {
        super.setHandle(GeoRegionEPSNative.jni_New(), true);
    }

    public GeoRegionParametric(GeoRegionParametric geoRegion) {
        if (geoRegion == null) {
            String string = InternalResource.loadString("geoRegion", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion.getHandle() == 0L) {
            String string = InternalResource.loadString("geoRegion", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoRegionEPSNative.jni_Clone(geoRegion.getHandle());
        super.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoRegion);
    }

    GeoRegionParametric(long handle) {
        this.setHandle(handle, false);
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionEPSNative.jni_GetArea(this.getHandle());
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionEPSNative.jni_GetPerimeter(this.getHandle());
    }

    @Override
    public GeoRegionParametric clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoRegionParametric(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoRegionEPSNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

