/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.GeoSpheroidNative;
import com.supermap.data.GeoSpheroidType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;

public class GeoSpheroid
extends InternalHandleDisposable {
    public GeoSpheroid() {
        long l = GeoSpheroidNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoSpheroid(GeoSpheroidType type) {
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(type);
        long l = GeoSpheroidNative.jni_New2(n);
        this.setHandle(l, true);
    }

    public GeoSpheroid(double axis, double flatten, String name) {
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoSpheroidNative.jni_New3(axis, flatten, name);
        this.setHandle(l, true);
    }

    public GeoSpheroid(GeoSpheroid geoSpheroid) {
        if (geoSpheroid == null) {
            String string = InternalResource.loadString("geoSpheroid", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoSpheroid.getHandle() == 0L) {
            String string = InternalResource.loadString("geoSpheroid", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoSpheroidNative.jni_Clone(geoSpheroid.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoSpheroid);
    }

    GeoSpheroid(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
    }

    public GeoSpheroid clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoSpheroid(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoSpheroidNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getAxis() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d = GeoSpheroidNative.jni_GetAxis(this.getHandle());
        return d;
    }

    public void setAxis(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != GeoSpheroidType.SPHEROID_USER_DEFINED) {
            String string = InternalResource.loadString("setAxis(double value)", "IfTypeNotUserDefinedCantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        GeoSpheroidNative.jni_SetAxis(this.getHandle(), value);
    }

    public double getFlatten() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFlatten()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d = GeoSpheroidNative.jni_GetFlatten(this.getHandle());
        return d;
    }

    public void setFlatten(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFlatten(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != GeoSpheroidType.SPHEROID_USER_DEFINED) {
            String string = InternalResource.loadString("setFlatten(double value)", "IfTypeNotUserDefinedCantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        GeoSpheroidNative.jni_SetFlatten(this.getHandle(), value);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoSpheroidNative.jni_GetName(this.getHandle());
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoSpheroidNative.jni_SetName(this.getHandle(), value);
    }

    public GeoSpheroidType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoSpheroidNative.jni_GetType(this.getHandle());
        return (GeoSpheroidType)Enum.parseUGCValue(GeoSpheroidType.class, n);
    }

    public void setType(GeoSpheroidType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setType(GeoSpheroidType value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(value);
        GeoSpheroidNative.jni_SetType(this.getHandle(), n);
    }

    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (xml != null && xml.trim().length() != 0) {
            bl = GeoSpheroidNative.jni_FromXML(this.getHandle(), xml);
        }
        return bl;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoSpheroidNative.jni_ToXML(this.getHandle());
    }
}

