/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.GeoStyle3D;
import com.supermap.data.Geometry;
import com.supermap.data.Point3D;
import com.supermap.data.Rectangle2D;
import com.supermap.realspace.CullModeType;
import com.supermap.realspace.HypsometricSetting;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalFieldInfos;
import com.supermap.realspace.InternalGeoStyle3D;
import com.supermap.realspace.InternalGeometry;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3DOSGBNative;
import com.supermap.realspace.Layer3Ds;
import com.supermap.realspace.LoadingPriorityEnum;
import com.supermap.realspace.ModifyRegionMode;
import com.supermap.realspace.OSGBType;
import com.supermap.realspace.OperationMode;
import com.supermap.realspace.PointCloudClassificationInfo;
import com.supermap.realspace.SelectedOSGBFileInfo;
import com.supermap.realspace.Volume3D;
import com.supermap.realspace.WireFrameType;
import java.awt.Color;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.regex.Pattern;

public class Layer3DOSGBFile
extends Layer3D {
    private FieldInfos m_fieldInfos;
    private int m_fieldCount;
    private boolean[] m_flag = new boolean[]{false};
    private GeoStyle3D m_geoStyle3D;
    private HypsometricSetting m_hypsometricSetting;
    private Volume3D m_volume;

    Layer3DOSGBFile(long handle, Layer3Ds layer3Ds) {
        super(handle, layer3Ds);
        long l = Layer3DOSGBNative.jni_GetSeoStyle3D(this.getHandle());
        this.m_geoStyle3D = InternalGeoStyle3D.createInstance(l);
        long l2 = Layer3DOSGBNative.jni_GetFieldInfos(this.getHandle());
        this.m_fieldInfos = InternalFieldInfos.createInstance(l2);
        this.m_fieldCount = this.m_fieldInfos.getCount();
        long l3 = Layer3DOSGBNative.jni_GetHypsometricSetting(handle);
        this.m_hypsometricSetting = l3 != 0L ? new HypsometricSetting(l3) : null;
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }

    public int getFlattenRegionCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFlattenRegionCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetFlattenRegionCount(this.getHandle());
    }

    public boolean isExcavation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isExcavation()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetExcavation(this.getHandle());
    }

    public void setExcavation(boolean bValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExcavation()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetExcavation(this.getHandle(), bValue);
    }

    public double getLODRangeScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLODRangeScale()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetLODRangeScale(this.getHandle());
    }

    public void setLODRangeScale(double dValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLODRangeScale()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetLODRangeScale(this.getHandle(), dValue);
    }

    public void setObjectsVisible(int[] nIds, boolean bVisible) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setObjectsVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetObjectsVisible(this.getHandle(), nIds, bVisible);
    }

    public int addFlattenRegion(Geometry geometry, String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addFlattenRegion()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (tag == null) {
            tag = "";
        }
        Geometry geometry2 = geometry.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry2, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry2);
        if (l2 == 0L) {
            return -1;
        }
        int n = Layer3DOSGBNative.jni_AddFlattenRegion(this.getHandle(), l2, tag);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry2);
        return n;
    }

    public int indexOfFlattenRegion(String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOfFlattenRegion()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_IndexOfFlattenRegion(this.getHandle(), tag);
    }

    public boolean removeFlattenRegion(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeFlattenRegion()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_RemoveFlattenRegion(this.getHandle(), index);
    }

    public boolean setFlattenRegionTag(int index, String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFlattenRegionTag()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_SetFlattenRegionTag(this.getHandle(), index, tag);
    }

    public Geometry getFlattenRegion(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFlattenRegion()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getFlattenRegionCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry = null;
        long l = Layer3DOSGBNative.jni_GetFlattenRegion(this.getHandle(), index);
        if (l != 0L) {
            geometry = InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, true);
        }
        return geometry;
    }

    public void clearFlattenRegions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clearFlattenRegions()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_ClearFlattenRegions(this.getHandle());
    }

    public void setObjectsColor(int[] ids, Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setObjectsColor()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetObjectsColor(this.getHandle(), ids, color.getRGB());
    }

    public Color[] getObjectsColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getObjectsColor()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = Layer3DOSGBNative.jni_GetObjectsColor(this.getHandle());
        Color[] colorArray = new Color[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            colorArray[i] = new Color(nArray[i], true);
        }
        return colorArray;
    }

    public int[] getObjectsColorIDs() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getObjectsColorIDs()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetObjectsColorIDs(this.getHandle());
    }

    public void removeObjectsColor(int[] ids) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeObjectsColor()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_RemoveObjectsColor(this.getHandle(), ids);
    }

    public void clearObjectsColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clearObjectsColor()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_ClearObjectsColor(this.getHandle());
    }

    public void setSelectionFiltrateByTransparency(double thredhold) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSelectionFiltrateByTransparency()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetSelectionFiltrateByTransparency(this.getHandle(), thredhold);
    }

    public double getSelectionFiltrateByTransparency() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelectionFiltrateByTransparency()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetSelectionFiltrateByTransparency(this.getHandle());
    }

    public Volume3D getVolume() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVolume()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_volume == null) {
            this.m_volume = new Volume3D(this);
        }
        return this.m_volume;
    }

    public FieldInfos getFieldInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFieldInfos", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return new FieldInfos(this.m_fieldInfos);
    }

    public Object getFieldValueOfSelectedObject(int index) {
        FieldType fieldType = this.m_fieldInfos.get(index).getType();
        if (fieldType.equals((Object)FieldType.INT32)) {
            Integer n = this.getInt32(index);
            if (this.m_flag[0]) {
                return null;
            }
            return n;
        }
        if (fieldType.equals((Object)FieldType.INT16)) {
            Short s = this.getInt16(index);
            if (this.m_flag[0]) {
                return null;
            }
            return s;
        }
        if (fieldType.equals((Object)FieldType.INT64)) {
            Double d = this.getDouble(index);
            if (this.m_flag[0]) {
                return null;
            }
            return d;
        }
        if (fieldType.equals((Object)FieldType.BOOLEAN)) {
            Boolean bl = this.getBoolean(index);
            if (this.m_flag[0]) {
                return null;
            }
            return bl;
        }
        if (fieldType.equals((Object)FieldType.WTEXT)) {
            String string = this.getString(index);
            if (this.m_flag[0]) {
                return null;
            }
            return string;
        }
        if (fieldType.equals((Object)FieldType.BYTE)) {
            Byte by = this.getByte(index);
            if (this.m_flag[0]) {
                return null;
            }
            return by;
        }
        if (fieldType.equals((Object)FieldType.CHAR)) {
            String string = this.getString(index);
            if (this.m_flag[0]) {
                return null;
            }
            return string;
        }
        if (fieldType.equals((Object)FieldType.DATETIME)) {
            Date date = this.getDateTime(index);
            if (this.m_flag[0]) {
                return null;
            }
            return date;
        }
        if (fieldType.equals((Object)FieldType.DATE)) {
            Date date = this.getDateTime(index);
            if (this.m_flag[0]) {
                return null;
            }
            return date;
        }
        if (fieldType.equals((Object)FieldType.TIME)) {
            Date date = this.getDateTime(index);
            if (this.m_flag[0]) {
                return null;
            }
            return date;
        }
        if (fieldType.equals((Object)FieldType.DOUBLE)) {
            double d = this.getDouble(index);
            if (this.m_flag[0]) {
                return null;
            }
            return d;
        }
        if (fieldType.equals((Object)FieldType.LONGBINARY)) {
            byte[] byArray = this.getLongBinary(index);
            if (this.m_flag[0]) {
                return null;
            }
            return byArray;
        }
        if (fieldType.equals((Object)FieldType.SINGLE)) {
            Float f = Float.valueOf(this.getSingle(index));
            if (this.m_flag[0]) {
                return null;
            }
            return f;
        }
        if (fieldType.equals((Object)FieldType.TEXT)) {
            String string = this.getString(index);
            if (this.m_flag[0]) {
                return null;
            }
            return string;
        }
        return null;
    }

    public Object getFieldValueOfSelectedObject(String name) {
        this.checkExceptionForGetFieldValueByName(name);
        int n = this.m_fieldInfos.indexOf(name);
        if (n < 0) {
            String string = InternalResource.loadString("" + n, "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.getFieldValueOfSelectedObject(n);
    }

    private void checkExceptionForGetFieldValueByIndex(int index) {
        if (index < 0 || index >= this.m_fieldCount) {
            String string = InternalResource.loadString("" + index, "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
    }

    private int getInt32(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        int n = Layer3DOSGBNative.jni_GetFieldValueIntByIndex(this.getHandle(), index, this.m_flag);
        return n;
    }

    private short getInt16(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        short s = Layer3DOSGBNative.jni_GetFieldValueShortByIndex(this.getHandle(), index, this.m_flag);
        return s;
    }

    private boolean getBoolean(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        boolean bl = Layer3DOSGBNative.jni_GetFieldValueBooleanByIndex(this.getHandle(), index, this.m_flag);
        return bl;
    }

    private String getString(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        boolean[] blArray = new boolean[]{false};
        String string = Layer3DOSGBNative.jni_GetFieldValueTextByIndex(this.getHandle(), index, blArray);
        return string;
    }

    private Date getDateTime(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        boolean[] blArray = new boolean[]{false};
        Date date = this.getFieldValueDateTimeByIndex(index, blArray);
        return date;
    }

    private Date getFieldValueDateTimeByIndex(int index, boolean[] m_flag) {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        String string = Layer3DOSGBNative.jni_GetFieldValueDateByIndex(this.getHandle(), index, m_flag);
        Date date = null;
        if (pattern.matcher(string).matches()) {
            try {
                date = DateFormat.getDateTimeInstance().parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    private double getDouble(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        boolean[] blArray = new boolean[]{false};
        double d = Layer3DOSGBNative.jni_GetFieldValueDoubleByIndex(this.getHandle(), index, blArray);
        return d;
    }

    private float getSingle(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        boolean[] blArray = new boolean[]{false};
        float f = Layer3DOSGBNative.jni_GetFieldValueFloatByIndex(this.getHandle(), index, blArray);
        return f;
    }

    private byte getByte(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        boolean[] blArray = new boolean[]{false};
        byte by = Layer3DOSGBNative.jni_GetFieldValueByteByIndex(this.getHandle(), index, blArray);
        return by;
    }

    private byte[] getLongBinary(int index) {
        this.checkExceptionForGetFieldValueByIndex(index);
        boolean[] blArray = new boolean[]{false};
        byte[] byArray = Layer3DOSGBNative.jni_GetFieldValueLongBinaryByIndex(this.getHandle(), index, blArray);
        return byArray;
    }

    private void checkExceptionForGetFieldValueByName(String name) {
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public void getVolNames(ArrayList<String> volNames) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (volNames == null) {
            return;
        }
        String[] stringArray = Layer3DOSGBNative.jni_GetVolNames(this.getHandle());
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        volNames.clear();
        for (String string : stringArray) {
            volNames.add(string);
        }
    }

    public String getVisibleVolName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetVisibleVolName(this.getHandle());
    }

    public void setVisibleVolName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetVisibleVolName(this.getHandle(), value);
    }

    public int getVisibleVolIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetVisibleVolIndex(this.getHandle());
    }

    public void setVisibleVolIndex(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetVisibleVolIndex(this.getHandle(), value);
    }

    public OSGBType getDataType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DOSGBNative.jni_GetDataType(this.getHandle());
        return (OSGBType)InternalEnum.parseUGCValue(OSGBType.class, n);
    }

    public void setModifyRegions(ArrayList<Geometry> regions, ModifyRegionMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = null;
        if (regions != null) {
            lArray = new long[regions.size()];
            for (int i = 0; i < regions.size(); ++i) {
                lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)regions.get(i));
            }
        }
        Layer3DOSGBNative.jni_SetModifyRegions(this.getHandle(), lArray, mode.value());
    }

    public void clearModifyRegions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_ClearModifyRegions(this.getHandle());
    }

    public Calendar getHistory() {
        String[] stringArray;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        GregorianCalendar gregorianCalendar = null;
        String string = Layer3DOSGBNative.jni_GetHistory(this.getHandle());
        if (string != null && (stringArray = string.trim().split(" ")).length == 2) {
            String[] stringArray2 = stringArray[0].trim().split("-");
            String[] stringArray3 = stringArray[1].trim().split(":");
            int n = Integer.parseInt(stringArray2[0]);
            int n2 = Integer.parseInt(stringArray2[1]);
            int n3 = Integer.parseInt(stringArray2[2]);
            int n4 = Integer.parseInt(stringArray3[0]);
            int n5 = Integer.parseInt(stringArray3[1]);
            int n6 = Integer.parseInt(stringArray3[2]);
            gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3, n4, n5, n6);
        }
        return gregorianCalendar;
    }

    public void setHistory(Calendar value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        String string = String.format("%1$tY-%1$tm-%1$td %1$tT", value);
        Layer3DOSGBNative.jni_SetHistory(this.getHandle(), string);
    }

    public boolean getTransparentSorting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetTransparentSorting(this.getHandle());
    }

    public void setTransparentSorting(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetTransparentSorting(this.getHandle(), value);
    }

    public WireFrameType getWireFrameMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DOSGBNative.jni_GetWireFrameMode(this.getHandle());
        return (WireFrameType)InternalEnum.parseUGCValue(WireFrameType.class, n);
    }

    public void setWireFrameMode(WireFrameType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetWireFrameMode(this.getHandle(), value.value());
    }

    public float getBrightness() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetBrightness(this.getHandle());
    }

    public void setBrightness(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetBrightness(this.getHandle(), value);
    }

    public float getConstrast() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetConstrast(this.getHandle());
    }

    public void setConstrast(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetConstrast(this.getHandle(), value);
    }

    public float getHue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetHue(this.getHandle());
    }

    public void setHue(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetHue(this.getHandle(), value);
    }

    public float getSaturation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetSaturation(this.getHandle());
    }

    public void setSaturation(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetSaturation(this.getHandle(), value);
    }

    public float getGamma() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetGamma(this.getHandle());
    }

    public void setGamma(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetGamma(this.getHandle(), value);
    }

    public float getConstantPolygonOffset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetConstantPolygonOffset(this.getHandle());
    }

    public void setConstantPolygonOffset(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetConstantPolygonOffset(this.getHandle(), value);
        this.updateData();
    }

    public float getSlopeScalePolygonOffset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetSlopeScalePolygonOffset(this.getHandle());
    }

    public void setSlopeScalePolygonOffset(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetSlopeScalePolygonOffset(this.getHandle(), value);
        this.updateData();
    }

    public GeoStyle3D getStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_geoStyle3D;
    }

    public void setStyle(GeoStyle3D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        if (l == 0L) {
            String string = InternalResource.loadString("value", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
    }

    public CullModeType getCullMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DOSGBNative.jni_GetCullMode(this.getHandle());
        return (CullModeType)InternalEnum.parseUGCValue(CullModeType.class, n);
    }

    public void setCullMode(CullModeType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetCullMode(this.getHandle(), value.value());
    }

    public HashMap<OperationMode, int[]> getOperationViewportIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DOSGBNative.jni_GetOperationViewportIndexCount(this.getHandle());
        HashMap<OperationMode, int[]> hashMap = new HashMap<OperationMode, int[]>();
        if (n > 0) {
            int[] nArray = new int[n];
            Object[] objectArray = new Object[n];
            Layer3DOSGBNative.jni_GetOperationViewportIndex(this.getHandle(), nArray, objectArray);
            for (int i = 0; i < n; ++i) {
                OperationMode operationMode = (OperationMode)InternalEnum.parseUGCValue(OperationMode.class, nArray[i]);
                hashMap.put(operationMode, (int[])objectArray[i]);
            }
        }
        return hashMap;
    }

    public void setOperationViewportIndex(OperationMode type, int[] index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetOperationViewportIndex(this.getHandle(), type.value(), index);
    }

    public String getFlattenRegionTag(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getFlattenRegionCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return Layer3DOSGBNative.jni_GetFlattenRegionTag(this.getHandle(), index);
    }

    public boolean isSelectByFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSelectedByFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetSelectByFile(this.getHandle());
    }

    public void setSelectByFile(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSelectedByFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetSelectByFile(this.getHandle(), value);
    }

    public ArrayList<SelectedOSGBFileInfo> getSelectedFileInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelectedFileInfos", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        String[] stringArray = Layer3DOSGBNative.jni_GetSelectedFileInfos(this.getHandle());
        ArrayList<SelectedOSGBFileInfo> arrayList = new ArrayList<SelectedOSGBFileInfo>();
        for (int i = 0; i < stringArray.length; i += 4) {
            String string = stringArray[i];
            double d = Double.valueOf(stringArray[i + 1]);
            double d2 = Double.valueOf(stringArray[i + 2]);
            double d3 = Double.valueOf(stringArray[i + 3]);
            Point3D point3D = new Point3D(d, d2, d3);
            SelectedOSGBFileInfo selectedOSGBFileInfo = new SelectedOSGBFileInfo(string, point3D);
            arrayList.add(selectedOSGBFileInfo);
        }
        return arrayList;
    }

    public void setHypsometricSetting(HypsometricSetting value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            return;
        }
        if (this.m_hypsometricSetting == null) {
            this.m_hypsometricSetting = new HypsometricSetting(InternalHandle.getHandle((com.supermap.data.InternalHandle)value));
        } else if (this.m_hypsometricSetting != value) {
            this.m_hypsometricSetting.ResetHypsometric(InternalHandle.getHandle((com.supermap.data.InternalHandle)value));
        }
        Layer3DOSGBNative.jni_SetHypsometricSetting(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_hypsometricSetting));
    }

    public HypsometricSetting getHypsometricSetting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_hypsometricSetting;
    }

    public double getMinDataValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinDataValue", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetMinDataValue(this.getHandle());
    }

    public double getMaxDataValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxDataValue", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetMaxDataValue(this.getHandle());
    }

    public ArrayList<PointCloudClassificationInfo> getPointCloudClassificationInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPointCloudClassificationInfos", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        String[] stringArray = Layer3DOSGBNative.jni_GetPointCloudClassificationInfos(this.getHandle());
        if (stringArray.length < 1) {
            return null;
        }
        ArrayList<PointCloudClassificationInfo> arrayList = new ArrayList<PointCloudClassificationInfo>();
        for (int i = 0; i < stringArray.length / 3; ++i) {
            String string = stringArray[3 * i];
            int n = Integer.valueOf(stringArray[3 * i + 1]);
            long l = Long.valueOf(stringArray[3 * i + 2]);
            PointCloudClassificationInfo pointCloudClassificationInfo = new PointCloudClassificationInfo(n, string, l);
            arrayList.add(pointCloudClassificationInfo);
        }
        return arrayList;
    }

    public String[] getPointCloudGroupInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPointCloudGroupInfos", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DOSGBNative.jni_GetPointCloudGroupInfos(this.getHandle());
    }

    public Rectangle2D getPointCloudGroupBounds(String groupName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPointCloudGroupBounds", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = Layer3DOSGBNative.jni_GetPointCloudGroupBounds(this.getHandle(), groupName);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[3], dArray[2], dArray[1]);
        return rectangle2D;
    }

    public void setPointCloudGroupsVisible(String[] groupNames, boolean bVisible) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPointCloudGroupsVisible", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetPointCloudGroupVisible(this.getHandle(), groupNames, bVisible);
    }

    public LoadingPriorityEnum getLoadingPriority() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLoadingPriority", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DOSGBNative.jni_GetLoadingPriority(this.getHandle());
        if (n == 0) {
            return LoadingPriorityEnum.CHILD_PRIORITY;
        }
        if (n == 1) {
            return LoadingPriorityEnum.ROOT_PRIORITY;
        }
        if (n == 2) {
            return LoadingPriorityEnum.USE_PAGEDLOD_INFO;
        }
        return LoadingPriorityEnum.CHILD_PRIORITY_NONLINEAR;
    }

    public void setLoadingPriority(LoadingPriorityEnum loadingPriorityType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLoadingPriority", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DOSGBNative.jni_SetLoadingPriority(this.getHandle(), loadingPriorityType.value());
    }
}

