/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.Colors;
import com.supermap.realspace.InternalColors;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3DNative;
import com.supermap.realspace.Layer3DSetting;
import com.supermap.realspace.Layer3DSettingType;
import com.supermap.realspace.Layer3Ds;
import java.awt.Color;

public class Layer3DSettingGrid
extends Layer3DSetting {
    private Layer3D m_layer3D;
    private Layer3Ds m_layer3Ds;
    private boolean isOwnerLayer;
    private boolean m_transparent;
    private Color m_transparentColor;
    private int m_transparentColorTolerance;
    private Colors m_colorTable = null;
    private double[] m_gridValueTable = null;
    private double m_specialValue = -9999.0;
    private Color m_specialValueColor = Color.black;
    private boolean m_specialValueTransparent = false;

    public Layer3DSettingGrid() {
        this.isOwnerLayer = false;
        this.setTransparent(false);
        this.setTransparentColor(new Color(255, 255, 255));
        this.setTransparentColorTolerance(24);
        Colors colors = new Colors();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this.m_colorTable = InternalColors.createInstance(l, false);
    }

    public Layer3DSettingGrid(Layer3DSettingGrid settingGrid) {
        if (settingGrid == null) {
            String string = InternalResource.loadString("settingGrid", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (settingGrid.isOwnerLayer) {
            if (settingGrid.m_layer3D == null) {
                String string = InternalResource.loadString("settingGrid", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle(settingGrid.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("settingGrid", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
            int n = settingGrid.m_layer3Ds.getLayersList().indexOf((Object)settingGrid.m_layer3D);
            if (n == -1) {
                String string = InternalResource.loadString("settingGrid", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        this.isOwnerLayer = false;
        this.setTransparent(settingGrid.isTransparent());
        this.setTransparentColor(settingGrid.getTransparentColor());
        this.setTransparentColorTolerance(settingGrid.getTransparentColorTolerance());
        Colors colors = new Colors(settingGrid.getColorTable());
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this.m_colorTable = InternalColors.createInstance(l, false);
        this.m_gridValueTable = (double[])settingGrid.getGridValueTable().clone();
        this.m_specialValue = settingGrid.getSpecialValue();
        this.m_specialValueColor = settingGrid.getSpecialValueColor();
        this.m_specialValueTransparent = settingGrid.isSpecialValueTransparent();
    }

    Layer3DSettingGrid(Layer3D layer3D, Layer3Ds layer3Ds) {
        this.m_layer3D = layer3D;
        this.m_layer3Ds = layer3Ds;
        this.isOwnerLayer = true;
        this.m_transparent = false;
        this.m_transparentColor = new Color(255, 255, 255);
        this.m_transparentColorTolerance = 24;
        Colors colors = new Colors();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this.m_colorTable = InternalColors.createInstance(l, false);
    }

    public boolean isTransparent() {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("isTransparent()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("isTransparent()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            this.m_transparent = Layer3DNative.jni_IsTransparent(l);
        }
        return this.m_transparent;
    }

    public void setTransparent(boolean transparent) {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("setTransparent(boolean transparent)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparent(boolean transparent)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            Layer3DNative.jni_SetTransparent(l, transparent);
        }
        this.m_transparent = transparent;
    }

    public Color getTransparentColor() {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("getTransparentColor()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("getTransparentColor()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            this.m_transparentColor = new Color(Layer3DNative.jni_GetTransparentColor(l));
        }
        return this.m_transparentColor;
    }

    public void setTransparentColor(Color color) {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("setTransparent(boolean transparent)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparent(boolean transparent)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            Layer3DNative.jni_SetTransparentColor(l, color.getRGB());
        }
        this.m_transparentColor = color;
    }

    public int getTransparentColorTolerance() {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("getTransparentColorTolerance()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("getTransparentColorTolerance()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            this.m_transparentColorTolerance = Layer3DNative.jni_GetTransparentColorTolerance(l);
        }
        return this.m_transparentColorTolerance;
    }

    public void setTransparentColorTolerance(int colorTolerance) {
        if (colorTolerance < 0 || colorTolerance > 255) {
            String string = InternalResource.loadString("setTransparentColorTolerance(int colorTolerance)", "TransparentColorTolerance_ShouldBetween0And255", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("setTransparentColorTolerance(int colorTolerance)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setTransparentColorTolerance(int colorTolerance)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            Layer3DNative.jni_SetTransparentColorTolerance(l, colorTolerance);
        }
        this.m_transparentColorTolerance = colorTolerance;
    }

    @Override
    void clearHandle() {
        this.m_layer3D = null;
        this.m_layer3Ds = null;
    }

    @Override
    public Layer3DSettingType getType() {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("getType()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("getType()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        return Layer3DSettingType.GRID;
    }

    @Override
    void reset(Layer3DSetting value) {
        this.setTransparent(((Layer3DSettingGrid)value).isTransparent());
        this.setTransparentColor(((Layer3DSettingGrid)value).getTransparentColor());
        this.setTransparentColorTolerance(((Layer3DSettingGrid)value).getTransparentColorTolerance());
    }

    public Colors getColorTable() {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("getColorTable()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("getColorTable()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l2 = Layer3DNative.jni_GetColorTable(l);
            if (this.m_colorTable != null && l2 != 0L && InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_colorTable) != l2) {
                InternalColors.changeHandle(this.m_colorTable, l2);
            }
        }
        return this.m_colorTable;
    }

    public void setColorTable(Colors colorTable) {
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("setColorTable(Colors colorTable)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setColorTable(Colors colorTable)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (colorTable == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)colorTable) == 0L) {
            String string = InternalResource.loadString("colorTable", "Layer3DSettingGrid_InvalidColors", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Colors colors = new Colors(colorTable);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        if (this.isOwnerLayer) {
            Layer3DNative.jni_SetColorTable(l, l2);
        } else if (this.m_colorTable == null) {
            this.m_colorTable = InternalColors.createInstance(l2, false);
        } else {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
            InternalColors.changeHandle(this.m_colorTable, l2);
        }
    }

    public double[] getGridValueTable() {
        if (this.m_layer3D == null) {
            String string = InternalResource.loadString("getGridValueTable()", "Global_OwnerHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_gridValueTable;
    }

    public void setGridValueTable(double[] value) {
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("setGridValueTable(List value)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setGridValueTable(List value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            if (value == null) {
                String string = InternalResource.loadString("", "Global_ArgumentNull", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
            double[] dArray = (double[])value.clone();
            Layer3DNative.jni_SetGridValueTable(l, dArray);
        }
        this.m_gridValueTable = value;
    }

    public Color getSpecialValueColor() {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("getSpecialValueColor()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("getSpecialValueColor()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = Layer3DNative.jni_GetGridSpecialValueColor(l);
            return new Color(n);
        }
        return this.m_specialValueColor;
    }

    public void setSpecialValueColor(Color value) {
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("setSpecialValueColor(Color value)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setSpecialValueColor(Color value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = value.getRGB();
            Layer3DNative.jni_SetGridSpecialValueColor(l, n);
        }
        this.m_specialValueColor = value;
    }

    public double getSpecialValue() {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("getSpecialValue()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("getSpecialValue()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            this.m_specialValue = Layer3DNative.jni_GetGridSpecialValue(l);
        }
        return this.m_specialValue;
    }

    public void setSpecialValue(double value) {
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("setSpecialValue(double value)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setSpecialValue(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            Layer3DNative.jni_SetGridSpecialValue(l, value);
        }
        this.m_specialValue = value;
    }

    public boolean isSpecialValueTransparent() {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("isSpecialValueColorTransparent()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("isSpecialValueColorTransparent()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            this.m_specialValueTransparent = Layer3DNative.jni_IsSpecialValueTransparent(l);
        }
        return this.m_specialValueTransparent;
    }

    public void setSpecialValueTransparent(boolean transparent) {
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("setSpecialValueColorTransparent(boolean transparent)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setSpecialValueColorTransparent(boolean transparent)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            Layer3DNative.jni_SetSpecialValueTransparent(l, transparent);
        }
        this.m_specialValueTransparent = transparent;
    }

    public void setOpaqueRate(int value) {
        long l = InternalHandle.getHandle(this.m_layer3D);
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("setOpaqueRate()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            if (l == 0L) {
                String string = InternalResource.loadString("setOpaqueRate()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        Layer3DNative.jni_SetOpaqueRate(l, value);
    }

    public int getOpaqueRate() {
        long l = InternalHandle.getHandle(this.m_layer3D);
        if (this.isOwnerLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("getOpaqueRate()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            if (l == 0L) {
                String string = InternalResource.loadString("getOpaqueRate()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        return Layer3DNative.jni_GetOpaqueRate(l);
    }
}

