/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.GeoModel;
import com.supermap.realspace.FlyEventType;
import com.supermap.realspace.FlyManager;
import com.supermap.realspace.FlyManagerNative;
import com.supermap.realspace.InternalGeoModel;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.PropertiesChangedEvent;
import com.supermap.realspace.Route;
import com.supermap.realspace.RoutesNative;
import com.supermap.realspace.Scene;
import java.util.ArrayList;

public class Routes
extends InternalHandle {
    FlyManager m_flyManager;
    ArrayList<Route> m_routes;
    GeoModel m_geoModel = null;

    protected Routes(FlyManager flyManager) {
        long l = FlyManagerNative.jni_GetRoutesHandle(InternalHandle.getHandle((com.supermap.data.InternalHandle)flyManager));
        this.setHandle(l);
        this.m_routes = new ArrayList();
        this.m_flyManager = flyManager;
        this.fillRoute();
    }

    private void fillRoute() {
        int n;
        int n2 = this.getCount();
        for (n = 0; n < n2; ++n) {
            long l = RoutesNative.jni_Get(this.getHandle(), n);
            Route route = new Route(l);
            route.m_flyManager = this.m_flyManager;
            this.m_routes.add(route);
        }
        n = this.m_routes.size();
        if (n > 0) {
            this.setCurrentRouteIndex(n - 1);
        }
    }

    private void clearRoute() {
        if (this.m_routes != null) {
            this.m_routes.clear();
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RoutesNative.jni_GetCount(this.getHandle());
    }

    public int indexOf(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            String string = InternalResource.loadString("indexOf", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        if (name != null && name.trim().length() != 0) {
            int n2 = this.getCount();
            for (int i = 0; i < n2; ++i) {
                if (!name.equalsIgnoreCase(this.get(i).getName())) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public Route get(String name) {
        return this.get(this.indexOf(name));
    }

    public Route get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("get", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Route route = this.m_routes.get(index);
        route.m_flyManager = this.m_flyManager;
        return route;
    }

    public void set(String name, Route route) {
        this.set(this.indexOf(name), route);
    }

    public void set(int index, Route route) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("set", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (route == null) {
            String string = InternalResource.loadString("set", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)route);
        RoutesNative.jni_Set(this.getHandle(), index, l);
        this.m_routes.set(index, route);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    private GeoModel getFollowModel() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFollowModel", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoModel == null && (l = RoutesNative.jni_GetFollowModel(this.getHandle())) != 0L) {
            this.m_geoModel = InternalGeoModel.createInstance(l);
        }
        return this.m_geoModel;
    }

    private void setFollowModel(GeoModel value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFollowModel", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        RoutesNative.jni_SetFollowModel(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public double getCameraDistanceX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCameraDistanceX()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RoutesNative.jni_GetCameraDistanceX(this.getHandle());
    }

    public void setCameraDistanceX(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCameraDistanceX(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "Argument_ShouldBePositive", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        RoutesNative.jni_SetCameraDistanceX(this.getHandle(), value);
    }

    public double getCameraDistanceY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCameraDistanceY()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RoutesNative.jni_GetCameraDistanceY(this.getHandle());
    }

    public void setCameraDistanceY(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCameraDistanceY(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "Argument_ShouldBePositive", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        RoutesNative.jni_SetCameraDistanceY(this.getHandle(), value);
    }

    public double getCameraDistanceZ() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCameraDistanceZ()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RoutesNative.jni_GetCameraDistanceZ(this.getHandle());
    }

    public void setCameraDistanceZ(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCameraDistanceZ(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "Argument_ShouldBePositive", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        RoutesNative.jni_SetCameraDistanceZ(this.getHandle(), value);
    }

    public int getCurrentRouteIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentRouteIndex", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RoutesNative.jni_GetCurrentRouteIndex(this.getHandle());
    }

    public Route getCurrentRoute() {
        Route route = null;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentRoute()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_routes.size() > 0) {
            route = this.m_routes.get(this.getCurrentRouteIndex());
        }
        return route;
    }

    public void setCurrentRouteIndex(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCurrentRouteIndex", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("setCurrentRouteIndex", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        RoutesNative.jni_SetCurrentRouteIndex(this.getHandle(), index);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.CURRENT_ROUTE_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public boolean contains(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("contains", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.indexOf(name) != -1;
    }

    public int add(Route route) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (route == null) {
            String string = InternalResource.loadString("add", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        String string = route.getName();
        if (this.contains(string)) {
            String string2 = InternalResource.loadString("add", "Route_IsAlreadyExist", "realspace_resources");
            throw new IllegalArgumentException(string2);
        }
        Route route2 = new Route(route);
        int n = -1;
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)route2);
        if (l != 0L && (n = RoutesNative.jni_Add(this.getHandle(), l)) != -1) {
            this.m_routes.add(route2);
            if (this.m_flyManager != null) {
                Scene scene = this.m_flyManager.getScene();
                route2.setScene(scene);
                route2.m_flyManager = this.m_flyManager;
                route.m_flyManager = this.m_flyManager;
                PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_COUNT_CHANGED);
                this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
            }
        }
        return n;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("remove", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Route route = this.get(index);
        if (route == null) {
            String string = InternalResource.loadString("remove", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)route) == 0L) {
            String string = InternalResource.loadString("remove", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = RoutesNative.jni_Remove(this.getHandle(), index);
        if (bl) {
            this.m_routes.remove(index);
            route.clearHandle();
        }
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        return bl;
    }

    public boolean remove(String name) {
        int n = this.indexOf(name);
        return this.remove(n);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RoutesNative.jni_Clear(this.getHandle());
        this.clearRoute();
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RoutesNative.jni_ToXML(this.getHandle());
    }

    public boolean fromXML(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("fromXML", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = RoutesNative.jni_FromXML(this.getHandle(), value);
        if (bl) {
            this.clear();
            this.fillRoute();
        }
        this.m_routes.get(this.getCurrentRouteIndex()).setScene(this.m_flyManager.getScene());
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        return bl;
    }

    public void toFile(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("toFile", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        RoutesNative.jni_ToFile(this.getHandle(), value);
    }

    public boolean fromFile(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("fromFile", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = RoutesNative.jni_FromFile(this.getHandle(), value);
        if (bl) {
            this.clearRoute();
            this.fillRoute();
            this.m_routes.get(this.getCurrentRouteIndex()).setScene(this.m_flyManager.getScene());
        }
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        return bl;
    }

    protected void finalize() throws Throwable {
        if (this.getHandle() != 0L) {
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
        int n = this.m_routes.size();
        for (int i = 0; i < n; ++i) {
            Route route = this.m_routes.get(i);
            route.clearHandle();
        }
    }
}

