/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.License;
import com.supermap.LicenseFeatureInfo;
import com.supermap.ProductType;
import com.supermap.data.AltitudeMode;
import com.supermap.data.Enum;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoModel;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Point3D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.realspace.Atmosphere;
import com.supermap.realspace.Camera;
import com.supermap.realspace.FlownEvent;
import com.supermap.realspace.FlownListener;
import com.supermap.realspace.FlyManager;
import com.supermap.realspace.FlyingMode;
import com.supermap.realspace.Fog;
import com.supermap.realspace.GlobalImage;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.InternalSceneControl;
import com.supermap.realspace.InternalToolkitSpace;
import com.supermap.realspace.LatLonGrid;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3DGroup;
import com.supermap.realspace.Layer3Ds;
import com.supermap.realspace.LookAt;
import com.supermap.realspace.MultiViewportMode;
import com.supermap.realspace.Ocean;
import com.supermap.realspace.ParallaxMode;
import com.supermap.realspace.PixelToGlobeMode;
import com.supermap.realspace.SceneClosedEvent;
import com.supermap.realspace.SceneClosedListener;
import com.supermap.realspace.SceneNative;
import com.supermap.realspace.SceneOpenedEvent;
import com.supermap.realspace.SceneOpenedListener;
import com.supermap.realspace.SceneType;
import com.supermap.realspace.ScreenLayer3D;
import com.supermap.realspace.Selection3D;
import com.supermap.realspace.Slider;
import com.supermap.realspace.Splitter;
import com.supermap.realspace.StereoMode;
import com.supermap.realspace.Sun;
import com.supermap.realspace.TerrainLayers;
import com.supermap.realspace.TrackingLayer3D;
import com.supermap.realspace.Underground;
import com.supermap.ui.InternalBufferImage;
import com.supermap.ui.SceneControl;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Timer;

public class Scene
extends InternalHandleDisposable {
    private Workspace m_workspace;
    private Layer3Ds m_layer3Ds;
    private ScreenLayer3D m_screenLayer;
    private TrackingLayer3D m_trackingLayer;
    private Fog m_fog;
    private LatLonGrid m_latLonGrid;
    private Atmosphere m_atmosphere;
    private Ocean m_ocean;
    private Sun m_sun;
    private Underground m_underground;
    private GlobalImage m_globalImage;
    private TerrainLayers m_terrainLayers;
    private SceneControl m_sceneControl;
    private License m_license;
    private FlyManager m_flyManager;
    private static final double DTOR = Math.PI / 180;
    private static final double RTOD = 57.29577951308232;
    transient Vector m_flownListeners;
    transient Vector m_sceneOpenedListeners;
    transient Vector m_sceneClosedListeners;
    private Timer m_timer;
    private HashMap<String, Splitter> m_dicSplitters = new HashMap();
    private HashMap<String, Slider> m_dicSliders = new HashMap();

    public Scene() {
        this(null);
    }

    public Scene(Workspace workspace) {
        this.checkLicense();
        long l = SceneNative.jni_New("");
        this.setHandle(l, true);
        if (workspace != null) {
            long l2 = InternalHandle.getHandle((InternalHandle)workspace);
            if (l2 == 0L) {
                String string = InternalResource.loadString("workspace", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
            this.setWorkspace(workspace);
        }
    }

    Scene(long handle, SceneControl sceneControl, Timer timer) {
        this.checkLicense();
        this.checkSpace3DEffectLicense();
        this.setHandle(handle, false);
        this.m_sceneControl = sceneControl;
        this.m_timer = timer;
        SceneNative.jni_NewSelfEventHandle(InternalSceneControl.getHandle(this.m_sceneControl), this);
        SceneNative.jni_SetDrawMode(this.getHandle());
    }

    private void checkLicense() {
        ArrayList<ProductType> arrayList = InternalToolkitSpace.managerProducts(InternalToolkitSpace.getSpaceProducts());
        this.m_license = InternalToolkitSpace.verifyLicense(arrayList);
        LicenseFeatureInfo licenseFeatureInfo = this.m_license.getFeatureInfo();
        InternalToolkitSpace.setSpaceRuntimeLicenseMode(licenseFeatureInfo.isTrial());
        InternalToolkitSpace.updateStatus();
    }

    private void checkSpace3DEffectLicense() {
        ProductType productType;
        ArrayList<ProductType> arrayList = InternalToolkitSpace.managerProducts(InternalToolkitSpace.getSpace3DEffectProducts());
        int n = -1;
        License license = new License();
        Iterator<ProductType> iterator = arrayList.iterator();
        while (iterator.hasNext() && (n = license.connect(productType = iterator.next())) != 0) {
        }
        if (n == 0) {
            n = license.verify();
        }
        if (n != 0) {
            SceneNative.jni_SetIsSpace3DEffectVailed(this.getHandle(), false);
        }
    }

    private void unLoadLicense() {
        if (this.m_license != null) {
            this.m_license.disconnect();
            this.m_license.dispose();
            this.m_license = null;
        }
    }

    public boolean isOverlapDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isOverlapDisplayed()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IsOverlapDisplayed(this.getHandle());
    }

    public void setOverlapDisplayed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlapDisplayed(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetOverlapDisplayed(this.getHandle(), value);
    }

    public double getFPS() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFPS()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetFPS(this.getHandle());
    }

    public Timer getTimer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimer()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_timer;
    }

    public Camera getCamera() {
        double d;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCamera()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[6];
        long l = SceneNative.jni_GetCamera(this.getHandle(), dArray);
        Camera camera = null;
        double d2 = d = this.getSceneType() == SceneType.NONEARTHFLAT ? 1.0 : 57.29577951308232;
        if (l != 0L) {
            if (d == 1.0) {
                dArray[2] = dArray[2] + 6378137.0;
            }
            camera = new Camera(dArray[0] * d, dArray[1] * d, dArray[2], (AltitudeMode)InternalEnum.parse(AltitudeMode.class, (int)((int)dArray[3])), dArray[4] * d, dArray[5] * d);
        }
        return camera;
    }

    public void setCamera(Camera camera) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCamera(camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (camera == null) {
            String string = InternalResource.loadString("camera", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        SceneNative.jni_SetCameraValue(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), InternalEnum.getUGCValue((Enum)camera.getAltitudeMode()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180));
    }

    public TerrainLayers getTerrainLayers() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetTerrainLayers()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_terrainLayers == null && (l = SceneNative.jni_getTerrainLayers(this.getHandle())) != 0L) {
            this.m_terrainLayers = TerrainLayers.createInstance(this, l);
        }
        return this.m_terrainLayers;
    }

    public double getTerrainExaggeration() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTerrainExaggeration()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetTerrainExaggeration(this.getHandle());
    }

    public void setTerrainExaggeration(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTerrainExaggeration(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetTerrainExaggeration(this.getHandle(), value);
    }

    public LatLonGrid getLatLonGrid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLatLonGrid()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_latLonGrid == null) {
            this.m_latLonGrid = new LatLonGrid(this);
        }
        return this.m_latLonGrid;
    }

    public Atmosphere getAtmosphere() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAtmosphere()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_atmosphere == null) {
            this.m_atmosphere = new Atmosphere(this);
        }
        return this.m_atmosphere;
    }

    public Ocean getOcean() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOcean()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_ocean == null) {
            this.m_ocean = new Ocean(this);
        }
        return this.m_ocean;
    }

    public Sun getSun() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSun", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_sun == null) {
            this.m_sun = new Sun(this);
        }
        return this.m_sun;
    }

    public Underground getUnderground() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Underground getUnderground()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_underground == null) {
            this.m_underground = new Underground(this);
        }
        return this.m_underground;
    }

    public GlobalImage getGlobalImage() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GlobalImage getGlobalImage()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_globalImage == null) {
            this.m_globalImage = new GlobalImage(this);
        }
        return this.m_globalImage;
    }

    public boolean isScaleLegendVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isScaleLegendVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IsScaleLegendVisible(this.getHandle());
    }

    public void setScaleLegendVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleLegendVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetScaleLegendVisible(this.getHandle(), value);
    }

    public boolean isCrossVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isCrossVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IsCrossVisible(this.getHandle());
    }

    public void setCrossVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCrossVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetCrossVisible(this.getHandle(), value);
    }

    public Selection3D[] findSelection(boolean hasObjectSelected) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findSelection(boolean hasObjectSelected)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3Ds layer3Ds = this.getLayers();
        int n = layer3Ds.getCount();
        ArrayList<Selection3D> arrayList = new ArrayList<Selection3D>();
        for (int i = 0; i < n; ++i) {
            this.getLayer3DSelection(arrayList, layer3Ds.get(i), hasObjectSelected);
        }
        Selection3D[] selection3DArray = new Selection3D[arrayList.size()];
        return arrayList.toArray(selection3DArray);
    }

    private void getLayer3DSelection(ArrayList<Selection3D> tempSelections, Layer3D layer3D, boolean hasObjectSelected) {
        if (layer3D instanceof Layer3DGroup) {
            Layer3DGroup layer3DGroup = (Layer3DGroup)layer3D;
            for (int i = 0; i < layer3DGroup.getCount(); ++i) {
                this.getLayer3DSelection(tempSelections, layer3DGroup.get(i), hasObjectSelected);
            }
        } else {
            Selection3D selection3D = layer3D.getSelection();
            if (!hasObjectSelected) {
                tempSelections.add(selection3D);
            } else if (selection3D.getCount() > 0) {
                tempSelections.add(selection3D);
            }
        }
    }

    public TrackingLayer3D getTrackingLayer() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTrackingLayer()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_trackingLayer == null && (l = SceneNative.jni_GetTrackingLayer(this.getHandle())) != 0L) {
            this.m_trackingLayer = TrackingLayer3D.createInstance(l, this);
        }
        return this.m_trackingLayer;
    }

    public Workspace getWorkspace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWorkspace()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_workspace;
    }

    public void setWorkspace(Workspace workspace) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWorkspace(Workspace workspace)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.getWorkspace() != null && this.getWorkspace().equals(workspace)) {
            return;
        }
        String string = "";
        if (this.m_workspace != null) {
            l = InternalHandle.getHandle((InternalHandle)this.m_workspace);
            if (l == 0L) {
                String string2 = InternalResource.loadString("setWorkspace()", "Map_DontDisposeOldWorkspace", "realspace_resources");
                throw new IllegalStateException(string2);
            }
            string = this.toXML();
        }
        this.close();
        if (workspace == null) {
            this.m_workspace = null;
        } else {
            l = InternalHandle.getHandle((InternalHandle)workspace);
            if (l == 0L) {
                String string3 = InternalResource.loadString("workspace", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalArgumentException(string3);
            }
            SceneNative.jni_SetWorkspace(this.getHandle(), l);
            this.m_workspace = workspace;
        }
        if (!string.trim().equals("")) {
            this.fromXML(string);
        }
    }

    public Layer3Ds getLayers() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLayers()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layer3Ds == null && (l = SceneNative.jni_GetLayers(this.getHandle())) != 0L) {
            this.m_layer3Ds = Layer3Ds.createInstance(l, this);
        }
        return this.m_layer3Ds;
    }

    public ScreenLayer3D getScreenLayer() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScreenLayer()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_screenLayer == null && (l = SceneNative.jni_GetScreenLayer(this.getHandle())) != 0L) {
            this.m_screenLayer = new ScreenLayer3D(l, InternalSceneControl.getHandle(this.m_sceneControl));
        }
        return this.m_screenLayer;
    }

    public Fog getFog() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFog()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_fog == null && (l = SceneNative.jni_GetFog(this.getHandle())) != 0L) {
            this.m_fog = Fog.createInstance(l);
        }
        return this.m_fog;
    }

    public void setFog(Fog fog) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFog(Fog fog)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (fog == null) {
            String string = InternalResource.loadString("fog", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)fog);
        if (l == 0L) {
            String string = InternalResource.loadString("fog", "Global_InvalidConstructorArgument", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        SceneNative.jni_SetFog(this.getHandle(), l);
    }

    public double getAltitude(double longitude, double latitude) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAltitude(double longitude, double latitude)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetAltitude(this.getHandle(), longitude, latitude);
    }

    public void setFogVisibleAltitude(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFogVisibleAltitude(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_setFogVisibleAltitude(this.getHandle(), value);
    }

    public double getFogVisibleAltitude() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetFogVisibleAltitude()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_getFogVisibleAltitude(this.getHandle());
    }

    @Deprecated
    public void fly(Geometry targetObject, FlyingMode flyingMode) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("flyTo(Object targetObject, FlyingMode flyingMode)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (targetObject == null) {
            String string = InternalResource.loadString("targetObject", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (InternalHandleDisposable.getHandle((InternalHandle)targetObject) == 0L) {
            String string = InternalResource.loadString("targetObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (targetObject.isEmpty()) {
            String string = InternalResource.loadString("targetObject", "Scene_FlyGeometryShouldNotBeNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (flyingMode == null) {
            String string = InternalResource.loadString("flyingMode", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        FlyingMode flyingMode2 = flyingMode;
        if (flyingMode == FlyingMode.FLYINGPLAY && !(targetObject instanceof GeoLine3D) && !(targetObject instanceof GeoLine)) {
            flyingMode2 = FlyingMode.FLYINGTO;
        }
        int n = InternalEnum.getUGCValue(flyingMode2);
        SceneNative.jni_FlyToGeometry(this.getHandle(), InternalHandleDisposable.getHandle((InternalHandle)targetObject), n);
    }

    public void fly(Camera camera) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("flyTo(Camera camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (camera == null) {
            String string = InternalResource.loadString("camera", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        SceneNative.jni_FlyToCamera(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), InternalEnum.getUGCValue((Enum)camera.getAltitudeMode()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180));
    }

    public void fly(Camera camera, int milliseconds) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("flyTo(Object targetObject, FlyingMode flyingMode)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (camera == null) {
            String string = InternalResource.loadString("camera", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (milliseconds < 0) {
            String string = InternalResource.loadString("milliseconds", "Scene_FlyMillisecondsShouldMoreThanZERO", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (milliseconds == 0) {
            milliseconds = 1;
        }
        SceneNative.jni_FlyToBymillisecondsCamera(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), InternalEnum.getUGCValue((Enum)camera.getAltitudeMode()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180), milliseconds);
    }

    @Deprecated
    public void fly(Geometry targetObject, int milliseconds) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fly(Geometry targetObject, int milliseconds)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (targetObject == null) {
            String string = InternalResource.loadString("targetObject", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)targetObject);
        if (l == 0L) {
            String string = InternalResource.loadString("targetObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetObject.isEmpty()) {
            String string = InternalResource.loadString("targetObject", "Scene_FlyGeometryShouldNotBeNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (milliseconds < 0) {
            String string = InternalResource.loadString("milliseconds", "Scene_FlyMillisecondsShouldMoreThanZERO", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (milliseconds == 0) {
            milliseconds = 1;
        }
        SceneNative.jni_FlyToBymillisecondsWithObject(this.getHandle(), l, milliseconds);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetObject);
    }

    @Deprecated
    public void fly(Camera camera, boolean isDirect) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("flyTo(Camera camera, boolean isDirect)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (camera == null) {
            String string = InternalResource.loadString("camera", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        SceneNative.jni_FlyToCameraDirect(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), InternalEnum.getUGCValue((Enum)camera.getAltitudeMode()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180), isDirect);
    }

    @Deprecated
    public void fly(Camera camera, int milliseconds, boolean isDirect) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("flyTo(Object targetObject, FlyingMode flyingMode, boolean isDirect)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (camera == null) {
            String string = InternalResource.loadString("camera", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (milliseconds < 0) {
            String string = InternalResource.loadString("milliseconds", "Scene_FlyMillisecondsShouldMoreThanZERO", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (milliseconds == 0) {
            milliseconds = 1;
        }
        SceneNative.jni_FlyToBymillisecondsCameraDirect(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), InternalEnum.getUGCValue((Enum)camera.getAltitudeMode()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180), milliseconds, isDirect);
    }

    @Deprecated
    public void flyPlay(Geometry line, double speedRatio, double distance) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("flyPlay(Geometry line, double speedRatio, double distance)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (line == null) {
            String string = InternalResource.loadString("line", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)line);
        if (l == 0L) {
            String string = InternalResource.loadString("line", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (!line.getType().equals((Object)GeometryType.GEOLINE) && !line.getType().equals((Object)GeometryType.GEOLINE3D)) {
            String string = InternalResource.loadString("line", "Scene_FlyPlayGeometryTypeUnsupport", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (speedRatio <= 0.0) {
            String string = InternalResource.loadString("speedRatio", "Scene_FlyPlaySpeedRatioShouldMoreThanZERO", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        SceneNative.jni_FlyPlay(this.getHandle(), l, speedRatio, distance);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)line);
    }

    public void flyCircle(Geometry geometry, double speedRatio) {
        this.verifyLicense();
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (speedRatio <= 0.0) {
            String string = InternalResource.loadString("speedRatio", "Scene_FlyPlaySpeedRatioShouldMoreThanZERO", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        SceneNative.jni_FlyCircle(this.getHandle(), l, speedRatio);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
    }

    public void stopFly() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("stopFly()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_StopFly(this.getHandle());
    }

    public Point3D pixelToGlobe(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pixelToGlobe(Point point)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Point3D point3D = new Point3D();
        double[] dArray = new double[]{Double.NaN, Double.NaN, Double.NaN};
        if (this.m_sceneControl != null && InternalSceneControl.getHandle(this.m_sceneControl) != 0L) {
            double[] dArray2 = new double[]{point.getX(), point.getY()};
            SceneNative.jni_PixelToScene(this.getHandle(), InternalSceneControl.getHandle(this.m_sceneControl), dArray2, dArray);
        }
        point3D.setX(dArray[0] * 57.29577951308232);
        point3D.setY(dArray[1] * 57.29577951308232);
        point3D.setZ(dArray[2]);
        return point3D;
    }

    public Point3D pixelToGlobe(Point point, PixelToGlobeMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pixelToGlobe(Point point, PixelToGlobeMode mode)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Point3D point3D = new Point3D(Double.NaN, Double.NaN, Double.NaN);
        if (this.m_sceneControl == null || InternalSceneControl.getHandle(this.m_sceneControl) == 0L) {
            return point3D;
        }
        double[] dArray = new double[]{Double.NaN, Double.NaN, Double.NaN};
        double[] dArray2 = new double[]{point.getX(), point.getY()};
        boolean bl = SceneNative.jni_PixelToWorld(this.getHandle(), InternalSceneControl.getHandle(this.m_sceneControl), dArray2, mode.value(), dArray);
        if (bl) {
            point3D.setX(dArray[0]);
            point3D.setY(dArray[1]);
            point3D.setZ(dArray[2]);
        }
        return point3D;
    }

    public Point globeToPixel(Point3D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("globeToPixel(Point3D point)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{point.getX(), point.getY(), point.getZ()};
        double[] dArray2 = new double[2];
        if (this.m_sceneControl != null && InternalSceneControl.getHandle(this.m_sceneControl) != 0L) {
            SceneNative.jni_SceneToPixel(this.getHandle(), InternalSceneControl.getHandle(this.m_sceneControl), dArray, dArray2);
        }
        Point point2 = new Point();
        point2.x = (int)dArray2[0];
        point2.y = (int)dArray2[1];
        return point2;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SceneNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
        this.unLoadLicense();
    }

    public void pan(double offsetLongitude, double offsetLatitude) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Pan(double offsetLongitude, double offsetLatitude)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_Pan(this.getHandle(), offsetLongitude, offsetLatitude);
    }

    public void zoom(double ratio) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("zoom(double ratio)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_Zoom(this.getHandle(), ratio);
    }

    public void pitch(double angle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pitch(double angle)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_Pitch(this.getHandle(), angle);
    }

    public void viewEntire() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("viewEntire()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_ViewEntire(this.getHandle());
    }

    public void refresh() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("refresh()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_Refresh(this.getHandle());
    }

    public String toXML() {
        String string;
        File file;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (!this.isWorkspaceAttatched()) {
            String string3 = InternalResource.loadString("toXML()", "Map_WorkspaceIsEmpty", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        String string4 = "";
        if (this.getWorkspace() != null && (file = new File(string = this.getWorkspace().getConnectionInfo().getServer())).exists()) {
            string4 = file.getParent();
        }
        return SceneNative.jni_ToXML(this.getHandle(), string4);
    }

    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_workspace == null || InternalHandle.getHandle((InternalHandle)this.m_workspace) == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Map_WorkspaceIsEmpty", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (xml != null && xml.trim().length() != 0) {
            String string;
            File file;
            String string2 = "";
            if (this.getWorkspace() != null && (file = new File(string = this.getWorkspace().getConnectionInfo().getServer())).exists()) {
                string2 = file.getParent();
            }
            long l = 0L;
            if (this.getWorkspace() != null) {
                l = InternalHandle.getHandle((InternalHandle)this.getWorkspace());
            }
            if (bl = SceneNative.jni_FromXML(this.getHandle(), xml, string2, l)) {
                this.clearLocalVariable();
                this.getLayers();
                this.getTerrainLayers();
                SceneOpenedEvent sceneOpenedEvent = new SceneOpenedEvent((Object)this, this);
                this.fireSceneOpened(sceneOpenedEvent);
            }
        }
        return bl;
    }

    public double getCameraFOV() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetCameraFOV()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_getCameraFOV(this.getHandle()) * 57.29577951308232;
    }

    public void setCameraFOV(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetCameraFOV(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0 || value >= 180.0) {
            String string = InternalResource.loadString("value", "Scene_CameraFOVOutOfRange", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        SceneNative.jni_setCameraFOV(this.getHandle(), value * (Math.PI / 180));
    }

    public double getMaxCameraDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetMaxCameraDistance()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_getMaxCameraDistance(this.getHandle());
    }

    public void setMaxCameraDistance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxCameraDistance(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("setMaxCameraDistance(double value)", "Scene_MaxCameraDistanceShouldNotBeNegative", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_setMaxCameraDistance(this.getHandle(), value);
    }

    public double getMinCameraDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinCameraDistance()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_getMinCameraDistance(this.getHandle());
    }

    public void setMinCameraDistance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinCameraDistance(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("setMaxCameraDistance(double value)", "Scene_MinCameraDistanceShouldNotBeNegative", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_setMinCameraDistance(this.getHandle(), value);
    }

    public boolean open(String name) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("open()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_workspace == null) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)this.m_workspace);
        if (l == 0L) {
            String string = InternalResource.loadString("workspace", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = this.m_workspace.getScenes().indexOf(name);
        if (n == -1) {
            String string = InternalResource.loadString("name", "Scene_SpecifiedNameNotExists", "realspace_resources");
            throw new IllegalStateException(string);
        }
        String string = this.m_workspace.getScenes().getSceneXML(n);
        return this.fromXML(string);
    }

    public boolean open(String iserverUrl, String strSceneName) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("open()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (iserverUrl == null || iserverUrl.trim().length() == 0) {
            String string = InternalResource.loadString("strServerUrl", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (strSceneName == null || strSceneName.trim().length() == 0) {
            String string = InternalResource.loadString("strSceneName", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = SceneNative.jni_Open(this.getHandle(), iserverUrl, strSceneName);
        if (this.m_layer3Ds != null) {
            this.m_layer3Ds.clearHandle();
            this.m_layer3Ds = null;
        }
        if (this.m_terrainLayers != null) {
            this.m_terrainLayers.clearHandle();
            this.m_terrainLayers = null;
        }
        return bl;
    }

    public void close() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("close()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layer3Ds != null) {
            this.m_layer3Ds.clear();
        }
        if (this.m_terrainLayers != null) {
            this.m_terrainLayers.clear();
        }
        SceneNative.jni_Reset(this.getHandle());
        SceneNative.jni_SetDrawMode(this.getHandle());
        SceneClosedEvent sceneClosedEvent = new SceneClosedEvent((Object)this, this);
        this.fireSceneClosed(sceneClosedEvent);
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        SceneNative.jni_setName(this.getHandle(), value);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_getName(this.getHandle());
    }

    public void roll(double angle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("roll(double angle)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_roll(this.getHandle(), angle);
    }

    public boolean roll(Point2D center, double angle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("roll(Point2D center, double angle)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_Roll2(this.getHandle(), center.getX(), center.getY(), angle);
    }

    public void rollEye(double angle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rollEye(double angle)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_rollEye(this.getHandle(), angle);
    }

    public double computeSphericalDistance(Point2D point1, Point2D point2) {
        double d;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeSphericalDistance(Point2D point1, Point2D point2)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double d2 = point2.getX() % 360.0;
        double d3 = point1.getY() % 180.0;
        double d4 = point2.getY() % 180.0;
        for (d = point1.getX() % 360.0; d < 0.0; d += 360.0) {
        }
        while (d > 360.0) {
            d -= 360.0;
        }
        while (d2 < 0.0) {
            d2 += 360.0;
        }
        while (d2 > 360.0) {
            d2 -= 360.0;
        }
        return SceneNative.jni_ComputeSphericalDistance(d, d3, d2, d4);
    }

    public double computeSphericalArea(Point2Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeSphericalDistance(Point2Ds points)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = points.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
        }
        return SceneNative.jni_ComputeSphericalArea(dArray, dArray2);
    }

    public void ensureVisible(Rectangle2D visibleBounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Rectangle2D visibleBounds)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_EnsureVisible(this.getHandle(), visibleBounds.getLeft(), visibleBounds.getBottom(), visibleBounds.getRight(), visibleBounds.getTop());
    }

    public void ensureVisible(Rectangle2D visibleBounds, int milliseconds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Rectangle2D visibleBounds, int milliseconds)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (milliseconds < 0) {
            String string = InternalResource.loadString("milliseconds", "Scene_FlyMillisecondsShouldMoreThanZERO", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (milliseconds == 0) {
            milliseconds = 1;
        }
        SceneNative.jni_EnsureVisible2(this.getHandle(), visibleBounds.getLeft(), visibleBounds.getBottom(), visibleBounds.getRight(), visibleBounds.getTop(), milliseconds);
    }

    public void ensureVisible(Layer3D layer3d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Layer3D layer3d)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (layer3d == null) {
            String string = InternalResource.loadString("layer3d", "Global_ArgumentNull", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        SceneNative.jni_EnsureVisible3(this.getHandle(), InternalHandle.getHandle((InternalHandle)layer3d));
    }

    public BufferedImage outputSceneToBitmap() {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToBitmap", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_sceneControl == null || InternalSceneControl.getHandle(this.m_sceneControl) == 0L) {
            String string = InternalResource.loadString("outputMapToBitmap", "Scene_RenderEnvironmentInvalid", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        int[] nArray = new int[2];
        long l = SceneNative.jni_GetImageBounds(this.getHandle(), nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        InternalBufferImage internalBufferImage = new InternalBufferImage(n, n2);
        SceneNative.jni_OutputSceneToBitmap(InternalHandleDisposable.getHandle((InternalHandle)internalBufferImage), l);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        bufferedImage.getGraphics().drawImage(internalBufferImage.getMemoryImage(), 0, 0, null);
        internalBufferImage.dispose();
        return bufferedImage;
    }

    static void flownCallBack(Scene scene) {
        if (scene != null) {
            FlownEvent flownEvent = new FlownEvent((Object)scene, scene.getCamera());
            scene.fireFlown(flownEvent);
        }
    }

    public synchronized void addFlownListener(FlownListener l) {
        if (this.m_flownListeners == null) {
            this.m_flownListeners = new Vector();
        }
        if (!this.m_flownListeners.contains(l)) {
            this.m_flownListeners.add(l);
        }
    }

    public synchronized void removeFlownListener(FlownListener l) {
        if (this.m_flownListeners != null && this.m_flownListeners.contains(l)) {
            this.m_flownListeners.remove(l);
        }
    }

    protected void fireFlown(FlownEvent event) {
        if (this.m_flownListeners != null) {
            Vector vector = this.m_flownListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((FlownListener)vector.elementAt(i)).flown(event);
            }
        }
    }

    public synchronized void addSceneOpenedListener(SceneOpenedListener l) {
        if (this.m_sceneOpenedListeners == null) {
            this.m_sceneOpenedListeners = new Vector();
        }
        if (!this.m_sceneOpenedListeners.contains(l)) {
            this.m_sceneOpenedListeners.add(l);
        }
    }

    public synchronized void removeSceneOpenedListener(SceneOpenedListener l) {
        if (this.m_sceneOpenedListeners != null && this.m_sceneOpenedListeners.contains(l)) {
            this.m_sceneOpenedListeners.remove(l);
        }
    }

    protected void fireSceneOpened(SceneOpenedEvent event) {
        if (this.m_sceneOpenedListeners != null) {
            Vector vector = this.m_sceneOpenedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SceneOpenedListener)vector.elementAt(i)).sceneOpened(event);
            }
        }
    }

    public synchronized void addSceneClosedListener(SceneClosedListener l) {
        if (this.m_sceneClosedListeners == null) {
            this.m_sceneClosedListeners = new Vector();
        }
        if (!this.m_sceneClosedListeners.contains(l)) {
            this.m_sceneClosedListeners.add(l);
        }
    }

    public synchronized void removeSceneClosedListener(SceneClosedListener l) {
        if (this.m_sceneClosedListeners != null && this.m_sceneClosedListeners.contains(l)) {
            this.m_sceneClosedListeners.remove(l);
        }
    }

    protected void fireSceneClosed(SceneClosedEvent event) {
        if (this.m_sceneClosedListeners != null) {
            Vector vector = this.m_sceneClosedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SceneClosedListener)vector.elementAt(i)).sceneClosed(event);
            }
        }
    }

    private boolean isWorkspaceAttatched() {
        boolean bl = true;
        if (this.m_workspace == null) {
            bl = false;
        } else {
            long l = InternalHandle.getHandle((InternalHandle)this.m_workspace);
            if (l == 0L) {
                bl = false;
            }
        }
        return bl;
    }

    License getLicense() {
        return this.m_license;
    }

    private void verifyLicense() {
        int n = this.m_license.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    protected static void clearHandle(Scene scene) {
        scene.clearHandle();
    }

    protected static Scene createInstance(long handle, SceneControl sceneControl, Timer timer) {
        return new Scene(handle, sceneControl, timer);
    }

    private void clearLocalVariable() {
        if (this.m_fog != null) {
            this.m_fog.clearHandle();
            this.m_fog = null;
        }
        if (this.m_screenLayer != null) {
            this.m_screenLayer.clearHandle();
            this.m_screenLayer = null;
        }
        if (this.m_trackingLayer != null) {
            this.m_trackingLayer.clearHandle();
            this.m_trackingLayer = null;
        }
        if (this.m_layer3Ds != null) {
            this.m_layer3Ds.clearHandle();
            this.m_layer3Ds = null;
        }
        if (this.m_terrainLayers != null) {
            this.m_terrainLayers.clearHandle();
            this.m_terrainLayers = null;
        }
    }

    protected void clearHandle() {
        this.clearLocalVariable();
        this.m_sceneControl = null;
        this.m_workspace = null;
        this.m_timer = null;
        this.setHandle(0L);
    }

    public static Rectangle2D toBounds(int level, int columnIndex, int rowIndex) {
        Rectangle2D rectangle2D = new Rectangle2D();
        double[] dArray = new double[4];
        SceneNative.jni_toBounds(level, columnIndex, rowIndex, dArray);
        rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public static Rectangle2D ceilBounds(Rectangle2D bounds, int level) {
        Rectangle2D rectangle2D = new Rectangle2D();
        double[] dArray = new double[4];
        SceneNative.jni_ceilBounds(bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop(), level, dArray);
        rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    protected static void InternalClearHandle(Scene scene) {
        Scene.clearHandle(scene);
    }

    public boolean isStereoEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isStereoEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IsStereoEnable(this.getHandle());
    }

    public void setStereoEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStereoEnable(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetStereoEnable(this.getHandle(), value);
    }

    public StereoMode getStereoMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStereoMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = SceneNative.jni_GetStereoMode(this.getHandle());
        return (StereoMode)Enum.parse(StereoMode.class, (int)n);
    }

    public void setStereoMode(StereoMode value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStereoMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetStereoMode(this.getHandle(), value.value());
    }

    public double getStereoEyeSeparation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCameraSeparation()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetCameraSeparation(this.getHandle());
    }

    public void setStereoEyeSeparation(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCameraSeparation(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetCameraSeparation(this.getHandle(), value);
    }

    public double getStereoEyeAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCameraAngle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetCameraAngle(this.getHandle());
    }

    public void setStereoEyeAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCameraSeparation(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetCameraAngle(this.getHandle(), value);
    }

    public void setParallaxMode(ParallaxMode value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setParallaxMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetParallaxMode(this.getHandle(), value.value());
    }

    public ParallaxMode getParallaxMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParallaxMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = SceneNative.jni_GetParallaxMode(this.getHandle());
        return (ParallaxMode)Enum.parse(ParallaxMode.class, (int)n);
    }

    @Deprecated
    public boolean isFullScreen() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isFullScreen()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IsFullScreen(this.getHandle());
    }

    @Deprecated
    public void setFullScreen(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFullScreen(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetFullScreen(this.getHandle(), value);
    }

    public boolean isStereoModeSupported(StereoMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isActiveStereoSupported()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = true;
        if (mode == StereoMode.ANAGLYPHIC || mode == StereoMode.HORIZONTAL_SPLIT || mode == StereoMode.VERTICAL_SPLIT) {
            bl = true;
        }
        if (mode == StereoMode.QUAD_BUFFER) {
            bl = SceneNative.jni_IsActiveStereoSupported(this.getHandle());
        }
        return bl;
    }

    public void setIServerCacheDirectory(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIServerCacheDirectory()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetIServerCacheDirectory(this.getHandle(), value);
    }

    public String getIServerCacheDirectory() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIServerCacheDirectory()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetIServerCacheDirectory(this.getHandle());
    }

    public void setAutoLockTarget(GeoModel value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAutoLockTarget(GeoModel value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value != null) {
            SceneNative.jni_SetAutoLockTarget(this.getHandle(), InternalHandle.getHandle((InternalHandle)value));
        } else {
            SceneNative.jni_SetAutoLockTarget(this.getHandle(), 0L);
        }
    }

    public void setAutoLockOffset(Point3D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAutoLockOffset(Point3D value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetAutoLockOffset(this.getHandle(), value.getX(), value.getY(), value.getZ());
    }

    public Point3D getAutoLockOffset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAutoLockOffset()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        SceneNative.jni_GetAutoLockOffset(this.getHandle(), dArray);
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        return point3D;
    }

    public Camera getFirstPersonCamera() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFirstPersonCamera()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[6];
        long l = SceneNative.jni_GetFirstPersonCamera(this.getHandle(), dArray);
        Camera camera = null;
        if (l != 0L) {
            camera = new Camera(dArray[0] * 57.29577951308232, dArray[1] * 57.29577951308232, dArray[2], (AltitudeMode)InternalEnum.parse(AltitudeMode.class, (int)((int)dArray[3])), dArray[4] * 57.29577951308232, dArray[5] * 57.29577951308232);
        }
        return camera;
    }

    public void setFirstPersonCamera(Camera camera) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFirstPersonCamera(Camera camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (camera == null) {
            String string = InternalResource.loadString("camera", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        SceneNative.jni_SetFirstPersonCameraValue(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), camera.getAltitude(), InternalEnum.getUGCValue((Enum)camera.getAltitudeMode()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180));
    }

    public boolean isFirstPersonView() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isFirstPersonView()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetIsFirstPersonView(this.getHandle());
    }

    public void setFirstPersonView(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFirstPersonView(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetIsFirstPersonView(this.getHandle(), value);
    }

    public FlyManager getFlyManager() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFirstPersonCamera(Camera camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_flyManager == null) {
            this.m_flyManager = new FlyManager();
            this.m_flyManager.setScene(this);
        }
        return this.m_flyManager;
    }

    public double getShadowVisibleDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getShadowVisibleDistance", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetShadowVisibleDistance(this.getHandle());
    }

    public void setShadowVisibleDistance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShadowVisibleDistance", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetShadowVisibleDistance(this.getHandle(), value);
    }

    public SceneType getSceneType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSceneType", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = SceneNative.jni_GetSceneType(this.getHandle());
        return (SceneType)InternalEnum.parse(SceneType.class, (int)n);
    }

    public void setSceneType(SceneType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetSceneType(this.getHandle(), value.value());
    }

    public static Point3D sphericalToCartesian(Point3D point) {
        double[] dArray = SceneNative.jni_SphericalToCartesian(point.getX(), point.getY(), point.getZ());
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public static Point3D sphericalToPseudoCartesian(Point3D point) {
        double[] dArray = SceneNative.jni_SphericalToPseudoCartesian(point.getX(), point.getY(), point.getZ());
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public static Point3D pseudoCartesianToSpherical(Point3D point) {
        double[] dArray = SceneNative.jni_PseudoCartesianToSpherical(point.getX(), point.getY(), point.getZ());
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public void setMultiViewportMode(MultiViewportMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMultiViewportMode", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(mode);
        SceneNative.jni_SetMultiViewportMode(this.getHandle(), n);
    }

    public MultiViewportMode getMultiViewportMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMultiViewportMode", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = SceneNative.jni_GetMultiViewportMode(this.getHandle());
        MultiViewportMode multiViewportMode = (MultiViewportMode)InternalEnum.parseUGCValue(MultiViewportMode.class, n);
        return multiViewportMode;
    }

    public void fly(LookAt lookAt) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("flyTo(LookAt lookAt)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (lookAt == null) {
            String string = InternalResource.loadString("lookAt", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        double d = this.getSceneType() == SceneType.NONEARTHFLAT ? 1.0 : Math.PI / 180;
        SceneNative.jni_FlyToLookAt(this.getHandle(), lookAt.getLongitude() * d, lookAt.getLatitude() * d, lookAt.getAltitude(), InternalEnum.getUGCValue((Enum)lookAt.getAltitudeMode()), lookAt.getHeading() * d, lookAt.getTilt() * d, lookAt.getRange());
    }

    public void fly(LookAt lookAt, int milliseconds) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("flyTo(LookAt lookAt)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (lookAt == null) {
            String string = InternalResource.loadString("lookAt", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        double d = this.getSceneType() == SceneType.NONEARTHFLAT ? 1.0 : Math.PI / 180;
        SceneNative.jni_FlyToLookAtByMilliseconds(this.getHandle(), lookAt.getLongitude() * d, lookAt.getLatitude() * d, lookAt.getAltitude(), InternalEnum.getUGCValue((Enum)lookAt.getAltitudeMode()), lookAt.getHeading() * d, lookAt.getTilt() * d, lookAt.getRange(), milliseconds);
    }

    public LookAt getLookAt() {
        double d;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLookAt()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[7];
        long l = SceneNative.jni_GetLookAt(this.getHandle(), dArray);
        LookAt lookAt = null;
        double d2 = d = this.getSceneType() == SceneType.NONEARTHFLAT ? 1.0 : 57.29577951308232;
        if (l != 0L) {
            lookAt = new LookAt(dArray[0] * d, dArray[1] * d, dArray[2], (AltitudeMode)InternalEnum.parse(AltitudeMode.class, (int)((int)dArray[3])), dArray[4] * d, dArray[5] * d, dArray[6]);
        }
        return lookAt;
    }

    public void setLookAt(LookAt lookAt) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCamera(camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (lookAt == null) {
            String string = InternalResource.loadString("lookAt", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        double d = this.getSceneType() == SceneType.NONEARTHFLAT ? 1.0 : Math.PI / 180;
        SceneNative.jni_SetLookAtValue(this.getHandle(), lookAt.getLongitude() * d, lookAt.getLatitude() * d, lookAt.getAltitude(), InternalEnum.getUGCValue((Enum)lookAt.getAltitudeMode()), lookAt.getHeading() * d, lookAt.getTilt() * d, lookAt.getRange());
    }

    public Splitter addSplitter(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addSplitter()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Splitter splitter = new Splitter(this, name);
        this.m_dicSplitters.put(name, splitter);
        return splitter;
    }

    public Splitter getSplitter(String name) {
        Splitter splitter = null;
        if (this.m_dicSplitters.containsKey(name)) {
            splitter = this.m_dicSplitters.get(name);
        }
        return splitter;
    }

    public boolean removeSplitter(String name) {
        boolean bl = false;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeSplitter()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_dicSplitters.containsKey(name)) {
            bl = SceneNative.jni_RemoveSplitter(this.getHandle(), name);
            this.m_dicSplitters.remove(name);
        }
        return bl;
    }

    public int getSplitterCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSplitterCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetSplitterCount(this.getHandle());
    }

    public Slider addSlider(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addSlider()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Slider slider = new Slider(this, name);
        this.m_dicSliders.put(name, slider);
        return slider;
    }

    public Slider getSlider(String name) {
        Slider slider = null;
        if (this.m_dicSliders.containsKey(name)) {
            slider = this.m_dicSliders.get(name);
        }
        return slider;
    }

    public boolean removeSlider(String name) {
        boolean bl = false;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeSlider()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_dicSliders.containsKey(name)) {
            bl = SceneNative.jni_RemoveSlider(this.getHandle(), name);
            this.m_dicSliders.remove(name);
        }
        return bl;
    }

    public int getSliderCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSliderCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetSliderCount(this.getHandle());
    }

    public double getHeight(double longitude, double latitude) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double d = 0.0;
        d = SceneNative.jni_GetHeight(this.getHandle(), longitude, latitude);
        return d;
    }

    public double getHeight(double longitude, double latitude, boolean trackingLayerHeightAvailable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double d = 0.0;
        d = SceneNative.jni_GetHeight2(this.getHandle(), longitude, latitude, trackingLayerHeightAvailable);
        return d;
    }

    public float getBrightness() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetBrightness(this.getHandle());
    }

    public void setBrightness(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetBrightness(this.getHandle(), value);
    }

    public float getConstrast() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetConstrast(this.getHandle());
    }

    public void setConstrast(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetConstrast(this.getHandle(), value);
    }

    public float getGamma() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetGamma(this.getHandle());
    }

    public void setGamma(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetGamma(this.getHandle(), value);
    }

    public float getHue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetHue(this.getHandle());
    }

    public void setHue(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetHue(this.getHandle(), value);
    }

    public float getSaturation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetSaturation(this.getHandle());
    }

    public void setSaturation(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetSaturation(this.getHandle(), value);
    }

    public boolean isCreateSkirt() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (!SceneNative.jni_HaveGlobalTINTerrain(this.getHandle())) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IsCreateSkirt(this.getHandle());
    }

    public void setCreateSkirt(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (!SceneNative.jni_HaveGlobalTINTerrain(this.getHandle())) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetCreateSkirt(this.getHandle(), value);
    }

    public boolean isReceiveShadow() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IsReceiveShadow(this.getHandle());
    }

    public void setReceiveShadow(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetReceiveShadow(this.getHandle(), value);
    }

    public boolean isZoomFlyPitching() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IsZoomFlyPitching(this.getHandle());
    }

    public void setZoomFlyPitching(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetZoomFlyPitching(this.getHandle(), value);
    }

    public TerrainInfo getTerrainInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        SceneNative.jni_GetTerrainInfo(this.getHandle(), dArray);
        return new TerrainInfo(dArray[0], dArray[1]);
    }

    public String iServerCacheDirectory() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IServerCacheDirectory(this.getHandle());
    }

    public void setServerCacheDirectory(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetServerCacheDirectory(this.getHandle(), value);
    }

    public boolean outputScenePicture(String path, int xResolution, int yResolution) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Scene", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_OutputScenePicture(this.getHandle(), path, xResolution, yResolution);
    }

    public Rectangle2D getViewBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getViewBounds", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = SceneNative.jni_GetViewBounds(this.getHandle());
        if (dArray == null || dArray.length == 0) {
            return null;
        }
        Rectangle2D rectangle2D = new Rectangle2D();
        rectangle2D.setLeft(dArray[0]);
        rectangle2D.setTop(dArray[1]);
        rectangle2D.setRight(dArray[2]);
        rectangle2D.setBottom(dArray[3]);
        return rectangle2D;
    }

    public class TerrainInfo {
        private double m_dMinTerrainAltitude;
        private double m_dMaxTerrainAltitude;

        public TerrainInfo(double minAltitude, double maxAltitude) {
            this.m_dMinTerrainAltitude = minAltitude;
            this.m_dMaxTerrainAltitude = maxAltitude;
        }

        public double getMinAltitude() {
            return this.m_dMinTerrainAltitude;
        }

        public double getMaxAltitude() {
            return this.m_dMaxTerrainAltitude;
        }
    }
}

