/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.GeoStyle3D;
import com.supermap.data.Recordset;
import com.supermap.realspace.InternalDataset;
import com.supermap.realspace.InternalGeoStyle3D;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3DDataset;
import com.supermap.realspace.Layer3DNative;
import com.supermap.realspace.Layer3DType;
import com.supermap.realspace.Layer3Ds;
import com.supermap.realspace.Selection3DNative;

public class Selection3D
extends InternalHandleDisposable {
    private GeoStyle3D m_geoStyle3D;
    private Layer3D m_layer3D;
    private Layer3Ds m_layer3Ds;
    private boolean isUserLayer;

    public Selection3D() {
        long l = Selection3DNative.jni_New();
        this.setHandle(l, true);
        this.isUserLayer = false;
    }

    Selection3D(long handle, Layer3D layer3D, Layer3Ds layer3Ds) {
        this.setHandle(handle, false);
        this.m_layer3D = layer3D;
        this.m_layer3Ds = layer3Ds;
        this.isUserLayer = true;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("getCount()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("getCount()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        return Selection3DNative.jni_GetCount(this.getHandle());
    }

    public int get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("get(int index)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("get(int index)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return Selection3DNative.jni_Get(this.getHandle(), index);
    }

    public GeoStyle3D getStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("getStyle()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("getStyle()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (this.m_geoStyle3D == null && (l = Selection3DNative.jni_GetStyle(this.getHandle())) != 0L) {
            this.m_geoStyle3D = InternalGeoStyle3D.createInstance(l);
        }
        return this.m_geoStyle3D;
    }

    public void setStyle(GeoStyle3D geoStyle3D) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyle(GeoStyle3D geoStyle3D)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("setStyle(GeoStyle3D geoStyle3D)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setStyle(GeoStyle3D geoStyle3D)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (geoStyle3D == null) {
            String string = InternalResource.loadString("geoStyle3D", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        l = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geoStyle3D);
        if (l == 0L) {
            String string = InternalResource.loadString("geoStyle3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geoStyle3D.clone());
        Selection3DNative.jni_SetStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle3D);
    }

    public Layer3D getLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLayer()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_layer3D;
    }

    public int add(int id) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(int id)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("add(int id)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("add(int id)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (id <= 0) {
            String string = InternalResource.loadString("id", "Selection3D_TheArgumentOfIDShouldBePositive", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        l = 0L;
        if (this.m_layer3Ds != null) {
            l = InternalHandle.getHandle(this.m_layer3Ds);
        }
        int n = Selection3DNative.jni_Add(this.getHandle(), l, id);
        this.updateData();
        return n;
    }

    public int addRange(int[] ids) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addRange(int[] ids)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("addRange(int[] ids)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("addRange(int[] ids)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (ids == null) {
            String string = InternalResource.loadString("ids", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] > 0) continue;
            String string = InternalResource.loadString("ids", "Selection3D_TheArgumentOfIDShouldBePositive", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (this.m_layer3Ds != null) {
            l = InternalHandle.getHandle(this.m_layer3Ds);
        }
        int n = Selection3DNative.jni_AddRange(this.getHandle(), l, ids);
        this.updateData();
        return n;
    }

    public boolean remove(int id) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int id)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("remove(int id)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("remove(int id)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if ((n = Selection3DNative.jni_IndexOf(this.getHandle(), id)) == -1) {
            String string = InternalResource.loadString("id", "Selection3D_TheIDIsNotInSelection", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (this.m_layer3Ds != null) {
            l = InternalHandle.getHandle(this.m_layer3Ds);
        }
        boolean bl = Selection3DNative.jni_Remove(this.getHandle(), l, n);
        this.updateData();
        return bl;
    }

    public int removeRange(int index, int count) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeRange(int index, int count)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("removeRange(int index, int count)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("removeRange(int index, int count)", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = this.getCount();
        if (count < 0 || index + count > n) {
            String string = InternalResource.loadString("count", "Selection3D_TheArgumentOfCountIsInvalid", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (this.m_layer3Ds != null) {
            l = InternalHandle.getHandle(this.m_layer3Ds);
        }
        int n2 = Selection3DNative.jni_RemoveRange(this.getHandle(), l, index, count);
        this.updateData();
        return n2;
    }

    public void clear() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("clear()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("clear()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            Layer3DNative.jni_ReleaseSelection(l, 0);
        }
        l = 0L;
        if (this.m_layer3Ds != null) {
            l = InternalHandle.getHandle(this.m_layer3Ds);
        }
        Selection3DNative.jni_Clear(this.getHandle(), l);
    }

    public Recordset toRecordset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toRecordset()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.isUserLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("toRecordset()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("toRecordset()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        Recordset recordset = null;
        if (this.m_layer3D != null) {
            Layer3DType layer3DType = this.m_layer3D.getType();
            if (!layer3DType.equals((Object)Layer3DType.DATASET)) {
                String string = InternalResource.loadString("m_layer3D", "Selection3D_Layer3DTypeMustBeDataset", "realspace_resources");
                throw new IllegalStateException(string);
            }
            Dataset dataset = ((Layer3DDataset)this.m_layer3D).getDataset();
            if (!InternalDataset.getIsVector(dataset)) {
                String string = InternalResource.loadString("dataset", "Selection3D_Layer3DDatasetTypeMustBeVector", "realspace_resources");
                throw new IllegalStateException(string);
            }
            int n = this.getCount();
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.get(i);
            }
            recordset = ((DatasetVector)dataset).query(nArray, CursorType.DYNAMIC);
        }
        return recordset;
    }

    public void updateData() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("updateData()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (this.isUserLayer) {
            if (this.m_layer3D == null) {
                String string = InternalResource.loadString("updateData()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer3D);
            if (l == 0L) {
                String string = InternalResource.loadString("updateData()", "Global_OwnerHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            Selection3DNative.jni_UpdateData(l);
        }
    }

    public boolean isBoundingBoxVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Selection3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layer3D != null && InternalHandle.getHandle(this.m_layer3D) != 0L) {
            return Selection3DNative.jni_IsBoundingBoxVisible(InternalHandle.getHandle(this.m_layer3D));
        }
        return false;
    }

    public void setBoundingBoxVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Selection3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layer3D != null && InternalHandle.getHandle(this.m_layer3D) != 0L) {
            Selection3DNative.jni_SetBoundingBoxVisible(InternalHandle.getHandle(this.m_layer3D), value);
        }
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            Selection3DNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        if (this.m_geoStyle3D != null) {
            InternalGeoStyle3D.clearHandle(this.m_geoStyle3D);
            this.m_geoStyle3D = null;
        }
        this.m_layer3D = null;
        this.setHandle(0L);
    }
}

