/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetMosaic;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerGroup;
import com.supermap.mapping.LayerGroupNative;
import com.supermap.mapping.LayerMosaic;
import com.supermap.mapping.LayerMosaicGroupNative;
import com.supermap.mapping.LayerType;
import com.supermap.mapping.Layers;
import com.supermap.mapping.Map;

public class LayerMosaicGroup
extends LayerGroup {
    protected LayerMosaic m_layerMosaic;
    protected Layer m_layerFootprint;
    protected Layer m_layerBoundary;
    DatasetMosaic m_datasetMosaic;

    LayerMosaicGroup(long handle, Layers layers, Map map) {
        super(handle, null, layers, map);
    }

    protected LayerMosaicGroup(long handle, DatasetMosaic dtMosaic, Layers layers, Map map) {
        super(handle, null, layers, map);
        this.setHandle(handle);
        this.m_datasetMosaic = dtMosaic;
        this.m_layersList.clear();
        this.fillUGOItem();
    }

    protected static LayerMosaicGroup createUGCManagedIntance(long handle, DatasetMosaic dtMosaic, Layers layers, Map map) {
        return new LayerMosaicGroup(handle, dtMosaic, layers, map);
    }

    public LayerMosaic getMosaicLayer() {
        return this.m_layerMosaic;
    }

    public Layer getFootprintLayer() {
        return this.m_layerFootprint;
    }

    public Layer getBoundaryLayer() {
        return this.m_layerBoundary;
    }

    @Override
    protected void fillUGOItem() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = LayerMosaicGroupNative.jni_GetCount(this.getHandle());
        for (int i = 0; i < n; ++i) {
            long l = LayerGroupNative.jni_GetItemByIndex(this.getHandle(), i);
            if (l == 0L) continue;
            Layer layer = null;
            if (Layer.getSubType(l) == LayerType.SUBLAYER_MOSAIC) {
                this.m_layerMosaic = new LayerMosaic(l, this.m_layers, this.m_map);
                this.m_layerMosaic.setParentGroup(this);
                this.m_layersList.add(this.m_layerMosaic);
                continue;
            }
            layer = new Layer(l, this.m_layers, this.m_map);
            Dataset dataset = layer.getDataset();
            if (dataset != null) {
                if (dataset.getTableName().endsWith("_F")) {
                    this.m_layerFootprint = layer;
                } else if (dataset.getTableName().endsWith("_B")) {
                    this.m_layerBoundary = layer;
                }
            }
            layer.setParentGroup(this);
            this.m_layersList.add(layer);
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.m_layerMosaic != null) {
            this.m_layerMosaic.clearHandle();
            this.m_layerMosaic = null;
        }
        if (this.m_layerFootprint != null) {
            this.m_layerFootprint.clearHandle();
            this.m_layerFootprint = null;
        }
    }
}

