/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.ColorGradientType;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Enum;
import com.supermap.data.Toolkit;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.RangeMode;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeGridRangeItem;
import com.supermap.mapping.ThemeGridRangeNative;
import java.awt.Color;
import java.util.ArrayList;

public class ThemeGridRange
extends Theme {
    private ArrayList m_gridRangeItems = null;
    double m_specialValue = -9999.0;
    boolean m_isSpecialValueTransparent = false;
    private Color m_specialValueColor = Color.white;

    public ThemeGridRange() {
        long l = ThemeGridRangeNative.jni_New();
        this.setHandle(l, true);
        this.m_gridRangeItems = new ArrayList();
    }

    public ThemeGridRange(ThemeGridRange themeGridRange) {
        if (themeGridRange == null) {
            String string = InternalResource.loadString("themeGridRange", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeGridRange.getHandle() == 0L) {
            String string = InternalResource.loadString("themeGridRange", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeGridRangeNative.jni_Clone(themeGridRange.getHandle());
        this.setHandle(l, true);
        this.m_gridRangeItems = new ArrayList();
        int n = themeGridRange.getGridRangeItemsList().size();
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeGridRange));
        for (int i = 0; i < n; ++i) {
            ThemeGridRangeItem themeGridRangeItem = new ThemeGridRangeItem(this);
            this.m_gridRangeItems.add(themeGridRangeItem);
        }
    }

    ThemeGridRange(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
        this.m_gridRangeItems = new ArrayList();
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            ThemeGridRangeItem themeGridRangeItem = new ThemeGridRangeItem(this);
            this.m_gridRangeItems.add(themeGridRangeItem);
        }
    }

    public RangeMode getRangeMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRangeMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGridRangeNative.jni_GetRangeMode(this.getHandle());
        return (RangeMode)Enum.parse(RangeMode.class, (int)n);
    }

    public ThemeGridRangeItem getItem(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return (ThemeGridRangeItem)this.m_gridRangeItems.get(index);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGridRangeNative.jni_GetCount(this.getHandle());
        int n2 = 0;
        n2 = n == 0 || n == 1 ? 0 : n - 1;
        return n2;
    }

    public boolean addToHead(ThemeGridRangeItem item) {
        return this.addToHead(item, false);
    }

    public boolean addToTail(ThemeGridRangeItem item) {
        return this.addToTail(item, false);
    }

    public boolean addToHead(ThemeGridRangeItem item, boolean normalize) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToHead(ThemeGridRangeItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (item.getStart() >= item.getEnd()) {
            if (normalize) {
                if (Toolkit.isZero((double)(item.getStart() - item.getEnd()))) {
                    return false;
                }
                Double d = item.getStart();
                item.setStart(item.getEnd());
                item.setEnd(d);
            } else {
                String string = InternalResource.loadString("item", "ThemeGridRange_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((n = this.getCount()) > 0) {
            double d;
            double d2 = ThemeGridRangeNative.jni_GetValueAt(this.getHandle(), 0);
            double d3 = item.getEnd();
            double d4 = d3 - d2;
            boolean bl = Toolkit.isZero((double)d4);
            if (!bl) {
                if (normalize) {
                    item.setEnd(d2);
                } else {
                    String string = InternalResource.loadString("item.getEnd()", "ThemeGridRange_InvalidEndOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if ((bl = Toolkit.isZero((double)(d4 = (d = item.getStart()) - d2))) || d > d2) {
                return false;
            }
        }
        this.m_lock.lock();
        ThemeGridRangeItem themeGridRangeItem = new ThemeGridRangeItem(item);
        boolean bl = ThemeGridRangeNative.jni_AddToHead(this.getHandle(), themeGridRangeItem.getCaption(), themeGridRangeItem.isVisible(), themeGridRangeItem.getColor().getRGB(), themeGridRangeItem.getStart(), themeGridRangeItem.getEnd());
        if (bl) {
            ThemeGridRangeItem themeGridRangeItem2 = new ThemeGridRangeItem(this);
            this.m_gridRangeItems.add(0, themeGridRangeItem2);
        }
        this.m_lock.unlock();
        return bl;
    }

    public boolean addToTail(ThemeGridRangeItem item, boolean normalize) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToTail(ThemeGridRangeItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (item.getStart() >= item.getEnd()) {
            if (normalize) {
                if (Toolkit.isZero((double)(item.getStart() - item.getEnd()))) {
                    return false;
                }
                Double d = item.getStart();
                item.setStart(item.getEnd());
                item.setEnd(d);
            } else {
                String string = InternalResource.loadString("item", "ThemeGridRange_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((n = this.getCount()) > 0) {
            double d;
            double d2 = ThemeGridRangeNative.jni_GetValueAt(this.getHandle(), n);
            double d3 = item.getStart();
            double d4 = d3 - d2;
            boolean bl = Toolkit.isZero((double)d4);
            if (!bl) {
                if (normalize) {
                    item.setStart(d2);
                } else {
                    String string = InternalResource.loadString("item.getStart()", "ThemeGridRange_InavlidStartOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if ((bl = Toolkit.isZero((double)(d4 = d2 - (d = item.getEnd())))) || d < d2) {
                return false;
            }
        }
        this.m_lock.lock();
        ThemeGridRangeItem themeGridRangeItem = new ThemeGridRangeItem(item);
        boolean bl = ThemeGridRangeNative.jni_AddToTail(this.getHandle(), themeGridRangeItem.getCaption(), themeGridRangeItem.isVisible(), themeGridRangeItem.getColor().getRGB(), themeGridRangeItem.getStart(), themeGridRangeItem.getEnd());
        if (bl) {
            ThemeGridRangeItem themeGridRangeItem2 = new ThemeGridRangeItem(this);
            this.m_gridRangeItems.add(themeGridRangeItem2);
        }
        this.m_lock.unlock();
        return bl;
    }

    public boolean split(int index, double splitValue, Color color1, String caption1, Color color2, String caption2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("split()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (color1 == null) {
            String string = InternalResource.loadString("color1", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (color2 == null) {
            String string = InternalResource.loadString("color2", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        double d = ThemeGridRangeNative.jni_GetValueAt(this.getHandle(), index);
        double d2 = ThemeGridRangeNative.jni_GetValueAt(this.getHandle(), index + 1);
        if (splitValue <= d || splitValue >= d2) {
            String string = InternalResource.loadString("splitValue", "ThemeGridRange_InvalidSplitValue", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (caption1 == null || caption1.trim().length() == 0) {
            String string = InternalResource.loadString("caption1", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (caption2 == null || caption2.trim().length() == 0) {
            String string = InternalResource.loadString("caption2", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        boolean bl = ThemeGridRangeNative.jni_Split(this.getHandle(), index, splitValue, color1.getRGB(), caption1, color2.getRGB(), caption2);
        if (bl) {
            ThemeGridRangeItem themeGridRangeItem = (ThemeGridRangeItem)this.m_gridRangeItems.get(index);
            themeGridRangeItem.setEnd(splitValue);
            themeGridRangeItem.setCaption(caption1);
            themeGridRangeItem.setColor(color1);
            ThemeGridRangeItem themeGridRangeItem2 = new ThemeGridRangeItem(this);
            this.m_gridRangeItems.add(index + 1, themeGridRangeItem2);
        }
        this.m_lock.unlock();
        return bl;
    }

    public boolean merge(int index, int count, Color color, String caption) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("merge(int index1, int count, Color color, String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (index + count < index || index + count > n) {
            String string = InternalResource.loadString("count", "ThemeGridRange_TheCountIsInvalid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        boolean bl = false;
        if (count == 0) {
            bl = true;
        } else {
            bl = ThemeGridRangeNative.jni_Merge(this.getHandle(), index, count, color.getRGB(), caption);
            if (bl) {
                ThemeGridRangeItem themeGridRangeItem = (ThemeGridRangeItem)this.m_gridRangeItems.get(index);
                double d = ThemeGridRangeNative.jni_GetValueAt(this.getHandle(), index + 1);
                themeGridRangeItem.setEnd(d);
                themeGridRangeItem.setCaption(caption);
                themeGridRangeItem.setColor(color);
                for (int i = 0; i < count - 1; ++i) {
                    this.m_gridRangeItems.remove(index + 1);
                }
            }
        }
        this.m_lock.unlock();
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGridRangeNative.jni_Clear(this.getHandle());
        if (this.m_gridRangeItems != null) {
            this.m_gridRangeItems.clear();
        }
        this.m_lock.unlock();
    }

    public static ThemeGridRange makeDefault(DatasetGrid dataset, RangeMode rangeMode, double rangeParameter, ColorGradientType colorGradientType) {
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rangeMode == null) {
            String string = InternalResource.loadString("rangeMode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rangeMode.equals((Object)RangeMode.STDDEVIATION) || rangeMode.equals((Object)RangeMode.QUANTILE)) {
            String string = InternalResource.loadString("rangeMode", "ThemeGridRange_TheRangeModeIsUnsupported", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if ((rangeMode.equals((Object)RangeMode.EQUALINTERVAL) || rangeMode.equals((Object)RangeMode.SQUAREROOT) || rangeMode.equals((Object)RangeMode.LOGARITHM)) && rangeParameter < 1.0) {
            String string = InternalResource.loadString("rangeParameter", "ThemeGridRange_TheArgumentOfRangeParameterShouldNotBeLessThanOneRange", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rangeMode.equals((Object)RangeMode.CUSTOMINTERVAL) && rangeParameter < 0.0) {
            String string = InternalResource.loadString("rangeParameter", "ThemeGridRange_TheArgumentOfRangeParameterShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.TERRAIN;
        }
        int n = InternalEnum.getUGCValue(rangeMode);
        int n2 = InternalEnum.getUGCValue((Enum)colorGradientType);
        long l2 = ThemeGridRangeNative.jni_MakeDefault(l, n, rangeParameter, n2);
        ThemeGridRange themeGridRange = null;
        if (l2 != 0L) {
            themeGridRange = new ThemeGridRange(l2, true);
        }
        return themeGridRange;
    }

    public static ThemeGridRange makeDefault(DatasetGrid dataset, RangeMode rangeMode, double rangeParameter) {
        return ThemeGridRange.makeDefault(dataset, rangeMode, rangeParameter, null);
    }

    public int indexOf(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGridRangeNative.jni_GetCount(this.getHandle());
        double[] dArray = new double[n];
        ThemeGridRangeNative.jni_GetValues(this.getHandle(), dArray);
        for (int i = 0; i < n - 1; ++i) {
            if (!(dArray[i] <= value) || !(value < dArray[i + 1])) continue;
            return i;
        }
        return -1;
    }

    public void reverseColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverseColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGridRangeNative.jni_ReverseColor(this.getHandle());
        this.m_lock.unlock();
    }

    @Override
    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count = ");
        stringBuffer.append(this.getCount());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeGridRangeNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    public boolean fromXML(String xml) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = super.fromXML(xml);
            if (bl) {
                this.refreshGridRangeItemsList();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    @Override
    protected void clearHandle() {
        if (this.m_gridRangeItems != null) {
            this.m_gridRangeItems.clear();
            this.m_gridRangeItems = null;
        }
        this.setHandle(0L);
    }

    ArrayList getGridRangeItemsList() {
        return this.m_gridRangeItems;
    }

    private void refreshGridRangeItemsList() {
        if (this.m_gridRangeItems != null) {
            this.m_gridRangeItems.clear();
        }
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            ThemeGridRangeItem themeGridRangeItem = new ThemeGridRangeItem(this);
            this.m_gridRangeItems.add(themeGridRangeItem);
        }
    }

    public void setSpecialValueTransparent(boolean bSpecialValueTransparent) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layer != null) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l != 0L) {
                LayerNative.jni_SetSpecialValueTransparent(l, bSpecialValueTransparent);
            }
        } else {
            this.m_isSpecialValueTransparent = bSpecialValueTransparent;
        }
    }

    public boolean isSpecialValueTransparent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.m_layer != null) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l != 0L) {
                bl = LayerNative.jni_GetSpecialValueTransparent(l);
            }
        } else {
            bl = this.m_isSpecialValueTransparent;
        }
        return bl;
    }

    @Deprecated
    public void setSpecialValue(int nSpecialValue) {
        this.setThemeSpecialValue(nSpecialValue);
    }

    @Deprecated
    public int GetSpecialValue() {
        return (int)this.getThemeSpecialValue();
    }

    public void setThemeSpecialValue(double nSpecialValue) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setThemeSpecialValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layer != null) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l != 0L) {
                LayerNative.jni_setGridSpecialValue(l, nSpecialValue);
            }
        } else {
            this.m_specialValue = nSpecialValue;
        }
    }

    public double getThemeSpecialValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getThemeSpecialValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double d = 0.0;
        if (this.m_layer != null) {
            long l = InternalHandle.getHandle(this.m_layer);
            if (l != 0L) {
                d = LayerNative.jni_getGridSpecialValue(l);
            }
        } else {
            d = this.m_specialValue;
        }
        return d;
    }

    public Color getSpecialValueColor() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpecialValueColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layer != null && (l = InternalHandle.getHandle(this.m_layer)) != 0L) {
            int n = LayerNative.jni_GetGridSpecialValueColor(l);
            return new Color(n, true);
        }
        return this.m_specialValueColor;
    }

    public void setSpecialValueColor(Color value) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpecialValueColor(Color value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layer != null && (l = InternalHandle.getHandle(this.m_layer)) != 0L) {
            LayerNative.jni_SetGridSpecialValueColor(l, value.getRGB());
        }
        this.m_specialValueColor = new Color(value.getRGB(), true);
    }
}

