/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.ThemeGridRange;
import com.supermap.mapping.ThemeGridRangeNative;
import java.awt.Color;

public class ThemeGridRangeItem {
    private double m_start = InternalToolkitMapping.FLT_MIN_VALUE;
    private double m_end = InternalToolkitMapping.FLT_MAX_VALUE;
    private boolean m_isVisible = true;
    private String m_caption = "UntitledThemeGridRangeItem";
    private Color m_color = Color.BLACK;
    private boolean isUserThemeGridRange = false;
    private ThemeGridRange m_themeGridRange = null;

    public ThemeGridRangeItem() {
        this.isUserThemeGridRange = false;
    }

    public ThemeGridRangeItem(double start, double end, Color color) {
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_start = start;
        this.m_end = end;
        this.m_color = color;
        this.isUserThemeGridRange = false;
    }

    public ThemeGridRangeItem(double start, double end, Color color, String caption) {
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_start = start;
        this.m_end = end;
        this.m_color = color;
        this.m_caption = caption;
        this.isUserThemeGridRange = false;
    }

    public ThemeGridRangeItem(ThemeGridRangeItem themeGridRangeItem) {
        if (themeGridRangeItem == null) {
            String string = InternalResource.loadString("themeGridRangeItem", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeGridRangeItem.isUserThemeGridRange) {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeGridRangeItem.m_themeGridRange);
            if (l == 0L) {
                String string = InternalResource.loadString("themeGridRengeItem", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            int n = themeGridRangeItem.m_themeGridRange.getGridRangeItemsList().indexOf(themeGridRangeItem);
            if (n == -1) {
                String string = InternalResource.loadString("themeGridRangeItem", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        this.m_start = themeGridRangeItem.getStart();
        this.m_end = themeGridRangeItem.getEnd();
        this.m_color = themeGridRangeItem.getColor();
        this.m_isVisible = themeGridRangeItem.isVisible();
        this.m_caption = themeGridRangeItem.getCaption();
        this.isUserThemeGridRange = false;
    }

    ThemeGridRangeItem(ThemeGridRange themeGridRange) {
        this.m_themeGridRange = themeGridRange;
        this.isUserThemeGridRange = true;
    }

    public double getStart() {
        if (this.isUserThemeGridRange) {
            int n = this.m_themeGridRange.getGridRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getStart()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridRange);
            if (l == 0L) {
                String string = InternalResource.loadString("getStart()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return ThemeGridRangeNative.jni_GetValueAt(l, n);
        }
        return this.m_start;
    }

    public void setStart(double start) {
        if (this.isUserThemeGridRange) {
            int n = this.m_themeGridRange.getGridRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setStart(double start)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridRange);
            if (l == 0L) {
                String string = InternalResource.loadString("setStart(double start)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            double d = InternalToolkitMapping.DBL_MIN_VALUE;
            if (n > 0) {
                d = ThemeGridRangeNative.jni_GetValueAt(l, n - 1);
            }
            double d2 = ThemeGridRangeNative.jni_GetValueAt(l, n + 1);
            if (start <= d || start >= d2) {
                String string = InternalResource.loadString("start", "ThemeGridRangeItem_InvalidStartValue", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            ThemeGridRangeNative.jni_SetValueAt(l, n, start);
        }
        this.m_start = start;
    }

    public double getEnd() {
        double d = 0.0;
        if (this.isUserThemeGridRange) {
            int n = this.m_themeGridRange.getGridRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getEnd()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridRange);
            if (l == 0L) {
                String string = InternalResource.loadString("getEnd()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            d = ThemeGridRangeNative.jni_GetValueAt(l, n + 1);
        } else {
            d = this.m_end;
        }
        return d;
    }

    public void setEnd(double end) {
        if (this.isUserThemeGridRange) {
            double d;
            int n = this.m_themeGridRange.getGridRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setEnd(double end)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridRange);
            if (l == 0L) {
                String string = InternalResource.loadString("setEnd(double end)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            double d2 = InternalToolkitMapping.DBL_MAX_VALUE;
            int n2 = this.m_themeGridRange.getCount();
            if (n != n2 - 1) {
                d2 = ThemeGridRangeNative.jni_GetValueAt(l, n + 2);
            }
            if (end <= (d = ThemeGridRangeNative.jni_GetValueAt(l, n)) || end >= d2) {
                String string = InternalResource.loadString("end", "ThemeGridRangeItem_InvalidStartValue", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            ThemeGridRangeNative.jni_SetValueAt(l, n + 1, end);
        }
        this.m_end = end;
    }

    public Color getColor() {
        Color color = null;
        if (this.isUserThemeGridRange) {
            int n = this.m_themeGridRange.getGridRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridRange);
            if (l == 0L) {
                String string = InternalResource.loadString("getColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n2 = ThemeGridRangeNative.jni_GetColorAt(l, n);
            color = new Color(n2, true);
        } else {
            color = this.m_color;
        }
        return color;
    }

    public void setColor(Color color) {
        int n = -1;
        long l = 0L;
        if (this.isUserThemeGridRange) {
            n = this.m_themeGridRange.getGridRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setColor(Color color)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridRange);
            if (l == 0L) {
                String string = InternalResource.loadString("setColor(Color color)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserThemeGridRange) {
            int n2 = color.getRGB();
            ThemeGridRangeNative.jni_SetColorAt(l, n, n2);
        }
        this.m_color = color;
    }

    public String getCaption() {
        String string = null;
        if (this.isUserThemeGridRange) {
            int n = this.m_themeGridRange.getGridRangeItemsList().indexOf(this);
            if (n == -1) {
                String string2 = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridRange);
            if (l == 0L) {
                String string3 = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string3);
            }
            string = ThemeGridRangeNative.jni_GetCaptionAt(l, n);
        } else {
            string = this.m_caption == null ? "" : this.m_caption;
        }
        return string;
    }

    public void setCaption(String value) {
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserThemeGridRange) {
            int n = this.m_themeGridRange.getGridRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setCaption(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridRange);
            if (l == 0L) {
                String string = InternalResource.loadString("setCaption(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeGridRangeNative.jni_SetCaptionAt(l, n, value);
        }
        this.m_caption = value;
    }

    public boolean isVisible() {
        boolean bl = false;
        if (this.isUserThemeGridRange) {
            int n = this.m_themeGridRange.getGridRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridRange);
            if (l == 0L) {
                String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            bl = ThemeGridRangeNative.jni_GetIsVisibleAt(l, n);
        } else {
            bl = this.m_isVisible;
        }
        return bl;
    }

    public void setVisible(boolean value) {
        if (this.isUserThemeGridRange) {
            int n = this.m_themeGridRange.getGridRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridRange);
            if (l == 0L) {
                String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeGridRangeNative.jni_SetIsVisibleAt(l, n, value);
        }
        this.m_isVisible = value;
    }

    public String toString() {
        if (this.isUserThemeGridRange) {
            int n = this.m_themeGridRange.getGridRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeGridRange);
            if (l == 0L) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Caption = ");
        stringBuffer.append(this.getCaption());
        stringBuffer.append(",Start = ");
        stringBuffer.append(this.getStart());
        stringBuffer.append(",End = ");
        stringBuffer.append(this.getEnd());
        stringBuffer.append(",Visible = ");
        stringBuffer.append(this.isVisible());
        stringBuffer.append(",Color = ");
        stringBuffer.append(this.getColor().toString());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

