/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping.benchmark;

import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.mapping.DynamicLayer;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerSettingVector;
import com.supermap.mapping.benchmark.DefaultRunner;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;

public class DynamicLayerRunner
extends DefaultRunner {
    public DynamicLayerRunner(Workspace workspace, String mapName, int timesPerThread, Rectangle2D bounds, String threadName, String format, int tileSize, CountDownLatch finishedLatch) {
        super(workspace, mapName, timesPerThread, bounds, threadName, format, tileSize, finishedLatch);
    }

    @Override
    public void initMap(Workspace workspace, String mapName) {
        Geometry geometry;
        super.initMap(workspace, mapName);
        Layer layer = this.map.getLayers().get(0);
        layer.setVisible(false);
        Dataset dataset = layer.getDataset();
        Recordset recordset = ((DatasetVector)dataset).getRecordset(false, CursorType.STATIC);
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        recordset.moveFirst();
        while (!recordset.isEOF()) {
            geometry = recordset.getGeometry();
            if (geometry != null) {
                arrayList.add(geometry);
            }
            recordset.moveNext();
        }
        recordset.dispose();
        geometry = new GeoStyle(((LayerSettingVector)layer.getAdditionalSetting()).getStyle());
        for (int i = 0; i < arrayList.size(); ++i) {
            Geometry geometry2 = (Geometry)arrayList.get(i);
            geometry2.setStyle((GeoStyle)geometry);
        }
        DynamicLayer dynamicLayer = new DynamicLayer();
        for (int i = 0; i < arrayList.size(); ++i) {
            Geometry geometry3 = (Geometry)arrayList.get(i);
            dynamicLayer.add(geometry3, String.valueOf(geometry3.getID()));
        }
        this.map.getDynamicLayers().add(dynamicLayer, true);
    }
}

