/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.License;
import com.supermap.data.AboutBox;
import com.supermap.data.ActionGraphicObject;
import com.supermap.data.EditHistory;
import com.supermap.data.EditType;
import com.supermap.data.Enum;
import com.supermap.data.Environment;
import com.supermap.data.GeoCompound;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoStyle;
import com.supermap.data.GeoText;
import com.supermap.data.Geometry;
import com.supermap.data.IDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.TextPart;
import com.supermap.data.Workspace;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerGroup;
import com.supermap.mapping.Layers;
import com.supermap.mapping.Map;
import com.supermap.mapping.SnapMode;
import com.supermap.mapping.SnapSetting;
import com.supermap.mapping.SnappedElement;
import com.supermap.ui.Action;
import com.supermap.ui.ActionChangedEvent;
import com.supermap.ui.ActionChangedListener;
import com.supermap.ui.ActionCursorChangingEvent;
import com.supermap.ui.ActionCursorChangingListener;
import com.supermap.ui.CustomRedoListener;
import com.supermap.ui.CustomUndoListener;
import com.supermap.ui.EditHandleBeginListener;
import com.supermap.ui.EditHandleEvent;
import com.supermap.ui.EditHandleFinishListener;
import com.supermap.ui.EditHandleMoveListener;
import com.supermap.ui.EditHandleOptions;
import com.supermap.ui.EditHandleType;
import com.supermap.ui.EditHistoryEvent;
import com.supermap.ui.GeometryAddedListener;
import com.supermap.ui.GeometryDeletedListener;
import com.supermap.ui.GeometryDeletingListener;
import com.supermap.ui.GeometryEvent;
import com.supermap.ui.GeometryModifiedListener;
import com.supermap.ui.GeometryModifyingListener;
import com.supermap.ui.GeometrySelectChangedEvent;
import com.supermap.ui.GeometrySelectChangedListener;
import com.supermap.ui.GeometrySelectedEvent;
import com.supermap.ui.GeometrySelectedListener;
import com.supermap.ui.InteractionMode;
import com.supermap.ui.InternalBufferImage;
import com.supermap.ui.InternalEditHistory;
import com.supermap.ui.InternalEnum;
import com.supermap.ui.InternalEnvironment;
import com.supermap.ui.InternalHandle;
import com.supermap.ui.InternalHandleDisposable;
import com.supermap.ui.InternalMappingGeoStyle;
import com.supermap.ui.InternalMappingGeometry;
import com.supermap.ui.InternalMappingMap;
import com.supermap.ui.InternalMappingResource;
import com.supermap.ui.InternalSnapSetting;
import com.supermap.ui.InternalToolkitMappingUI;
import com.supermap.ui.MapControlNative;
import com.supermap.ui.MapControl_this_componentAdapter;
import com.supermap.ui.MapControl_this_keyAdapter;
import com.supermap.ui.MapControl_this_mouseAdapter;
import com.supermap.ui.MapControl_this_mouseMotionAdapter;
import com.supermap.ui.MapControl_this_mouseWheelAdapter;
import com.supermap.ui.PaintListener;
import com.supermap.ui.PaintMapControlEvent;
import com.supermap.ui.PointInputedEvent;
import com.supermap.ui.PointInputedListener;
import com.supermap.ui.RedoneListener;
import com.supermap.ui.SelectionMode;
import com.supermap.ui.TrackMode;
import com.supermap.ui.TrackedEvent;
import com.supermap.ui.TrackedListener;
import com.supermap.ui.TrackingEvent;
import com.supermap.ui.TrackingListener;
import com.supermap.ui.UndoneListener;
import com.supermap.ui.VectorizationSetting;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;
import javax.swing.Timer;

public class MapControl
extends JComponent
implements IDisposable,
Serializable,
Runnable {
    private Map m_map;
    private boolean isNewFlag = false;
    private boolean m_isFirstPaint;
    private long m_handle;
    private InternalBufferImage m_bufferImage = null;
    private BorderLayout bolderLayout = new BorderLayout();
    transient Vector m_actionChangedListeners;
    transient Vector m_geometrySelectedListeners;
    transient Vector m_geometrySelectChangedListeners;
    transient Vector m_geometryDeletingListeners;
    transient Vector m_geometryAddedListeners;
    transient Vector m_geometryModifyingListeners;
    transient Vector m_geometryModifiedListeners;
    transient Vector m_pointInputedListeners;
    transient Vector m_editHandleBeginListeners;
    transient Vector m_editHandleMoveListeners;
    transient Vector m_editHandleFinishListeners;
    transient Vector m_actionCursorChangingListeners;
    transient Vector m_trackingListeners;
    transient Vector m_trackedListeners;
    transient Vector m_geometryDeletedListeners;
    transient Vector m_redoneListeners;
    transient Vector m_undoneListeners;
    transient Vector m_customRedoneListeners;
    transient Vector m_customUndoneListeners;
    transient Vector m_paintListeners;
    private boolean m_bNeedOndraw = false;
    private Action m_action = Action.NULL;
    private SnappedElement[] m_snappedElements = null;
    private EditHandleOptions m_handleOptions = null;
    private GeoStyle m_trackingStyle = null;
    private GeoStyle m_assistantLineStyle = null;
    private TrackMode m_trackMode = null;
    private InteractionMode m_interactionMode = null;
    private VectorizationSetting m_vectorlizationSetting = null;
    private SnapSetting m_snapSetting = null;
    private GeoStyle m_assistantRegionStyle = null;
    private GeoStyle m_defaultEditStyle = null;
    private GeoStyle m_trackingZoomAndSelectStyle = null;
    private ArrayList<Layer> m_editableLayers = new ArrayList();
    private License m_license;
    private int m_SelectionTolerance = 1;
    private Workspace m_workspace;
    Action m_beforeAction;
    private GeoPoint m_lastPoint = new GeoPoint();
    private double m_lastLength;
    private double m_lastAngle;
    private double m_lastAzimuth;
    private double m_lastArea;
    private boolean m_waitCursorEnabled = true;
    private boolean m_cursorCustomized = false;
    private Cursor m_currentCursor;
    private Cursor m_followCursor;
    private boolean m_hasDrawn = false;
    private EditHistory m_editHistory;
    private boolean m_bPanButtonDown = false;
    private boolean m_unrefreshable = false;
    private Timer m_timerZoomRefresh;
    private Timer m_timerPanMap;
    private boolean m_bRollingWheelWithoutDelay = false;
    private boolean m_isInOnDrawMethod;
    private ReentrantLock m_lock;
    private ExecutorService m_drawThreadPool;
    private boolean m_isOtherThreadDraw = false;
    private boolean m_drawThreadRunning = false;
    private boolean m_pauseThreadRunning = false;

    public long get_mHandle() {
        return this.m_handle;
    }

    public MapControl() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected MapControl(boolean asynchronousMode) {
        try {
            this.jbInit(asynchronousMode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MapControl(Workspace workspace) {
        if (workspace == null) {
            String string = InternalMappingResource.loadString("workspace", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_workspace = workspace;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)workspace);
    }

    private void checkLicense() {
    }

    private void unLoadLicense() {
        if (this.m_license != null) {
            this.m_license.disconnect();
            this.m_license.dispose();
            this.m_license = null;
        }
    }

    void setEditEnviroment() {
        MapControlNative.jni_SetEditEnvironment(this.m_handle);
    }

    protected static void setEditEnvironment(MapControl mapControl) {
        mapControl.setEditEnviroment();
    }

    public SnapSetting getSnapSetting() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getSnapSetting()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_snapSetting == null) {
            long l = MapControlNative.jni_GetSnapSetting(this.m_handle);
            this.m_snapSetting = InternalSnapSetting.createInstance(l);
        }
        return this.m_snapSetting;
    }

    public void setSnapSetting(SnapSetting value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setSnapSetting(SnapSetting  value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalMappingResource.loadString("setSnapSetting(SnapSetting  value)", "Global_ArgumentNull", "ui_mapping_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("SnapSetting value", "Global_ArgumentObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapControlNative.jni_SetSnapSetting(this.m_handle, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)value));
    }

    public TrackMode getTrackMode() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getTrackMode()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_trackMode;
    }

    public void setTrackMode(TrackMode value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getTrackMode()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!InternalEnum.isDefined(TrackMode.class, (int)value.value())) {
            String string = InternalMappingResource.loadString("TrackMode value", "Global_EnumValueIsError", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == TrackMode.TRACK) {
            if (this.isOtherThreadDraw()) {
                this.waitDrawThreadDown(false);
                this.setDrawThreadRunning(false);
            }
            InternalMappingMap.setCanRefreshTrackingLayer(this.m_map, true);
        } else {
            InternalMappingMap.setCanRefreshTrackingLayer(this.m_map, false);
            if (this.isOtherThreadDraw()) {
                this.setDrawThreadRunning(true);
            }
        }
        this.m_trackMode = value;
        this.setAction(this.getAction());
    }

    public SnappedElement[] getSnappedElements() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getSnappedElements()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapControlNative.jni_GetSnappedElementCount(this.m_handle);
        this.m_snappedElements = null;
        if (n > 0) {
            ArrayList<SnappedElement> arrayList = new ArrayList<SnappedElement>();
            String[] stringArray = new String[n];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            double[] dArray = new double[3 * n];
            double[] dArray2 = new double[3 * n];
            MapControlNative.jni_GetSnappedElements(this.m_handle, stringArray, nArray, nArray2, dArray, dArray2);
            Layers layers = this.getMap().getLayers();
            Layer layer = null;
            for (int i = 0; i < stringArray.length; ++i) {
                layer = layers.findLayer(stringArray[i]);
                if (layer == null) continue;
                Point2D[] point2DArray = null;
                SnapMode snapMode = (SnapMode)InternalEnum.parseUGCValue(SnapMode.class, nArray2[i]);
                int n2 = snapMode.value();
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 32: 
                    case 256: 
                    case 512: 
                    case 4096: 
                    case 8192: {
                        point2DArray = new Point2D[]{new Point2D()};
                        point2DArray[0].setX(dArray[3 * i]);
                        point2DArray[0].setY(dArray2[3 * i]);
                        break;
                    }
                    case 64: 
                    case 128: 
                    case 1024: 
                    case 2048: {
                        point2DArray = new Point2D[]{new Point2D(), new Point2D()};
                        point2DArray[0].setX(dArray[3 * i]);
                        point2DArray[0].setY(dArray2[3 * i]);
                        point2DArray[1].setX(dArray[3 * i + 1]);
                        point2DArray[1].setY(dArray2[3 * i + 1]);
                        break;
                    }
                    case 4: 
                    case 8: 
                    case 16: {
                        point2DArray = new Point2D[]{new Point2D(), new Point2D(), new Point2D()};
                        point2DArray[0].setX(dArray[3 * i]);
                        point2DArray[0].setY(dArray2[3 * i]);
                        point2DArray[1].setX(dArray[3 * i + 1]);
                        point2DArray[1].setY(dArray2[3 * i + 1]);
                        point2DArray[2].setX(dArray[3 * i + 2]);
                        point2DArray[2].setY(dArray2[3 * i + 2]);
                        break;
                    }
                }
                arrayList.add(new SnappedElement(layer, nArray[i], snapMode, point2DArray));
            }
            this.m_snappedElements = arrayList.toArray(new SnappedElement[0]);
        }
        return this.m_snappedElements;
    }

    public Layer[] getEditableLayers() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("GetEditableLayers()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_editableLayers.clear();
        Map map = this.getMap();
        Layers layers = null;
        if (map != null) {
            layers = map.getLayers();
            for (int i = 0; i < layers.getCount(); ++i) {
                this.CheckLayerEditable(layers.get(i));
            }
        }
        Layer[] layerArray = new Layer[this.m_editableLayers.size()];
        return this.m_editableLayers.toArray(layerArray);
    }

    private void CheckLayerEditable(Layer layer) {
        LayerGroup layerGroup = null;
        if (layer instanceof LayerGroup) {
            layerGroup = (LayerGroup)layer;
            for (int i = 0; i < layerGroup.getCount(); ++i) {
                this.CheckLayerEditable(layerGroup.get(i));
            }
        } else if (layer.isEditable()) {
            this.m_editableLayers.add(layer);
        }
    }

    public GeoStyle getAssistantRegionStyle() {
        long l;
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getAssistantRegionStyle()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_assistantRegionStyle == null && (l = MapControlNative.jni_GetAssistantRegionStyle(this.m_handle)) != 0L) {
            this.m_assistantRegionStyle = InternalMappingGeoStyle.createInstance(l);
        }
        return this.m_assistantRegionStyle;
    }

    public void setAssistantRegionStyle(GeoStyle value) {
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setAssistantRegionStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalMappingResource.loadString("GeoStyle value", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("GeoStyle value", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapControlNative.jni_SetAssistantRegionStyle(this.m_handle, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public boolean canRedo() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("isCanRedo()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetIsCanRedo(this.m_handle);
    }

    public boolean canUndo() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("isCanUndo()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetIsCanUndo(this.m_handle);
    }

    public boolean canCut() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("isCanCut()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetIsCanCut(this.m_handle);
    }

    public boolean canCopy() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("isCanCopy()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetIsCanCopy(this.m_handle);
    }

    public boolean canPaste() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("isCanPaste()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetIsCanPaste(this.m_handle);
    }

    public Layer getActiveEditableLayer() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getActiveEditableLayer()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        Layer layer = null;
        long l = MapControlNative.jni_GetActiveEditableLayerHandle(this.m_handle);
        if (l != 0L) {
            Layer[] layerArray = this.getEditableLayers();
            for (int i = 0; i < layerArray.length; ++i) {
                layer = layerArray[i];
                if (InternalHandle.getHandle(layer) != l) continue;
                return layer;
            }
        }
        return layer;
    }

    public void setActiveEditableLayer(Layer value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setActiveEditableLayer(Layer  value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        Map map = this.getMap();
        Layers layers = map.getLayers();
        if (value != null) {
            long l = InternalHandle.getHandle(value);
            MapControlNative.jni_SetActiveEditableLayer(this.m_handle, l);
        }
    }

    public boolean isMultiLayerEditEnabled() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("isMultiLayerEditEnabled()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetMultiLayerEditEnable(this.m_handle);
    }

    public void setMultiLayerEditEnabled(boolean value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setMultiLayerEditEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapControlNative.jni_SetMultiLayerEditEnable(this.m_handle, value);
    }

    public void setRefreshAtTracked(boolean value) {
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setRefreshAtTracked(boolean value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapControlNative.jni_SetRefreshAtTracked(this.m_handle, value);
    }

    public boolean refreshAtTracked() {
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("refreshAtTracked()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_RefreshAtTracked(this.m_handle);
    }

    public void setRefreshInInvalidArea(boolean value) {
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setRefreshInInvalidArea(boolean value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapControlNative.jni_SetRefreshInInvalidArea(this.m_handle, value);
    }

    public boolean refreshInInvalidArea() {
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("refreshInInvalidArea()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_RefreshInInvalidArea(this.m_handle);
    }

    public VectorizationSetting getVectorizationSetting() {
        long l;
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getVectorlizationSetting()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_vectorlizationSetting == null && (l = MapControlNative.jni_GetVectorlizationSetting(this.m_handle)) != 0L) {
            this.m_vectorlizationSetting = new VectorizationSetting(l);
        }
        return this.m_vectorlizationSetting;
    }

    public void setVectorizationSetting(VectorizationSetting value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setVectorlizationSetting(VectorlizationSetting  value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalMappingResource.loadString("VectorlizationSetting  value", "Global_ArgumentNull", "ui_mapping_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("VectorlizationSetting  value", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new NullPointerException(string);
        }
        Layers layers = this.m_map.getLayers();
        if (!layers.contains(value.getRasterLayer().getName())) {
            String string = InternalMappingResource.loadString("value.getRasterLayer()", "MapControl_NotContainLayer", "ui_mapping_resources");
            throw new NullPointerException(string);
        }
        MapControlNative.jni_SetVectorlizationSetting(this.m_handle, l);
        if (this.m_vectorlizationSetting == null) {
            long l2 = MapControlNative.jni_GetVectorlizationSetting(this.m_handle);
            if (l2 != 0L) {
                this.m_vectorlizationSetting = new VectorizationSetting(l2);
            }
        } else {
            long l3 = MapControlNative.jni_GetVectorlizationSetting(this.m_handle);
            this.m_vectorlizationSetting.changeHandle(l3);
        }
        if (this.m_vectorlizationSetting != null) {
            this.m_vectorlizationSetting.setRasterLayer(value.getRasterLayer());
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)value));
    }

    public Action getAction() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getAction()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapControlNative.jni_GetUserAction(this.m_handle);
        if (n != -1) {
            try {
                this.m_action = (Action)InternalEnum.parseUGCValue(Action.class, n);
            }
            catch (Exception exception) {
                this.m_action = Action.newInstance(n);
            }
        }
        return this.m_action;
    }

    public void setAction(Action action) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setAction(Action action)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (action == null) {
            String string = InternalMappingResource.loadString("action", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        Action action2 = this.getAction();
        int n = -1;
        try {
            n = InternalEnum.getUGCValue(action);
        }
        catch (Exception exception) {
            n = action.value();
        }
        if (this.m_isOtherThreadDraw) {
            if (action.value() == Action.SWIPE.value()) {
                this.setDrawThreadRunning(false);
            } else if (action2.value() == Action.SWIPE.value()) {
                this.setDrawThreadRunning(true);
            }
        }
        this.m_action = action;
        int n2 = InternalEnum.getUGCValue(this.m_trackMode);
        MapControlNative.jni_SetAction(this.m_handle, n, n2);
        if (!this.getAction().equals((Object)action2)) {
            ActionChangedEvent actionChangedEvent = new ActionChangedEvent(this, action2, action);
            this.fireActionChanged(actionChangedEvent);
        }
        this.setCursor(false);
    }

    public boolean getMarginPanEnabled() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getMarginPanEnabled()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetMarginPanEnable(this.m_handle);
    }

    public void setMarginPanEnabled(boolean value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setMarginPanEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapControlNative.jni_SetMarginPanEnable(this.m_handle, value);
    }

    public double getMarginPanPercent() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getMarginPanPercent()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetMarginPanPercent(this.m_handle);
    }

    public void setMarginPanPercent(double value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setMarginPanPercent(double value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0 || value > 1.0) {
            String string = InternalMappingResource.loadString("value", "MapControl_TheArgumentOfMarginPanPercentValueIsInvalid", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapControlNative.jni_SetMarginPanPercent(this.m_handle, value);
    }

    public double getSelectionTolerance() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getSelectionTolerance()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetSelectionTolerance(this.m_handle);
    }

    public void setSelectionTolerance(double value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setSelectionTolerance(int value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapControlNative.jni_SetSelectionTolerance(this.m_handle, value);
    }

    public SelectionMode getSelectionMode() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getSelectionMode()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapControlNative.jni_GetSelectMode(this.m_handle);
        return (SelectionMode)InternalEnum.parseUGCValue(SelectionMode.class, n);
    }

    public void setInvertSelectionMode(SelectionMode selectionMode) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setSelectionMode(SelectionMode value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (selectionMode == null) {
            String string = InternalMappingResource.loadString("selectionMode", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(selectionMode);
        MapControlNative.jni_SetInvertSlectMode(this.m_handle, n);
    }

    public SelectionMode getInvertSelectionMode() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getSelectionMode()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapControlNative.jni_GetInvertSelectMode(this.m_handle);
        return (SelectionMode)InternalEnum.parseUGCValue(SelectionMode.class, n);
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setSelectionMode(SelectionMode value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (selectionMode == null) {
            String string = InternalMappingResource.loadString("selectionMode", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(selectionMode);
        MapControlNative.jni_SetSlectMode(this.m_handle, n);
    }

    public int getSelectionPixelTolerance() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getSelectionPixelTolerance()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_SelectionTolerance = MapControlNative.jni_getSelectionPixelTolerance(this.m_handle);
        return this.m_SelectionTolerance;
    }

    public void setSelectionPixelTolerance(int value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setSelectionPixelTolerance(int value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_SelectionTolerance = value;
        MapControlNative.jni_setSelectionPixelTolerance(this.m_handle, this.m_SelectionTolerance);
    }

    public long getMaxEditGeometriesCount() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getMaxEditGeometriesCount()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_GetMaxEditGeometriesCount(this.m_handle);
    }

    public void setMaxEditGeometriesCount(long value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setMaxEditGeometriesCount(int value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapControlNative.jni_SetMaxEditGeometriesCount(this.m_handle, value);
    }

    public boolean isOtherThreadDraw() {
        return this.m_isOtherThreadDraw;
    }

    public boolean isDrawThreadRunning() {
        return this.m_drawThreadRunning;
    }

    public void setDrawThreadRunning(boolean value) {
        this.m_drawThreadRunning = value ? this.getEditableLayers().length <= 0 : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMap() {
        try {
            this.m_lock.lock();
            this.makeSureNewFromJNI();
            if (this.m_handle == 0L) {
                String string = InternalMappingResource.loadString("getMap()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_map == null) {
                long l = MapControlNative.jni_GetMap(this.m_handle);
                if (l == 0L) {
                    Map map = null;
                    return map;
                }
                this.m_map = InternalMappingMap.createInstance(l, this, this.m_lock);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return this.m_map;
    }

    public void setInteractionMode(InteractionMode value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setInteractionMode(InteractionMode value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_interactionMode = value;
    }

    public InteractionMode getInteractionMode() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getInteractionMode()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_interactionMode;
    }

    public EditHandleOptions getHandleOptions() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getHandleOptions()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_handleOptions == null) {
            this.m_handleOptions = new EditHandleOptions(this);
        }
        return this.m_handleOptions;
    }

    public void setHandleOptions(EditHandleOptions value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getHandleOptions()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalMappingResource.loadString("EditHandleOptions value", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        Enum[] enumArray = Enum.getEnums(EditHandleType.class);
        for (int i = 0; i < enumArray.length; ++i) {
            EditHandleType editHandleType = (EditHandleType)enumArray[i];
            int n = InternalEnum.getUGCValue(editHandleType);
            MapControlNative.jni_SetEditHandleType(this.m_handle, n, value.get(editHandleType));
        }
    }

    public GeoStyle getTrackingStyle() {
        long l;
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getTrackingStyle()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_trackingStyle == null && (l = MapControlNative.jni_GetTrackingStyle(this.m_handle)) != 0L) {
            this.m_trackingStyle = InternalMappingGeoStyle.createInstance(l);
        }
        return this.m_trackingStyle;
    }

    public void setTrackingStyle(GeoStyle value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getTrackingStyle(GeoStyle  value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalMappingResource.loadString("GeoStyle value", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("style", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapControlNative.jni_SetTrackingStyle(this.m_handle, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public GeoStyle getAssistantLineStyle() {
        long l;
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getAssistantLineStyle()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_assistantLineStyle == null && (l = MapControlNative.jni_GetAssistantLineStyle(this.m_handle)) != 0L) {
            this.m_assistantLineStyle = InternalMappingGeoStyle.createInstance(l);
        }
        return this.m_assistantLineStyle;
    }

    public void setAssistantLineStyle(GeoStyle value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setAssistantLineStyle(GeoStyle  value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalMappingResource.loadString("GeoStyle value", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("style", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapControlNative.jni_SetAssistantLineStyle(this.m_handle, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public void aboutBox() {
        AboutBox aboutBox = new AboutBox();
        aboutBox.setVisible(true);
    }

    public boolean copy() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("copy()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_Copy(this.m_handle);
    }

    public boolean cut() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("cut()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_Cut(this.m_handle);
    }

    public boolean delete() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("delete()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_OnDelete(this.m_handle);
    }

    public boolean canDelete() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("canDelete()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_CanDelete(this.m_handle);
    }

    public boolean paste() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("paste()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_Paste(this.m_handle);
    }

    public boolean redo() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("redo()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("undo()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_Redo(this.m_handle, l);
    }

    public boolean undo() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("undo()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("undo()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapControlNative.jni_Undo(this.m_handle, l);
    }

    public void doMouseDown(MouseEvent e) {
        if (this.m_isOtherThreadDraw && this.m_drawThreadRunning) {
            this.waitDrawThreadDown();
            this.m_pauseThreadRunning = true;
        }
        this.requestFocusInWindow();
        this.m_beforeAction = this.getAction();
        if (e.getButton() == 1 && this.getAction().equals((Object)Action.CREATETEXT)) {
            long l;
            if (this.m_handle != 0L && this.m_bufferImage != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage)) != 0L) {
                GeoText geoText = new GeoText();
                geoText.getTextStyle().setSizeFixed(false);
                geoText.getTextStyle().setFontName("");
                Point2D point2D = this.getMap().pixelToMap(e.getPoint());
                geoText.addPart(new TextPart("", point2D));
                TrackedEvent trackedEvent = new TrackedEvent(this, (Geometry)geoText, this.m_lastLength, this.m_lastAngle, this.m_lastAzimuth, this.m_lastArea);
                this.fireTracked(trackedEvent);
                if (!geoText.getText().equals("")) {
                    String string = geoText.getPart(0).getText();
                    GeoText geoText2 = new GeoText();
                    geoText2.setTextStyle(geoText.getTextStyle());
                    geoText2.addPart(new TextPart(string, point2D));
                    MapControlNative.jni_AddText(this.m_handle, l, InternalHandle.getHandle((com.supermap.data.InternalHandle)geoText2));
                    geoText2.dispose();
                }
            }
        } else if (e.getButton() == 2) {
            long l;
            this.setAction(Action.PAN);
            int n = this.getMouseFlag(e);
            if (this.m_handle != 0L && this.m_bufferImage != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage)) != 0L) {
                MapControlNative.jni_mousePressed(this.m_handle, l, 1, n, e.getX(), e.getY());
                if (this.getAction().equals((Object)Action.PAN) && e.getButton() == 2) {
                    this.m_bPanButtonDown = true;
                    InternalMappingMap.setCanRefreshTrackingLayer(this.m_map, false);
                } else {
                    InternalMappingMap.setCanRefreshTrackingLayer(this.m_map, true);
                }
            }
        } else {
            long l;
            int n = this.getMouseFlag(e);
            if (this.m_handle != 0L && this.m_bufferImage != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage)) != 0L) {
                Map map = this.getMap();
                if (this.getAction().equals((Object)Action.CREATE_ALONG_LINE_TEXT) && map != null && map.isDynamicProjection()) {
                    map.setDynamicProjection(false);
                    MapControlNative.jni_mousePressed(this.m_handle, l, e.getButton(), n, e.getX(), e.getY());
                    map.setDynamicProjection(true);
                } else {
                    MapControlNative.jni_mousePressed(this.m_handle, l, e.getButton(), n, e.getX(), e.getY());
                }
                if (this.getAction().equals((Object)Action.PAN) && e.getButton() == 1) {
                    this.m_bPanButtonDown = true;
                    InternalMappingMap.setCanRefreshTrackingLayer(this.m_map, false);
                } else {
                    InternalMappingMap.setCanRefreshTrackingLayer(this.m_map, true);
                }
            }
        }
        if (this.m_isOtherThreadDraw) {
            this.m_pauseThreadRunning = false;
        }
    }

    public void doMouseMove(MouseEvent e) {
        Action action = this.getAction();
        if (e.getModifiers() != 0 || action != Action.PAN && action != Action.PAN2 && action != Action.ZOOMFREE && action != Action.ZOOMFREE2 && action != Action.ZOOMIN && action != Action.ZOOMOUT && action != Action.SELECT && action != Action.SELECT2) {
            long l;
            this.setCursor(false);
            int n = this.getMouseFlag(e);
            if (this.m_handle != 0L && this.m_bufferImage != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage)) != 0L) {
                MapControlNative.jni_mouseMoved(this.m_handle, l, n, e.getX(), e.getY());
                if (this.m_bPanButtonDown) {
                    InternalMappingMap.setCanRefreshTrackingLayer(this.m_map, false);
                }
            }
            this.setCursor(false);
            this.repaint();
        }
    }

    public void doMouseUp(MouseEvent e) {
        if (this.m_handle != 0L && this.m_bufferImage != null) {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage);
            if (l != 0L) {
                if (this.m_isOtherThreadDraw && this.m_drawThreadRunning) {
                    this.waitDrawThreadDown();
                    this.m_pauseThreadRunning = true;
                }
                this.m_bPanButtonDown = false;
                if (e.getButton() == 3) {
                    long l2;
                    if (this.getAction().equals((Object)Action.CREATE_ALONG_LINE_TEXT) && (l2 = MapControlNative.jni_getTrackGeometry(this.m_handle)) != 0L) {
                        Geometry geometry = InternalMappingGeometry.createInstance2(l2);
                        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, false);
                        GeoText geoText = new GeoText();
                        geoText.getTextStyle().setSizeFixed(false);
                        geoText.getTextStyle().setFontName("");
                        Point2D point2D = this.getMap().pixelToMap(e.getPoint());
                        geoText.addPart(new TextPart("", point2D));
                        GeoCompound geoCompound = new GeoCompound();
                        geoCompound.addPart((Geometry)geoText);
                        geoCompound.addPart(geometry);
                        geoText.dispose();
                        TrackedEvent trackedEvent = new TrackedEvent(this, (Geometry)geoCompound, this.m_lastLength, this.m_lastAngle, this.m_lastAzimuth, this.m_lastArea);
                        this.fireTracked(trackedEvent);
                        if (!((GeoText)geoCompound.getPart(0)).getText().equals("")) {
                            GeoText geoText2 = new GeoText();
                            geoText2.setTextStyle(((GeoText)geoCompound.getPart(0)).getTextStyle());
                            geoText2.addPart(new TextPart(((GeoText)geoCompound.getPart(0)).getText(), point2D));
                            MapControlNative.jni_AddText(this.m_handle, l, InternalHandle.getHandle((com.supermap.data.InternalHandle)geoText2));
                            geoText2.dispose();
                        }
                    }
                    if (this.getAction().equals((Object)Action.VERTEXADD) || this.getAction().equals((Object)Action.VERTEXEDIT)) {
                        int n = InternalEnum.getUGCValue(this.m_trackMode);
                        MapControlNative.jni_SetAction(this.m_handle, 100, n);
                    }
                } else if (e.getButton() == 2) {
                    int n = this.getMouseFlag(e);
                    if (l != 0L) {
                        MapControlNative.jni_mouseReleased(this.m_handle, l, 1, n, e.getX(), e.getY());
                    }
                    if (this.getAction().equals((Object)Action.PAN)) {
                        InternalMappingMap.setCanRefreshTrackingLayer(this.m_map, false);
                    } else {
                        InternalMappingMap.setCanRefreshTrackingLayer(this.m_map, true);
                    }
                    this.setAction(this.m_beforeAction);
                } else {
                    int n = this.getMouseFlag(e);
                    MapControlNative.jni_mouseReleased(this.m_handle, l, e.getButton(), n, e.getX(), e.getY());
                    if (this.getAction().equals((Object)Action.PAN)) {
                        InternalMappingMap.setCanRefreshTrackingLayer(this.m_map, false);
                    } else {
                        InternalMappingMap.setCanRefreshTrackingLayer(this.m_map, true);
                    }
                }
                if (this.m_isOtherThreadDraw) {
                    this.m_pauseThreadRunning = false;
                }
            }
            if (!this.getAction().equals((Object)this.m_beforeAction)) {
                ActionChangedEvent actionChangedEvent = new ActionChangedEvent(this, this.m_beforeAction, this.getAction());
                this.fireActionChanged(actionChangedEvent);
            }
            this.repaint();
        }
    }

    public void doMouseWheel(MouseWheelEvent e) {
        if (this.m_handle != 0L && this.m_bufferImage != null && !this.m_bPanButtonDown) {
            if (this.m_isOtherThreadDraw && this.m_drawThreadRunning) {
                this.waitDrawThreadDown();
                this.m_pauseThreadRunning = true;
            }
            if (!this.m_bRollingWheelWithoutDelay) {
                if (!this.this_GetZoomRefreshFlag()) {
                    this.this_StopZoomRefreshTimer();
                } else {
                    this.this_SetZoomRefreshFlag(false);
                }
                this.this_StartZoomRefreshTimer();
            } else {
                this.this_SetZoomRefreshFlag(true);
            }
            Point2D point2D = this.getMap().pixelToMap(e.getPoint());
            double d = 0.0;
            d = -e.getUnitsToScroll() > 0 ? 1.25 : 0.8;
            InternalMappingMap.setCanRefreshTrackingLayer(this.m_map, false);
            this.getMap().zoom(d);
            Point2D point2D2 = this.getMap().pixelToMap(e.getPoint());
            InternalMappingMap.panOnZoom(this.getMap(), point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
            if (this.m_isOtherThreadDraw) {
                this.m_pauseThreadRunning = false;
            }
            this.getMap().refresh();
        }
    }

    public void doKeyDown(KeyEvent e) {
        long l;
        int n = 0;
        if (e.isShiftDown()) {
            n |= 4;
        }
        if (e.isControlDown()) {
            n |= 8;
        }
        int n2 = this.getKey(e);
        if (this.m_handle != 0L && this.m_bufferImage != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage)) != 0L) {
            if (this.m_isOtherThreadDraw && this.m_drawThreadRunning) {
                MapControlNative.jni_SetDrawCancel(this.m_handle);
                if (e.getKeyCode() == 27) {
                    return;
                }
            }
            InternalMappingMap.setCanRefreshTrackingLayer(this.getMap(), false);
            if (!(e.isShiftDown() || e.isControlDown() || e.isAltDown())) {
                if (e.getKeyCode() == 90) {
                    this.setAction(Action.ZOOMIN);
                }
                if (e.getKeyCode() == 88) {
                    this.setAction(Action.ZOOMOUT);
                }
                if (e.getKeyCode() == 67) {
                    this.setAction(Action.ZOOMFREE2);
                }
                if (e.getKeyCode() == 65) {
                    this.setAction(Action.PAN);
                }
                if (e.getKeyCode() == 83) {
                    this.setAction(Action.SELECT2);
                }
            }
            if (e.getKeyCode() == 116) {
                this.getMap().refresh();
            } else if (e.getKeyCode() == 117) {
                this.getMap().viewEntire();
            } else {
                this.setCursor(false);
                MapControlNative.jni_keyPressed(this.m_handle, l, n2, 1, n);
                this.setCursor(false);
                if (e.isControlDown() && (e.getKeyCode() == 90 || e.getKeyCode() == 89)) {
                    if (this.getTrackMode() == TrackMode.TRACK) {
                        boolean bl = InternalMappingMap.getCanRefreshTrackingLayer(this.getMap());
                        InternalMappingMap.setCanRefreshTrackingLayer(this.getMap(), true);
                        this.getMap().refreshTrackingLayer();
                        InternalMappingMap.setCanRefreshTrackingLayer(this.getMap(), bl);
                    } else {
                        this.getMap().refresh();
                    }
                }
            }
        }
    }

    public boolean doGeometryCreate(Geometry geometry) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("ensureVisible(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalMappingResource.loadString("geometry", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = MapControlNative.jni_DoGeometryCreate(this.m_handle, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        return bl;
    }

    public void dispose() {
        this.clearHandle();
        if (this.m_handle != 0L) {
            MapControlNative.jni_Delete(this.m_handle);
            this.m_handle = 0L;
        }
        if (this.m_bufferImage != null) {
            this.m_bufferImage.dispose();
        }
        this.unLoadLicense();
    }

    @Override
    public void setSize(int width, int height) {
        this.resize(width, height);
    }

    @Override
    public void setSize(Dimension d) {
        this.resize(d);
    }

    @Override
    public void resize(int width, int height) {
        this.waitDrawThreadDown();
        ComponentListener componentListener = null;
        if (this.getComponentListeners().length > 0) {
            componentListener = this.getComponentListeners()[0];
            this.removeComponentListener(componentListener);
        }
        super.resize(width, height);
        if (componentListener != null) {
            this.addComponentListener(componentListener);
        }
        this.this_componentResized();
    }

    @Override
    public void resize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    protected static void onDraw(MapControl mapControl) {
        mapControl.onDraw();
    }

    protected static void refreshEx(MapControl mapControl, Rectangle2D rect) {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)mapControl.m_bufferImage);
        if (l != 0L && mapControl.m_handle != 0L) {
            mapControl.setCursor(true);
            MapControlNative.jni_RefreshEx(mapControl.m_handle, l, rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getTop());
            mapControl.repaint();
            mapControl.setCursor(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDraw() {
        try {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage);
            if (l != 0L && this.m_handle != 0L) {
                this.m_isInOnDrawMethod = true;
                boolean bl = MapControlNative.jni_OnDraw(this.m_handle, l);
                this.m_isInOnDrawMethod = false;
                if (!bl) {
                    String string = InternalMappingResource.loadString("", "NotEnoughMemory", "ui_mapping_resources");
                    throw new OutOfMemoryError(string);
                }
            }
        }
        finally {
            this.m_isInOnDrawMethod = false;
        }
    }

    void clearHandle() {
        if (this.m_isOtherThreadDraw) {
            this.m_isOtherThreadDraw = false;
            this.waitDrawThreadDown();
            this.m_drawThreadRunning = false;
            this.m_drawThreadPool.shutdown();
        }
        if (this.m_map != null) {
            InternalMappingMap.clearHandle(this.m_map);
            this.m_map = null;
        }
        this.m_workspace = null;
        if (this.m_trackingStyle != null) {
            InternalMappingGeoStyle.clearHandle(this.m_trackingStyle);
            this.m_trackingStyle = null;
        }
        if (this.m_assistantLineStyle != null) {
            InternalMappingGeoStyle.clearHandle(this.m_assistantLineStyle);
            this.m_assistantLineStyle = null;
        }
        if (this.m_assistantRegionStyle != null) {
            InternalMappingGeoStyle.clearHandle(this.m_assistantRegionStyle);
            this.m_assistantLineStyle = null;
        }
        if (this.m_snapSetting != null) {
            InternalSnapSetting.clearHandle(this.m_snapSetting);
            this.m_snapSetting = null;
        }
        if (this.m_vectorlizationSetting != null) {
            InternalHandleDisposable.setIsDisposable(this.m_vectorlizationSetting, true);
            this.m_vectorlizationSetting.dispose();
            this.m_vectorlizationSetting.clearHandle();
            this.m_vectorlizationSetting = null;
        }
    }

    void mouseMoved(MouseEvent e) {
        if (this.m_interactionMode == InteractionMode.DEFAULT || this.m_interactionMode == InteractionMode.CUSTOMKEYBOARD) {
            this.doMouseMove(e);
        }
    }

    void mouseWheel(MouseWheelEvent e) {
        if (this.m_interactionMode == InteractionMode.DEFAULT || this.m_interactionMode == InteractionMode.CUSTOMKEYBOARD) {
            this.doMouseWheel(e);
        }
    }

    void mouseDragged(MouseEvent e) {
        if (this.m_interactionMode == InteractionMode.DEFAULT || this.m_interactionMode == InteractionMode.CUSTOMKEYBOARD) {
            this.doMouseMove(e);
        }
    }

    void mousePressed(MouseEvent e) {
        if (this.m_interactionMode == InteractionMode.DEFAULT || this.m_interactionMode == InteractionMode.CUSTOMKEYBOARD) {
            this.doMouseDown(e);
        }
    }

    void mouseReleased(MouseEvent e) {
        if (this.m_interactionMode == InteractionMode.DEFAULT || this.m_interactionMode == InteractionMode.CUSTOMKEYBOARD) {
            this.doMouseUp(e);
        }
    }

    void mouseWheelMoved(MouseWheelEvent e) {
        if (this.m_interactionMode == InteractionMode.DEFAULT || this.m_interactionMode == InteractionMode.CUSTOMKEYBOARD) {
            this.doMouseWheel(e);
        }
    }

    void keyPressed(KeyEvent e) {
        if (this.m_interactionMode == InteractionMode.DEFAULT || this.m_interactionMode == InteractionMode.CUSTOMMOUSE) {
            this.doKeyDown(e);
        }
    }

    void this_componentResized(ComponentEvent e) {
        this.this_componentResized();
    }

    private boolean this_GetZoomRefreshFlag() {
        return MapControlNative.jni_GetZoomRefreshFlag(this.m_handle);
    }

    private void this_SetZoomRefreshFlag(boolean bZoomRefresh) {
        MapControlNative.jni_SetZoomRefreshFlag(this.m_handle, bZoomRefresh);
    }

    private void this_StartZoomRefreshTimer() {
        this.m_timerZoomRefresh.start();
    }

    private void this_StopZoomRefreshTimer() {
        this.m_timerZoomRefresh.stop();
    }

    private void this_StartPanMapTimer() {
        this.m_timerPanMap.start();
    }

    private void this_StopPanMapTimer() {
        this.m_timerPanMap.stop();
    }

    void this_componentResized() {
        this.waitDrawThreadDown();
        this.m_lock.lock();
        if (this.m_handle != 0L && this.m_bufferImage != null) {
            Object object;
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage);
            boolean bl = this.m_unrefreshable = this.getWidth() == 0 && this.getHeight() == 0;
            if (l != 0L && !this.m_unrefreshable) {
                object = this.m_map == null ? Color.white : this.m_map.getBackgroundStyle().getFillForeColor();
                this.m_bufferImage.resize(this.getWidth(), this.getHeight(), (Color)object);
                MapControlNative.jni_OnSize(this.m_handle, l);
            }
            object = null;
            object = this.m_map == null ? this.getMap() : this.m_map;
            InternalMappingMap.resetImageSize(object, this.getWidth(), this.getHeight());
            InternalMappingMap.setCanRefreshTrackingLayer(this.getMap(), false);
        }
        this.m_lock.unlock();
        this.m_bNeedOndraw = true;
    }

    int getMouseFlag(MouseEvent e) {
        int n = 0;
        if ((e.getModifiersEx() & 0x80) == 128) {
            n = 8;
        }
        if ((e.getModifiersEx() & 0x40) == 64) {
            n = 4;
        }
        return n;
    }

    int getKey(KeyEvent e) {
        int n = 0;
        switch (e.getKeyCode()) {
            case 127: {
                n = 46;
                break;
            }
            case 27: {
                n = 27;
                break;
            }
            case 36: {
                n = 36;
                break;
            }
            case 35: {
                n = 35;
                break;
            }
            case 33: {
                n = 33;
                break;
            }
            case 34: {
                n = 34;
                break;
            }
            case 38: {
                n = 38;
                break;
            }
            case 40: {
                n = 40;
                break;
            }
            case 37: {
                n = 37;
                break;
            }
            case 39: {
                n = 39;
                break;
            }
            default: {
                n = e.getKeyCode();
            }
        }
        return n;
    }

    protected static void mapControlInvalidate(MapControl mapControl) {
        mapControl.m_bNeedOndraw = true;
        mapControl.repaint();
    }

    static void mapControlDrawPaint(MapControl mapControl) {
        if (mapControl.m_isInOnDrawMethod) {
            if (mapControl.m_isOtherThreadDraw && mapControl.m_drawThreadRunning) {
                mapControl.repaint();
            } else {
                Graphics graphics = mapControl.getGraphics();
                if (graphics != null) {
                    graphics.drawImage(mapControl.m_bufferImage.getMemoryImage(), 0, 0, null);
                    graphics.dispose();
                }
            }
        }
    }

    static void mapControlStartTimer(MapControl mapControl, int nIDEvent) {
        mapControl.this_StartPanMapTimer();
    }

    static void mapControlStopTimer(MapControl mapControl, int nIDEvent) {
        mapControl.this_StopPanMapTimer();
    }

    private void makeSureNewFromJNI() {
        if (!this.isNewFlag) {
            this.m_handle = MapControlNative.jni_New(this);
            this.reset();
            this.m_bufferImage = new InternalBufferImage(this.getWidth(), this.getHeight());
            if (this.m_bufferImage.getHeight() == 0 && this.m_bufferImage.getWidth() == 0) {
                String string = InternalMappingResource.loadString("", "NotEnoughMemory", "ui_mapping_resources");
                throw new OutOfMemoryError(string);
            }
            this.isNewFlag = true;
            this.setBackground(Color.white);
            this.setSelectionMode(SelectionMode.CONTAIN_INNER_POINT);
            if (this.m_workspace != null) {
                this.getMap().setWorkspace(this.m_workspace);
            }
        }
    }

    private void reset() {
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("reset()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapControlNative.jni_Reset(this.m_handle);
    }

    protected static void clearEditToolPack(MapControl mapControl) {
        MapControlNative.jni_ClearEditToolPack(mapControl.m_handle);
    }

    @Deprecated
    public void SetActionGraphicObject(ActionGraphicObject action2D) {
        MapControlNative.jni_SetActionGraphicObject(this.m_handle, action2D.action, action2D.param1, action2D.param2, action2D.param3, action2D.param4);
    }

    public void setActionGraphicObject(ActionGraphicObject action2D) {
        Action action = this.getAction();
        ActionGraphicObject actionGraphicObject = this.getActionGraphicObject();
        MapControlNative.jni_SetActionGraphicObject(this.m_handle, action2D.action, action2D.param1, action2D.param2, action2D.param3, action2D.param4);
        Action action2 = this.getAction();
        ActionGraphicObject actionGraphicObject2 = this.getActionGraphicObject();
        if (!this.getAction().equals((Object)action) || actionGraphicObject.param1 != actionGraphicObject2.param1 || actionGraphicObject.param2 != actionGraphicObject2.param2 || !actionGraphicObject.param4.equals(actionGraphicObject2.param4)) {
            ActionChangedEvent actionChangedEvent = new ActionChangedEvent(this, action, action2);
            this.fireActionChanged(actionChangedEvent);
        }
    }

    public ActionGraphicObject getActionGraphicObject() {
        long[] lArray = new long[3];
        String string = MapControlNative.jni_GetActionGraphicObject(this.m_handle, lArray);
        return new ActionGraphicObject(this.getTrackMode().value(), lArray[0], lArray[1], lArray[2], string);
    }

    private void jbInit() throws Exception {
        this.jbInit(false);
    }

    private void jbInit(boolean asynchronousMode) throws Exception {
        this.m_lock = new ReentrantLock();
        this.setLayout(this.bolderLayout);
        this.setSize(256, 256);
        this.addComponentListener(new MapControl_this_componentAdapter(this));
        this.addMouseListener(new MapControl_this_mouseAdapter(this));
        this.addMouseMotionListener(new MapControl_this_mouseMotionAdapter(this));
        this.addMouseWheelListener(new MapControl_this_mouseWheelAdapter(this));
        this.addKeyListener(new MapControl_this_keyAdapter(this));
        this.setFocusable(true);
        this.m_trackMode = TrackMode.EDIT;
        this.m_interactionMode = InteractionMode.DEFAULT;
        this.m_isFirstPaint = true;
        this.m_timerZoomRefresh = new Timer(400, new MapControl_this_ZoomRefreshTimer(this));
        this.m_timerPanMap = new Timer(30, new MapControl_this_PanMapTimer(this));
        boolean bl = Environment.getElementValue((String)"MapControlAsynchronousMode").equalsIgnoreCase("true");
        if (!asynchronousMode) {
            bl = false;
        }
        this.m_drawThreadRunning = bl;
        this.m_isOtherThreadDraw = bl;
        if (this.m_isOtherThreadDraw) {
            this.m_drawThreadPool = Executors.newSingleThreadExecutor();
            this.m_drawThreadPool.execute(this);
        }
    }

    public boolean getRollingWheelWithoutDelay() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_bRollingWheelWithoutDelay;
    }

    public void setRollingWheelWithoutDelay(boolean value) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setMarginPanPercent(double value)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_bRollingWheelWithoutDelay = value;
    }

    public boolean isCursorCustomized() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_cursorCustomized;
    }

    public void setCursorCustomized(boolean cursorCustomized) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_cursorCustomized = cursorCustomized;
    }

    public boolean isWaitCursorEnabled() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_waitCursorEnabled;
    }

    public void setWaitCursorEnabled(boolean waitCursorEnabled) {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_waitCursorEnabled = waitCursorEnabled;
    }

    public EditHistory getEditHistory() {
        this.makeSureNewFromJNI();
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_editHistory == null) {
            long l = MapControlNative.jni_GetEditHistory(this.m_handle);
            this.m_editHistory = InternalEditHistory.createInstance(l);
        }
        return this.m_editHistory;
    }

    private Cursor getDefaultCursor() {
        int n = MapControlNative.jni_GetCursorShape(this.m_handle);
        Cursor cursor = null;
        switch (n) {
            case 1: {
                cursor = Cursors.getBusy();
                break;
            }
            case 2: {
                cursor = Cursors.getArrow();
                break;
            }
            case 3: {
                cursor = Cursors.getMarginPanLeft();
                break;
            }
            case 4: {
                cursor = Cursors.getMarginPanRight();
                break;
            }
            case 5: {
                cursor = Cursors.getMarginPanTop();
                break;
            }
            case 6: {
                cursor = Cursors.getMarginPanBottom();
                break;
            }
            case 7: {
                cursor = Cursors.getMarginPanTopLeft();
                break;
            }
            case 8: {
                cursor = Cursors.getMarginPanTopRight();
                break;
            }
            case 9: {
                cursor = Cursors.getMarginPanBottomRight();
                break;
            }
            case 10: {
                cursor = Cursors.getMarginPanBottomLeft();
                break;
            }
            case 11: {
                cursor = Cursors.getZoomFree();
                break;
            }
            case 12: {
                cursor = Cursors.getZoomFree2();
                break;
            }
            case 13: {
                cursor = Cursors.getPan();
                break;
            }
            case 14: {
                cursor = Cursors.getPan2();
                break;
            }
            case 15: {
                cursor = Cursors.getZoomIn();
                break;
            }
            case 16: {
                cursor = Cursors.getZoomOut();
                break;
            }
            case 17: {
                cursor = Cursors.getSelect();
                break;
            }
            case 18: {
                cursor = Cursors.getSelect2();
                break;
            }
            case 19: {
                cursor = Cursors.getSelectRectangle();
                break;
            }
            case 20: {
                cursor = Cursors.getSelectCircle();
                break;
            }
            case 21: {
                cursor = Cursors.getSelectRegion();
                break;
            }
            case 22: {
                cursor = Cursors.getSelectLine();
                break;
            }
            case 23: {
                cursor = Cursors.getCreatePoint();
                break;
            }
            case 24: {
                cursor = Cursors.getCreateLine();
                break;
            }
            case 25: {
                cursor = Cursors.getCreatePolyline();
                break;
            }
            case 26: {
                cursor = Cursors.getCreateEllipseArc();
                break;
            }
            case 27: {
                cursor = Cursors.getCreateArc3P();
                break;
            }
            case 28: {
                cursor = Cursors.getCreateCurve();
                break;
            }
            case 29: {
                if (this.getAction().equals((Object)Action.CREATE_NORTHARROW)) {
                    cursor = Cursors.getCreateNorthArrow();
                    break;
                }
                if (this.getAction().equals((Object)Action.CREATE_MAPSCALE)) {
                    cursor = Cursors.getCreateMapScale();
                    break;
                }
                if (this.getAction().equals((Object)Action.CREATE_GEOLEGEND)) {
                    cursor = Cursors.getCreateGeoLegend();
                    break;
                }
                if (this.getTrackMode().equals((Object)TrackMode.EDITGEOMAP)) {
                    cursor = Cursors.getCreateMap();
                    break;
                }
                cursor = Cursors.getCreateRectangle();
                break;
            }
            case 30: {
                cursor = Cursors.getCreateRoundRectangle();
                break;
            }
            case 31: {
                cursor = Cursors.getCreateCircle();
                break;
            }
            case 32: {
                cursor = Cursors.getCreateCircle3P();
                break;
            }
            case 33: {
                cursor = Cursors.getCreateCircle2P();
                break;
            }
            case 34: {
                cursor = Cursors.getCreateEllipse();
                break;
            }
            case 35: {
                cursor = Cursors.getCreateObliqueEllipse();
                break;
            }
            case 36: {
                cursor = Cursors.getCreatePolygon();
                break;
            }
            case 37: {
                cursor = Cursors.getCreateText();
                break;
            }
            case 38: {
                cursor = Cursors.getCreateAlongLineText();
                break;
            }
            case 39: {
                cursor = Cursors.getCreateParallel();
                break;
            }
            case 40: {
                cursor = Cursors.getCross();
                break;
            }
            case 41: {
                cursor = Cursors.getRotation();
                break;
            }
            case 42: {
                cursor = Cursors.getBeam();
                break;
            }
            case 43: {
                cursor = Cursors.getMove();
                break;
            }
            case 44: {
                cursor = Cursors.getNorthSouth();
                break;
            }
            case 45: {
                cursor = Cursors.getWestEast();
                break;
            }
            case 46: {
                cursor = Cursors.getNorthwestSoutheast();
                break;
            }
            case 47: {
                cursor = Cursors.getNortheastSouthwest();
                break;
            }
            case 48: {
                cursor = Cursors.getSnapPoint();
                break;
            }
            case 49: {
                cursor = Cursors.getSnapVertex();
                break;
            }
            case 50: {
                cursor = Cursors.getSnapMidpoint();
                break;
            }
            case 51: {
                cursor = Cursors.getSnapLine();
                break;
            }
            case 52: {
                cursor = Cursors.getSnapVertical();
                break;
            }
            case 53: {
                cursor = Cursors.getSnapParallel();
                break;
            }
            case 54: {
                cursor = Cursors.getMoveRotationBase();
                break;
            }
            case 55: {
                cursor = Cursors.getCreatePie();
                break;
            }
            case 56: {
                cursor = Cursors.getCreateParallelogram();
                break;
            }
            case 59: {
                cursor = Cursors.getCreateBSpline();
                break;
            }
            case 60: {
                cursor = Cursors.getCreateCurve();
                break;
            }
            case 61: {
                cursor = Cursors.getCreateFreePolyline();
                break;
            }
            case 62: {
                cursor = Cursors.getCreateCardinal();
                break;
            }
            case 63: {
                cursor = Cursors.getCreateCardinal();
                break;
            }
            case 64: {
                cursor = Cursors.getSwipeLeft();
                break;
            }
            case 65: {
                cursor = Cursors.getSwipeTop();
                break;
            }
            case 66: {
                cursor = Cursors.getSwipeRight();
                break;
            }
            case 67: {
                cursor = Cursors.getSwipeBottom();
                break;
            }
            case 68: {
                cursor = Cursors.getSwipeHorizontal();
                break;
            }
            case 69: {
                cursor = Cursors.getSwipeVertical();
            }
        }
        return cursor;
    }

    private Cursor getCursor(int cur) {
        int n = MapControlNative.jni_GetCursorShape(this.m_handle);
        Cursor cursor = null;
        switch (n) {
            case 1: {
                cursor = Cursors.getBusy();
                break;
            }
            case 2: {
                cursor = Cursors.getArrow();
                break;
            }
            case 3: {
                cursor = Cursors.getMarginPanLeft();
                break;
            }
            case 4: {
                cursor = Cursors.getMarginPanRight();
                break;
            }
            case 5: {
                cursor = Cursors.getMarginPanTop();
                break;
            }
            case 6: {
                cursor = Cursors.getMarginPanBottom();
                break;
            }
            case 7: {
                cursor = Cursors.getMarginPanTopLeft();
                break;
            }
            case 8: {
                cursor = Cursors.getMarginPanTopRight();
                break;
            }
            case 9: {
                cursor = Cursors.getMarginPanBottomRight();
                break;
            }
            case 10: {
                cursor = Cursors.getMarginPanBottomLeft();
                break;
            }
            case 11: {
                cursor = Cursors.getZoomFree();
                break;
            }
            case 12: {
                cursor = Cursors.getZoomFree2();
                break;
            }
            case 13: {
                cursor = Cursors.getPan();
                break;
            }
            case 14: {
                cursor = Cursors.getPan2();
                break;
            }
            case 15: {
                cursor = Cursors.getZoomIn();
                break;
            }
            case 16: {
                cursor = Cursors.getZoomOut();
                break;
            }
            case 17: {
                cursor = Cursors.getSelect();
                break;
            }
            case 18: {
                cursor = Cursors.getSelect();
                break;
            }
            case 19: {
                cursor = Cursors.getSelect2();
                break;
            }
            case 20: {
                cursor = Cursors.getSelectCircle();
                break;
            }
            case 21: {
                cursor = Cursors.getSelectRegion();
                break;
            }
            case 22: {
                cursor = Cursors.getCreatePolyline();
                break;
            }
            case 23: {
                cursor = Cursors.getCreatePoint();
                break;
            }
            case 24: {
                cursor = Cursors.getCreateLine();
                break;
            }
            case 25: {
                cursor = Cursors.getCreatePolyline();
                break;
            }
            case 26: {
                cursor = Cursors.getCreateEllipseArc();
                break;
            }
            case 27: {
                cursor = Cursors.getCreateArc3P();
                break;
            }
            case 28: {
                cursor = Cursors.getCreateCurve();
                break;
            }
            case 29: {
                cursor = Cursors.getCreateRectangle();
                break;
            }
            case 30: {
                cursor = Cursors.getCreateRoundRectangle();
                break;
            }
            case 31: {
                cursor = Cursors.getCreateCircle();
                break;
            }
            case 32: {
                cursor = Cursors.getCreateCircle3P();
                break;
            }
            case 33: {
                cursor = Cursors.getCreateCircle2P();
                break;
            }
            case 34: {
                cursor = Cursors.getCreateEllipse();
                break;
            }
            case 35: {
                cursor = Cursors.getCreateObliqueEllipse();
                break;
            }
            case 36: {
                cursor = Cursors.getCreatePolygon();
                break;
            }
            case 37: {
                cursor = Cursors.getCreateText();
                break;
            }
            case 38: {
                cursor = Cursors.getCreateAlongLineText();
                break;
            }
            case 39: {
                cursor = Cursors.getCreateParallel();
                break;
            }
            case 40: {
                cursor = Cursors.getCross();
                break;
            }
            case 41: {
                cursor = Cursors.getRotation();
                break;
            }
            case 42: {
                cursor = Cursors.getBeam();
                break;
            }
            case 43: {
                cursor = Cursors.getMove();
                break;
            }
            case 44: {
                cursor = Cursors.getNorthSouth();
                break;
            }
            case 45: {
                cursor = Cursors.getWestEast();
                break;
            }
            case 46: {
                cursor = Cursors.getNorthwestSoutheast();
                break;
            }
            case 47: {
                cursor = Cursors.getNortheastSouthwest();
                break;
            }
            case 48: {
                cursor = Cursors.getSnapPoint();
                break;
            }
            case 49: {
                cursor = Cursors.getSnapVertex();
                break;
            }
            case 50: {
                cursor = Cursors.getSnapMidpoint();
                break;
            }
            case 51: {
                cursor = Cursors.getSnapLine();
                break;
            }
            case 52: {
                cursor = Cursors.getSnapVertical();
                break;
            }
            case 53: {
                cursor = Cursors.getSnapParallel();
                break;
            }
            case 54: {
                cursor = Cursors.getMoveRotationBase();
                break;
            }
            case 55: {
                cursor = Cursors.getCreatePie();
                break;
            }
            case 56: {
                cursor = Cursors.getCreateParallelogram();
                break;
            }
            case 57: {
                cursor = Cursors.getSelectRectangle();
                break;
            }
            case 58: {
                cursor = Cursors.getSelectRectangle();
            }
        }
        return cursor;
    }

    private void setCursor(boolean wait) {
        this.setCursor(wait, false);
    }

    private void setCursor(boolean wait, boolean useCurrent) {
        if (this.m_handle == 0L) {
            return;
        }
        if (this.m_cursorCustomized) {
            return;
        }
        if (wait && !this.m_waitCursorEnabled) {
            return;
        }
        Cursor cursor = this.getCursor();
        if (!cursor.equals(Cursors.getBusy())) {
            this.m_currentCursor = cursor;
            useCurrent = false;
        }
        if (this.m_currentCursor != null) {
            Cursor cursor2 = wait ? Cursors.getBusy() : (useCurrent ? this.m_currentCursor : this.getDefaultCursor());
            this.m_followCursor = cursor2;
            if (this.m_followCursor != null && !this.m_currentCursor.equals(this.m_followCursor)) {
                ActionCursorChangingEvent actionCursorChangingEvent = new ActionCursorChangingEvent(this, this.m_currentCursor, this.m_followCursor);
                this.fireActionCursorChanging(actionCursorChangingEvent);
                this.m_followCursor = actionCursorChangingEvent.getFollowingCursor();
            }
            try {
                this.setCursor(this.m_followCursor);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public synchronized void addActionChangedListener(ActionChangedListener l) {
        if (this.m_actionChangedListeners == null) {
            this.m_actionChangedListeners = new Vector();
        }
        if (!this.m_actionChangedListeners.contains(l)) {
            this.m_actionChangedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeActionChangedListener(ActionChangedListener l) {
        if (this.m_actionChangedListeners != null && this.m_actionChangedListeners.contains(l)) {
            this.m_actionChangedListeners.remove(l);
        }
    }

    protected void fireActionChanged(ActionChangedEvent event) {
        if (this.m_actionChangedListeners != null) {
            Vector vector = this.m_actionChangedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ActionChangedListener)vector.elementAt(i)).actionChanged(event);
            }
        }
    }

    public synchronized void addGeometrySelectedListener(GeometrySelectedListener l) {
        if (this.m_geometrySelectedListeners == null) {
            this.m_geometrySelectedListeners = new Vector();
        }
        if (!this.m_geometrySelectedListeners.contains(l)) {
            this.m_geometrySelectedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeGeometrySelectedListener(GeometrySelectedListener l) {
        if (this.m_geometrySelectedListeners != null && this.m_geometrySelectedListeners.contains(l)) {
            this.m_geometrySelectedListeners.remove(l);
        }
    }

    protected void fireGeometrySelected(GeometrySelectedEvent event) {
        if (this.m_geometrySelectedListeners != null) {
            Vector vector = this.m_geometrySelectedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((GeometrySelectedListener)vector.elementAt(i)).geometrySelected(event);
            }
        }
    }

    static void geometrySelectedCallBack(MapControl mapControl, int selectedGeometryCount) {
        if (mapControl != null) {
            if (mapControl.isOtherThreadDraw() && selectedGeometryCount > 0) {
                mapControl.waitDrawThreadDown();
                mapControl.setDrawThreadRunning(false);
            }
            GeometrySelectedEvent geometrySelectedEvent = new GeometrySelectedEvent(mapControl, selectedGeometryCount);
            mapControl.fireGeometrySelected(geometrySelectedEvent);
            if (mapControl.isOtherThreadDraw() && selectedGeometryCount <= 0) {
                mapControl.setDrawThreadRunning(true);
            }
        }
    }

    public synchronized void addGeometrySelectChangedListener(GeometrySelectChangedListener l) {
        if (this.m_geometrySelectChangedListeners == null) {
            this.m_geometrySelectChangedListeners = new Vector();
        }
        if (!this.m_geometrySelectChangedListeners.contains(l)) {
            this.m_geometrySelectChangedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeGeometrySelectChangedListener(GeometrySelectChangedListener l) {
        if (this.m_geometrySelectChangedListeners != null && this.m_geometrySelectChangedListeners.contains(l)) {
            this.m_geometrySelectChangedListeners.remove(l);
        }
    }

    protected void fireGeometrySelectChanged(GeometrySelectChangedEvent event) {
        if (this.m_geometrySelectChangedListeners != null) {
            Vector vector = this.m_geometrySelectChangedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((GeometrySelectChangedListener)vector.elementAt(i)).geometrySelectChanged(event);
            }
        }
    }

    static void geometrySelectChangedCallBack(MapControl mapControl, int selectedGeometryCount) {
        if (mapControl != null) {
            if (mapControl.isOtherThreadDraw() && selectedGeometryCount > 0) {
                mapControl.waitDrawThreadDown();
                mapControl.setDrawThreadRunning(false);
            }
            GeometrySelectChangedEvent geometrySelectChangedEvent = new GeometrySelectChangedEvent(mapControl, selectedGeometryCount);
            mapControl.fireGeometrySelectChanged(geometrySelectChangedEvent);
            if (mapControl.isOtherThreadDraw() && selectedGeometryCount <= 0) {
                mapControl.setDrawThreadRunning(true);
            }
        }
    }

    public synchronized void addGeometryDeletingListener(GeometryDeletingListener l) {
        if (this.m_geometryDeletingListeners == null) {
            this.m_geometryDeletingListeners = new Vector();
        }
        if (!this.m_geometryDeletingListeners.contains(l)) {
            this.m_geometryDeletingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeGeometryDeletingListener(GeometryDeletingListener l) {
        if (this.m_geometryDeletingListeners != null && this.m_geometryDeletingListeners.contains(l)) {
            this.m_geometryDeletingListeners.remove(l);
        }
    }

    protected void fireGeometryDeleting(GeometryEvent event) {
        if (this.m_geometryDeletingListeners != null) {
            Vector vector = this.m_geometryDeletingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((GeometryDeletingListener)vector.elementAt(i)).geometryDeleting(event);
            }
        }
    }

    static void geometryDeletingCallBack(MapControl mapControl, long cancelHandle, int geometryID, long layerHandle) {
        if (mapControl != null) {
            Layer layer = mapControl.getMap().getLayers().findLayer(layerHandle);
            boolean bl = InternalToolkitMappingUI.getHandleBooleanValue(cancelHandle);
            GeometryEvent geometryEvent = new GeometryEvent(mapControl, geometryID, bl, layer);
            mapControl.fireGeometryDeleting(geometryEvent);
            InternalToolkitMappingUI.setHandleBooleanValue(cancelHandle, geometryEvent.getCancel());
        }
    }

    public synchronized void addGeometryDeletedListener(GeometryDeletedListener l) {
        if (this.m_geometryDeletedListeners == null) {
            this.m_geometryDeletedListeners = new Vector();
        }
        if (!this.m_geometryDeletedListeners.contains(l)) {
            this.m_geometryDeletedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeGeometryDeletedListener(GeometryDeletedListener l) {
        if (this.m_geometryDeletedListeners != null && this.m_geometryDeletedListeners.contains(l)) {
            this.m_geometryDeletedListeners.remove(l);
        }
    }

    protected void fireGeometryDeleted(GeometryEvent event) {
        if (this.m_geometryDeletedListeners != null) {
            Vector vector = this.m_geometryDeletedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((GeometryDeletedListener)vector.elementAt(i)).geometryDeleted(event);
            }
        }
    }

    static void geometryDeletedCallBack(MapControl mapControl, long cancelHandle, int geometryID, long layerHandle) {
        if (mapControl != null) {
            Layer layer = mapControl.getMap().getLayers().findLayer(layerHandle);
            boolean bl = InternalToolkitMappingUI.getHandleBooleanValue(cancelHandle);
            GeometryEvent geometryEvent = new GeometryEvent(mapControl, geometryID, bl, layer);
            mapControl.fireGeometryDeleted(geometryEvent);
            InternalToolkitMappingUI.setHandleBooleanValue(cancelHandle, geometryEvent.getCancel());
        }
    }

    public synchronized void addGeometryAddedListener(GeometryAddedListener l) {
        if (this.m_geometryAddedListeners == null) {
            this.m_geometryAddedListeners = new Vector();
        }
        if (!this.m_geometryAddedListeners.contains(l)) {
            this.m_geometryAddedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeGeometryAddedListener(GeometryAddedListener l) {
        if (this.m_geometryAddedListeners != null && this.m_geometryAddedListeners.contains(l)) {
            this.m_geometryAddedListeners.remove(l);
        }
    }

    protected void fireGeometryAdded(GeometryEvent event) {
        if (this.m_geometryAddedListeners != null) {
            Vector vector = this.m_geometryAddedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((GeometryAddedListener)vector.elementAt(i)).geometryAdded(event);
            }
        }
    }

    static void geometryAddedCallBack(MapControl mapControl, int id, long layerHandle) {
        if (mapControl != null) {
            Layer layer = mapControl.getMap().getLayers().findLayer(layerHandle);
            boolean bl = false;
            GeometryEvent geometryEvent = new GeometryEvent(mapControl, id, bl, layer);
            mapControl.fireGeometryAdded(geometryEvent);
        }
    }

    public synchronized void addGeometryModifyingListener(GeometryModifyingListener l) {
        if (this.m_geometryModifyingListeners == null) {
            this.m_geometryModifyingListeners = new Vector();
        }
        if (!this.m_geometryModifyingListeners.contains(l)) {
            this.m_geometryModifyingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeGeometryModifyingListener(GeometryModifyingListener l) {
        if (this.m_geometryModifyingListeners != null && this.m_geometryModifyingListeners.contains(l)) {
            this.m_geometryModifyingListeners.remove(l);
        }
    }

    protected void fireGeometryModifying(GeometryEvent event) {
        if (this.m_geometryModifyingListeners != null) {
            Vector vector = this.m_geometryModifyingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((GeometryModifyingListener)vector.elementAt(i)).geometryModifying(event);
            }
        }
    }

    static void geometryModifyingCallBack(MapControl mapControl, long cancelHandle, int geometryID, long layerHandle) {
        if (mapControl != null) {
            Layer layer = mapControl.getMap().getLayers().findLayer(layerHandle);
            boolean bl = InternalToolkitMappingUI.getHandleBooleanValue(cancelHandle);
            GeometryEvent geometryEvent = new GeometryEvent(mapControl, geometryID, bl, layer);
            mapControl.fireGeometryModifying(geometryEvent);
            InternalToolkitMappingUI.setHandleBooleanValue(cancelHandle, geometryEvent.getCancel());
        }
    }

    public synchronized void addGeometryModifiedListener(GeometryModifiedListener l) {
        if (this.m_geometryModifiedListeners == null) {
            this.m_geometryModifiedListeners = new Vector();
        }
        if (!this.m_geometryModifiedListeners.contains(l)) {
            this.m_geometryModifiedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeGeometryModifiedListener(GeometryModifiedListener l) {
        if (this.m_geometryModifiedListeners != null && this.m_geometryModifiedListeners.contains(l)) {
            this.m_geometryModifiedListeners.remove(l);
        }
    }

    protected void fireGeometryModified(GeometryEvent event) {
        if (this.m_geometryModifiedListeners != null) {
            Vector vector = this.m_geometryModifiedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((GeometryModifiedListener)vector.elementAt(i)).geometryModified(event);
            }
        }
    }

    static void geometryModifiedCallBack(MapControl mapControl, int geometryID, long layerHandle) {
        if (mapControl != null) {
            Layer layer = mapControl.getMap().getLayers().findLayer(layerHandle);
            boolean bl = false;
            GeometryEvent geometryEvent = new GeometryEvent(mapControl, geometryID, bl, layer);
            mapControl.fireGeometryModified(geometryEvent);
        }
    }

    public synchronized void addPointInputedListener(PointInputedListener l) {
        if (this.m_pointInputedListeners == null) {
            this.m_pointInputedListeners = new Vector();
        }
        if (!this.m_pointInputedListeners.contains(l)) {
            this.m_pointInputedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removePointInputedListener(PointInputedListener l) {
        if (this.m_pointInputedListeners != null && this.m_pointInputedListeners.contains(l)) {
            this.m_pointInputedListeners.remove(l);
        }
    }

    protected void firePointInputed(PointInputedEvent event) {
        if (this.m_pointInputedListeners != null) {
            Vector vector = this.m_pointInputedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((PointInputedListener)vector.elementAt(i)).pointInputed(event);
            }
        }
    }

    static void pointInputedCallBack(MapControl mapControl, long xHandle, long yHandle, long zHandle) {
        if (mapControl != null) {
            double d = InternalToolkitMappingUI.getHandleDoubleValue(xHandle);
            double d2 = InternalToolkitMappingUI.getHandleDoubleValue(yHandle);
            double d3 = InternalToolkitMappingUI.getHandleDoubleValue(zHandle);
            PointInputedEvent pointInputedEvent = new PointInputedEvent(mapControl, d, d2, d3);
            mapControl.firePointInputed(pointInputedEvent);
        }
    }

    public synchronized void addEditHandleBeginListener(EditHandleBeginListener l) {
        if (this.m_editHandleBeginListeners == null) {
            this.m_editHandleBeginListeners = new Vector();
        }
        if (!this.m_editHandleBeginListeners.contains(l)) {
            this.m_editHandleBeginListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeEditHandleBeginListener(EditHandleBeginListener l) {
        if (this.m_editHandleBeginListeners != null && this.m_editHandleBeginListeners.contains(l)) {
            this.m_editHandleBeginListeners.remove(l);
        }
    }

    protected void fireEditHandleBegin(EditHandleEvent event) {
        if (this.m_editHandleBeginListeners != null) {
            Vector vector = this.m_editHandleBeginListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((EditHandleBeginListener)vector.elementAt(i)).editHandleBegin(event);
            }
        }
    }

    Geometry[] getEditGeometries() {
        long[] lArray = MapControlNative.jni_GetEditGeometries(this.m_handle);
        Geometry[] geometryArray = new Geometry[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            geometryArray[i] = InternalMappingGeometry.createInstance2(lArray[i]);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometryArray[i], false);
        }
        return geometryArray;
    }

    static void editHandleBeginCallBack(MapControl mapControl, int editHandleType, long cancelHandle, int[] editHandles, double x, double y) {
        if (mapControl != null) {
            EditHandleEvent editHandleEvent = null;
            EditHandleType editHandleType2 = null;
            try {
                editHandleType2 = (EditHandleType)InternalEnum.parse(EditHandleType.class, (int)editHandleType);
            }
            catch (Exception exception) {
                editHandleType2 = null;
            }
            boolean bl = InternalToolkitMappingUI.getHandleBooleanValue(cancelHandle);
            Geometry[] geometryArray = mapControl.getEditGeometries();
            if (editHandles.length > 0 && editHandles[0] != -1) {
                Geometry geometry = geometryArray[0];
                int[] nArray = InternalMappingGeometry.getSpatialData2(InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry));
                int n = -1;
                int[] nArray2 = new int[editHandles.length];
                if (editHandles[0] - 10 >= 0) {
                    int n2 = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        if (editHandles[0] - 10 >= (n2 += nArray[i])) continue;
                        n = i;
                        for (int j = 0; j < nArray2.length; ++j) {
                            nArray2[j] = editHandles[j] - 10 - (n2 - nArray[i]);
                        }
                        break;
                    }
                    editHandleEvent = new EditHandleEvent(mapControl, x, y, editHandleType2, bl, nArray2, n, geometryArray);
                } else {
                    editHandleEvent = new EditHandleEvent(mapControl, x, y, editHandleType2, bl, new int[0], -1, geometryArray);
                }
            } else {
                editHandleEvent = new EditHandleEvent(mapControl, x, y, editHandleType2, bl, new int[0], -1, geometryArray);
            }
            mapControl.fireEditHandleBegin(editHandleEvent);
            InternalToolkitMappingUI.setHandleBooleanValue(cancelHandle, editHandleEvent.getCancel());
        }
    }

    public synchronized void addEditHandleMoveListener(EditHandleMoveListener l) {
        if (this.m_editHandleMoveListeners == null) {
            this.m_editHandleMoveListeners = new Vector();
        }
        if (!this.m_editHandleMoveListeners.contains(l)) {
            this.m_editHandleMoveListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeEditHandleMoveListener(EditHandleMoveListener l) {
        if (this.m_editHandleMoveListeners != null && this.m_editHandleMoveListeners.contains(l)) {
            this.m_editHandleMoveListeners.remove(l);
        }
    }

    protected void fireEditHandleMove(EditHandleEvent event) {
        if (this.m_editHandleMoveListeners != null) {
            Vector vector = this.m_editHandleMoveListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((EditHandleMoveListener)vector.elementAt(i)).editHandleMove(event);
            }
        }
    }

    static void editHandleMoveCallBack(MapControl mapControl, int editHandleType, long cancelHandle, int[] editHandles, double x, double y) {
        if (mapControl != null) {
            EditHandleType editHandleType2 = null;
            try {
                editHandleType2 = (EditHandleType)InternalEnum.parse(EditHandleType.class, (int)editHandleType);
            }
            catch (Exception exception) {
                editHandleType2 = null;
            }
            EditHandleEvent editHandleEvent = null;
            boolean bl = InternalToolkitMappingUI.getHandleBooleanValue(cancelHandle);
            Geometry[] geometryArray = mapControl.getEditGeometries();
            if (editHandles.length > 0 && editHandles[0] != -1) {
                Geometry geometry = geometryArray[0];
                int[] nArray = InternalMappingGeometry.getSpatialData2(InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry));
                int n = -1;
                int[] nArray2 = new int[editHandles.length];
                if (editHandles[0] - 10 >= 0) {
                    int n2 = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        if (editHandles[0] - 10 >= (n2 += nArray[i])) continue;
                        n = i;
                        for (int j = 0; j < nArray2.length; ++j) {
                            nArray2[j] = editHandles[j] - 10 - (n2 - nArray[i]);
                        }
                        break;
                    }
                    editHandleEvent = new EditHandleEvent(mapControl, x, y, editHandleType2, bl, nArray2, n, geometryArray);
                } else {
                    editHandleEvent = new EditHandleEvent(mapControl, x, y, editHandleType2, bl, new int[0], -1, geometryArray);
                }
            } else {
                editHandleEvent = new EditHandleEvent(mapControl, x, y, editHandleType2, bl, new int[0], -1, geometryArray);
            }
            mapControl.fireEditHandleMove(editHandleEvent);
            InternalToolkitMappingUI.setHandleBooleanValue(cancelHandle, editHandleEvent.getCancel());
        }
    }

    public synchronized void addEditHandleFinishListener(EditHandleFinishListener l) {
        if (this.m_editHandleFinishListeners == null) {
            this.m_editHandleFinishListeners = new Vector();
        }
        if (!this.m_editHandleFinishListeners.contains(l)) {
            this.m_editHandleFinishListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeEditHandleFinishListener(EditHandleFinishListener l) {
        if (this.m_editHandleFinishListeners != null && this.m_editHandleFinishListeners.contains(l)) {
            this.m_editHandleFinishListeners.remove(l);
        }
    }

    protected void fireEditHandleFinish(EditHandleEvent event) {
        if (this.m_editHandleFinishListeners != null) {
            Vector vector = this.m_editHandleFinishListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((EditHandleFinishListener)vector.elementAt(i)).editHandleFinish(event);
            }
        }
    }

    static void editHandleFinishCallBack(MapControl mapControl, int editHandleType, int[] editHandles, double x, double y) {
        if (mapControl != null) {
            EditHandleType editHandleType2 = null;
            try {
                editHandleType2 = (EditHandleType)InternalEnum.parse(EditHandleType.class, (int)editHandleType);
            }
            catch (Exception exception) {
                editHandleType2 = null;
            }
            EditHandleEvent editHandleEvent = null;
            Geometry[] geometryArray = mapControl.getEditGeometries();
            if (editHandles.length > 0 && editHandles[0] != -1) {
                Geometry geometry = geometryArray[0];
                int[] nArray = InternalMappingGeometry.getSpatialData2(InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry));
                int n = -1;
                int[] nArray2 = new int[editHandles.length];
                if (editHandles[0] - 10 >= 0) {
                    int n2 = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        if (editHandles[0] - 10 >= (n2 += nArray[i])) continue;
                        n = i;
                        for (int j = 0; j < nArray2.length; ++j) {
                            nArray2[j] = editHandles[j] - 10 - (n2 - nArray[i]);
                        }
                        break;
                    }
                    editHandleEvent = new EditHandleEvent(mapControl, x, y, editHandleType2, false, nArray2, n, geometryArray);
                } else {
                    editHandleEvent = new EditHandleEvent(mapControl, x, y, editHandleType2, false, new int[0], -1, geometryArray);
                }
            } else {
                editHandleEvent = new EditHandleEvent(mapControl, x, y, editHandleType2, false, new int[0], -1, geometryArray);
            }
            mapControl.fireEditHandleFinish(editHandleEvent);
        }
    }

    public synchronized void addActionCursorChangingListener(ActionCursorChangingListener l) {
        if (this.m_actionCursorChangingListeners == null) {
            this.m_actionCursorChangingListeners = new Vector();
        }
        if (!this.m_actionCursorChangingListeners.contains(l)) {
            this.m_actionCursorChangingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeActionCursorChangingListener(ActionCursorChangingListener l) {
        if (this.m_actionCursorChangingListeners != null && this.m_actionCursorChangingListeners.contains(l)) {
            this.m_actionCursorChangingListeners.remove(l);
        }
    }

    protected void fireActionCursorChanging(ActionCursorChangingEvent event) {
        if (this.m_actionCursorChangingListeners != null) {
            Vector vector = this.m_actionCursorChangingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ActionCursorChangingListener)vector.elementAt(i)).actionCursorChanging(event);
            }
        }
    }

    public synchronized void addTrackingListener(TrackingListener l) {
        if (this.m_trackingListeners == null) {
            this.m_trackingListeners = new Vector();
        }
        if (!this.m_trackingListeners.contains(l)) {
            this.m_trackingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeTrackingListener(TrackingListener l) {
        if (this.m_trackingListeners != null && this.m_trackingListeners.contains(l)) {
            this.m_trackingListeners.remove(l);
        }
    }

    protected void fireTracking(TrackingEvent event) {
        this.m_lastPoint.setX(event.getX());
        this.m_lastPoint.setY(event.getY());
        this.m_lastAngle = event.getAngle();
        this.m_lastArea = event.getArea();
        this.m_lastAzimuth = event.getCurrentAzimuth();
        this.m_lastLength = event.getTotalLength();
        if (this.m_trackingListeners != null) {
            Vector vector = this.m_trackingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((TrackingListener)vector.elementAt(i)).tracking(event);
            }
        }
    }

    private double computeAzimuth(double x, double y) {
        double d = 0.0;
        if (this.m_lastPoint.getX() == -1.7976931348623157E308 && this.m_lastPoint.getY() == -1.7976931348623157E308) {
            d = this.m_lastPoint.getY() >= y ? Math.asin((this.m_lastPoint.getX() - x) / Math.sqrt((this.m_lastPoint.getX() - x) * (this.m_lastPoint.getX() - x) - (this.m_lastPoint.getY() - y) * (this.m_lastPoint.getY() - y))) / Math.PI * 180.0 - 90.0 : (this.m_lastPoint.getX() > x ? 0.0 - (Math.asin((this.m_lastPoint.getX() - x) / Math.sqrt((this.m_lastPoint.getX() - x) * (this.m_lastPoint.getX() - x) - (this.m_lastPoint.getY() - y) * (this.m_lastPoint.getY() - y))) / Math.PI * 180.0 - 90.0) + 360.0 : 270.0 - Math.asin((this.m_lastPoint.getX() - x) / Math.sqrt((this.m_lastPoint.getX() - x) * (this.m_lastPoint.getX() - x) - (this.m_lastPoint.getY() - y) * (this.m_lastPoint.getY() - y))) / Math.PI * 180.0);
        }
        return d;
    }

    static void trackingCallBack(MapControl mapControl, double x, double y, double length, double totalLength, double angle, double area, double dAzimuth) {
        if (mapControl != null) {
            Geometry geometry = null;
            long l = MapControlNative.jni_getTrackingGeometry(mapControl.m_handle);
            if (l != 0L) {
                geometry = InternalMappingGeometry.createInstance2(l);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, false);
            }
            TrackingEvent trackingEvent = new TrackingEvent(mapControl, x, y, length, angle, dAzimuth, area, totalLength, geometry);
            mapControl.fireTracking(trackingEvent);
        }
    }

    public synchronized void addTrackedListener(TrackedListener l) {
        if (this.m_trackedListeners == null) {
            this.m_trackedListeners = new Vector();
        }
        if (!this.m_trackedListeners.contains(l)) {
            this.m_trackedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeTrackedListener(TrackedListener l) {
        if (this.m_trackedListeners != null && this.m_trackedListeners.contains(l)) {
            this.m_trackedListeners.remove(l);
        }
    }

    protected void fireTracked(TrackedEvent event) {
        event.setAngle(this.m_lastAngle);
        event.setArea(this.m_lastArea);
        event.setAzimuth(this.m_lastAzimuth);
        event.setLength(this.m_lastLength);
        if (this.m_trackedListeners != null) {
            Vector vector = this.m_trackedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((TrackedListener)vector.elementAt(i)).tracked(event);
            }
        }
    }

    static void trackedCallBack(MapControl mapControl) {
        if (mapControl != null) {
            Geometry geometry = null;
            long l = MapControlNative.jni_getTrackGeometry(mapControl.m_handle);
            if (l != 0L) {
                geometry = InternalMappingGeometry.createInstance2(l);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, false);
            }
            TrackedEvent trackedEvent = new TrackedEvent(mapControl, geometry, 0.0, 0.0, 0.0, 0.0);
            if (!mapControl.getAction().equals((Object)Action.CREATE_ALONG_LINE_TEXT) && !mapControl.getAction().equals((Object)Action.CREATETEXT)) {
                mapControl.fireTracked(trackedEvent);
            }
        }
    }

    public synchronized void addRedoneListener(RedoneListener l) {
        if (this.m_redoneListeners == null) {
            this.m_redoneListeners = new Vector();
        }
        if (!this.m_redoneListeners.contains(l)) {
            this.m_redoneListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeRedoneListener(RedoneListener l) {
        if (this.m_redoneListeners != null && this.m_redoneListeners.contains(l)) {
            this.m_redoneListeners.remove(l);
        }
    }

    protected void fireRedone(EventObject event) {
        if (this.m_redoneListeners != null) {
            Vector vector = this.m_redoneListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                if (event instanceof EditHistoryEvent) {
                    if (!(vector.elementAt(i) instanceof CustomRedoListener)) continue;
                    ((CustomRedoListener)vector.elementAt(i)).redone((EditHistoryEvent)event);
                    continue;
                }
                ((RedoneListener)vector.elementAt(i)).redone(event);
            }
        }
    }

    static void redoneCallBack(MapControl mapControl, int optType, int[] ids) {
        if (mapControl != null) {
            EditType editType = (EditType)InternalEnum.parseUGCValue(EditType.class, optType);
            if (editType == EditType.CUSTOM) {
                EditHistoryEvent editHistoryEvent = new EditHistoryEvent(mapControl, editType, ids);
                mapControl.fireRedone(editHistoryEvent);
                EditHistory editHistory = mapControl.getEditHistory();
                if (editHistory != null) {
                    editHistory.customEditModify(editHistoryEvent.getModifyIDs(), false);
                }
            } else {
                EventObject eventObject = new EventObject(mapControl);
                mapControl.fireRedone(eventObject);
            }
        }
    }

    public synchronized void addUndoneListener(UndoneListener l) {
        if (this.m_undoneListeners == null) {
            this.m_undoneListeners = new Vector();
        }
        if (!this.m_undoneListeners.contains(l)) {
            this.m_undoneListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeUndoneListener(UndoneListener l) {
        if (this.m_undoneListeners != null && this.m_undoneListeners.contains(l)) {
            this.m_undoneListeners.remove(l);
        }
    }

    protected void fireUndone(EventObject event) {
        if (this.m_undoneListeners != null) {
            Vector vector = this.m_undoneListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                if (event instanceof EditHistoryEvent) {
                    if (!(vector.elementAt(i) instanceof CustomUndoListener)) continue;
                    ((CustomUndoListener)vector.elementAt(i)).undone((EditHistoryEvent)event);
                    continue;
                }
                ((UndoneListener)vector.elementAt(i)).undone(event);
            }
        }
    }

    static void undoneCallBack(MapControl mapControl, int optType, int[] ids) {
        if (mapControl != null) {
            EditType editType = (EditType)InternalEnum.parseUGCValue(EditType.class, optType);
            if (editType == EditType.CUSTOM) {
                EditHistoryEvent editHistoryEvent = new EditHistoryEvent(mapControl, editType, ids);
                mapControl.fireUndone(editHistoryEvent);
                EditHistory editHistory = mapControl.getEditHistory();
                if (editHistory != null) {
                    editHistory.customEditModify(editHistoryEvent.getModifyIDs(), true);
                }
            } else {
                EventObject eventObject = new EventObject(mapControl);
                mapControl.fireUndone(eventObject);
            }
        }
    }

    public synchronized void addPaintListener(PaintListener l) {
        if (this.m_paintListeners == null) {
            this.m_paintListeners = new Vector();
        }
        if (!this.m_paintListeners.contains(l)) {
            this.m_paintListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removePaintListener(PaintListener l) {
        if (this.m_paintListeners != null && this.m_paintListeners.contains(l)) {
            this.m_paintListeners.remove(l);
        }
    }

    protected void firePaint(Graphics graphics) {
        if (this.m_paintListeners != null) {
            Vector vector = this.m_paintListeners;
            int n = vector.size();
            PaintMapControlEvent paintMapControlEvent = new PaintMapControlEvent(this, graphics);
            for (int i = n - 1; i >= 0; --i) {
                ((PaintListener)vector.elementAt(i)).paint(paintMapControlEvent);
            }
        }
    }

    public void waitDrawThreadDown() {
        this.waitDrawThreadDown(true);
    }

    public void waitDrawThreadDown(boolean setCancel) {
        if (this.m_drawThreadRunning) {
            if (setCancel) {
                this.m_bNeedOndraw = false;
                MapControlNative.jni_SetDrawCancel(this.m_handle);
            }
            while (this.m_isInOnDrawMethod) {
                Thread.yield();
            }
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("MapControlDrawing");
        while (this.m_isOtherThreadDraw) {
            if (this.m_drawThreadRunning && this.m_bufferImage != null && this.m_bNeedOndraw && !this.m_isFirstPaint && !this.m_pauseThreadRunning) {
                if (this.m_handle == 0L) break;
                this.setCursor(true);
                this.m_bNeedOndraw = false;
                if (this.m_unrefreshable) {
                    MapControlNative.jni_MapSetRefreshFlag(this.m_handle, false);
                    this.m_unrefreshable = false;
                }
                this.onDraw();
                this.setCursor(false, true);
                this.m_hasDrawn = true;
                this.repaint();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.getParent() != null && this.m_isFirstPaint && this.m_bufferImage != null) {
            this.m_isFirstPaint = false;
            this.repaint();
            return;
        }
        if (this.m_handle != 0L) {
            if (this.m_isOtherThreadDraw && this.m_drawThreadRunning) {
                if (this.m_bufferImage != null) {
                    g.drawImage(this.m_bufferImage.getMemoryImage(), 0, 0, null);
                }
            } else {
                if (this.m_bNeedOndraw) {
                    this.setCursor(true);
                    this.m_bNeedOndraw = false;
                    if (this.m_unrefreshable) {
                        MapControlNative.jni_MapSetRefreshFlag(this.m_handle, false);
                        this.m_unrefreshable = false;
                    }
                    this.onDraw();
                    this.setCursor(false);
                    this.m_hasDrawn = true;
                }
                if (this.m_hasDrawn && this.m_bufferImage != null) {
                    g.drawImage(this.m_bufferImage.getMemoryImage(), 0, 0, null);
                }
            }
        } else {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.firePaint(g);
    }

    public void setDefaultEditGeoStyle(GeoStyle style) {
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setDefaultEditGeoStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (style == null) {
            String string = InternalMappingResource.loadString("style", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("GeoStyle style", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapControlNative.jni_SetDefaultEditGeoStyle(this.m_handle, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
    }

    public GeoStyle getDefaultEditGeoStyle() {
        long l;
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getDefaultEditGeoStyle()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_defaultEditStyle == null && (l = MapControlNative.jni_GetDefaultEditGeoStyle(this.m_handle)) != 0L) {
            this.m_defaultEditStyle = InternalMappingGeoStyle.createInstance(l);
        }
        return this.m_defaultEditStyle;
    }

    public void setTrackingZoomAndSelectStyle(GeoStyle style) {
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("setTrackingZoomAndSelectStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (style == null) {
            String string = InternalMappingResource.loadString("style", "Global_ArgumentNull", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalMappingResource.loadString("GeoStyle style", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapControlNative.jni_SetTrackingZoomAndSelectStyle(this.m_handle, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
    }

    public GeoStyle getTrackingZoomAndSelectStyle() {
        long l;
        if (this.m_handle == 0L) {
            String string = InternalMappingResource.loadString("getTrackingZoomAndSelectStyle()", "Handle_ObjectHasBeenDisposed", "ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_trackingZoomAndSelectStyle == null && (l = MapControlNative.jni_GetTrackingZoomAndSelectStyle(this.m_handle)) != 0L) {
            this.m_trackingZoomAndSelectStyle = InternalMappingGeoStyle.createInstance(l);
        }
        return this.m_trackingZoomAndSelectStyle;
    }

    protected void cancelDrawing(boolean isWait) {
        MapControlNative.jni_SetDrawCancel(this.m_handle);
        while (isWait && this.m_isInOnDrawMethod) {
            Thread.yield();
        }
    }

    protected static long getHandle(MapControl mapControl) {
        return mapControl.m_handle;
    }

    public long gethandle() {
        return this.m_handle;
    }

    protected static boolean isPanButtonDown(MapControl mapControl) {
        return mapControl.m_bPanButtonDown;
    }

    static {
        InternalEnvironment.LoadWrapJ();
    }

    class MapControl_this_PanMapTimer
    implements ActionListener {
        private MapControl adaptee;

        MapControl_this_PanMapTimer(MapControl adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.adaptee != null && this.adaptee.m_map != null) {
                this.adaptee.m_map.refresh();
                Graphics graphics = this.adaptee.getGraphics();
                if (graphics != null) {
                    graphics.drawImage(this.adaptee.m_bufferImage.getMemoryImage(), 0, 0, null);
                    graphics.dispose();
                }
            }
        }
    }

    class MapControl_this_ZoomRefreshTimer
    implements ActionListener {
        private MapControl adaptee;

        MapControl_this_ZoomRefreshTimer(MapControl adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.adaptee.this_GetZoomRefreshFlag()) {
                this.adaptee.this_StopZoomRefreshTimer();
                this.adaptee.this_SetZoomRefreshFlag(true);
                this.adaptee.getMap().refresh();
            }
        }
    }

    public static class Cursors {
        private static Cursor m_busy = null;
        private static Cursor m_arrow = null;
        private static Cursor m_marginPanLeft = null;
        private static Cursor m_marginPanRight = null;
        private static Cursor m_marginPanTop = null;
        private static Cursor m_marginPanBottom = null;
        private static Cursor m_marginPanTopLeft = null;
        private static Cursor m_marginPanTopRight = null;
        private static Cursor m_marginPanBottomRightt = null;
        private static Cursor m_marginPanBottomLeft = null;
        private static Cursor m_zoomFree = null;
        private static Cursor m_pan2 = null;
        private static Cursor m_zoomFree2 = null;
        private static Cursor m_select = null;
        private static Cursor m_pan = null;
        private static Cursor m_zoonOut = null;
        private static Cursor m_zoonIn = null;
        private static Cursor m_selectRegion = null;
        private static Cursor m_selectLine = null;
        private static Cursor m_select2 = null;
        private static Cursor m_line = null;
        private static Cursor m_point = null;
        private static Cursor m_selectCircle = null;
        private static Cursor m_polyline = null;
        private static Cursor m_circle = null;
        private static Cursor m_polygon = null;
        private static Cursor m_text = null;
        private static Cursor m_alongLineText = null;
        private static Cursor m_parallel = null;
        private static Cursor m_pie = null;
        private static Cursor m_parallelogram = null;
        private static Cursor m_cross = null;
        private static Cursor m_rotation = null;
        private static Cursor m_roundRectangle = null;
        private static Cursor m_circle2P = null;
        private static Cursor m_circle3P = null;
        private static Cursor m_ellipse = null;
        private static Cursor m_ellipseArc = null;
        private static Cursor m_arc3P = null;
        private static Cursor m_curve = null;
        private static Cursor m_rectangle = null;
        private static Cursor m_beam = null;
        private static Cursor m_move = null;
        private static Cursor m_northSouth = null;
        private static Cursor m_westEast = null;
        private static Cursor m_northeastSouthwest = null;
        private static Cursor m_northwestSoutheast = null;
        private static Cursor m_snapPoint = null;
        private static Cursor m_snapVertex = null;
        private static Cursor m_snapMidpoint = null;
        private static Cursor m_snapLine = null;
        private static Cursor m_obliqueEllipse = null;
        private static Cursor m_snapVertical = null;
        private static Cursor m_snapParallel = null;
        private static Cursor m_moveRotationBase = null;
        private static Cursor m_rectangleSelect = null;
        private static Cursor m_createNorthArrow = null;
        private static Cursor m_createMapScale = null;
        private static Cursor m_createGeoLegend = null;
        private static Cursor m_createBSpline;
        private static Cursor m_createFreePolyline;
        private static Cursor m_createCardinal;
        private static Cursor m_createMap;
        private static Cursor m_swipeLeft;
        private static Cursor m_swipeTop;
        private static Cursor m_swipeRight;
        private static Cursor m_swipeBottom;
        private static Cursor m_swipeHorizontal;
        private static Cursor m_swipeVertical;
        private static String imagePath;

        private Cursors() {
        }

        private static Cursor setCursorFromFile(String fileName) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Cursor cursor = null;
            URL uRL = Cursors.class.getResource("/com/supermap/ui/MapControl.class");
            String string = uRL.getFile();
            int n = string.indexOf("com/supermap/ui/MapControl.class");
            string = string.substring(0, n);
            Image image = null;
            String string2 = string + "Mapping/Resources/" + fileName;
            File file = new File(string2);
            if (file.exists()) {
                image = toolkit.createImage(string2);
            } else {
                uRL = Cursors.class.getResource("/com/supermap/ui/image/mappingImage/" + fileName);
                if (uRL != null) {
                    image = toolkit.createImage(uRL);
                }
            }
            if (image != null) {
                cursor = toolkit.createCustomCursor(image, new Point(7, 7), "");
            }
            return cursor;
        }

        private static Cursor setCursorFromFile(String fileName, int x, int y) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Cursor cursor = null;
            URL uRL = Cursors.class.getResource("/com/supermap/ui/MapControl.class");
            String string = uRL.getFile();
            int n = string.indexOf("com/supermap/ui/MapControl.class");
            string = string.substring(0, n);
            Image image = null;
            String string2 = string + "Mapping/Resources/" + fileName;
            File file = new File(string2);
            if (file.exists()) {
                image = toolkit.createImage(string2);
            } else {
                uRL = Cursors.class.getResource("/com/supermap/ui/image/mappingImage/" + fileName);
                if (uRL != null) {
                    image = toolkit.createImage(uRL);
                }
            }
            if (image != null) {
                cursor = toolkit.createCustomCursor(image, new Point(x, y), "");
            }
            return cursor;
        }

        public static Cursor getBusy() {
            if (m_busy == null) {
                m_busy = Cursors.setCursorFromFile(imagePath + "busy.gif");
            }
            return m_busy;
        }

        public static void setBusy(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_busy = cursor;
        }

        public static Cursor getArrow() {
            if (m_arrow == null) {
                m_arrow = Cursors.setCursorFromFile(imagePath + "null.gif", 0, 0);
            }
            return m_arrow;
        }

        public static void setArrow(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_arrow = cursor;
        }

        public static Cursor getMarginPanLeft() {
            if (m_marginPanLeft == null) {
                m_marginPanLeft = Cursors.setCursorFromFile(imagePath + "marginPanLeft.gif", 0, 15);
            }
            return m_marginPanLeft;
        }

        public static void setMarginPanLeft(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_marginPanLeft = cursor;
        }

        public static Cursor getMarginPanRight() {
            if (m_marginPanRight == null) {
                m_marginPanRight = Cursors.setCursorFromFile(imagePath + "marginPanRight.gif", 30, 10);
            }
            return m_marginPanRight;
        }

        public static void setMarginPanRight(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_marginPanRight = cursor;
        }

        public static Cursor getMarginPanTop() {
            if (m_marginPanTop == null) {
                m_marginPanTop = Cursors.setCursorFromFile(imagePath + "marginPanTop.gif", 10, 0);
            }
            return m_marginPanTop;
        }

        public static void setMarginPanTop(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_marginPanTop = cursor;
        }

        public static Cursor getMarginPanBottom() {
            if (m_marginPanBottom == null) {
                m_marginPanBottom = Cursors.setCursorFromFile(imagePath + "marginPanBottom.gif", 10, 30);
            }
            return m_marginPanBottom;
        }

        public static void setMarginPanBottom(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_marginPanBottom = cursor;
        }

        public static Cursor getMarginPanTopLeft() {
            if (m_marginPanTopLeft == null) {
                m_marginPanTopLeft = Cursors.setCursorFromFile(imagePath + "marginPanTopLeft.gif");
            }
            return m_marginPanTopLeft;
        }

        public static void setMarginPanTopLeft(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_marginPanTopLeft = cursor;
        }

        public static Cursor getMarginPanTopRight() {
            if (m_marginPanTopRight == null) {
                m_marginPanTopRight = Cursors.setCursorFromFile(imagePath + "marginPanTopRight.gif", 30, 0);
            }
            return m_marginPanTopRight;
        }

        public static void setMarginPanTopRight(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_marginPanTopRight = cursor;
        }

        public static Cursor getMarginPanBottomRight() {
            if (m_marginPanBottomRightt == null) {
                m_marginPanBottomRightt = Cursors.setCursorFromFile(imagePath + "marginPanBottomRight.gif", 30, 30);
            }
            return m_marginPanBottomRightt;
        }

        public static Cursor getMarginPanBottomLeft() {
            if (m_marginPanBottomLeft == null) {
                m_marginPanBottomLeft = Cursors.setCursorFromFile(imagePath + "marginPanBottomLeft.gif", 0, 30);
            }
            return m_marginPanBottomLeft;
        }

        public static void setMarginPanBottomLeft(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_marginPanBottomLeft = cursor;
        }

        public static Cursor getZoomFree() {
            if (m_zoomFree == null) {
                m_zoomFree = Cursors.setCursorFromFile(imagePath + "zoomfree.gif");
            }
            return m_zoomFree;
        }

        public static void setZoomFree(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_zoomFree = cursor;
        }

        public static Cursor getZoomFree2() {
            if (m_zoomFree2 == null) {
                m_zoomFree2 = Cursors.setCursorFromFile(imagePath + "zoomfree.gif");
            }
            return m_zoomFree2;
        }

        public static void setZoomFree2(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_zoomFree2 = cursor;
        }

        public static Cursor getPan() {
            if (m_pan == null) {
                m_pan = Cursors.setCursorFromFile(imagePath + "pan.gif");
            }
            return m_pan;
        }

        public static void setPan(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_pan = cursor;
        }

        public static Cursor getPan2() {
            if (m_pan2 == null) {
                m_pan2 = Cursors.setCursorFromFile(imagePath + "pan.gif");
            }
            return m_pan2;
        }

        public static void setPan2(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_pan2 = cursor;
        }

        public static Cursor getZoomIn() {
            if (m_zoonIn == null) {
                m_zoonIn = Cursors.setCursorFromFile(imagePath + "zoomin.gif");
            }
            return m_zoonIn;
        }

        public static void setZoomIn(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_zoonIn = cursor;
        }

        public static Cursor getZoomOut() {
            if (m_zoonOut == null) {
                m_zoonOut = Cursors.setCursorFromFile(imagePath + "zoomout.gif");
            }
            return m_zoonOut;
        }

        public static void setZoomOut(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_zoonOut = cursor;
        }

        public static Cursor getSelect() {
            if (m_select == null) {
                m_select = Cursors.setCursorFromFile(imagePath + "select.gif", 4, 5);
            }
            return m_select;
        }

        public static void setSelect(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_select = cursor;
        }

        public static Cursor getSelect2() {
            if (m_select2 == null) {
                m_select2 = Cursors.setCursorFromFile(imagePath + "select.gif", 4, 5);
            }
            return m_select2;
        }

        public static void setSelect2(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_select2 = cursor;
        }

        public static Cursor getSelectCircle() {
            if (m_selectCircle == null) {
                m_selectCircle = Cursors.setCursorFromFile(imagePath + "selectCircle.gif", 0, 0);
            }
            return m_selectCircle;
        }

        public static void setSelectCircle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_selectCircle = cursor;
        }

        public static Cursor getSelectRegion() {
            if (m_selectRegion == null) {
                m_selectRegion = Cursors.setCursorFromFile(imagePath + "selectregion.gif", 0, 0);
            }
            return m_selectRegion;
        }

        public static void setSelectRegion(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_selectRegion = cursor;
        }

        public static Cursor getSelectLine() {
            if (m_selectLine == null) {
                m_selectLine = Cursors.setCursorFromFile(imagePath + "selectLine.gif", 0, 0);
            }
            return m_selectLine;
        }

        public static void setSelectLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_selectLine = cursor;
        }

        public static Cursor getCreatePoint() {
            if (m_point == null) {
                m_point = Cursors.setCursorFromFile(imagePath + "createPoint.gif");
            }
            return m_point;
        }

        public static void setCreatePoint(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_point = cursor;
        }

        public static Cursor getCreateLine() {
            if (m_line == null) {
                m_line = Cursors.setCursorFromFile(imagePath + "createline.gif");
            }
            return m_line;
        }

        public static void setCreateLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_line = cursor;
        }

        public static Cursor getCreatePolyline() {
            if (m_polyline == null) {
                m_polyline = Cursors.setCursorFromFile(imagePath + "createPolyLine.gif");
            }
            return m_polyline;
        }

        public static void setCreatePolyline(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_polyline = cursor;
        }

        public static Cursor getCreateEllipseArc() {
            if (m_ellipseArc == null) {
                m_ellipseArc = Cursors.setCursorFromFile(imagePath + "createEllipseArc.gif");
            }
            return m_ellipseArc;
        }

        public static void setCreateEllipseArc(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_ellipseArc = cursor;
        }

        public static Cursor getCreateArc3P() {
            if (m_arc3P == null) {
                m_arc3P = Cursors.setCursorFromFile(imagePath + "createArc3p.gif");
            }
            return m_arc3P;
        }

        public static void setCreateArc3P(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_arc3P = cursor;
        }

        public static Cursor getCreateCurve() {
            if (m_curve == null) {
                m_curve = Cursors.setCursorFromFile(imagePath + "createCurve.gif");
            }
            return m_curve;
        }

        public static void setCreateCurve(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_curve = cursor;
        }

        public static Cursor getCreateRectangle() {
            if (m_rectangle == null) {
                m_rectangle = Cursors.setCursorFromFile(imagePath + "createRectangle.gif");
            }
            return m_rectangle;
        }

        public static void setCreateRectangle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_rectangle = cursor;
        }

        public static Cursor getCreateRoundRectangle() {
            if (m_roundRectangle == null) {
                m_roundRectangle = Cursors.setCursorFromFile(imagePath + "createRoundRectangle.gif");
            }
            return m_roundRectangle;
        }

        public static void setCreateRoundRectangle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_roundRectangle = cursor;
        }

        public static Cursor getCreateCircle() {
            if (m_circle == null) {
                m_circle = Cursors.setCursorFromFile(imagePath + "createCircle.gif");
            }
            return m_circle;
        }

        public static void setCreateCircle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_circle = cursor;
        }

        public static Cursor getCreateCircle2P() {
            if (m_circle2P == null) {
                m_circle2P = Cursors.setCursorFromFile(imagePath + "createCircle2p.gif");
            }
            return m_circle2P;
        }

        public static void setCreateCircle2P(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_circle2P = cursor;
        }

        public static Cursor getCreateCircle3P() {
            if (m_circle3P == null) {
                m_circle3P = Cursors.setCursorFromFile(imagePath + "createCircle3p.gif");
            }
            return m_circle3P;
        }

        public static void setCreateCircle3P(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_circle3P = cursor;
        }

        public static Cursor getCreateEllipse() {
            if (m_ellipse == null) {
                m_ellipse = Cursors.setCursorFromFile(imagePath + "createEllipse.gif");
            }
            return m_ellipse;
        }

        public static void setCreateEllipse(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_ellipse = cursor;
        }

        public static Cursor getCreateObliqueEllipse() {
            if (m_obliqueEllipse == null) {
                m_obliqueEllipse = Cursors.setCursorFromFile(imagePath + "createObliqueEllipse.gif");
            }
            return m_obliqueEllipse;
        }

        public static void setCreateObliqueEllipse(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_obliqueEllipse = cursor;
        }

        public static Cursor getCreatePolygon() {
            if (m_polygon == null) {
                m_polygon = Cursors.setCursorFromFile(imagePath + "createPolygon.gif");
            }
            return m_polygon;
        }

        public static void setCreatePolygon(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_polygon = cursor;
        }

        public static Cursor getCreateText() {
            if (m_text == null) {
                m_text = Cursors.setCursorFromFile(imagePath + "createText.gif");
            }
            return m_text;
        }

        public static void setCreateText(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_text = cursor;
        }

        public static Cursor getCreateAlongLineText() {
            if (m_alongLineText == null) {
                m_alongLineText = Cursors.setCursorFromFile(imagePath + "createAlongLineText.gif");
            }
            return m_alongLineText;
        }

        public static void setCreateAlongLineText(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_alongLineText = cursor;
        }

        public static Cursor getCreateParallel() {
            if (m_parallel == null) {
                m_parallel = Cursors.setCursorFromFile(imagePath + "createparallel.gif");
            }
            return m_parallel;
        }

        public static void setCreateParallel(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_parallel = cursor;
        }

        public static Cursor getCreatePie() {
            if (m_pie == null) {
                m_pie = Cursors.setCursorFromFile(imagePath + "createPie.gif");
            }
            return m_pie;
        }

        public static void setCreatePie(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_pie = cursor;
        }

        public static Cursor getCreateParallelogram() {
            if (m_parallelogram == null) {
                m_parallelogram = Cursors.setCursorFromFile(imagePath + "createParallelogram.gif");
            }
            return m_parallelogram;
        }

        public static void setCreateParallelogram(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_parallelogram = cursor;
        }

        public static Cursor getCross() {
            if (m_cross == null) {
                m_cross = Cursors.setCursorFromFile(imagePath + "cross.gif");
            }
            return m_cross;
        }

        public static void setCross(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_cross = cursor;
        }

        public static Cursor getRotation() {
            if (m_rotation == null) {
                m_rotation = Cursors.setCursorFromFile(imagePath + "rotation.gif");
            }
            return m_rotation;
        }

        public static void setRotation(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_rotation = cursor;
        }

        public static Cursor getBeam() {
            if (m_beam == null) {
                m_beam = Cursors.setCursorFromFile(imagePath + "beam.gif");
            }
            return m_beam;
        }

        public static void setBeam(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_beam = cursor;
        }

        public static Cursor getMove() {
            if (m_move == null) {
                m_move = Cursors.setCursorFromFile(imagePath + "move.gif", 0, 0);
            }
            return m_move;
        }

        public static void setMove(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_move = cursor;
        }

        public static Cursor getNorthSouth() {
            if (m_northSouth == null) {
                m_northSouth = Cursors.setCursorFromFile(imagePath + "northSouth.gif");
            }
            return m_northSouth;
        }

        public static void setNorthSouth(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_northSouth = cursor;
        }

        public static Cursor getWestEast() {
            if (m_westEast == null) {
                m_westEast = Cursors.setCursorFromFile(imagePath + "weateast.gif");
            }
            return m_westEast;
        }

        public static void setWestEast(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_westEast = cursor;
        }

        public static Cursor getNortheastSouthwest() {
            if (m_northeastSouthwest == null) {
                m_northeastSouthwest = Cursors.setCursorFromFile(imagePath + "northeastSouthwest.gif");
            }
            return m_northeastSouthwest;
        }

        public static void setNortheastSouthwest(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_northeastSouthwest = cursor;
        }

        public static Cursor getNorthwestSoutheast() {
            if (m_northwestSoutheast == null) {
                m_northwestSoutheast = Cursors.setCursorFromFile(imagePath + "northwestSoutheast.gif");
            }
            return m_northwestSoutheast;
        }

        public static void setNorthwestSoutheast(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_northwestSoutheast = cursor;
        }

        public static Cursor getSnapPoint() {
            if (m_snapPoint == null) {
                m_snapPoint = Cursors.setCursorFromFile(imagePath + "snapPoint.gif");
            }
            return m_snapPoint;
        }

        public static void setSnapPoint(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_snapPoint = cursor;
        }

        public static Cursor getSnapVertex() {
            if (m_snapVertex == null) {
                m_snapVertex = Cursors.setCursorFromFile(imagePath + "snapVertex.gif");
            }
            return m_snapVertex;
        }

        public static void setSnapVertex(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_snapVertex = cursor;
        }

        public static Cursor getSnapMidpoint() {
            if (m_snapMidpoint == null) {
                m_snapMidpoint = Cursors.setCursorFromFile(imagePath + "snapMidpoint.gif");
            }
            return m_snapMidpoint;
        }

        public static void setSnapMidpoint(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_snapMidpoint = cursor;
        }

        public static Cursor getSnapLine() {
            if (m_snapLine == null) {
                m_snapLine = Cursors.setCursorFromFile(imagePath + "snapLine.gif");
            }
            return m_snapLine;
        }

        public static void setSnapLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_snapLine = cursor;
        }

        public static Cursor getSnapVertical() {
            if (m_snapVertical == null) {
                m_snapVertical = Cursors.setCursorFromFile(imagePath + "snapVertical.gif");
            }
            return m_snapVertical;
        }

        public static void setSnapVertical(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_snapVertical = cursor;
        }

        public static Cursor getSnapParallel() {
            if (m_snapParallel == null) {
                m_snapParallel = Cursors.setCursorFromFile(imagePath + "snapParallel.gif");
            }
            return m_snapParallel;
        }

        public static void setSnapParallel(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_snapParallel = cursor;
        }

        public static Cursor getMoveRotationBase() {
            if (m_moveRotationBase == null) {
                m_moveRotationBase = Cursors.setCursorFromFile(imagePath + "moveRotationBase.gif");
            }
            return m_moveRotationBase;
        }

        public static void setMoveRotationBase(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_moveRotationBase = cursor;
        }

        public static Cursor getSelectRectangle() {
            if (m_rectangleSelect == null) {
                m_rectangleSelect = Cursors.setCursorFromFile(imagePath + "selectRect.gif", 0, 0);
            }
            return m_rectangleSelect;
        }

        public static void setSelectRectangle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_rectangleSelect = cursor;
        }

        public static Cursor getCreateNorthArrow() {
            if (m_createNorthArrow == null) {
                m_createNorthArrow = Cursors.setCursorFromFile(imagePath + "createNorthArrow.gif");
            }
            return m_createNorthArrow;
        }

        public void setCreateNorthArrow(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_createNorthArrow = cursor;
        }

        public static Cursor getCreateMapScale() {
            if (m_createMapScale == null) {
                m_createMapScale = Cursors.setCursorFromFile(imagePath + "createMapScale.gif");
            }
            return m_createMapScale;
        }

        public static Cursor getCreateGeoLegend() {
            if (m_createGeoLegend == null) {
                m_createGeoLegend = Cursors.setCursorFromFile(imagePath + "createRectangle.gif");
            }
            return m_createGeoLegend;
        }

        public void setCreateGeoLegend(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_createGeoLegend = cursor;
        }

        public void setCreateMapScale(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_createMapScale = cursor;
        }

        public static Cursor getCreateBSpline() {
            if (m_createBSpline == null) {
                m_createBSpline = Cursors.setCursorFromFile(imagePath + "createBSpline.gif");
            }
            return m_createBSpline;
        }

        public void setCreateBSpline(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_createBSpline = cursor;
        }

        public static Cursor getCreateFreePolyline() {
            if (m_createFreePolyline == null) {
                m_createFreePolyline = Cursors.setCursorFromFile(imagePath + "createFreePolyline.gif");
            }
            return m_createFreePolyline;
        }

        public void setCreateFreePolyline(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_createFreePolyline = cursor;
        }

        public static Cursor getCreateCardinal() {
            if (m_createCardinal == null) {
                m_createCardinal = Cursors.setCursorFromFile(imagePath + "createCardinal.gif");
            }
            return m_createCardinal;
        }

        public void setCreateCardinal(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_createCardinal = cursor;
        }

        public static Cursor getCreateMap() {
            if (m_createMap == null) {
                m_createMap = Cursors.setCursorFromFile(imagePath + "createMap.gif");
            }
            return m_createMap;
        }

        public static Cursor getSwipeLeft() {
            if (m_swipeLeft == null) {
                m_swipeLeft = Cursors.setCursorFromFile(imagePath + "swipeLeft.gif");
            }
            return m_swipeLeft;
        }

        public void setSwipeLeft(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_swipeLeft = cursor;
        }

        public static Cursor getSwipeTop() {
            if (m_swipeTop == null) {
                m_swipeTop = Cursors.setCursorFromFile(imagePath + "swipeTop.gif");
            }
            return m_swipeTop;
        }

        public void setSwipeTop(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_swipeTop = cursor;
        }

        public static Cursor getSwipeRight() {
            if (m_swipeRight == null) {
                m_swipeRight = Cursors.setCursorFromFile(imagePath + "swipeRight.gif");
            }
            return m_swipeRight;
        }

        public void setSwipeRight(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_swipeRight = cursor;
        }

        public static Cursor getSwipeBottom() {
            if (m_swipeBottom == null) {
                m_swipeBottom = Cursors.setCursorFromFile(imagePath + "swipeBottom.gif");
            }
            return m_swipeBottom;
        }

        public void setSwipeBottom(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_swipeBottom = cursor;
        }

        public static Cursor getSwipeHorizontal() {
            if (m_swipeHorizontal == null) {
                m_swipeHorizontal = Cursors.setCursorFromFile(imagePath + "swipeHorizontal.gif");
            }
            return m_swipeHorizontal;
        }

        public void setSwipeHorizontal(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_swipeHorizontal = cursor;
        }

        public static Cursor getSwipeVertical() {
            if (m_swipeVertical == null) {
                m_swipeVertical = Cursors.setCursorFromFile(imagePath + "swipeVertical.gif");
            }
            return m_swipeVertical;
        }

        public void setSwipeVertical(Cursor cursor) {
            if (cursor == null) {
                String string = InternalMappingResource.loadString("cursor", "Global_ArgumentNull", "ui_mapping_resources");
                throw new IllegalArgumentException(string);
            }
            m_swipeVertical = cursor;
        }

        static {
            m_swipeLeft = null;
            m_swipeTop = null;
            m_swipeRight = null;
            m_swipeBottom = null;
            m_swipeHorizontal = null;
            m_swipeVertical = null;
            imagePath = "";
        }
    }
}

