/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoCompound;
import com.supermap.data.GeoLegendNative;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.TextStyle;
import com.supermap.data.Workspace;

public class GeoLegend
extends Geometry {
    String m_mapName = "";
    private GeoStyle m_backGroundStyle;
    private TextStyle m_titleStyle;
    private TextStyle m_itemTextStyle;
    private TextStyle m_subItemTextStyle;
    private Workspace m_workspace;
    private String[] m_items = new String[0];
    private boolean isChange = false;
    private GeoCompound m_geoCompound;
    private boolean isSet = false;

    public GeoLegend(GeoLegend geoLegend) {
        if (geoLegend == null) {
            String string = InternalResource.loadString("geoLegend", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoLegend);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoLegend geoLegend", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = GeoLegendNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setWorkspace(geoLegend.getWorkspace());
        this.isChange = true;
        InternalHandleDisposable.makeSureNativeObjectLive(geoLegend);
    }

    public GeoLegend(String mapName, Workspace workspace, String title) {
        long l = GeoLegendNative.jni_New2(mapName, title, InternalHandle.getHandle(workspace));
        this.setHandle(l, true);
        this.setWorkspace(workspace);
        this.setMapName(mapName);
        this.isChange = true;
        this.getItems();
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
    }

    public GeoLegend(String mapName, Workspace workspace) {
        long l = GeoLegendNative.jni_New3(mapName, InternalHandle.getHandle(workspace));
        this.setHandle(l, true);
        this.setWorkspace(workspace);
        this.setMapName(mapName);
        this.isChange = true;
        this.getItems();
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
    }

    GeoLegend(long handle, Workspace workspace) {
        this.setHandle(handle, false);
        this.setWorkspace(workspace);
        this.isChange = true;
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
    }

    GeoLegend(long handle) {
        this.setHandle(handle, false);
        this.isChange = true;
    }

    public String getMapName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isSet) {
            this.m_mapName = GeoLegendNative.jni_GetMapName(this.getHandle());
        }
        return this.m_mapName;
    }

    public void setMapName(String mapName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapName(String mapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (mapName == null) {
            mapName = "";
        }
        if (!this.m_mapName.equalsIgnoreCase(mapName)) {
            if (this.getWorkspace().getMaps().indexOf(mapName) == -1) {
                String string = InternalResource.loadString("getItems()", "GeoLegend_MapNameMustInWorkspace", "data_resources");
                throw new IllegalStateException(string);
            }
            this.isSet = true;
            this.m_mapName = mapName;
            this.isChange = true;
            this.getItemNames();
        }
    }

    public String getTitle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTitle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLegendNative.jni_GetTitle(this.getHandle());
    }

    public void setTitle(String title) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapName(String mapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (title == null) {
            title = "";
        }
        GeoLegendNative.jni_SetTitle(this.getHandle(), title);
    }

    public GeoStyle getBackGroundStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBackGroundStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_backGroundStyle == null && (l = GeoLegendNative.jni_GetBackGroundStyle(this.getHandle())) != 0L) {
            this.m_backGroundStyle = new GeoStyle(l);
        }
        return this.m_backGroundStyle;
    }

    public void setBackGroundStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBackGroundStyle(GeoStyle geoStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("geoStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("geoStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLegendNative.jni_SetBackGroundStyle(this.getHandle(), geoStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    public TextStyle getTitleStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTitleStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_titleStyle == null && (l = GeoLegendNative.jni_GetTitleStyle(this.getHandle())) != 0L) {
            this.m_titleStyle = new TextStyle(l);
        }
        return this.m_titleStyle;
    }

    public void setTitleStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTitleStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLegendNative.jni_SetTitleStyle(this.getHandle(), textStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle);
    }

    public TextStyle getItemTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItemTextStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_itemTextStyle == null && (l = GeoLegendNative.jni_GetItemTextStyle(this.getHandle())) != 0L) {
            this.m_itemTextStyle = new TextStyle(l);
        }
        return this.m_itemTextStyle;
    }

    public void setItemTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setItemTextStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLegendNative.jni_SetItemTextStyle(this.getHandle(), textStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle);
    }

    public TextStyle getSubItemTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSubItemTextStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_subItemTextStyle == null && (l = GeoLegendNative.jni_GetSubItemTextStyle(this.getHandle())) != 0L) {
            this.m_subItemTextStyle = new TextStyle(l);
        }
        return this.m_subItemTextStyle;
    }

    public void setSubItemTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSubItemTextStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLegendNative.jni_SetSubItemTextStyle(this.getHandle(), textStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle);
    }

    public double getLeftMargin() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLeftMargin()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLegendNative.jni_GetLeftMargin(this.getHandle());
    }

    public void setLeftMargin(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLeftMargin()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLegendNative.jni_SetLeftMargin(this.getHandle(), value);
    }

    public double getRightMargin() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRightMargin()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLegendNative.jni_GetRightMargin(this.getHandle());
    }

    public void setRightMargin(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRightMargin()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLegendNative.jni_SetRightMargin(this.getHandle(), value);
    }

    public double getTopMargin() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTopMargin()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLegendNative.jni_GetTopMargin(this.getHandle());
    }

    public void setTopMargin(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTopMargin()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLegendNative.jni_SetTopMargin(this.getHandle(), value);
    }

    public double getBottomMargin() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBottomMargin()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLegendNative.jni_GetBottomMargin(this.getHandle());
    }

    public void setBottomMargin(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBottomMargin()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLegendNative.jni_SetBottomMargin(this.getHandle(), value);
    }

    public int getColumnCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColumnCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLegendNative.jni_GetColumnCount(this.getHandle());
    }

    public void setColumnCount(int count) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColumnCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (count < 1) {
            String string = InternalResource.loadString("count", "Global_ArgumentShouldNotSmallerThanOne", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLegendNative.jni_SetColumnCount(this.getHandle(), count);
    }

    public String[] getItemNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItemNames()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getWorkspace() == null) {
            String string = InternalResource.loadString("getItemNames()", "GeoLegend_WorkspaceCANNOTBENULL", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getWorkspace().getMaps().indexOf(this.getMapName()) == -1) {
            String string = InternalResource.loadString("getItemNames()", "GeoLegend_MapNameMustInWorkspace", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isChange) {
            this.m_items = GeoLegendNative.jni_GetItems(this.getHandle(), this.getMapName(), InternalHandle.getHandle(this.getWorkspace()));
            this.isChange = false;
        }
        return this.m_items;
    }

    @Deprecated
    public String[] getItems() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItems()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getWorkspace() == null) {
            String string = InternalResource.loadString("getItems()", "GeoLegend_WorkspaceCANNOTBENULL", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getWorkspace().getMaps().indexOf(this.getMapName()) == -1) {
            String string = InternalResource.loadString("getItems()", "GeoLegend_MapNameMustInWorkspace", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isChange) {
            this.m_items = GeoLegendNative.jni_GetItems(this.getHandle(), this.getMapName(), InternalHandle.getHandle(this.getWorkspace()));
            this.isChange = false;
        }
        return this.m_items;
    }

    public boolean isItemVisible(String itemName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isItemVisible(String itemName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (itemName == null) {
            itemName = "";
        }
        String[] stringArray = this.getItems();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(itemName)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            String string = InternalResource.loadString("itemName", "GeoLegend_ItemNameMustInItems", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoLegendNative.jni_IsItemVisible(this.getHandle(), itemName);
    }

    public void setItemVisible(String itemName, boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setItemVisible(String itemName, boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (itemName == null) {
            itemName = "";
        }
        String[] stringArray = this.getItems();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(itemName)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            String string = InternalResource.loadString("itemName", "GeoLegend_ItemNameMustInItems", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLegendNative.jni_SetItemVisible(this.getHandle(), this.getMapName(), itemName, value, InternalHandle.getHandle(this.getWorkspace()));
    }

    public Workspace getWorkspace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWorkspace()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_workspace;
    }

    void setWorkspace(Workspace workspace) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWorkspace(Workspace workspace)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.m_workspace = workspace;
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoLegendNative.jni_GetCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setCenter(Point2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCenter(Point2D value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLegendNative.jni_SetCenter(this.getHandle(), value.getX(), value.getY());
    }

    public double getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLegendNative.jni_GetWidth(this.getHandle());
    }

    public void setWidth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoRectangleWidthShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLegendNative.jni_SetWidth(this.getHandle(), value);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLegendNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoRectangleHeightShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLegendNative.jni_SetHeight(this.getHandle(), value);
    }

    public void load(boolean isAddToScreenLayer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("load()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLegendNative.jni_Load(this.getHandle(), this.getMapName(), InternalHandle.getHandle(this.getWorkspace()), isAddToScreenLayer);
        if (this.m_geoCompound != null) {
            GeoCompound.refreshFromUGC1(this.m_geoCompound);
        }
    }

    public GeoCompound getInnerGeometry() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInnerGeometry()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoCompound == null && (l = GeoLegendNative.jni_GetGeoCompound(this.getHandle())) != 0L) {
            this.m_geoCompound = new GeoCompound(l);
        }
        return this.m_geoCompound;
    }

    @Override
    public GeoLegend clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoLegend(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoLegendNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        if (this.m_backGroundStyle != null) {
            this.m_backGroundStyle.clearHandle();
            this.m_backGroundStyle = null;
        }
        if (this.m_titleStyle != null) {
            this.m_titleStyle.clearHandle();
            this.m_titleStyle = null;
        }
        if (this.m_itemTextStyle != null) {
            this.m_itemTextStyle.clearHandle();
            this.m_itemTextStyle = null;
        }
        if (this.m_subItemTextStyle != null) {
            this.m_subItemTextStyle.clearHandle();
            this.m_subItemTextStyle = null;
        }
        if (this.m_geoCompound != null) {
            this.m_geoCompound.clearHandle();
            this.m_geoCompound = null;
        }
        this.m_workspace = null;
        this.setHandle(0L);
    }

    public int getSubItemStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSubItemTextStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoLegendNative.jni_GetSubItemStyle(this.getHandle(), this.m_workspace.getHandle(), this.getMapName());
        return n;
    }

    public void setSubItemStyle(int nGeoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSubItemStyle(int nGeoStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLegendNative.jni_SetSubItemStyle(this.getHandle(), this.m_workspace.getHandle(), this.getMapName(), nGeoStyle);
    }

    public String[] getCurrentMakeItemNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentMakeItemNames()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLegendNative.jni_GetCurrentMakeItemNames(this.getHandle());
    }

    public void setCurrentMakeItemNames(String[] layerNames) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCurrentMakeItemNames(String[] layerNames)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (layerNames == null || layerNames.length < 1) {
            String string = InternalResource.loadString("layerNames)", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLegendNative.jni_SetCurrentMakeItemNames(this.getHandle(), layerNames);
    }

    public boolean isNoteLeft() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isNoteLeft()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLegendNative.jni_IsNoteLeft(this.getHandle());
    }

    public void setIsNoteLeft(String itemName, boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsNoteLeft(Boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLegendNative.jni_setIsNoteLeft(this.getHandle(), value);
    }
}

