/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalResource;
import com.supermap.data.MapAddedEvent;
import com.supermap.data.MapAddedListener;
import com.supermap.data.MapClearedEvent;
import com.supermap.data.MapClearedListener;
import com.supermap.data.MapClearingEvent;
import com.supermap.data.MapClearingListener;
import com.supermap.data.MapRemovedEvent;
import com.supermap.data.MapRemovedListener;
import com.supermap.data.MapRemovingEvent;
import com.supermap.data.MapRemovingListener;
import com.supermap.data.MapRenamedEvent;
import com.supermap.data.MapRenamedListener;
import com.supermap.data.MapRenamingEvent;
import com.supermap.data.MapRenamingListener;
import com.supermap.data.MapsNative;
import com.supermap.data.Workspace;
import com.supermap.data.WorkspaceVersion;
import java.util.concurrent.CopyOnWriteArrayList;

public class Maps {
    private Workspace m_workspace;
    transient CopyOnWriteArrayList<MapRenamingListener> m_mapRenamingListeners;
    transient CopyOnWriteArrayList<MapRenamedListener> m_mapRenamedListeners;
    transient CopyOnWriteArrayList<MapRemovingListener> m_mapRemovingListeners;
    transient CopyOnWriteArrayList<MapRemovedListener> m_mapRemovedListeners;
    transient CopyOnWriteArrayList<MapAddedListener> m_mapAddedListeners;
    transient CopyOnWriteArrayList<MapClearingListener> m_mapClearingListeners;
    transient CopyOnWriteArrayList<MapClearedListener> m_mapClearedListeners;

    Maps(Workspace workspace) {
        this.m_workspace = workspace;
    }

    public int getCount() {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return MapsNative.jni_GetCount(this.m_workspace.getHandle());
    }

    public String get(int index) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return MapsNative.jni_GetItem(this.m_workspace.getHandle(), index);
    }

    public int add(String name, String xml) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Maps_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        n = MapsNative.jni_Add(this.m_workspace.getHandle(), name, xml);
        if (n > -1) {
            MapAddedEvent mapAddedEvent = new MapAddedEvent(this, name);
            this.fireAdded(mapAddedEvent);
        }
        return n;
    }

    public int add(String name, String xml, WorkspaceVersion version) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Maps_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        int n2 = version.value();
        n = MapsNative.jni_Add2(this.m_workspace.getHandle(), name, xml, n2);
        if (n > -1) {
            MapAddedEvent mapAddedEvent = new MapAddedEvent(this, name);
            this.fireAdded(mapAddedEvent);
        }
        return n;
    }

    public boolean insert(int index, String name, String xml) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Maps_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return MapsNative.jni_Insert(this.m_workspace.getHandle(), index, name, xml);
    }

    public boolean insert(int index, String name, String xml, WorkspaceVersion version) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Maps_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = version.value();
        return MapsNative.jni_Insert2(this.m_workspace.getHandle(), index, name, xml, n);
    }

    public boolean setMapXML(int index, String xml) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (xml == null) {
            xml = "";
        }
        return MapsNative.jni_SetMapXML(this.m_workspace.getHandle(), index, xml);
    }

    public boolean setMapXML(int index, String xml, WorkspaceVersion version) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (xml == null) {
            xml = "";
        }
        int n = version.value();
        return MapsNative.jni_SetMapXML2(this.m_workspace.getHandle(), index, xml, n);
    }

    public boolean setMapXML(String name, String xml) {
        int n;
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if ((n = this.indexOf(name)) == -1) {
            String string = InternalResource.loadString("name", "Maps_NameIsNotInMaps", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this.setMapXML(n, xml);
    }

    public boolean setMapXML(String name, String xml, WorkspaceVersion version) {
        int n;
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if ((n = this.indexOf(name)) == -1) {
            String string = InternalResource.loadString("name", "Maps_NameIsNotInMaps", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this.setMapXML(n, xml, version);
    }

    public String getMapXML(int index) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return MapsNative.jni_GetMapXML(this.m_workspace.getHandle(), index);
    }

    public String getMapXML(String name) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.indexOf(name);
        if (n == -1) {
            String string = InternalResource.loadString("name", "Maps_NameIsNotInMaps", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return MapsNative.jni_GetMapXML(this.m_workspace.getHandle(), n);
    }

    public boolean remove(int index) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        String string = this.get(index);
        MapRemovingEvent mapRemovingEvent = new MapRemovingEvent(this, string);
        this.fireRemoving(mapRemovingEvent);
        if (mapRemovingEvent.isCancel()) {
            return false;
        }
        boolean bl = false;
        bl = MapsNative.jni_Remove(this.m_workspace.getHandle(), index);
        if (bl) {
            MapRemovedEvent mapRemovedEvent = new MapRemovedEvent(this, string);
            this.fireRemoved(mapRemovedEvent);
        }
        return bl;
    }

    public boolean remove(String name) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = this.indexOf(name);
        if (n != -1) {
            bl = this.remove(n);
        }
        return bl;
    }

    public void clear() {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        MapClearingEvent mapClearingEvent = new MapClearingEvent(this);
        this.fireClearing(mapClearingEvent);
        if (mapClearingEvent.isCancel()) {
            return;
        }
        int n = this.getCount();
        MapsNative.jni_Clear(this.m_workspace.getHandle());
        MapClearedEvent mapClearedEvent = new MapClearedEvent(this, n);
        this.fireCleared(mapClearedEvent);
    }

    public int indexOf(String name) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (name != null && name.trim().length() != 0) {
            n = MapsNative.jni_IndexOf(this.m_workspace.getHandle(), name);
        }
        return n;
    }

    public String getAvailableMapName(String name) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            name = "";
        }
        return MapsNative.jni_GetUnoccupiedMapName(this.m_workspace.getHandle(), name);
    }

    public boolean rename(String oldName, String newName) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (oldName == null || oldName.trim().length() == 0) {
            String string = InternalResource.loadString("oldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (newName == null || newName.trim().length() == 0) {
            String string = InternalResource.loadString("newName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(oldName) == -1) {
            String string = InternalResource.loadString("oldName", "Maps_NameIsNotInMaps", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (newName.equalsIgnoreCase(oldName)) {
            return false;
        }
        if (this.indexOf(newName) >= 0) {
            String string = InternalResource.loadString("newName", "Maps_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MapRenamingEvent mapRenamingEvent = new MapRenamingEvent(this, oldName, newName);
        this.fireRenaming(mapRenamingEvent);
        if (mapRenamingEvent.isCancel()) {
            return false;
        }
        boolean bl = false;
        bl = MapsNative.jni_Rename(this.m_workspace.getHandle(), oldName, newName);
        if (bl) {
            MapRenamedEvent mapRenamedEvent = new MapRenamedEvent(this, oldName, newName);
            this.fireRenamed(mapRenamedEvent);
        }
        return bl;
    }

    protected void clearHandle() {
        this.m_workspace = null;
    }

    public synchronized void addRenamingListener(MapRenamingListener l) {
        if (this.m_mapRenamingListeners == null) {
            this.m_mapRenamingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_mapRenamingListeners.contains(l)) {
            this.m_mapRenamingListeners.add(l);
        }
    }

    public void removeRenamingListener(MapRenamingListener l) {
        if (this.m_mapRenamingListeners != null && this.m_mapRenamingListeners.contains(l)) {
            this.m_mapRenamingListeners.remove(l);
        }
    }

    protected void fireRenaming(MapRenamingEvent event) {
        if (this.m_mapRenamingListeners != null) {
            CopyOnWriteArrayList<MapRenamingListener> copyOnWriteArrayList = this.m_mapRenamingListeners;
            for (MapRenamingListener mapRenamingListener : copyOnWriteArrayList) {
                mapRenamingListener.mapRenaming(event);
            }
        }
    }

    public synchronized void addRenamedListener(MapRenamedListener l) {
        if (this.m_mapRenamedListeners == null) {
            this.m_mapRenamedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_mapRenamedListeners.contains(l)) {
            this.m_mapRenamedListeners.add(l);
        }
    }

    public void removeRenamedListener(MapRenamedListener l) {
        if (this.m_mapRenamedListeners != null && this.m_mapRenamedListeners.contains(l)) {
            this.m_mapRenamedListeners.remove(l);
        }
    }

    protected void fireRenamed(MapRenamedEvent event) {
        if (this.m_mapRenamedListeners != null) {
            CopyOnWriteArrayList<MapRenamedListener> copyOnWriteArrayList = this.m_mapRenamedListeners;
            for (MapRenamedListener mapRenamedListener : copyOnWriteArrayList) {
                mapRenamedListener.mapRenamed(event);
            }
        }
    }

    public synchronized void addRemovingListener(MapRemovingListener l) {
        if (this.m_mapRemovingListeners == null) {
            this.m_mapRemovingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_mapRemovingListeners.contains(l)) {
            this.m_mapRemovingListeners.add(l);
        }
    }

    public void removeRemovingListener(MapRemovingListener l) {
        if (this.m_mapRemovingListeners != null && this.m_mapRemovingListeners.contains(l)) {
            this.m_mapRemovingListeners.remove(l);
        }
    }

    protected void fireRemoving(MapRemovingEvent event) {
        if (this.m_mapRemovingListeners != null) {
            CopyOnWriteArrayList<MapRemovingListener> copyOnWriteArrayList = this.m_mapRemovingListeners;
            for (MapRemovingListener mapRemovingListener : copyOnWriteArrayList) {
                mapRemovingListener.mapRemoving(event);
            }
        }
    }

    public synchronized void addRemovedListener(MapRemovedListener l) {
        if (this.m_mapRemovedListeners == null) {
            this.m_mapRemovedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_mapRemovedListeners.contains(l)) {
            this.m_mapRemovedListeners.add(l);
        }
    }

    public void removeRemovedListener(MapRemovedListener l) {
        if (this.m_mapRemovedListeners != null && this.m_mapRemovedListeners.contains(l)) {
            this.m_mapRemovedListeners.remove(l);
        }
    }

    protected void fireRemoved(MapRemovedEvent event) {
        if (this.m_mapRemovedListeners != null) {
            CopyOnWriteArrayList<MapRemovedListener> copyOnWriteArrayList = this.m_mapRemovedListeners;
            for (MapRemovedListener mapRemovedListener : copyOnWriteArrayList) {
                mapRemovedListener.mapRemoved(event);
            }
        }
    }

    public synchronized void addAddedListener(MapAddedListener l) {
        if (this.m_mapAddedListeners == null) {
            this.m_mapAddedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_mapAddedListeners.contains(l)) {
            this.m_mapAddedListeners.add(l);
        }
    }

    public void removeAddedListener(MapAddedListener l) {
        if (this.m_mapAddedListeners != null && this.m_mapAddedListeners.contains(l)) {
            this.m_mapAddedListeners.remove(l);
        }
    }

    protected void fireAdded(MapAddedEvent event) {
        if (this.m_mapAddedListeners != null) {
            CopyOnWriteArrayList<MapAddedListener> copyOnWriteArrayList = this.m_mapAddedListeners;
            for (MapAddedListener mapAddedListener : copyOnWriteArrayList) {
                mapAddedListener.mapAdded(event);
            }
        }
    }

    public synchronized void addClearingListener(MapClearingListener l) {
        if (this.m_mapClearingListeners == null) {
            this.m_mapClearingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_mapClearingListeners.contains(l)) {
            this.m_mapClearingListeners.add(l);
        }
    }

    public void removeClearingListener(MapClearingListener l) {
        if (this.m_mapClearingListeners != null && this.m_mapClearingListeners.contains(l)) {
            this.m_mapClearingListeners.remove(l);
        }
    }

    protected void fireClearing(MapClearingEvent event) {
        if (this.m_mapClearingListeners != null) {
            CopyOnWriteArrayList<MapClearingListener> copyOnWriteArrayList = this.m_mapClearingListeners;
            for (MapClearingListener mapClearingListener : copyOnWriteArrayList) {
                mapClearingListener.mapClearing(event);
            }
        }
    }

    public synchronized void addClearedListener(MapClearedListener l) {
        if (this.m_mapClearedListeners == null) {
            this.m_mapClearedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_mapClearedListeners.contains(l)) {
            this.m_mapClearedListeners.add(l);
        }
    }

    public void removeClearedListener(MapClearedListener l) {
        if (this.m_mapClearedListeners != null && this.m_mapClearedListeners.contains(l)) {
            this.m_mapClearedListeners.remove(l);
        }
    }

    protected void fireCleared(MapClearedEvent event) {
        if (this.m_mapClearedListeners != null) {
            CopyOnWriteArrayList<MapClearedListener> copyOnWriteArrayList = this.m_mapClearedListeners;
            for (MapClearedListener mapClearedListener : copyOnWriteArrayList) {
                mapClearedListener.mapCleared(event);
            }
        }
    }
}

