/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Point3D;
import java.util.ArrayList;

public class Point3Ds {
    private ArrayList<Point3D> m_point3Ds = null;
    private GeoLine3D m_geoLine3D = null;
    private GeoRegion3D m_geoRegion3D = null;
    private UserType m_userType = UserType.NONE;

    public Point3Ds() {
        this.m_point3Ds = new ArrayList();
        this.m_userType = UserType.NONE;
    }

    public Point3Ds(Point3Ds points) {
        this();
        int n = points.getCount();
        for (int i = 0; i < n; ++i) {
            this.m_point3Ds.add(points.getItem(i).clone());
        }
    }

    public Point3Ds(Point3D[] points) {
        this();
        this.addRange(points);
    }

    Point3Ds(Point3Ds points, GeoLine3D geoLine3D) {
        this(points);
        this.m_geoLine3D = geoLine3D;
        this.m_userType = UserType.GEOLINE3D;
    }

    Point3Ds(Point3Ds points, GeoRegion3D geoRegion3D) {
        this(points);
        this.m_geoRegion3D = geoRegion3D;
        this.m_userType = UserType.GEOREGION3D;
    }

    public Point3Ds clone() {
        if (this.m_userType.value() == UserType.GEOLINE3D.value()) {
            if (this.m_geoLine3D.getHandle() == 0L) {
                String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoLine3D.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOREGION3D.value()) {
            if (this.m_geoRegion3D.getHandle() == 0L) {
                String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoRegion3D.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        }
        return new Point3Ds(this);
    }

    public int getCount() {
        if (this.m_userType.value() == UserType.GEOLINE3D.value()) {
            if (this.m_geoLine3D.getHandle() == 0L) {
                String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoLine3D.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOREGION3D.value()) {
            if (this.m_geoRegion3D.getHandle() == 0L) {
                String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoRegion3D.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        }
        return this.m_point3Ds.size();
    }

    public Point3D getItem(int index) {
        int n;
        if (this.m_userType.value() == UserType.GEOLINE3D.value()) {
            if (this.m_geoLine3D.getHandle() == 0L) {
                String string = InternalResource.loadString("getItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            n = this.m_geoLine3D.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOREGION3D.value()) {
            if (this.m_geoRegion3D.getHandle() == 0L) {
                String string = InternalResource.loadString("getItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            n = this.m_geoRegion3D.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        }
        Point3D point3D = this.m_point3Ds.get(index);
        return point3D.clone();
    }

    public void setItem(int index, Point3D point3D) {
        if (point3D == null) {
            String string = InternalResource.loadString("setItem(int index, Point3D point3D)", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (this.m_userType.value() == UserType.NONE.value()) {
            this.m_point3Ds.set(index, point3D.clone());
        } else if (this.m_userType.value() == UserType.GEOLINE3D.value()) {
            if (this.m_geoLine3D.getHandle() == 0L) {
                String string = InternalResource.loadString("setItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoLine3D.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            this.m_point3Ds.set(index, point3D);
            this.m_geoLine3D.setPartJustToUGC(n, this);
        } else if (this.m_userType.value() == UserType.GEOREGION3D.value()) {
            if (this.m_geoRegion3D.getHandle() == 0L) {
                String string = InternalResource.loadString("setItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoRegion3D.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setItem()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (index == 0) {
                this.m_point3Ds.remove(this.m_point3Ds.size() - 1);
            } else if (index == this.m_point3Ds.size() - 1) {
                this.m_point3Ds.set(0, point3D);
            }
            this.m_point3Ds.set(index, point3D);
            this.m_geoRegion3D.setPartJustToUGC(n, this);
        }
    }

    public int add(Point3D pt) {
        if (pt == null) {
            String string = InternalResource.loadString("add(Point3D pt)", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        int n = -1;
        boolean bl = false;
        int n2 = -1;
        if (this.m_userType.value() == UserType.NONE.value()) {
            n2 = this.m_point3Ds.size() - 1;
            bl = this.m_point3Ds.add(pt.clone());
            if (bl) {
                n = this.m_point3Ds.size() - 1;
            }
        } else if (this.m_userType.value() == UserType.GEOLINE3D.value()) {
            if (this.m_geoLine3D.getHandle() == 0L) {
                String string = InternalResource.loadString("add()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n3 = this.m_geoLine3D.getPartsList().indexOf(this);
            if (n3 == -1) {
                String string = InternalResource.loadString("add()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            n2 = this.m_point3Ds.size() - 1;
            bl = this.m_point3Ds.add(pt.clone());
            if (bl) {
                n = this.m_point3Ds.size() - 1;
            }
            int n4 = this.m_geoLine3D.getPartsList().indexOf(this);
            this.m_geoLine3D.setPart(n4, this);
        } else if (this.m_userType.value() == UserType.GEOREGION3D.value()) {
            if (this.m_geoRegion3D.getHandle() == 0L) {
                String string = InternalResource.loadString("add()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n5 = this.m_geoRegion3D.getPartsList().indexOf(this);
            if (n5 == -1) {
                String string = InternalResource.loadString("add()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            n2 = this.m_point3Ds.size() - 1;
            bl = this.m_point3Ds.add(pt.clone());
            if (bl) {
                n = this.m_point3Ds.size() - 1;
            }
            this.m_point3Ds.remove(n2);
            this.m_geoRegion3D.setPart(n5, this);
        }
        return n;
    }

    public int addRange(Point3D[] points) {
        int n = points.length;
        int n2 = this.m_point3Ds.size() - 1;
        if (this.m_userType.value() == UserType.NONE.value()) {
            for (int i = 0; i < n; ++i) {
                this.m_point3Ds.add(points[i].clone());
            }
        } else if (this.m_userType.value() == UserType.GEOLINE3D.value()) {
            if (this.m_geoLine3D.getHandle() == 0L) {
                String string = InternalResource.loadString("addRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n3 = this.m_geoLine3D.getPartsList().indexOf(this);
            if (n3 == -1) {
                String string = InternalResource.loadString("addRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            for (int i = 0; i < n; ++i) {
                this.m_point3Ds.add(points[i].clone());
            }
            this.m_geoLine3D.setPart(n3, this);
        } else if (this.m_userType.value() == UserType.GEOREGION3D.value()) {
            if (this.m_geoRegion3D.getHandle() == 0L) {
                String string = InternalResource.loadString("addRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n4 = this.m_geoRegion3D.getPartsList().indexOf(this);
            if (n4 == -1) {
                String string = InternalResource.loadString("addRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            for (int i = 0; i < n; ++i) {
                this.m_point3Ds.add(points[i].clone());
            }
            this.m_point3Ds.remove(n2);
            this.m_geoRegion3D.setPart(n4, this);
        }
        return n;
    }

    public boolean insert(int index, Point3D pt) {
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("insert(int index, Point3D point3D)", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (pt == null) {
            String string = InternalResource.loadString("insert(int index, Point3D point3D)", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        boolean bl = false;
        int n = this.m_point3Ds.size() - 1;
        int n2 = this.m_point3Ds.size();
        if (this.m_userType.value() == UserType.NONE.value()) {
            this.m_point3Ds.add(index, pt.clone());
            bl = this.m_point3Ds.size() == n2 + 1;
        } else if (this.m_userType.value() == UserType.GEOLINE3D.value()) {
            if (this.m_geoLine3D.getHandle() == 0L) {
                String string = InternalResource.loadString("insert()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n3 = this.m_geoLine3D.getPartsList().indexOf(this);
            if (n3 == -1) {
                String string = InternalResource.loadString("insert()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            this.m_point3Ds.add(index, pt.clone());
            bl = this.m_point3Ds.size() == n2 + 1;
            this.m_geoLine3D.setPart(n3, this);
        } else if (this.m_userType.value() == UserType.GEOREGION3D.value()) {
            if (this.m_geoRegion3D.getHandle() == 0L) {
                String string = InternalResource.loadString("insert()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n4 = this.m_geoRegion3D.getPartsList().indexOf(this);
            if (n4 == -1) {
                String string = InternalResource.loadString("insert()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            this.m_point3Ds.add(index, pt.clone());
            bl = this.m_point3Ds.size() == n2 + 1;
            if (index == 0) {
                this.m_point3Ds.remove(n + 1);
            }
            if (index == this.m_point3Ds.size()) {
                this.m_point3Ds.remove(n);
            }
            this.m_geoRegion3D.setPart(n4, this);
        }
        return bl;
    }

    public int insertRange(int index, Point3D[] points) {
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("insertRange(int index, Point3D[] points)", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.m_point3Ds.size() - 1;
        int n2 = points.length;
        if (this.m_userType.value() == UserType.NONE.value()) {
            for (int i = 0; i < n2; ++i) {
                int n3 = index + i;
                this.m_point3Ds.add(n3, points[i].clone());
            }
        } else if (this.m_userType.value() == UserType.GEOLINE3D.value()) {
            if (this.m_geoLine3D.getHandle() == 0L) {
                String string = InternalResource.loadString("insertRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n4 = this.m_geoLine3D.getPartsList().indexOf(this);
            if (n4 == -1) {
                String string = InternalResource.loadString("insertRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            for (int i = 0; i < n2; ++i) {
                int n5 = index + i;
                this.m_point3Ds.add(n5, points[i].clone());
            }
            this.m_geoLine3D.setPart(n4, this);
        } else if (this.m_userType.value() == UserType.GEOREGION3D.value()) {
            if (this.m_geoRegion3D.getHandle() == 0L) {
                String string = InternalResource.loadString("insertRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n6 = this.m_geoRegion3D.getPartsList().indexOf(this);
            if (n6 == -1) {
                String string = InternalResource.loadString("insertRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            for (int i = 0; i < n2; ++i) {
                int n7 = index + i;
                this.m_point3Ds.add(n7, points[i].clone());
            }
            if (index == 0) {
                this.m_point3Ds.remove(n + n2);
            }
            if (index == this.m_point3Ds.size()) {
                this.m_point3Ds.remove(n);
            }
            this.m_geoRegion3D.setPart(n6, this);
        }
        return n2;
    }

    public boolean remove(int index) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("remove(int index)", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point3D point3D = null;
        Point3D point3D2 = null;
        boolean bl = false;
        if (this.m_userType.value() == UserType.NONE.value()) {
            point3D = this.m_point3Ds.get(index);
            if (point3D.equals(point3D2 = this.m_point3Ds.remove(index))) {
                bl = true;
            }
        } else if (this.m_userType.value() == UserType.GEOLINE3D.value()) {
            if (this.m_geoLine3D.getHandle() == 0L) {
                String string = InternalResource.loadString("remove()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoLine3D.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("remove()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.getCount() < 2) {
                String string = InternalResource.loadString("remove()", "Point3Ds_InvalidPointsLength", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            point3D = this.m_point3Ds.get(index);
            if (point3D.equals(point3D2 = this.m_point3Ds.remove(index))) {
                this.m_geoLine3D.setPart(n, this);
                bl = true;
            }
        } else if (this.m_userType.value() == UserType.GEOREGION3D.value()) {
            if (this.m_geoRegion3D.getHandle() == 0L) {
                String string = InternalResource.loadString("remove()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n = this.m_geoRegion3D.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("remove()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.getCount() < 4) {
                String string = InternalResource.loadString("remove()", "Point3Ds_InvalidPointsLength", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            point3D = this.m_point3Ds.get(index);
            if (point3D.equals(point3D2 = this.m_point3Ds.remove(index))) {
                if (index == 0) {
                    this.m_point3Ds.remove(this.m_point3Ds.size() - 1);
                }
                if (index == this.m_point3Ds.size()) {
                    this.m_point3Ds.remove(0);
                }
                this.m_geoRegion3D.setPart(n, this);
                bl = true;
            }
        }
        return bl;
    }

    public int removeRange(int index, int count) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("removeRange(int index, int count)", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getCount() < index + count || count < 0) {
            String string = InternalResource.loadString("removeRange(int index, int count)", "Point3Ds_TheCountIsInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.getCount();
        int n2 = n - count;
        if (this.m_userType.value() == UserType.NONE.value()) {
            for (int i = index + count - 1; i >= index; --i) {
                this.m_point3Ds.remove(i);
            }
        } else if (this.m_userType.value() == UserType.GEOLINE3D.value()) {
            if (this.m_geoLine3D.getHandle() == 0L) {
                String string = InternalResource.loadString("removeRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n3 = this.m_geoLine3D.getPartsList().indexOf(this);
            if (n3 == -1) {
                String string = InternalResource.loadString("removeRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (n2 < 2) {
                String string = InternalResource.loadString("removeRange()", "Point3Ds_InvalidPointsLength", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            for (int i = index + count - 1; i >= index; --i) {
                this.m_point3Ds.remove(i);
            }
            this.m_geoLine3D.setPart(n3, this);
        } else if (this.m_userType.value() == UserType.GEOREGION3D.value()) {
            if (this.m_geoRegion3D.getHandle() == 0L) {
                String string = InternalResource.loadString("removeRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            int n4 = this.m_geoRegion3D.getPartsList().indexOf(this);
            if (n4 == -1) {
                String string = InternalResource.loadString("removeRange()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (n2 < 4) {
                String string = InternalResource.loadString("removeRange()", "Point3Ds_InvalidPointsLength", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            for (int i = index + count - 1; i >= index; --i) {
                this.m_point3Ds.remove(i);
            }
            if (index == 0) {
                this.m_point3Ds.remove(this.m_point3Ds.size() - 1);
            }
            if (index + count == n) {
                this.m_point3Ds.remove(0);
            }
            this.m_geoRegion3D.setPart(n4, this);
        }
        return count;
    }

    public void clear() {
        if (this.m_userType.equals(UserType.GEOLINE3D) || this.m_userType.equals(UserType.GEOREGION3D)) {
            String string = InternalResource.loadString("clear()", "Point3Ds_CannotDoClearOperation", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        this.m_point3Ds.clear();
    }

    public Point3D[] toArray() {
        int n;
        if (this.m_userType.value() == UserType.GEOLINE3D.value()) {
            if (this.m_geoLine3D.getHandle() == 0L) {
                String string = InternalResource.loadString("toArray()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            n = this.m_geoLine3D.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("toArray()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.m_userType.value() == UserType.GEOREGION3D.value()) {
            if (this.m_geoRegion3D.getHandle() == 0L) {
                String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            n = this.m_geoRegion3D.getPartsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
        }
        n = this.m_point3Ds.size();
        Point3D[] point3DArray = new Point3D[n];
        for (int i = 0; i < n; ++i) {
            point3DArray[i] = this.m_point3Ds.get(i);
        }
        return point3DArray;
    }

    public Point2Ds toPoint2Ds() {
        int n = this.getCount();
        Point2D[] point2DArray = new Point2D[n];
        for (int i = 0; i < n; ++i) {
            point2DArray[i] = new Point2D();
            point2DArray[i].setX(this.getItem(i).getX());
            point2DArray[i].setY(this.getItem(i).getY());
        }
        Point2Ds point2Ds = new Point2Ds(point2DArray);
        return point2Ds;
    }

    UserType getUserType() {
        return this.m_userType;
    }

    void setUserType(UserType userType) {
        this.m_userType = userType;
    }

    static class UserType
    extends Enum {
        public static final UserType NONE = new UserType(1, 1);
        public static final UserType GEOLINE3D = new UserType(2, 2);
        public static final UserType GEOREGION3D = new UserType(3, 3);

        private UserType(int value, int ugcValue) {
            super(value, ugcValue);
        }
    }
}

