/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DecorationPositionType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalBufferImage;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolLineBase;
import com.supermap.data.SymbolLineDecoration;
import com.supermap.data.SymbolLineNative;
import com.supermap.data.SymbolType;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class SymbolLine
extends Symbol {
    private ArrayList<SymbolLineBase> m_symbolLineBaseList;

    protected SymbolLine(long handle) {
        this.setHandle(handle, false);
        this.setLibrary(null);
        this.refreshLineBaseList(handle);
    }

    @Override
    protected void clearHandle() {
        if (this.m_symbolLineBaseList != null) {
            this.clearLineBaseList();
        }
        super.clearHandle();
    }

    protected void clearLineBaseList() {
        for (int i = 0; i < this.m_symbolLineBaseList.size(); ++i) {
            SymbolLineBase symbolLineBase = this.m_symbolLineBaseList.get(i);
            symbolLineBase.clearHandle();
        }
        this.m_symbolLineBaseList.clear();
    }

    public SymbolLine() {
        long l = SymbolLineNative.jni_New();
        this.setHandle(l, true);
        this.setLibrary(null);
        this.refreshLineBaseList(l);
    }

    private void refreshLineBaseList(long handle) {
        if (this.m_symbolLineBaseList != null) {
            this.clearLineBaseList();
        } else {
            this.m_symbolLineBaseList = new ArrayList();
        }
        int n = SymbolLineNative.jni_GetCount(handle);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                long l = SymbolLineNative.jni_Get(handle, i);
                SymbolLineBase symbolLineBase = new SymbolLineBase(l);
                this.m_symbolLineBaseList.add(symbolLineBase);
            }
        }
    }

    @Override
    public boolean draw(Graphics graphics, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        GeometryType geometryType = geometry.getType();
        if (geometryType.equals(GeometryType.GEOLINE) || geometryType.equals(GeometryType.GEOREGION) || geometryType.equals(GeometryType.GEOARC) || geometryType.equals(GeometryType.GEOLINEM) || geometryType.equals(GeometryType.GEOBSPLINE) || geometryType.equals(GeometryType.GEOCARDINAL) || geometryType.equals(GeometryType.GEOPIE) || geometryType.equals(GeometryType.GEOPIECYLINDER) || geometryType.equals(GeometryType.GEOROUNDRECTANGLE) || geometryType.equals(GeometryType.GEOELLIPTICARC) || geometryType.equals(GeometryType.GEOCIRCLE) || geometryType.equals(GeometryType.GEOELLIPSE) || geometryType.equals(GeometryType.GEORECTANGLE) || geometryType.equals(GeometryType.GEOCURVE) || geometryType.equals(GeometryType.GEOCHORD)) {
            InternalBufferImage internalBufferImage;
            Rectangle2D rectangle2D = geometry.getBounds();
            try {
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 20, (int)rectangle2D.getHeight() + 20);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            int n = (int)rectangle2D.getLeft();
            int n2 = (int)rectangle2D.getBottom();
            geometry.offset((double)(-n) + 10.0, (double)(-n2) + 10.0);
            long l2 = this.m_lib != null ? this.m_lib.getHandle() : 0L;
            bl = SymbolLineNative.jni_Draw(this.getHandle(), l2, internalBufferImage.getHandle(), geometry.getHandle());
            if (bl) {
                graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - 10, (int)rectangle2D.getBottom() - 10, null);
            }
            internalBufferImage.makeSureNativeObjectLive();
        }
        geometry.makeSureNativeObjectLive();
        return bl;
    }

    @Override
    public boolean draw(BufferedImage image, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(BufferedImage image, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        geometry.makeSureNativeObjectLive();
        return this.draw(image.getGraphics(), geometry);
    }

    @Override
    public boolean draw(Graphics graphics, Point2Ds points, GeoStyle style) {
        InternalBufferImage internalBufferImage;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Point2Ds points, GeoStyle style)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLine geoLine = new GeoLine(points);
        Rectangle2D rectangle2D = geoLine.getBounds();
        boolean bl = false;
        try {
            internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 20, (int)rectangle2D.getHeight() + 20);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        geoLine.offset(-rectangle2D.getLeft() + 10.0, -rectangle2D.getBottom() + 10.0);
        Point2Ds point2Ds = geoLine.getPart(0);
        int n = point2Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        long l = this.m_lib != null ? Long.valueOf(this.m_lib.getHandle()) : null;
        bl = style == null ? SymbolLineNative.jni_Draw2(this.getHandle(), l, internalBufferImage.getHandle(), dArray, dArray2, 0L) : SymbolLineNative.jni_Draw2(this.getHandle(), l, internalBufferImage.getHandle(), dArray, dArray2, style.getHandle());
        if (bl) {
            graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - 10, (int)rectangle2D.getBottom() - 10, null);
        }
        internalBufferImage.makeSureNativeObjectLive();
        if (style != null) {
            style.makeSureNativeObjectLive();
        }
        return bl;
    }

    @Override
    public boolean draw(BufferedImage image, Point2Ds points, GeoStyle style) {
        InternalBufferImage internalBufferImage;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(BufferedImage image, Point2Ds points, GeoStyle style)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLine geoLine = new GeoLine(points);
        Rectangle2D rectangle2D = geoLine.getBounds();
        boolean bl = false;
        try {
            internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 20, (int)rectangle2D.getHeight() + 20);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        geoLine.offset(-rectangle2D.getLeft() + 10.0, -rectangle2D.getBottom() + 10.0);
        Point2Ds point2Ds = geoLine.getPart(0);
        int n = point2Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        long l = this.m_lib != null ? Long.valueOf(this.m_lib.getHandle()) : null;
        bl = style == null ? SymbolLineNative.jni_Draw2(this.getHandle(), l, internalBufferImage.getHandle(), dArray, dArray2, 0L) : SymbolLineNative.jni_Draw2(this.getHandle(), l, internalBufferImage.getHandle(), dArray, dArray2, style.getHandle());
        if (bl) {
            image.getGraphics().drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - 10, (int)rectangle2D.getBottom() - 10, null);
        }
        internalBufferImage.makeSureNativeObjectLive();
        if (style != null) {
            style.makeSureNativeObjectLive();
        }
        return bl;
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolLineNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public SymbolType getType() {
        return SymbolType.LINE;
    }

    protected boolean internalDraw(Graphics graphics, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        GeometryType geometryType = geometry.getType();
        if (geometryType.equals(GeometryType.GEOLINE) || geometryType.equals(GeometryType.GEOREGION) || geometryType.equals(GeometryType.GEOARC) || geometryType.equals(GeometryType.GEOLINEM) || geometryType.equals(GeometryType.GEOBSPLINE) || geometryType.equals(GeometryType.GEOCARDINAL) || geometryType.equals(GeometryType.GEOPIE) || geometryType.equals(GeometryType.GEOPIECYLINDER) || geometryType.equals(GeometryType.GEOROUNDRECTANGLE) || geometryType.equals(GeometryType.GEOELLIPTICARC) || geometryType.equals(GeometryType.GEOCIRCLE) || geometryType.equals(GeometryType.GEOELLIPSE) || geometryType.equals(GeometryType.GEORECTANGLE) || geometryType.equals(GeometryType.GEOCURVE) || geometryType.equals(GeometryType.GEOCHORD)) {
            InternalBufferImage internalBufferImage;
            Rectangle2D rectangle2D = geometry.getBounds();
            try {
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 20, (int)rectangle2D.getHeight() + 20);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            int n = (int)rectangle2D.getLeft();
            int n2 = (int)rectangle2D.getBottom();
            geometry.offset((double)(-n) + 10.0, (double)(-n2) + 10.0);
            long l2 = this.m_lib != null ? this.m_lib.getHandle() : 0L;
            bl = SymbolLineNative.jni_InternalDraw(this.getHandle(), l2, internalBufferImage.getHandle(), geometry.getHandle());
            if (bl) {
                graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - 10, (int)rectangle2D.getBottom() - 10, null);
            }
            internalBufferImage.makeSureNativeObjectLive();
        }
        geometry.makeSureNativeObjectLive();
        return bl;
    }

    protected static boolean internalDraw(SymbolLine line, Graphics graphics, Geometry geometry) {
        return line.internalDraw(graphics, geometry);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLineNative.jni_GetCount(this.getHandle());
    }

    public SymbolLineBase get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index >= this.getCount() || index < 0) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_symbolLineBaseList.get(index);
    }

    public void set(int index, SymbolLineBase lineBase) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index >= this.getCount() || index < 0) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (lineBase == null) {
            String string = InternalResource.loadString("lineBase", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(lineBase);
        if (l == 0L) {
            String string = InternalResource.loadString("lineBase", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SymbolLineNative.jni_Set(this.getHandle(), index, l);
        lineBase.makeSureNativeObjectLive();
    }

    public int add(SymbolLineBase lineBase) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (lineBase == null) {
            String string = InternalResource.loadString("lineBase", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(lineBase);
        if (l == 0L) {
            String string = InternalResource.loadString("lineBase", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = SymbolLineNative.jni_Add(this.getHandle(), l);
        this.m_symbolLineBaseList.add(lineBase);
        lineBase.makeSureNativeObjectLive();
        return n;
    }

    public boolean bringForward(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("bringForward", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index >= this.getCount() || index < 0) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = SymbolLineNative.jni_BringForward(this.getHandle(), index);
        if (bl) {
            SymbolLineBase symbolLineBase = this.m_symbolLineBaseList.remove(index);
            this.m_symbolLineBaseList.add(index - 1, symbolLineBase);
        }
        return bl;
    }

    public boolean bringToFront(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("bringToFront", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index >= this.getCount() || index < 0) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = SymbolLineNative.jni_BringToFront(this.getHandle(), index);
        if (bl) {
            SymbolLineBase symbolLineBase = this.m_symbolLineBaseList.remove(index);
            this.m_symbolLineBaseList.add(0, symbolLineBase);
        }
        return bl;
    }

    public boolean insert(int index, SymbolLineBase lineBase) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index >= this.getCount() || index < 0) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (lineBase == null) {
            String string = InternalResource.loadString("lineBase", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(lineBase);
        if (l == 0L) {
            String string = InternalResource.loadString("lineBase", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = SymbolLineNative.jni_Insert(this.getHandle(), index, l);
        if (bl) {
            this.m_symbolLineBaseList.add(index, lineBase);
        }
        lineBase.makeSureNativeObjectLive();
        return bl;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index >= this.getCount() || index < 0) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = SymbolLineNative.jni_Remove(this.getHandle(), index);
        if (bl) {
            SymbolLineBase symbolLineBase = this.m_symbolLineBaseList.remove(index);
            symbolLineBase.clearHandle();
        }
        return bl;
    }

    public boolean sendBackward(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("sendBackward", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index >= this.getCount() || index < 0) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = SymbolLineNative.jni_SendBackward(this.getHandle(), index);
        if (bl) {
            SymbolLineBase symbolLineBase = this.m_symbolLineBaseList.remove(index);
            this.m_symbolLineBaseList.add(index + 1, symbolLineBase);
        }
        return bl;
    }

    public boolean sendToBack(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("sendToBack", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index >= this.getCount() || index < 0) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = SymbolLineNative.jni_SendToBack(this.getHandle(), index);
        if (bl) {
            SymbolLineBase symbolLineBase = this.m_symbolLineBaseList.remove(index);
            this.m_symbolLineBaseList.add(this.getCount() - 1, symbolLineBase);
        }
        return bl;
    }

    public SymbolLineDecoration getDecoration(DecorationPositionType position) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDecoration", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = SymbolLineNative.jni_GetDecoration(this.getHandle(), position.getUGCValue());
        return new SymbolLineDecoration(l);
    }

    public void setDecoration(DecorationPositionType position, SymbolLineDecoration decoration) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDecoration", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (decoration == null) {
            String string = InternalResource.loadString("decoration", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(decoration);
        if (l == 0L) {
            String string = InternalResource.loadString("lineBase", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SymbolLineNative.jni_SetDecoration(this.getHandle(), position.getUGCValue(), l);
        decoration.makeSureNativeObjectLive();
    }
}

