/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.plot;

import com.supermap.data.GraphicObjectType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.plot.InternalEnum;
import com.supermap.plot.InternalResource;
import com.supermap.plot.SymbolInfoNative;
import com.supermap.plot.SymbolInfoNodeType;
import java.awt.Color;

public class SymbolInfo
extends InternalHandleDisposable {
    private SymbolInfo() {
        long l = SymbolInfoNative.jni_New();
        this.setHandle(l, true);
    }

    SymbolInfo(long handle) {
        this.setHandle(handle, false);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        SymbolInfoNative.jni_Delete(this.getHandle());
        this.clearHandle();
    }

    public SymbolInfoNodeType getInfoNodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInfoNodeType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = SymbolInfoNative.jni_GetNodeType(this.getHandle());
        SymbolInfoNodeType symbolInfoNodeType = null;
        symbolInfoNodeType = (SymbolInfoNodeType)InternalEnum.parseUGCValue(SymbolInfoNodeType.class, n);
        return symbolInfoNodeType;
    }

    public void setInfoNodeType(SymbolInfoNodeType nodeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInfoNodeType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolInfoNative.jni_SetNodeType(this.getHandle(), nodeType.value());
    }

    public GraphicObjectType getGraphicObjectType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGraphicObjectType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = SymbolInfoNative.jni_GetObjectType(this.getHandle());
        GraphicObjectType graphicObjectType = null;
        graphicObjectType = (GraphicObjectType)InternalEnum.parseUGCValue(GraphicObjectType.class, n);
        return graphicObjectType;
    }

    public void setGraphicObjectType(GraphicObjectType symbolType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGraphicObjectType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolInfoNative.jni_SetObjectType(this.getHandle(), symbolType.value());
    }

    public int getSymbolLibId() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolLibId()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolInfoNative.jni_GetSymbolLibId(this.getHandle());
    }

    public void setSymbolLibId(int libId) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolLibId()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolInfoNative.jni_SetSymbolLibId(this.getHandle(), libId);
    }

    public int getSymbolCode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolCode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolInfoNative.jni_GetSymbolCode(this.getHandle());
    }

    public void setSymbolCode(int code) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolCode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolInfoNative.jni_SetSymbolCode(this.getHandle(), code);
    }

    public int getChildSymbolCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChildSymbolCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolInfoNative.jni_GetChildCount(this.getHandle());
    }

    public SymbolInfo getChildSymbol(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChildSymbol()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = SymbolInfoNative.jni_GetChildSymbol(this.getHandle(), index);
        SymbolInfo symbolInfo = new SymbolInfo(l);
        return symbolInfo;
    }

    public String getSymbolName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolInfoNative.jni_GetSymbolName(this.getHandle());
    }

    public void setSymbolName(String symbolName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolInfoNative.jni_SetSymbolName(this.getHandle(), symbolName);
    }

    public int getInnerCode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInnerCode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolInfoNative.jni_GetInnerCode(this.getHandle());
    }

    public void setInnerCode(int innerCode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInnerCode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolInfoNative.jni_SetInnerCode(this.getHandle(), innerCode);
    }

    public int getDotMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDotMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolInfoNative.jni_GetDotMode(this.getHandle());
    }

    public void setDotMode(int dotMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDotMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolInfoNative.jni_SetDotMode(this.getHandle(), dotMode);
    }

    public int getRelationModelID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRelationModelID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolInfoNative.jni_GetRelationModelID(this.getHandle());
    }

    public void setRelationModelID(int modelID) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRelationModelID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolInfoNative.jni_SetRelationModelID(this.getHandle(), modelID);
    }

    public int getDotRankPos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDotRankPos()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolInfoNative.jni_GetDotRankPos(this.getHandle());
    }

    public void setDotRankPos(int rankPos) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDotRankPos()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolInfoNative.jni_SetDotRankPos(this.getHandle(), rankPos);
    }

    public int getDotRanksCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDotRanksCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolInfoNative.jni_GetDotRanksCount(this.getHandle());
    }

    public int[] getDotRanks() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDotRanks()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getDotRanksCount();
        if (0 == n) {
            return null;
        }
        int[] nArray = new int[n];
        SymbolInfoNative.jni_GetDotRanks(this.getHandle(), nArray);
        return nArray;
    }

    public void setDotRanks(int[] dotRanks) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDotRanks()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == dotRanks) {
            return;
        }
        SymbolInfoNative.jni_SetDotRanks(this.getHandle(), dotRanks);
    }

    public boolean getMiddleMarkExist() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMiddleMarkExist()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolInfoNative.jni_GetMiddleMarkExist(this.getHandle());
    }

    public void setMiddleMarkExist(boolean middleMarkExist) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMiddleMarkExist()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolInfoNative.jni_SetMiddleMarkExist(this.getHandle(), middleMarkExist);
    }

    public Rectangle2D getMiddleMarkBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMiddleMarkBounds()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        SymbolInfoNative.jni_GetMiddleMarkBounds(this.getHandle(), dArray);
        return new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public void setMiddleMarkBounds(Rectangle2D markBounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMiddleMarkBounds()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == markBounds) {
            return;
        }
        double[] dArray = new double[]{markBounds.getLeft(), markBounds.getBottom(), markBounds.getRight(), markBounds.getTop()};
        SymbolInfoNative.jni_SetMiddleMarkBounds(this.getHandle(), dArray);
    }

    public Point2D getAnchorPoint2D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnchorPoint2D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        SymbolInfoNative.jni_GetAnchorPoint2D(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setAnchorPoint2D(Point2D achorPoint) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnchorPoint2D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == achorPoint) {
            return;
        }
        SymbolInfoNative.jni_SetAnchorPoint2D(this.getHandle(), achorPoint.getX(), achorPoint.getY());
    }

    public Point2D getAnchorPoint3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnchorPoint3D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        SymbolInfoNative.jni_GetAnchorPoint3D(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setAnchorPoint3D(Point2D achorPoint) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnchorPoint3D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == achorPoint) {
            return;
        }
        SymbolInfoNative.jni_SetAnchorPoint3D(this.getHandle(), achorPoint.getX(), achorPoint.getY());
    }

    public Color getLineColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new Color(SymbolInfoNative.jni_GetLineColor(this.getHandle()));
    }

    public void setLineColor(Color lineColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolInfoNative.jni_SetLineColor(this.getHandle(), lineColor.getRGB());
    }
}

