/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.conversion.ExportSetting;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.InternalResource;
import java.io.File;

public class ExportSettingJPG
extends ExportSetting {
    private String m_worldFilePath;
    private int m_compression;

    public ExportSettingJPG() {
        this.m_worldFilePath = "";
        this.m_type = FileType.JPG;
        this.m_compression = 75;
    }

    public ExportSettingJPG(ExportSettingJPG exportSettingJPG) {
        super(exportSettingJPG);
        this.setWorldFilePath(exportSettingJPG.getWorldFilePath());
        this.setCompression(exportSettingJPG.getCompression());
        this.m_type = FileType.JPG;
    }

    public ExportSettingJPG(Object sourceData, String targetFilePath, FileType targetFileType) {
        super(sourceData, targetFilePath, targetFileType);
        this.m_worldFilePath = "";
        this.m_type = FileType.JPG;
        this.m_compression = 75;
    }

    public String getWorldFilePath() {
        return this.m_worldFilePath;
    }

    public void setWorldFilePath(String path) {
        File file;
        File file2 = new File(path);
        if (file2.isDirectory()) {
            String string = this.getTargetFilePath();
            File file3 = new File(string);
            path = path + file3.getName() + ".tga";
        } else if (file2.getParent() != null && !(file = new File(file2.getParent())).exists()) {
            String string = InternalResource.loadString("", "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_worldFilePath = path;
    }

    public int getCompression() {
        return this.m_compression;
    }

    public void setCompression(int value) {
        if (value < 0 || value > 100) {
            String string = InternalResource.loadString("transparentColor", "ExportSettingJPG_TheCompressionShouldBetweenZeroAndHundred", "conversion_resources");
            throw new NullPointerException(string);
        }
        this.m_compression = value;
    }

    @Override
    public FileType getTargetFileType() {
        return this.m_type;
    }

    @Override
    public void setTargetFileType(FileType type) {
        if (FileType.JPG != type) {
            String string = InternalResource.loadString("setTargetFileType(FileType type)", "SetTargetFileTypeIsNotAllowed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_type = FileType.JPG;
    }
}

