/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.ImportDataInfo;
import com.supermap.data.conversion.ImportDataInfoAiBinGrid;
import com.supermap.data.conversion.ImportDataInfoBIL;
import com.supermap.data.conversion.ImportDataInfoBIP;
import com.supermap.data.conversion.ImportDataInfoBMP;
import com.supermap.data.conversion.ImportDataInfoBSQ;
import com.supermap.data.conversion.ImportDataInfoCSV;
import com.supermap.data.conversion.ImportDataInfoCoverage;
import com.supermap.data.conversion.ImportDataInfoDBF;
import com.supermap.data.conversion.ImportDataInfoDGN;
import com.supermap.data.conversion.ImportDataInfoDWG;
import com.supermap.data.conversion.ImportDataInfoDXF;
import com.supermap.data.conversion.ImportDataInfoE00;
import com.supermap.data.conversion.ImportDataInfoECW;
import com.supermap.data.conversion.ImportDataInfoEGC;
import com.supermap.data.conversion.ImportDataInfoFileGDBVector;
import com.supermap.data.conversion.ImportDataInfoGBDEM;
import com.supermap.data.conversion.ImportDataInfoGIF;
import com.supermap.data.conversion.ImportDataInfoGJB;
import com.supermap.data.conversion.ImportDataInfoGML;
import com.supermap.data.conversion.ImportDataInfoGPKG;
import com.supermap.data.conversion.ImportDataInfoGRD;
import com.supermap.data.conversion.ImportDataInfoGRIB;
import com.supermap.data.conversion.ImportDataInfoGeoJson;
import com.supermap.data.conversion.ImportDataInfoIMG;
import com.supermap.data.conversion.ImportDataInfoJP2;
import com.supermap.data.conversion.ImportDataInfoJPG;
import com.supermap.data.conversion.ImportDataInfoKML;
import com.supermap.data.conversion.ImportDataInfoKMZ;
import com.supermap.data.conversion.ImportDataInfoLIDAR;
import com.supermap.data.conversion.ImportDataInfoMAPGIS;
import com.supermap.data.conversion.ImportDataInfoMIF;
import com.supermap.data.conversion.ImportDataInfoMrSID;
import com.supermap.data.conversion.ImportDataInfoNetCDF;
import com.supermap.data.conversion.ImportDataInfoOSM;
import com.supermap.data.conversion.ImportDataInfoOrangeTab;
import com.supermap.data.conversion.ImportDataInfoPNG;
import com.supermap.data.conversion.ImportDataInfoPersonalGDBVector;
import com.supermap.data.conversion.ImportDataInfoRAW;
import com.supermap.data.conversion.ImportDataInfoSCV;
import com.supermap.data.conversion.ImportDataInfoSDEVector;
import com.supermap.data.conversion.ImportDataInfoSHP;
import com.supermap.data.conversion.ImportDataInfoSIT;
import com.supermap.data.conversion.ImportDataInfoTAB;
import com.supermap.data.conversion.ImportDataInfoTEMSBuildingVector;
import com.supermap.data.conversion.ImportDataInfoTEMSClutter;
import com.supermap.data.conversion.ImportDataInfoTEMSTextLabels;
import com.supermap.data.conversion.ImportDataInfoTEMSVector;
import com.supermap.data.conversion.ImportDataInfoTIF;
import com.supermap.data.conversion.ImportDataInfoUSGSDEM;
import com.supermap.data.conversion.ImportDataInfoVCT;
import com.supermap.data.conversion.ImportDataInfoVRT;
import com.supermap.data.conversion.ImportDataInfoWOR;
import com.supermap.data.conversion.ImportDataInfosNative;
import com.supermap.data.conversion.ImportSettingWORNative;
import com.supermap.data.conversion.InternalHandle;
import com.supermap.data.conversion.InternalResource;
import java.util.ArrayList;

public class ImportDataInfos
extends InternalHandle {
    private ArrayList<ImportDataInfo> m_importDataInfos = new ArrayList();
    private ArrayList<Boolean> m_states = new ArrayList();
    private DataType m_DataType;

    ImportDataInfos(long handle, FileType fileType, DataType dataType, String filePath, String targetName) {
        this.m_DataType = dataType;
        this.setHandle(handle);
        if (this.m_DataType.equals((Object)DataType.WOR)) {
            String[] stringArray = ImportSettingWORNative.jni_GetDataInfosDatasetNames(this.getHandle());
            String[] stringArray2 = ImportSettingWORNative.jni_GetDataInfosMapNames(this.getHandle());
            ImportDataInfoWOR importDataInfoWOR = new ImportDataInfoWOR(stringArray, stringArray2, filePath);
            this.m_importDataInfos.add(importDataInfoWOR);
            this.m_states.add(false);
        } else if (this.m_DataType.equals((Object)DataType.VECTOR)) {
            int n = ImportDataInfosNative.jni_GetCount(handle);
            for (int i = 0; i < n; ++i) {
                long l = ImportDataInfosNative.jni_GetItem(handle, i);
                if (l == 0L) continue;
                ImportDataInfo importDataInfo = this.createInstance(l, filePath, fileType, targetName);
                this.m_importDataInfos.add(importDataInfo);
                this.m_states.add(false);
            }
        } else {
            int n = ImportDataInfosNative.jni_GetRasterCount(handle);
            for (int i = 0; i < n; ++i) {
                long l = ImportDataInfosNative.jni_GetRasterItem(handle, i);
                if (l == 0L) continue;
                ImportDataInfo importDataInfo = this.createInstance(l, filePath, fileType, targetName);
                this.m_importDataInfos.add(importDataInfo);
                this.m_states.add(false);
            }
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this.m_importDataInfos.size();
    }

    public ImportDataInfo get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(enclosing_method_argumenttypes_and_arguments)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "conversion_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_importDataInfos.get(index);
    }

    public void setImportState(int index, boolean excludeDataInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportState(int index, boolean excludeDataInfo)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (!this.m_DataType.equals((Object)DataType.WOR)) {
            this.m_states.set(index, excludeDataInfo);
        }
    }

    public boolean getImportState(int index) {
        return this.m_states.get(index);
    }

    ArrayList<Boolean> getStates() {
        return this.m_states;
    }

    void setStates(ArrayList<Boolean> states) {
        this.m_states = (ArrayList)states.clone();
    }

    protected void clearHandle() {
        int n = this.m_importDataInfos.size();
        if (!this.m_DataType.equals((Object)DataType.WOR)) {
            for (int i = 0; i < n; ++i) {
                ImportDataInfo importDataInfo = this.m_importDataInfos.get(i);
                importDataInfo.clearHandle();
            }
        }
        this.m_importDataInfos.clear();
        this.m_importDataInfos = null;
    }

    protected void finalize() {
        if (this.getHandle() != 0L) {
            if (this.m_DataType.equals((Object)DataType.VECTOR)) {
                ImportDataInfosNative.jni_Delete(this.getHandle());
            } else if (this.m_DataType.equals((Object)DataType.RASTER)) {
                ImportDataInfosNative.jni_Delete2(this.getHandle());
            }
        }
    }

    private ImportDataInfo createInstance(long handle, String filePath, FileType fileType, String targetName) {
        ImportDataInfo importDataInfo = null;
        if (fileType.equals((Object)FileType.MIF)) {
            importDataInfo = new ImportDataInfoMIF(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.TAB)) {
            importDataInfo = new ImportDataInfoTAB(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.DBF)) {
            importDataInfo = new ImportDataInfoDBF(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.PNG)) {
            importDataInfo = new ImportDataInfoPNG(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.TIF)) {
            importDataInfo = new ImportDataInfoTIF(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.IMG)) {
            importDataInfo = new ImportDataInfoIMG(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.GRD)) {
            importDataInfo = new ImportDataInfoGRD(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.SHP)) {
            importDataInfo = new ImportDataInfoSHP(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.COVERAGE)) {
            importDataInfo = new ImportDataInfoCoverage(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.DWG)) {
            importDataInfo = new ImportDataInfoDWG(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.DXF)) {
            importDataInfo = new ImportDataInfoDXF(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.KML)) {
            importDataInfo = new ImportDataInfoKML(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.KMZ)) {
            importDataInfo = new ImportDataInfoKMZ(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.MAPGIS)) {
            importDataInfo = new ImportDataInfoMAPGIS(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.GIF)) {
            importDataInfo = new ImportDataInfoGIF(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.JPG)) {
            importDataInfo = new ImportDataInfoJPG(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.RAW)) {
            importDataInfo = new ImportDataInfoRAW(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.SIT)) {
            importDataInfo = new ImportDataInfoSIT(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.BMP)) {
            importDataInfo = new ImportDataInfoBMP(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.GRIB)) {
            importDataInfo = new ImportDataInfoGRIB(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.TEMSBuildingVector)) {
            importDataInfo = new ImportDataInfoTEMSBuildingVector(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.TEMSVector)) {
            importDataInfo = new ImportDataInfoTEMSVector(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.TEMSTEXT)) {
            importDataInfo = new ImportDataInfoTEMSTextLabels(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.TEMSClutter)) {
            importDataInfo = new ImportDataInfoTEMSClutter(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.CSV)) {
            importDataInfo = new ImportDataInfoCSV(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.SCV)) {
            importDataInfo = new ImportDataInfoSCV(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.GML)) {
            importDataInfo = new ImportDataInfoGML(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.E00)) {
            importDataInfo = new ImportDataInfoE00(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.SDEVector)) {
            importDataInfo = new ImportDataInfoSDEVector(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.FileGDBVector)) {
            importDataInfo = new ImportDataInfoFileGDBVector(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.DGN)) {
            importDataInfo = new ImportDataInfoDGN(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.VCT)) {
            importDataInfo = new ImportDataInfoVCT(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.GJB5068)) {
            importDataInfo = new ImportDataInfoGJB(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.USGSDEM)) {
            importDataInfo = new ImportDataInfoUSGSDEM(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.GBDEM)) {
            importDataInfo = new ImportDataInfoGBDEM(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.BIL)) {
            importDataInfo = new ImportDataInfoBIL(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.BIP)) {
            importDataInfo = new ImportDataInfoBIP(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.BSQ)) {
            importDataInfo = new ImportDataInfoBSQ(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.LIDAR)) {
            importDataInfo = new ImportDataInfoLIDAR(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.ARCINFO_BINGRID)) {
            importDataInfo = new ImportDataInfoAiBinGrid(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.MrSID)) {
            importDataInfo = new ImportDataInfoMrSID(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.ECW)) {
            importDataInfo = new ImportDataInfoECW(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.JP2)) {
            importDataInfo = new ImportDataInfoJP2(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.EGC)) {
            importDataInfo = new ImportDataInfoEGC(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.GeoPackage)) {
            importDataInfo = new ImportDataInfoGPKG(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.ORANGETAB)) {
            importDataInfo = new ImportDataInfoOrangeTab(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.GEOJSON)) {
            importDataInfo = new ImportDataInfoGeoJson(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.OSM)) {
            importDataInfo = new ImportDataInfoOSM(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.PersonalGDBVector)) {
            importDataInfo = new ImportDataInfoPersonalGDBVector(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.VRT)) {
            importDataInfo = new ImportDataInfoVRT(handle, filePath, fileType, targetName);
        } else if (fileType.equals((Object)FileType.NetCDF)) {
            importDataInfo = new ImportDataInfoNetCDF(handle, filePath, fileType, targetName);
        } else {
            throw new RuntimeException("$$$\u76f8\u5173\u7c7b\u578b\u8fd8\u672a\u5b9e\u73b0");
        }
        return importDataInfo;
    }
}

