/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.SpatialIndexInfo;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingDWGNative;
import com.supermap.data.conversion.ImportSettingDXFNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.InternalSpatialIndexInfo;
import java.io.File;

public class ImportSettingDXF
extends ImportSetting {
    public ImportSettingDXF() {
        long l = ImportSettingDXFNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingDXF(ImportSettingDXF ImportSettingDXF2) {
        if (ImportSettingDXF2 == null) {
            String string = InternalResource.loadString("ImportSettingDXF", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)ImportSettingDXF2);
        if (l == 0L) {
            String string = InternalResource.loadString("ImportSettingDXF", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingDXFNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(ImportSettingDXF2.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(ImportSettingDXF2.getTargetDatasource());
        this.setTargetPrjCoordSys(ImportSettingDXF2.getTargetPrjCoordSys());
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)ImportSettingDXF2));
    }

    public ImportSettingDXF(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public ImportSettingDXF(String sourceFilePath, Datasource targetDatasource) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingDXF(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo, boolean importingAsCAD) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        this.setImportingAsCAD(importingAsCAD);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public boolean isImportingAsCAD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingAsCAD()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportingAsCAD(this.getHandle());
    }

    public void setImportingAsCAD(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsCAD(boolean value)", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportingAsCAD(this.getHandle(), value);
    }

    public SpatialIndexInfo getSpatialIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpatialIndex()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ImportSettingDXFNative.jni_GetSpatialIndex(this.getHandle());
        return InternalSpatialIndexInfo.createInstance(l);
    }

    public void setSpatialIndex(SpatialIndexInfo value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpatialIndex(SpatialIndex value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetSpatialIndex(this.getHandle(), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)value));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    @Deprecated
    public SpatialIndexInfo getSpatialIndexType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpatialIndexType()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ImportSettingDXFNative.jni_GetSpatialIndex(this.getHandle());
        return InternalSpatialIndexInfo.createInstance(l);
    }

    @Deprecated
    public void setSpatialIndexType(SpatialIndexInfo value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpatialIndexType(SpatialIndexType value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetSpatialIndex(this.getHandle(), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)value));
    }

    public boolean isImportingBlockAsPoint() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingSymbolBlockAsPoint()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportingBlockAsPoint(this.getHandle());
    }

    public void setImportingBlockAsPoint(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingSymbolBlockAsPoint(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportingBlockAsPoint(this.getHandle(), value);
    }

    public boolean isLWPLineWidthIgnored() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsLWPLineWidthIgnored()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsLWPLineWidthIgnored(this.getHandle());
    }

    public void setLWPLineWidthIgnored(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsLWPLineWidthIgnored(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetIsLWPLineWidthIgnored(this.getHandle(), value);
    }

    public boolean isBlockAttributeIgnored() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsLWPLineWidthIgnored()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDWGNative.jni_IsBlockAttributeIgnored(this.getHandle());
    }

    public void setBlockAttributeIgnored(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsLWPLineWidthIgnored(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDWGNative.jni_SetIsBlockAttributeIgnored(this.getHandle(), value);
    }

    @Deprecated
    public void setIsLWPLineWidthIgnored(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsLWPLineWidthIgnored(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetIsLWPLineWidthIgnored(this.getHandle(), value);
    }

    public int getCurveSegment() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurveSegment()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_GetCurveSegment(this.getHandle());
    }

    public void setCurveSegment(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCurveSegment(int value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetCurveSegment(this.getHandle(), value);
    }

    public boolean isImportingExternalData() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingExternalData()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportingExternalData(this.getHandle());
    }

    public void setImportingExternalData(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingExternalData(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportingExternalData(this.getHandle(), value);
    }

    public boolean isImportingXRecord() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isIgnoredXRecord()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportingXRecord(this.getHandle());
    }

    public void setImportingXRecord(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoredXRecord(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportingXRecord(this.getHandle(), value);
    }

    public boolean isImportingByLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingByLayer()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportingByLayer(this.getHandle());
    }

    public void setImportingByLayer(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingByLayer(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportingByLayer(this.getHandle(), value);
    }

    public boolean isImportingInvisibleLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingInvisibleLayer()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportingInvisibleLayer(this.getHandle());
    }

    public void setImportingInvisibleLayer(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingInvisibleLayer(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportingInvisibleLayer(this.getHandle(), value);
    }

    public boolean isImporttingAs3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImporttingAs3D()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportingAs3D(this.getHandle());
    }

    public void setImporttingAs3D(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImporttingAs3D()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportingAs3D(this.getHandle(), value);
    }

    public boolean isKeepingParametricPart() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsKeepingParametricPart()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsKeepingParametricPart(this.getHandle());
    }

    public void setKeepingParametricPart(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetKeepingParametricPart()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetKeepingParametricPart(this.getHandle(), value);
    }

    public String getStyleMappingTableFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyleMapFilePath()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingDXFNative.jni_GetStyleMapFilePath(this.getHandle());
    }

    public void setStyleMappingTableFile(String path) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyleMapFilePath(String path)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (path == null || path.trim().length() == 0) {
            String string = InternalResource.loadString("path", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(path);
        if (!file.exists()) {
            String string = InternalResource.loadString(file.getAbsolutePath(), "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetStyleMapFilePath(this.getHandle(), path);
    }

    public void setShxPaths(String[] filePaths) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShxPaths()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (filePaths.length == 0) {
            return;
        }
        ImportSettingDXFNative.jni_SetShxPaths(this.getHandle(), filePaths);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingDXFNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }

    public void setImportEmptyDataset(boolean bImportEmptyDT) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDXFNative.jni_SetImportEmptyDT(this.getHandle(), bImportEmptyDT);
    }

    public boolean isImportEmptyDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDXFNative.jni_IsImportEmptyDT(this.getHandle());
    }
}

