/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.analyst.addressmatching.InternalResource;

public class AddressSearchSetting {
    private int m_maxResultCount;
    private String m_searchDirectory;
    private String m_nameTopGroup;
    private String m_nameSecondaryGroup;
    private String m_nameLowestGroup;
    private boolean m_isLocationReturn;
    private boolean m_isAddressSegmented;

    public AddressSearchSetting() {
        this.m_isLocationReturn = true;
        this.m_isAddressSegmented = false;
        this.m_maxResultCount = 10;
        this.m_nameTopGroup = "";
        this.m_nameSecondaryGroup = "";
        this.m_nameLowestGroup = "";
    }

    public AddressSearchSetting(AddressSearchSetting addressSearchSetting) {
        if (addressSearchSetting == null) {
            String string = InternalResource.loadString("addressLoadSetting", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_maxResultCount = addressSearchSetting.getMaxResultCount();
        this.m_searchDirectory = addressSearchSetting.getSearchDirectory();
        this.m_nameTopGroup = addressSearchSetting.getTopGroupName();
        this.m_nameSecondaryGroup = addressSearchSetting.getSecondaryGroupName();
        this.m_nameLowestGroup = addressSearchSetting.getLowestGroupName();
        this.m_isLocationReturn = addressSearchSetting.isLocationReturn();
        this.m_isAddressSegmented = addressSearchSetting.isAddressSegmented();
    }

    public String getSearchDirectory() {
        return this.m_searchDirectory;
    }

    public void setSearchDirectory(String value) {
        if (value == null) {
            String string = InternalResource.loadString("setLoadDirectory(String value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_searchDirectory = value;
    }

    public int getMaxResultCount() {
        return this.m_maxResultCount;
    }

    public void setMaxResultCount(int value) {
        if (value <= 0) {
            String string = InternalResource.loadString("value", "Global_ShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_maxResultCount = value;
    }

    public String getTopGroupName() {
        return this.m_nameTopGroup;
    }

    public void setTopGroupName(String value) {
        if (value == null) {
            String string = InternalResource.loadString("setTopGroupName(String value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_nameTopGroup = value;
    }

    public String getSecondaryGroupName() {
        return this.m_nameSecondaryGroup;
    }

    public void setSecondaryGroupName(String value) {
        if (value == null) {
            String string = InternalResource.loadString("setSecondaryGroupName(String value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_nameSecondaryGroup = value;
    }

    public String getLowestGroupName() {
        return this.m_nameLowestGroup;
    }

    public void setLowestGroupName(String value) {
        if (value == null) {
            String string = InternalResource.loadString("setLowestGroupName(String value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_nameLowestGroup = value;
    }

    public boolean isLocationReturn() {
        return this.m_isLocationReturn;
    }

    public void setLocationReturn(boolean value) {
        this.m_isLocationReturn = value;
    }

    public boolean isAddressSegmented() {
        return this.m_isAddressSegmented;
    }

    public void setAddressSegmented(boolean value) {
        this.m_isAddressSegmented = value;
    }
}

