/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Colors;
import com.supermap.data.DatasetGrid;
import com.supermap.data.NetCDFVarInfo;
import com.supermap.mapping.InternalColors;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.LayerSetting;
import com.supermap.mapping.LayerSettingType;
import com.supermap.mapping.Layers;
import java.awt.Color;

public class LayerSettingNetCDF
extends LayerSetting {
    private Colors m_colorTable = null;
    private Color m_specialValueColor = Color.black;
    private Layer m_layer = null;
    private Layers m_layers = null;
    boolean isOwnerLayer = false;
    private double m_specialValue;
    boolean is_set = false;
    private int m_Brightness = 0;
    private int m_Contrast = 0;
    private int m_OpaqueRate = 100;
    private boolean m_SpecialValueTransparent = false;
    private NetCDFVarInfo m_NetCDFVarInfo;

    public LayerSettingNetCDF() {
        Colors colors = new Colors();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this.m_colorTable = InternalColors.createInstance(l, false);
        this.m_NetCDFVarInfo = new NetCDFVarInfo();
        this.isOwnerLayer = false;
    }

    public LayerSettingNetCDF(LayerSettingNetCDF layerSettingNetCDF) {
        if (layerSettingNetCDF == null) {
            String string = InternalResource.loadString("layerSettingGrid", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (layerSettingNetCDF.isOwnerLayer) {
            if (layerSettingNetCDF.m_layer == null) {
                String string = InternalResource.loadString("layerSettingGrid", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle(layerSettingNetCDF.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("layerSettingGrid", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        Colors colors = new Colors(layerSettingNetCDF.getColorTable());
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        this.m_colorTable = InternalColors.createInstance(l, false);
        this.m_NetCDFVarInfo = new NetCDFVarInfo(layerSettingNetCDF.m_NetCDFVarInfo);
        this.isOwnerLayer = false;
    }

    LayerSettingNetCDF(Layer layer, Layers layers) {
        this.m_layer = layer;
        this.m_layers = layers;
        DatasetGrid datasetGrid = (DatasetGrid)layer.getDataset();
        this.m_NetCDFVarInfo = new NetCDFVarInfo(datasetGrid.getNetCDFVarInfo());
        this.isOwnerLayer = true;
    }

    @Override
    public LayerSettingType getType() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getType()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getType()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        return LayerSettingType.NetCDF;
    }

    public Colors getColorTable() {
        if (this.isOwnerLayer) {
            long l;
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getColorTable()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle(this.m_layer);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getColorTable()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_colorTable == null && (l = LayerNative.jni_GetColorTable(l2)) != 0L) {
                this.m_colorTable = InternalColors.createInstance(l, false);
            }
        }
        return this.m_colorTable;
    }

    public void setColorTable(Colors colorTable) {
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setColorTable(Colors colorTable)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setColorTable(Colors colorTable)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (colorTable == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)colorTable) == 0L) {
            String string = InternalResource.loadString("colorTable", "LayerSettingGrid_InvalidColors", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        Colors colors = new Colors(colorTable);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)colors);
        if (this.isOwnerLayer) {
            LayerNative.jni_SetColorTable(l, l2);
        } else if (this.m_colorTable == null) {
            this.m_colorTable = InternalColors.createInstance(l2, false);
        } else {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)colors, false);
            InternalColors.changeHandle(this.m_colorTable, l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colors);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)colorTable);
    }

    public Color getSpecialValueColor() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getSpecialValueColor()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getSpecialValueColor()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = LayerNative.jni_GetGridSpecialValueColor(l);
            return new Color(n, true);
        }
        return this.m_specialValueColor;
    }

    public void setSpecialValueColor(Color value) {
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setSpecialValueColor(Color value)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setSpecialValueColor(Color value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetGridSpecialValueColor(l, value.getRGB());
        }
        this.m_specialValueColor = new Color(value.getRGB(), true);
    }

    public double getSpecialValue() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getSpecialValue()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getSpecialValue()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_specialValue = LayerNative.jni_getGridSpecialValue(l);
        }
        return this.m_specialValue;
    }

    public void setSpecialValue(double value) {
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setSpecialValue(double value)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setSpecialValue(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_setGridSpecialValue(l, value);
        }
        this.is_set = true;
        this.m_specialValue = value;
    }

    public int getBrightness() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getBrightness()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getBrightness()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_Brightness = LayerNative.jni_GetBrightness(l);
        }
        return this.m_Brightness;
    }

    public void setBrightness(int brightness) {
        if (brightness < -100 || brightness > 100) {
            String string = InternalResource.loadString("brightness", "GlobalArgument_OutOfBounds", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setBrightness(int brightness)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setBrightness(int brightness)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_setBrightness(l, brightness);
        }
        this.m_Brightness = brightness;
    }

    public int getContrast() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getContrast()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getContrast()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_Contrast = LayerNative.jni_GetContrast(l);
        }
        return this.m_Contrast;
    }

    public void setContrast(int contrast) {
        if (contrast < -100 || contrast > 100) {
            String string = InternalResource.loadString("contrast", "GlobalArgument_OutOfBounds", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setContrast(int contrast)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setContrast(int contrast)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_setContrast(l, contrast);
        }
        this.m_Contrast = contrast;
    }

    public int getOpaqueRate() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("getOpaqueRate()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("getOpaqueRate()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_OpaqueRate = LayerNative.jni_GridGetOpaqueRate(l);
        }
        return this.m_OpaqueRate;
    }

    public void setOpaqueRate(int opaqueRate) {
        if (opaqueRate < 0 || opaqueRate > 100) {
            String string = InternalResource.loadString("contrast", "GlobalArgument_OutOfBounds", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setOpaqueRate(int opaqueRate)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setOpaqueRate(int opaqueRate)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetGridOpaqueRate(l, opaqueRate);
        }
        this.m_OpaqueRate = opaqueRate;
    }

    public boolean isSpecialValueTransparent() {
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("isSpecialValueTransparent()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("isSpecialValueTransparent()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_SpecialValueTransparent = LayerNative.jni_GetSpecialValueTransparent(l);
        }
        return this.m_SpecialValueTransparent;
    }

    public void setSpecialValueTransparent(boolean specialValueTransparent) {
        long l = 0L;
        if (this.isOwnerLayer) {
            if (this.m_layer == null) {
                String string = InternalResource.loadString("setSpecialValueTransparent(boolean specialValueTransparent)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle(this.m_layer);
            if (l == 0L) {
                String string = InternalResource.loadString("setSpecialValueTransparent(boolean specialValueTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetSpecialValueTransparent(l, specialValueTransparent);
        }
        this.m_SpecialValueTransparent = specialValueTransparent;
    }

    public String getXDimension() {
        return this.m_NetCDFVarInfo.getXDimension();
    }

    public boolean setXDimension(String value) {
        return this.m_NetCDFVarInfo.setXDimension(value);
    }

    public int getXStartIndex() {
        return this.m_NetCDFVarInfo.getXStartIndex();
    }

    public boolean setXStartIndex(int value) {
        return this.m_NetCDFVarInfo.setXStartIndex(value);
    }

    public int getXEndIndex() {
        return this.m_NetCDFVarInfo.getXEndIndex();
    }

    public boolean setXEndIndex(int value) {
        return this.m_NetCDFVarInfo.setXEndIndex(value);
    }

    public String getYDimension() {
        return this.m_NetCDFVarInfo.getYDimension();
    }

    public boolean setYDimension(String value) {
        return this.m_NetCDFVarInfo.setYDimension(value);
    }

    public int getYStartIndex() {
        return this.m_NetCDFVarInfo.getYStartIndex();
    }

    public boolean setYStartIndex(int value) {
        return this.m_NetCDFVarInfo.setYStartIndex(value);
    }

    public int getYEndIndex() {
        return this.m_NetCDFVarInfo.getYEndIndex();
    }

    public boolean setYEndIndex(int value) {
        return this.m_NetCDFVarInfo.setYEndIndex(value);
    }

    public String getOptionalDimension() {
        return this.m_NetCDFVarInfo.getOptionalDimension();
    }

    public boolean setOptionalDimension(String value) {
        return this.m_NetCDFVarInfo.setOptionalDimension(value);
    }

    public int getOptionalDimIndex() {
        return this.m_NetCDFVarInfo.getOptionalDimIndex();
    }

    public boolean setOptionalDimIndex(int value) {
        return this.m_NetCDFVarInfo.setOptionalDimIndex(value);
    }

    protected void finalize() {
        if (this.m_colorTable != null) {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_colorTable, true);
            this.m_colorTable.dispose();
        }
    }

    @Override
    void clearHandle() {
        if (this.m_colorTable != null) {
            InternalColors.clearHandle(this.m_colorTable);
            this.m_colorTable = null;
        }
        this.m_layer = null;
        this.m_layers = null;
    }
}

