/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.GeoMap;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalPrjCoordSys;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.LayerPainterNative;
import com.supermap.mapping.Map;
import com.supermap.mapping.Theme;
import com.supermap.ui.InternalBufferImage;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ArrayList;

public class MapPainter
extends InternalHandle {
    protected long graphicsHandle;
    private InternalBufferImage m_bufferImage = null;
    protected Graphics m_graphics = null;
    protected PrjCoordSys m_prjCoordSys = null;

    MapPainter(Map map, long graphicsHandle) {
        this.setHandle(LayerPainterNative.jni_GetLayerPainterHandle(InternalHandle.getHandle((com.supermap.data.InternalHandle)map)));
        this.graphicsHandle = graphicsHandle;
    }

    MapPainter(long drawingHandle, long graphicsHandle) {
        this.setHandle(drawingHandle);
        this.graphicsHandle = graphicsHandle;
    }

    public Graphics getGraphics() {
        long l;
        if (this.m_graphics == null && (l = LayerPainterNative.jni_GetBufferImageHandle(this.graphicsHandle)) != 0L) {
            this.m_bufferImage = new InternalBufferImage(l, true);
            this.m_graphics = this.m_bufferImage.getInternalImage().getGraphics();
        }
        return this.m_graphics;
    }

    public Image getImage() {
        if (this.m_bufferImage != null) {
            return this.m_bufferImage.getInternalImage();
        }
        return null;
    }

    public Dimension getImageSize() {
        Dimension dimension = new Dimension();
        int[] nArray = new int[2];
        LayerPainterNative.jni_GetBufferImageSize(this.graphicsHandle, nArray);
        dimension.height = nArray[1];
        dimension.width = nArray[0];
        return dimension;
    }

    void realeaseGraphics() {
        if (this.m_graphics != null) {
            this.m_graphics.dispose();
            this.m_graphics = null;
        }
        if (this.m_bufferImage != null) {
            this.m_bufferImage.dispose();
            this.m_bufferImage = null;
        }
    }

    public void drawGeometry(Geometry geometry) {
        if (geometry instanceof GeoMap) {
            throw new IllegalArgumentException();
        }
        LayerPainterNative.jni_DrawGeometry(this.getHandle(), this.graphicsHandle, InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
    }

    public void drawGeometry(Iterable<Geometry> geometries, GeoStyle style) {
        Object object2;
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (Object object2 : geometries) {
            if (object2 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)object2) == 0L) continue;
            arrayList.add((Geometry)object2);
        }
        object2 = new long[arrayList.size()];
        for (int i = 0; i < ((Geometry)object2).length; ++i) {
            object2[i] = (Geometry)InternalHandle.getHandle((com.supermap.data.InternalHandle)arrayList.get(i));
        }
        long l = 0L;
        if (style != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        }
        LayerPainterNative.jni_DrawGeometries(this.getHandle(), this.graphicsHandle, (long[])object2, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
        InternalHandleDisposable.makeSureNativeObjectLive(arrayList);
    }

    public void drawLabel(ArrayList<Geometry> geos, ArrayList<String> labels, Theme theme) {
        long[] lArray = new long[geos.size()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geos.get(i));
        }
        LayerPainterNative.DrawLabel(this.getHandle(), this.graphicsHandle, lArray, labels, InternalHandle.getHandle((com.supermap.data.InternalHandle)theme), true);
    }

    public Rectangle2D getMapDrawingBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        LayerPainterNative.jni_GetDrawingBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public PrjCoordSys getMapDrawingPrj() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_prjCoordSys == null && (l = LayerPainterNative.jni_GetMapPrjCoordSys(this.getHandle())) != 0L) {
            this.m_prjCoordSys = InternalPrjCoordSys.createInstance(l, false);
        }
        return this.m_prjCoordSys;
    }

    void copyBufferImageToUGC() {
        if (this.m_bufferImage != null) {
            this.m_bufferImage.setMemoryImageToUGC();
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_bufferImage);
            if (l != 0L) {
                LayerPainterNative.jni_CopyBufferImageToUGC(this.graphicsHandle, l);
            }
        }
    }

    public void dispose() {
        this.clearHandle();
    }
}

