/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.ColorGradientType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Enum;
import com.supermap.data.GeoStyle;
import com.supermap.data.JoinItems;
import com.supermap.data.Size2D;
import com.supermap.data.TextStyle;
import com.supermap.data.Toolkit;
import com.supermap.mapping.AlongLineCulture;
import com.supermap.mapping.AlongLineDirection;
import com.supermap.mapping.AlongLineDrawingMode;
import com.supermap.mapping.AlongLineLabelMode;
import com.supermap.mapping.AvoidMode;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalTextStyle;
import com.supermap.mapping.LabelBackShape;
import com.supermap.mapping.LabelMatrix;
import com.supermap.mapping.LabelType;
import com.supermap.mapping.MixedTextStyle;
import com.supermap.mapping.OverLengthLabelMode;
import com.supermap.mapping.RangeMode;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeLabelItem;
import com.supermap.mapping.ThemeLabelNative;
import com.supermap.mapping.ThemeLabelRangeItems;
import com.supermap.mapping.ThemeLabelUniqueItems;
import java.util.ArrayList;

public class ThemeLabel
extends Theme {
    private ArrayList m_labelItems = null;
    private GeoStyle m_backStyle = null;
    private GeoStyle m_leaderLineStyle = null;
    private TextStyle m_uniformStyle = null;
    private MixedTextStyle m_mixedTextStyle = null;
    private LabelMatrix m_labelMatrix = null;
    private ThemeLabel m_themeLabel = null;
    private Size2D m_size2D;
    private RangeMode m_rangeMode;
    private ThemeLabelRangeItems m_ThemeLabelRangeItems = null;
    private ThemeLabelUniqueItems m_ThemeLabelUniqueItems = null;

    public ThemeLabel() {
        long l = ThemeLabelNative.jni_New();
        this.setHandle(l, true);
        this.reset();
        this.m_labelItems = new ArrayList();
        this.m_rangeMode = RangeMode.NONE;
        this.m_ThemeLabelRangeItems = new ThemeLabelRangeItems(this);
        this.m_ThemeLabelUniqueItems = new ThemeLabelUniqueItems(this);
    }

    public ThemeLabel(ThemeLabel themeLabel) {
        if (themeLabel == null) {
            String string = InternalResource.loadString("themeLabel", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeLabel.getHandle() == 0L) {
            String string = InternalResource.loadString("themeLabel", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeLabelNative.jni_Clone(themeLabel.getHandle());
        this.setHandle(l, true);
        this.m_labelItems = new ArrayList();
        int n = themeLabel.getLabelItemsList().size();
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeLabel));
        for (int i = 0; i < n; ++i) {
            ThemeLabelItem themeLabelItem = new ThemeLabelItem(this);
            this.m_labelItems.add(themeLabelItem);
        }
        this.m_ThemeLabelRangeItems = new ThemeLabelRangeItems(this);
        this.m_ThemeLabelUniqueItems = new ThemeLabelUniqueItems(this);
        this.m_rangeMode = RangeMode.NONE;
    }

    ThemeLabel(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
        int n = ThemeLabelNative.jni_GetValueCount(this.getHandle());
        this.m_labelItems = new ArrayList();
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            ThemeLabelItem themeLabelItem = new ThemeLabelItem(this);
            this.m_labelItems.add(themeLabelItem);
        }
        this.m_ThemeLabelRangeItems = new ThemeLabelRangeItems(this);
        this.m_ThemeLabelUniqueItems = new ThemeLabelUniqueItems(this);
        this.m_rangeMode = RangeMode.NONE;
    }

    @Deprecated
    public ThemeLabelItem getItem(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return (ThemeLabelItem)this.m_labelItems.get(index);
    }

    @Deprecated
    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetValueCount(this.getHandle());
        int n2 = 0;
        n2 = n == 0 || n == 1 ? 0 : n - 1;
        return n2;
    }

    public GeoStyle getBackStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBackStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_backStyle == null && (l = ThemeLabelNative.jni_GetBackStyle(this.getHandle())) != 0L) {
            this.m_backStyle = InternalGeoStyle.createInstance(l);
        }
        return this.m_backStyle;
    }

    public void setBackStyle(GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBackStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle = style.clone();
        long l2 = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geoStyle);
        ThemeLabelNative.jni_SetBackStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    public LabelBackShape getBackShape() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBackShape()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetBackShape(this.getHandle());
        return (LabelBackShape)InternalEnum.parseUGCValue(LabelBackShape.class, n);
    }

    public void setBackShape(LabelBackShape value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBackShape(LabelBackShape value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(value);
        ThemeLabelNative.jni_SetBackShape(this.getHandle(), n);
    }

    public int getMaxLabelLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxLabelLength()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetMaxLabelLength(this.getHandle());
    }

    public void setMaxLabelLength(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxLabelLength(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "ThemeLabel_TheArgumentOfMaxLabelLengthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeLabelNative.jni_SetMaxLabelLength(this.getHandle(), value);
    }

    public OverLengthLabelMode getOverLengthMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOverLengthMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetOverLengthMode(this.getHandle());
        return (OverLengthLabelMode)InternalEnum.parseUGCValue(OverLengthLabelMode.class, n);
    }

    public void setOverLengthMode(OverLengthLabelMode value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverLenghMode(OverLengthLabelMode value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(value);
        ThemeLabelNative.jni_SetOverLengthMode(this.getHandle(), n);
    }

    public boolean isFlowEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsFlowEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetIsFlowEnabled(this.getHandle());
    }

    public void setFlowEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsFlowEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetIsFlowEnabled(this.getHandle(), value);
    }

    public boolean isSmallGeometryLabeled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSmallGeometryLabeled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetIsSmallGeometryLabeled(this.getHandle());
    }

    public void setSmallGeometryLabeled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSmallGeometryLabeled(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetSmallGeometryLabeled(this.getHandle(), value);
    }

    public AlongLineDirection getAlongLineDirection() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAlongLineDirection()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetAlongLineDirection(this.getHandle());
        return (AlongLineDirection)InternalEnum.parseUGCValue(AlongLineDirection.class, n);
    }

    public void setAlongLineDirection(AlongLineDirection value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAlongLineDirection(AlongLineDirection value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(value);
        ThemeLabelNative.jni_SetAlongLineDirection(this.getHandle(), n);
    }

    public AlongLineCulture getAlongLineCulture() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAlongLineCulture()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetAlongLineCulture(this.getHandle());
        return (AlongLineCulture)InternalEnum.parseUGCValue(AlongLineCulture.class, n);
    }

    public void setAlongLineCulture(AlongLineCulture value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAlongLineCulture(AlongLineCulture value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(value);
        ThemeLabelNative.jni_SetAlongLineCulture(this.getHandle(), n);
    }

    public boolean isAlongLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAlongLine()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetIsAlongLine(this.getHandle());
    }

    public void setAlongLine(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsAlongLine(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetIsAlongLine(this.getHandle(), value);
    }

    public boolean isAngleFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsAngleFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetIsAngleFixed(this.getHandle());
    }

    public void setAngleFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsAngleFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetIsAngleFixed(this.getHandle(), value);
    }

    public boolean isOverlapAvoided() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsOverlapAvoided()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetIsOverlapAvoid(this.getHandle());
    }

    public void setOverlapAvoided(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsOverlapAvoided(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetIsOverlapAvoid(this.getHandle(), value);
    }

    public boolean isRepeatIntervalFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRepeatIntervalFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetRepeatIntervalFixed(this.getHandle());
    }

    public void setRepeatIntervalFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRepeatIntervalFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetRepeatIntervalFixed(this.getHandle(), value);
    }

    public double getLabelRepeatInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLabelRepeatInterval()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetLabelRepeatInterval(this.getHandle());
    }

    public void setLabelRepeatInterval(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLabelRepeatInterval(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetLabelRepeatInterval(this.getHandle(), value);
    }

    public String getOffsetX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetX()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetOffsetX(this.getHandle());
    }

    public void setOffsetX(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetX(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        ThemeLabelNative.jni_SetOffsetX(this.getHandle(), value);
    }

    public String getOffsetY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetY()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetOffsetY(this.getHandle());
    }

    public void setOffsetY(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetY(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        ThemeLabelNative.jni_SetOffsetY(this.getHandle(), value);
    }

    public GeoStyle getLeaderLineStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLeaderLineStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_leaderLineStyle == null && (l = ThemeLabelNative.jni_GetLeaderLineStyle(this.getHandle())) != 0L) {
            this.m_leaderLineStyle = InternalGeoStyle.createInstance(l);
        }
        return this.m_leaderLineStyle;
    }

    public void setLeaderLineStyle(GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLeaderLineStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle = style.clone();
        long l2 = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geoStyle);
        ThemeLabelNative.jni_SetLeaderLineStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    public boolean isLeaderLineDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsLeaderLineDisplayed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetIsLeaderLineDisplayed(this.getHandle());
    }

    public void setLeaderLineDisplayed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsLeaderLineDisplayed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetIsLeaderLineDisplayed(this.getHandle(), value);
    }

    public String getRangeExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRangeExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetRangeExpression(this.getHandle());
    }

    public void setRangeExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRangeExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        ThemeLabelNative.jni_SetRangeExpression(this.getHandle(), value);
    }

    public String getUniqueExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUniqueExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetUniqueExpression(this.getHandle());
    }

    public void setUniqueExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUniqueExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        ThemeLabelNative.jni_SetUniqueExpression(this.getHandle(), value);
    }

    public String getLabelExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLabelExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetLabelExpression(this.getHandle());
    }

    public void setLabelExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLabelExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetLabelExpression(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public String getExplodeXExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExplodeXExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetLabelExpression(this.getHandle());
    }

    public void setExplodeXExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExplodeXExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetLabelExpression(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public String getExplodeYExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExplodeYExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetExplodeYExpression(this.getHandle());
    }

    public void setExplodeYExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExplodeYExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetExplodeYExpression(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public String getLabelSizeExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLabelSizeExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetLabelSizeExpression(this.getHandle());
    }

    public void setLabelSizeExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLabelSizeExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetLabelSizeExpression(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public String getLabelFontTypeExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLabelFontTypeExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetLabelFontTypeExpression(this.getHandle());
    }

    public void setLabelFontTypeExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLabelFontTypeExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetLabelFontTypeExpression(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public String getLabelColorExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLabelColorExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetLabelColorExpression(this.getHandle());
    }

    public void setLabelColorExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLabelColorExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetLabelColorExpression(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public String getLabelAngleExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLabelAngleExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetLabelAngleExpression(this.getHandle());
    }

    public void setLabelAngleExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLabelAngleExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetLabelAngleExpression(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public TextStyle getUniformStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUniformStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_uniformStyle == null && (l = ThemeLabelNative.jni_GetUniformStyle(this.getHandle())) != 0L) {
            this.m_uniformStyle = InternalTextStyle.createInstance(l);
        }
        return this.m_uniformStyle;
    }

    public void setUniformStyle(TextStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUniformStyle(TextStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle = style.clone();
        this.m_lock.lock();
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
        ThemeLabelNative.jni_SetUniformStyle(this.getHandle(), l2);
        this.m_lock.unlock();
        InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
    }

    @Deprecated
    public boolean addToHead(ThemeLabelItem item) {
        return this.addToHead(item, false);
    }

    @Deprecated
    public boolean addToTail(ThemeLabelItem item) {
        return this.addToTail(item, false);
    }

    public boolean isOptimizeMutilineAlignment() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOptimizeMutilineAlignment()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetOptimizeMutilineAlignment(this.getHandle());
    }

    public void setOptimizeMutilineAlignment(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOptimizeMutilineAlignment(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetOptimizeMutilineAlignment(this.getHandle(), value);
    }

    @Deprecated
    public boolean addToHead(ThemeLabelItem item, boolean normalize) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToHead(ThemeLabelItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (item.getStart() >= item.getEnd()) {
            if (normalize) {
                if (Toolkit.isZero((double)(item.getStart() - item.getEnd()))) {
                    return false;
                }
                Double d = item.getStart();
                item.setStart(item.getEnd());
                item.setEnd(d);
            } else {
                String string = InternalResource.loadString("item", "ThemeLabel_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((n = this.getCount()) > 0) {
            double d;
            double d2 = ThemeLabelNative.jni_GetValueAt(this.getHandle(), 0);
            double d3 = item.getEnd();
            double d4 = d3 - d2;
            boolean bl = Toolkit.isZero((double)d4);
            if (!bl) {
                if (normalize) {
                    item.setEnd(d2);
                } else {
                    String string = InternalResource.loadString("item.getEnd()", "ThemeLabel_InvalidEndOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if ((bl = Toolkit.isZero((double)(d4 = (d = item.getStart()) - d2))) || d > d2) {
                return false;
            }
        }
        this.m_lock.lock();
        ThemeLabelItem themeLabelItem = new ThemeLabelItem(item);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabelItem.getStyle());
        boolean bl = ThemeLabelNative.jni_AddToHead(this.getHandle(), themeLabelItem.getCaption(), themeLabelItem.isVisible(), l, themeLabelItem.getStart(), themeLabelItem.getEnd(), themeLabelItem.getOffsetX(), themeLabelItem.getOffsetY());
        if (bl) {
            ThemeLabelItem themeLabelItem2 = new ThemeLabelItem(this);
            this.m_labelItems.add(0, themeLabelItem2);
            this.refreshLabelItemStyle();
        }
        this.m_lock.unlock();
        return bl;
    }

    @Deprecated
    public boolean addToTail(ThemeLabelItem item, boolean normalize) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToTail(ThemeLabelItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (item.getStart() >= item.getEnd()) {
            if (normalize) {
                if (Toolkit.isZero((double)(item.getStart() - item.getEnd()))) {
                    return false;
                }
                Double d = item.getStart();
                item.setStart(item.getEnd());
                item.setEnd(d);
            } else {
                String string = InternalResource.loadString("item", "ThemeLabel_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((n = this.getCount()) > 0) {
            double d;
            double d2 = ThemeLabelNative.jni_GetValueAt(this.getHandle(), n);
            double d3 = item.getStart();
            double d4 = d3 - d2;
            boolean bl = Toolkit.isZero((double)d4);
            if (!bl) {
                if (normalize) {
                    item.setStart(d2);
                } else {
                    String string = InternalResource.loadString("item.getStart()", "ThemeLabel_InavlidStartOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if ((bl = Toolkit.isZero((double)(d4 = d2 - (d = item.getEnd())))) || d < d2) {
                return false;
            }
        }
        this.m_lock.lock();
        ThemeLabelItem themeLabelItem = new ThemeLabelItem(item);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabelItem.getStyle());
        boolean bl = ThemeLabelNative.jni_AddToTail(this.getHandle(), themeLabelItem.getCaption(), themeLabelItem.isVisible(), l, themeLabelItem.getStart(), themeLabelItem.getEnd(), themeLabelItem.getOffsetX(), themeLabelItem.getOffsetY());
        if (bl) {
            ThemeLabelItem themeLabelItem2 = new ThemeLabelItem(this);
            this.m_labelItems.add(themeLabelItem2);
            this.refreshLabelItemStyle();
        }
        this.m_lock.unlock();
        return bl;
    }

    @Deprecated
    public boolean split(int index, double splitValue, TextStyle style1, String caption1, TextStyle style2, String caption2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("split(int index, double splitValue, TextStyle style1, String caption1, TextStyle style2, String caption2)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (style1 == null) {
            String string = InternalResource.loadString("style1", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)style1);
        if (l == 0L) {
            String string = InternalResource.loadString("style1", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (style2 == null) {
            String string = InternalResource.loadString("style2", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)style2);
        if (l2 == 0L) {
            String string = InternalResource.loadString("style2", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        double d = ThemeLabelNative.jni_GetValueAt(this.getHandle(), index);
        double d2 = ThemeLabelNative.jni_GetValueAt(this.getHandle(), index + 1);
        if (splitValue <= d || splitValue >= d2) {
            String string = InternalResource.loadString("splitValue", "ThemeLabel_InvalidSplitValue", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle = style1.clone();
        TextStyle textStyle2 = style2.clone();
        long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
        long l4 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle2);
        if (caption1 == null || caption1.trim().length() == 0) {
            String string = InternalResource.loadString("caption1", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (caption2 == null || caption2.trim().length() == 0) {
            String string = InternalResource.loadString("caption2", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        boolean bl = ThemeLabelNative.jni_Split(this.getHandle(), index, splitValue, l3, caption1, l4, caption2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle2);
        if (bl) {
            ThemeLabelItem themeLabelItem = new ThemeLabelItem(this);
            this.m_labelItems.add(index + 1, themeLabelItem);
            this.refreshLabelItemStyle();
        }
        this.m_lock.unlock();
        return bl;
    }

    @Deprecated
    public boolean merge(int index, int count, TextStyle style, String caption) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("merge(int index, int count, TextStyle style, String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (index + count < index || index + count > n) {
            String string = InternalResource.loadString("count", "ThemeLabel_TheCountIsInvalid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (count == 0) {
            return true;
        }
        this.m_lock.lock();
        TextStyle textStyle = style.clone();
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
        boolean bl = ThemeLabelNative.jni_Merge(this.getHandle(), index, count, l2, caption);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
        if (bl) {
            ThemeLabelItem themeLabelItem = (ThemeLabelItem)this.m_labelItems.get(index);
            double d = ThemeLabelNative.jni_GetValueAt(this.getHandle(), index + 1);
            themeLabelItem.setEnd(d);
            themeLabelItem.setCaption(caption);
            themeLabelItem.setStyle(style.clone());
            for (int i = 0; i < count - 1; ++i) {
                ThemeLabelItem themeLabelItem2 = (ThemeLabelItem)this.m_labelItems.get(index + 1);
                themeLabelItem2.clearHandle();
                this.m_labelItems.remove(index + 1);
            }
            this.refreshLabelItemStyle();
        }
        this.m_lock.unlock();
        return bl;
    }

    @Deprecated
    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_Clear(this.getHandle());
        if (this.m_labelItems != null) {
            this.clearLabelItemsList();
        }
        this.m_ThemeLabelUniqueItems.clearHandle();
        this.m_ThemeLabelRangeItems.clearHandle();
        this.m_lock.unlock();
    }

    public static ThemeLabel makeDefault(DatasetVector dataset, String rangeExpression, RangeMode rangeMode, double rangeParameter) {
        return ThemeLabel.makeDefault(dataset, rangeExpression, rangeMode, rangeParameter, null, null);
    }

    public static ThemeLabel makeDefault(DatasetVector dataset, String rangeExpression, RangeMode rangeMode, double rangeParameter, ColorGradientType colorGradientType) {
        return ThemeLabel.makeDefault(dataset, rangeExpression, rangeMode, rangeParameter, colorGradientType, null);
    }

    public static ThemeLabel makeDefault(DatasetVector dataset, String rangeExpression, RangeMode rangeMode, double rangeParameter, ColorGradientType colorGradientType, JoinItems joinItems) {
        int n;
        int n2;
        long l;
        long l2;
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l3 == 0L) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rangeExpression == null || rangeExpression.trim().length() == 0) {
            String string = InternalResource.loadString("rangeExpression", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (joinItems == null) {
            joinItems = new JoinItems();
        }
        if ((l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)joinItems)) == 0L) {
            String string = InternalResource.loadString("joinItems", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rangeMode == null) {
            String string = InternalResource.loadString("rangeMode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if ((rangeMode.equals((Object)RangeMode.EQUALINTERVAL) || rangeMode.equals((Object)RangeMode.SQUAREROOT) || rangeMode.equals((Object)RangeMode.LOGARITHM) || rangeMode.equals((Object)RangeMode.QUANTILE)) && rangeParameter < 1.0) {
            String string = InternalResource.loadString("rangeParameter", "ThemeLabel_TheArgumentOfRangeParameterShouldNotBeLessThanOneRange", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rangeMode.equals((Object)RangeMode.CUSTOMINTERVAL) && rangeParameter < 0.0) {
            String string = InternalResource.loadString("rangeParameter", "ThemeLabel_TheArgumentOfRangeParameterShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.YELLOWRED;
        }
        if ((l = ThemeLabelNative.jni_MakeDefault(l3, rangeExpression, l2, n2 = InternalEnum.getUGCValue(rangeMode), rangeParameter, n = InternalEnum.getUGCValue((Enum)colorGradientType))) == 0L) {
            return null;
        }
        ThemeLabel themeLabel = new ThemeLabel(l, true);
        themeLabel.setRangeMode(rangeMode);
        return themeLabel;
    }

    @Deprecated
    public int indexOf(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetValueCount(this.getHandle());
        int[] nArray = new int[n];
        ThemeLabelNative.jni_GetValues(this.getHandle(), nArray);
        for (int i = 0; i < n - 1; ++i) {
            if (!((double)nArray[i] <= value) || !(value < (double)nArray[i + 1])) continue;
            return i;
        }
        return -1;
    }

    public void reverseStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverseStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_ReverseStyle(this.getHandle());
        this.m_lock.unlock();
    }

    @Deprecated
    public MixedTextStyle getUniformMixedSytle() {
        return this.getUniformMixedStyle();
    }

    public MixedTextStyle getUniformMixedStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUniformMixedSytle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_mixedTextStyle == null && ThemeLabelNative.jni_GetUniformMixedSytle(this.getHandle())) {
            this.m_mixedTextStyle = new MixedTextStyle(this);
        }
        return this.m_mixedTextStyle;
    }

    @Deprecated
    public void setUniformMixedSytle(MixedTextStyle value) {
        this.setUniformMixedStyle(value);
    }

    public void setUniformMixedStyle(MixedTextStyle value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUniformMixedSytle(MixedTextStyle value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            if (this.m_mixedTextStyle != null) {
                this.m_mixedTextStyle.clearHandle();
                this.m_mixedTextStyle = null;
            }
            ThemeLabelNative.jni_SetUniformMixedSytle(this.getHandle(), false);
            return;
        }
        ThemeLabelNative.jni_SetUniformMixedSytle(this.getHandle(), true);
        if (this.m_mixedTextStyle == null) {
            this.m_mixedTextStyle = new MixedTextStyle(this);
        }
        this.m_mixedTextStyle.setDefaultStyle(value.getDefaultStyle());
        if (value.getSeparator() != null) {
            this.m_mixedTextStyle.setSeparator(value.getSeparator());
        }
        this.m_mixedTextStyle.setSeparatorEnabled(value.isSeparatorEnabled());
        this.m_mixedTextStyle.setSplitIndexes(value.getSplitIndexes());
        this.m_mixedTextStyle.setStyles(value.getStyles());
    }

    public LabelMatrix getLabels() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLabels()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_labelMatrix == null && (l = ThemeLabelNative.jni_GetThemeLabelLabelMatrix(this.getHandle())) != 0L) {
            this.m_labelMatrix = new LabelMatrix(l, this);
            int n = InternalEnum.getUGCValue(LabelType.TABLE);
            ThemeLabelNative.jni_SetThemeLabelType(this.getHandle(), n);
        }
        return this.m_labelMatrix;
    }

    public void setLabels(LabelMatrix labelMatrix) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLabels()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(LabelType.TEXT);
        if (labelMatrix == null) {
            if (this.m_labelMatrix != null) {
                this.m_labelMatrix.clearHandle();
            }
            this.m_labelMatrix = null;
            ThemeLabelNative.jni_SetThemeLabelType(this.getHandle(), n);
            ThemeLabelNative.jni_SetThemeLabelLabelMatrix(this.getHandle(), 0L);
            return;
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)labelMatrix) == 0L) {
            String string = InternalResource.loadString("setLabels()", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        n = InternalEnum.getUGCValue(LabelType.TABLE);
        ThemeLabelNative.jni_SetThemeLabelType(this.getHandle(), n);
        long l = ThemeLabelNative.jni_SetThemeLabelLabelMatrix(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)labelMatrix));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)labelMatrix));
        if (this.m_labelMatrix == null) {
            this.m_labelMatrix = new LabelMatrix(l, this);
        } else {
            this.m_labelMatrix.clearHandle();
            this.m_labelMatrix.refreshPartsList(l, this);
        }
        this.m_lock.unlock();
    }

    public ThemeLabel getParent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_themeLabel;
    }

    public int getNumericPrecision() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNumericPrecision()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = ThemeLabelNative.jni_GetNumericPrecision(this.getHandle());
        if (string.equals("")) {
            return -1;
        }
        if (string.indexOf(".") == -1 || string.indexOf("f") == -1) {
            return -1;
        }
        int n = string.indexOf(".") + 1;
        string = string.substring(n, string.indexOf("f"));
        return Integer.parseInt(string);
    }

    public void setNumericPrecision(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setNumericPrecision(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (value >= 0) {
            string = "1." + value + "f";
        }
        ThemeLabelNative.jni_SetNumericPrecision(this.getHandle(), string);
    }

    public int getMaxTextHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxTextHeight()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetMaxTextHeight(this.getHandle());
    }

    public void setMaxTextHeight(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxTextHeight(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetMaxTextHeight(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public int getMinTextHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinTextHeight()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetMinTextHeight(this.getHandle());
    }

    public void setMinTextHeight(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinTextHeight(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetMinTextHeight(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public int getMaxTextWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxTextHeight()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetMaxTextWidth(this.getHandle());
    }

    public void setMaxTextWidth(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxTextWidth(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetMaxTextWidth(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public int getMinTextWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinTextWidth()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetMinTextWidth(this.getHandle());
    }

    public void setMinTextWidth(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinTextWidth(int result)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetMinTextWidth(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public Size2D getTextExtentInflation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextExtentInflation()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        ThemeLabelNative.jni_GetTextExtentInflation(this.getHandle(), dArray);
        if (this.m_size2D == null) {
            this.m_size2D = new Size2D(dArray[0], dArray[1]);
        } else {
            this.m_size2D.setWidth(dArray[0]);
            this.m_size2D.setHeight(dArray[1]);
        }
        return this.m_size2D;
    }

    public void setTextExtentInflation(Size2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextExtentInflation(Size2D value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value.getHeight() < 0.0 || value.getWidth() < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeLabelNative.jni_SetTextExtentInflation(this.getHandle(), value.getWidth(), value.getHeight());
    }

    public boolean isRepeatedLabelAvoided() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRepeatedLableAvoided()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_IsRepeatedLableAvoided(this.getHandle());
    }

    public void setRepeatedLabelAvoided(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRepeatedLableAvoided(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetRepeatedLableAvoided(this.getHandle(), value);
    }

    public boolean isOffsetFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsOffsetFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_isOffsetFixed(this.getHandle());
    }

    public void setOffsetFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetOffsetFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_setOffsetFixed(this.getHandle(), value);
    }

    public boolean isAutoAdjustRegionLabel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAutoAdjustRegionLabel()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_IsAutoAdjustRegionLabel(this.getHandle());
    }

    public void setAutoAdjustRegionLabel(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAutoAdjustRegionLabel(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetAutoAdjustRegionLabel(this.getHandle(), value);
    }

    public boolean isVertical() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isVertical()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_IsVertical(this.getHandle());
    }

    public void setVertical(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVertical(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetVertical(this.getHandle(), value);
    }

    @Deprecated
    public double getTextSpaceing() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextSpaceing()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetTextSpaceing(this.getHandle());
    }

    public double getTextSpacing() {
        return this.getTextSpaceing();
    }

    @Deprecated
    public void setTextSpaceing(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextSpaceing(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetTextSpaceing(this.getHandle(), value);
    }

    public void setTextSpacing(double value) {
        this.setTextSpaceing(value);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeLabelNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{AlongLineDirection =");
        stringBuffer.append(this.getAlongLineDirection().name());
        stringBuffer.append(",IsSmallGeometryLabeled = ");
        stringBuffer.append(this.isSmallGeometryLabeled());
        stringBuffer.append("BackShape = ");
        stringBuffer.append(this.getBackShape().name());
        stringBuffer.append(",BackStyle = ");
        stringBuffer.append(this.getBackStyle());
        stringBuffer.append(",Count = ");
        stringBuffer.append(this.getCount());
        stringBuffer.append(",IsAlongLine = ");
        stringBuffer.append(this.isAlongLine());
        stringBuffer.append(",IsAngleFixed = ");
        stringBuffer.append(this.isAngleFixed());
        stringBuffer.append(",IsFlowEnabled = ");
        stringBuffer.append(this.isFlowEnabled());
        stringBuffer.append(",IsRepeatIntervalFixed = ");
        stringBuffer.append(this.isRepeatIntervalFixed());
        stringBuffer.append(",IsLeaderLineDisplayed = ");
        stringBuffer.append(this.isLeaderLineDisplayed());
        stringBuffer.append(",isOverlapAvoided = ");
        stringBuffer.append(this.isOverlapAvoided());
        stringBuffer.append(",LabelExpression = ");
        stringBuffer.append(this.getLabelExpression());
        stringBuffer.append(",LabelRepeatInterval = ");
        stringBuffer.append(this.getLabelRepeatInterval());
        stringBuffer.append(",LeaderLineStyle = ");
        stringBuffer.append(this.getLeaderLineStyle());
        stringBuffer.append(",MaxLabelLength = ");
        stringBuffer.append(this.getMaxLabelLength());
        stringBuffer.append(",OffsetX = ");
        stringBuffer.append(this.getOffsetX());
        stringBuffer.append(",OffsetY = ");
        stringBuffer.append(this.getOffsetY());
        stringBuffer.append(",OverLengthMode = ");
        stringBuffer.append(this.getOverLengthMode().name());
        stringBuffer.append(",RangeExpression = ");
        stringBuffer.append(this.getRangeExpression());
        stringBuffer.append(",UniqueExpression = ");
        stringBuffer.append(this.getUniqueExpression());
        stringBuffer.append(",getIsOptimizeMutilineAlignment = ");
        stringBuffer.append(this.isOptimizeMutilineAlignment());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    @Deprecated
    public boolean isAllDirectionsOverlapedAvoided() {
        return this.isAllDirectionsOverlappedAvoided();
    }

    @Deprecated
    public boolean isAllDirectionsOverlappedAvoided() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_IsAllDirectionOverlap(this.getHandle());
    }

    public AvoidMode getOverlapeAvoidMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOverlapeAvoidMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetOverlapeAvoidMode(this.getHandle());
        return AvoidMode.get(n);
    }

    @Deprecated
    public void setAllDirectionsOverlapedAvoided(boolean value) {
        this.setAllDirectionsOverlappedAvoided(value);
    }

    @Deprecated
    public void setAllDirectionsOverlappedAvoided(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetAllDirectionOverlaped(this.getHandle(), value);
    }

    public void setOverlapeAvoidMode(AvoidMode value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlapeAvoidMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetOverlapeAvoidMode(this.getHandle(), value.value());
    }

    public double getAlongLineSpaceRatio() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAlongLineSpaceRatio()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetAlongLineSpaceRatio(this.getHandle());
    }

    public void setAlongLineSpaceRatio(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAlongLineSpaceRatio()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetAlongLineSpaceRatio(this.getHandle(), value);
    }

    @Override
    public boolean fromXML(String xml) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = super.fromXML(xml);
            if (bl) {
                if (this.m_backStyle != null) {
                    InternalGeoStyle.clearHandle(this.m_backStyle);
                    this.m_backStyle = null;
                }
                if (this.m_leaderLineStyle != null) {
                    InternalGeoStyle.clearHandle(this.m_leaderLineStyle);
                    this.m_leaderLineStyle = null;
                }
                this.refreshLabelItemsList();
                this.m_ThemeLabelUniqueItems.refreshLabelItemsList();
                this.m_ThemeLabelRangeItems.refreshLabelItemsList();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public RangeMode getRangeMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRangeMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetRangeMode(this.getHandle());
        return (RangeMode)InternalEnum.parseUGCValue(RangeMode.class, n);
    }

    public double getCustomInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCustomInterval()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetCustomInterval(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        if (this.m_labelItems != null) {
            this.clearLabelItemsList();
            this.m_labelItems = null;
        }
        if (this.m_backStyle != null) {
            InternalGeoStyle.clearHandle(this.m_backStyle);
            this.m_backStyle = null;
        }
        if (this.m_leaderLineStyle != null) {
            InternalGeoStyle.clearHandle(this.m_leaderLineStyle);
            this.m_leaderLineStyle = null;
        }
        if (this.m_mixedTextStyle != null) {
            this.m_mixedTextStyle.clearHandle();
            this.m_mixedTextStyle = null;
        }
        if (this.m_labelMatrix != null) {
            this.m_labelMatrix.clearHandle();
            this.m_labelMatrix = null;
        }
        if (this.m_uniformStyle != null) {
            InternalTextStyle.clearHandle(this.m_uniformStyle);
            this.m_uniformStyle = null;
        }
        this.m_ThemeLabelUniqueItems.clearHandle();
        this.m_ThemeLabelRangeItems.clearHandle();
        this.m_size2D = null;
        this.setHandle(0L);
    }

    ArrayList getLabelItemsList() {
        return this.m_labelItems;
    }

    void setParent(ThemeLabel themeLabel) {
        this.m_themeLabel = themeLabel;
    }

    private void clearLabelItemsList() {
        int n = this.m_labelItems.size();
        for (int i = 0; i < n; ++i) {
            ThemeLabelItem themeLabelItem = (ThemeLabelItem)this.m_labelItems.get(i);
            themeLabelItem.clearHandle();
        }
        this.m_labelItems.clear();
    }

    private void refreshLabelItemsList() {
        if (this.m_labelItems != null) {
            this.clearLabelItemsList();
        }
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            ThemeLabelItem themeLabelItem = new ThemeLabelItem(this);
            this.m_labelItems.add(themeLabelItem);
        }
    }

    private void refreshLabelItemStyle() {
        int n = this.getCount();
        long[] lArray = new long[n];
        ThemeLabelNative.jni_GetStylesHandle(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            ThemeLabelItem themeLabelItem = this.getItem(i);
            themeLabelItem.refreshStyle(lArray[i]);
        }
    }

    private void reset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reset()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_Reset(this.getHandle());
    }

    private void setRangeMode(RangeMode rangeMode) {
        this.m_rangeMode = rangeMode;
    }

    public boolean isTextExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTextExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetIsTextExpression(this.getHandle());
    }

    public void setTextExpression(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setisTextExpression(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetIsTextExpression(this.getHandle(), value);
    }

    public char getSplitSeparator() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSplitSeparator()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetSplitSeparator(this.getHandle());
    }

    public void setSplitSeparator(char value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSplitSeparator(char value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetSplitSeparator(this.getHandle(), value);
    }

    public ThemeLabelUniqueItems getUniqueItems() {
        return this.m_ThemeLabelUniqueItems;
    }

    public ThemeLabelRangeItems getRangeItems() {
        return this.m_ThemeLabelRangeItems;
    }

    public boolean isOnTop() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_IsOnTop(this.getHandle());
    }

    public void setOnTop(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetOnTop(this.getHandle(), value);
    }

    public static ThemeLabel makeDefault(String[] values, String uniqueExpression, ColorGradientType colorGradientType, JoinItems joinItems) {
        long l;
        if (values == null) {
            String string = InternalResource.loadString("values", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (values.length == 0) {
            String string = InternalResource.loadString("values", "Global_ArgumentShouldMoreThanZero", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (uniqueExpression == null || uniqueExpression.trim().length() == 0) {
            String string = InternalResource.loadString("uniqueExpression", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (joinItems == null) {
            joinItems = new JoinItems();
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)joinItems)) == 0L) {
            String string = InternalResource.loadString("joinItems", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.YELLOWRED;
        }
        int n = InternalEnum.getUGCValue((Enum)colorGradientType);
        long l2 = ThemeLabelNative.jni_MakeUniqueDefault2(values, uniqueExpression, l, n);
        ThemeLabel themeLabel = null;
        if (l2 != 0L) {
            themeLabel = new ThemeLabel(l2, true);
        }
        return themeLabel;
    }

    public static ThemeLabel makeDefault(DatasetVector dataset, String uniqueExpression, ColorGradientType colorGradientType, JoinItems joinItems) {
        long l;
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l2 == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (uniqueExpression == null || uniqueExpression.trim().length() == 0) {
            String string = InternalResource.loadString("uniqueExpression", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (joinItems == null) {
            joinItems = new JoinItems();
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)joinItems)) == 0L) {
            String string = InternalResource.loadString("joinItems", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.YELLOWRED;
        }
        int n = InternalEnum.getUGCValue((Enum)colorGradientType);
        long l3 = ThemeLabelNative.jni_MakeUniqueDefault(l2, uniqueExpression, l, n);
        ThemeLabel themeLabel = null;
        if (l3 != 0L) {
            themeLabel = new ThemeLabel(l3, true);
        }
        return themeLabel;
    }

    public int getAlongLineWordAngleRange() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetAlongLineWordAngleRange(this.getHandle());
    }

    public void setAlongLineWordAngleRange(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetAlongLineWordAngleRange(this.getHandle(), value);
    }

    public boolean isAlongLineResampleSmooth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_IsAlongLineResampleSmooth(this.getHandle());
    }

    public void setAlongLineResampleSmooth(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetAlongLineResampleSmooth(this.getHandle(), value);
    }

    public double getAlongLineResampleTolerance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetAlongLineResampleTolerance(this.getHandle());
    }

    public void setAlongLineResampleTolerance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetAlongLineResampleTolerance(this.getHandle(), value);
    }

    public int getAlongLineSmoothness() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetAlongLineSmoothness(this.getHandle());
    }

    public void setAlongLineSmoothness(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetAlongLineSmoothness(this.getHandle(), value);
    }

    public AlongLineDrawingMode getAlongLineDrawingMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetAlongLineDrawingMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetAlongLineDrawingMode(this.getHandle());
        return (AlongLineDrawingMode)InternalEnum.parseUGCValue(AlongLineDrawingMode.class, n);
    }

    public void setAlongLineDrawingMode(AlongLineDrawingMode value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAlongLineDrawingMode(AlongLineDrawingMode value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(value);
        ThemeLabelNative.jni_SetAlongLineDrawingMode(this.getHandle(), n);
    }

    public boolean isRarefyPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_IsRarefyPoints(this.getHandle());
    }

    public void setRarefyPoints(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetRarefyPoints(this.getHandle(), value);
    }

    public double getRarefyPointsRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetRarefyPointsRadius(this.getHandle());
    }

    public void setRarefyPointsRadius(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetRarefyPointsRadius(this.getHandle(), value);
    }

    public int getRarefyThreshold() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetRarefyThreshold(this.getHandle());
    }

    public void setRarefyThreshold(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetRarefyThreshold(this.getHandle(), value);
    }

    public boolean isAlongLineSelfOverlap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAlongLineSelfOverlap()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_IsAlongLineSelfOverlap(this.getHandle());
    }

    public void setAlongLineSelfOverlap(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAlongLineSelfOverlap()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetAlongLineSelfOverlap(this.getHandle(), value);
    }

    public AlongLineLabelMode getAlongLineLabelMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetAlongLineLabelMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetAlongLineLabelMode(this.getHandle());
        return (AlongLineLabelMode)InternalEnum.parseUGCValue(AlongLineLabelMode.class, n);
    }

    public void setAlongLineLabelMode(AlongLineLabelMode value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAlongLineLabelMode(AlongLineLabelMode value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(value);
        ThemeLabelNative.jni_SetAlongLineLabelMode(this.getHandle(), n);
    }
}

