/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.TextStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalTextStyle;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.ThemeLabel;
import com.supermap.mapping.ThemeLabelNative;

@Deprecated
public class ThemeLabelItem {
    private String m_caption = "UntitledThemeLabelItem";
    private TextStyle m_textStyle = null;
    private boolean m_visible = true;
    private double m_start = InternalToolkitMapping.FLT_MIN_VALUE;
    private double m_end = InternalToolkitMapping.FLT_MAX_VALUE;
    private ThemeLabel m_themeLabel = null;
    private double m_OffsetX = 0.0;
    private double m_OffsetY = 0.0;
    private boolean isUserThemeLabel = false;

    public ThemeLabelItem() {
        TextStyle textStyle = new TextStyle();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle, false);
        this.m_textStyle = textStyle;
        this.isUserThemeLabel = false;
    }

    public ThemeLabelItem(double start, double end, TextStyle style) {
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_start = start;
        this.m_end = end;
        TextStyle textStyle = style.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle, false);
        this.m_textStyle = textStyle;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
        this.isUserThemeLabel = false;
    }

    public ThemeLabelItem(double start, double end, TextStyle style, String caption) {
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_start = start;
        this.m_end = end;
        this.m_caption = caption;
        this.m_OffsetX = 0.0;
        this.m_OffsetY = 0.0;
        TextStyle textStyle = style.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle, false);
        this.m_textStyle = textStyle;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
        this.isUserThemeLabel = false;
    }

    public ThemeLabelItem(double start, double end, TextStyle style, String caption, double offsetX, double offsetY) {
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_start = start;
        this.m_end = end;
        this.m_caption = caption;
        this.m_OffsetX = offsetX;
        this.m_OffsetY = offsetY;
        TextStyle textStyle = style.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle, false);
        this.m_textStyle = textStyle;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
        this.isUserThemeLabel = false;
    }

    public ThemeLabelItem(ThemeLabelItem themeLabelItem) {
        if (themeLabelItem == null) {
            String string = InternalResource.loadString("themeLabelItem", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeLabelItem.isUserThemeLabel) {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabelItem.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("themeLabelItem", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            int n = themeLabelItem.m_themeLabel.getLabelItemsList().indexOf(themeLabelItem);
            if (n == -1) {
                String string = InternalResource.loadString("themeLabelItem", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        this.m_start = themeLabelItem.getStart();
        this.m_end = themeLabelItem.getEnd();
        this.m_visible = themeLabelItem.isVisible();
        this.m_caption = themeLabelItem.getCaption();
        this.m_OffsetX = themeLabelItem.getOffsetX();
        this.m_OffsetY = themeLabelItem.getOffsetY();
        TextStyle textStyle = themeLabelItem.getStyle().clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle, false);
        this.m_textStyle = textStyle;
        this.isUserThemeLabel = false;
    }

    ThemeLabelItem(ThemeLabel themeLabel) {
        this.m_themeLabel = themeLabel;
        this.isUserThemeLabel = true;
    }

    public String getCaption() {
        String string = null;
        if (this.isUserThemeLabel) {
            int n = this.m_themeLabel.getLabelItemsList().indexOf(this);
            if (n == -1) {
                String string2 = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string3 = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string3);
            }
            string = ThemeLabelNative.jni_GetCaptionAt(l, n);
        } else {
            string = this.m_caption == null ? "" : this.m_caption;
        }
        return string;
    }

    public void setCaption(String caption) {
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserThemeLabel) {
            int n = this.m_themeLabel.getLabelItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeLabelNative.jni_SetCaptionAt(l, n, caption);
        }
        this.m_caption = caption;
    }

    public TextStyle getStyle() {
        if (this.isUserThemeLabel) {
            long l;
            int n = this.m_themeLabel.getLabelItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_textStyle == null && (l = ThemeLabelNative.jni_GetStyleAt(l2, n)) != 0L) {
                this.m_textStyle = InternalTextStyle.createInstance(l);
            }
        }
        return this.m_textStyle;
    }

    public void setStyle(TextStyle textStyle) {
        int n = -1;
        long l = 0L;
        if (this.isUserThemeLabel) {
            n = this.m_themeLabel.getLabelItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("setStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
        if (l2 == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle2 = textStyle.clone();
        long l3 = 0L;
        if (this.isUserThemeLabel) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle2);
            ThemeLabelNative.jni_SetStyleAt(l, n, l3);
        } else {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle2, false);
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle2);
            if (this.m_textStyle == null) {
                this.m_textStyle = textStyle2;
            } else {
                InternalTextStyle.changeHandle(this.m_textStyle, l3);
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle2);
    }

    public boolean isVisible() {
        boolean bl = false;
        if (this.isUserThemeLabel) {
            int n = this.m_themeLabel.getLabelItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            bl = ThemeLabelNative.jni_GetIsVisibleAt(l, n);
        } else {
            bl = this.m_visible;
        }
        return bl;
    }

    public void setVisible(boolean value) {
        if (this.isUserThemeLabel) {
            int n = this.m_themeLabel.getLabelItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeLabelNative.jni_SetIsVisibleAt(l, n, value);
        }
        this.m_visible = value;
    }

    public void setStart(double start) {
        if (this.isUserThemeLabel) {
            int n = this.m_themeLabel.getLabelItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setStart(double start)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("setStart(double start)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            double d = InternalToolkitMapping.DBL_MIN_VALUE;
            if (n > 0) {
                d = ThemeLabelNative.jni_GetValueAt(l, n - 1);
            }
            double d2 = ThemeLabelNative.jni_GetValueAt(l, n + 1);
            if (start <= d || start >= d2) {
                String string = InternalResource.loadString("start", "ThemeLabelItem_InvalidStartValue", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            ThemeLabelNative.jni_SetValueAt(l, n, start);
        }
        this.m_start = start;
    }

    public void setEnd(double end) {
        if (this.isUserThemeLabel) {
            double d;
            int n = this.m_themeLabel.getLabelItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setEnd(double end)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("setEnd(double end)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            double d2 = InternalToolkitMapping.DBL_MAX_VALUE;
            int n2 = this.m_themeLabel.getCount();
            if (n != n2 - 1) {
                d2 = ThemeLabelNative.jni_GetValueAt(l, n + 2);
            }
            if (end <= (d = ThemeLabelNative.jni_GetValueAt(l, n)) || end >= d2) {
                String string = InternalResource.loadString("end", "ThemeLabelItem_InvalidStartValue", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            ThemeLabelNative.jni_SetValueAt(l, n + 1, end);
        }
        this.m_end = end;
    }

    public double getStart() {
        double d = 0.0;
        if (this.isUserThemeLabel) {
            int n = this.m_themeLabel.getLabelItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getStart()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("getStart()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            d = ThemeLabelNative.jni_GetValueAt(l, n);
        } else {
            d = this.m_start;
        }
        return d;
    }

    public double getEnd() {
        double d = 0.0;
        if (this.isUserThemeLabel) {
            int n = this.m_themeLabel.getLabelItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getEnd()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("getEnd()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            d = ThemeLabelNative.jni_GetValueAt(l, n + 1);
        } else {
            d = this.m_end;
        }
        return d;
    }

    public void setOffsetX(double value) {
        if (this.isUserThemeLabel) {
            int n = this.m_themeLabel.getLabelItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setOffsetXAt(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeLabelNative.jni_SetOffsetXAt(l, n, value);
        }
        this.m_OffsetX = value;
    }

    public double getOffsetX() {
        double d;
        if (this.isUserThemeLabel) {
            int n = this.m_themeLabel.getLabelItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getOffsetX() ", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("getOffsetX()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            d = ThemeLabelNative.jni_GetOffsetXAt(l, n);
        } else {
            d = this.m_OffsetX == 0.0 ? 0.0 : this.m_OffsetX;
        }
        return d;
    }

    public void setOffsetY(double value) {
        if (this.isUserThemeLabel) {
            int n = this.m_themeLabel.getLabelItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setOffsetYAt(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeLabelNative.jni_SetOffsetYAt(l, n, value);
        }
        this.m_OffsetY = value;
    }

    public double getOffsetY() {
        double d;
        if (this.isUserThemeLabel) {
            int n = this.m_themeLabel.getLabelItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getOffsetY()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("getOffsetY()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            d = ThemeLabelNative.jni_GetOffsetYAt(l, n);
        } else {
            d = this.m_OffsetY == 0.0 ? 0.0 : this.m_OffsetY;
        }
        return d;
    }

    public String toString() {
        if (this.isUserThemeLabel) {
            int n = this.m_themeLabel.getLabelItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Caption = ");
        stringBuffer.append(this.getCaption());
        stringBuffer.append(",Start = ");
        stringBuffer.append(this.getStart());
        stringBuffer.append(",End = ");
        stringBuffer.append(this.getEnd());
        stringBuffer.append(",Visible = ");
        stringBuffer.append(this.isVisible());
        stringBuffer.append(",Style = ");
        stringBuffer.append(this.getStyle().toString());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    void clearHandle() {
        if (this.m_textStyle != null) {
            InternalTextStyle.clearHandle(this.m_textStyle);
            this.m_textStyle = null;
        }
    }

    void refreshStyle(long handle) {
        if (this.isUserThemeLabel && this.m_textStyle != null) {
            InternalTextStyle.refreshHandle(this.m_textStyle, handle);
        }
    }
}

