/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.DatasetVector;
import com.supermap.data.Environment;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point3D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.CacheBuilderOSGBToolNative;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.ObjRotateOption;
import com.supermap.data.processing.TextureCompressType;
import com.supermap.tilestorage.TileStorageConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Vector;

public class CacheBuilderOSGBTool
extends InternalHandleDisposable {
    private static transient Vector m_steppedListeners;

    public CacheBuilderOSGBTool() {
        long l = CacheBuilderOSGBToolNative.jni_New();
        this.setHandle(l, true);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            CacheBuilderOSGBToolNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public static boolean discret(String scpFileName, String outputFolder, DatasetVector pDatasetVector, String strFieldName) {
        if (scpFileName == null || scpFileName.isEmpty()) {
            String string = InternalResource.loadString("scpFileName", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)pDatasetVector);
        return CacheBuilderOSGBToolNative.jni_Discret(scpFileName, outputFolder, l, strFieldName);
    }

    static double[] readNodeRect(String nodeFilePath, boolean bOSGBCacheFile) {
        double[] dArray = new double[4];
        return (double[])(CacheBuilderOSGBToolNative.jni_ReadNodeRect(nodeFilePath, dArray, bOSGBCacheFile) ? dArray : null);
    }

    static boolean saveConfigToMongo(String scpPath, String indexDataPath, TileStorageConnection mongoConn) {
        String[] stringArray = null;
        if (mongoConn != null) {
            stringArray = new String[]{mongoConn.getServer(), mongoConn.getDatabase(), mongoConn.getName(), mongoConn.getUser(), mongoConn.getPassword()};
        }
        return CacheBuilderOSGBToolNative.jni_SaveConfigToMongo(scpPath, indexDataPath, stringArray);
    }

    public static boolean osgb2s3m(String scpFileName, String outputFolder, TextureCompressType type) {
        if (scpFileName == null || scpFileName.isEmpty()) {
            String string = InternalResource.loadString("scpFileName", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        return CacheBuilderOSGBToolNative.jni_osgb2s3m(scpFileName, outputFolder, type.value());
    }

    public static boolean compressTextures(String scpFileName, String outputFolder, TextureCompressType type) {
        if (scpFileName == null || scpFileName.isEmpty()) {
            String string = InternalResource.loadString("scpFileName", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        return CacheBuilderOSGBToolNative.jni_CompressTextures(scpFileName, outputFolder, type.value());
    }

    public static boolean combineFile(String inScpFileName, String outScpFileName, int combineLevel, TextureCompressType type, int processThreadsCount) {
        if (inScpFileName == null || inScpFileName.isEmpty()) {
            String string = InternalResource.loadString("scpFileName", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        return CacheBuilderOSGBToolNative.jni_CombineFile(inScpFileName, outScpFileName, combineLevel, type.value(), processThreadsCount);
    }

    public static boolean i3sTos3m(String scpFileName, String outputFolder) {
        if (scpFileName == null || scpFileName.isEmpty()) {
            String string = InternalResource.loadString("scpFileName", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(scpFileName);
        if (!file.exists()) {
            String string = InternalResource.loadString("scpFileName", "FileNotExists", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        return CacheBuilderOSGBToolNative.jni_i3sTos3m(scpFileName, outputFolder);
    }

    public static boolean osgbTo3dTiles(String scpFileName, String outputFolder) {
        if (scpFileName == null || scpFileName.isEmpty()) {
            String string = InternalResource.loadString("scpFileName", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(scpFileName);
        if (!file.exists()) {
            String string = InternalResource.loadString("scpFileName", "FileNotExists", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        return CacheBuilderOSGBToolNative.jni_osgbTo3dTiles(scpFileName, outputFolder);
    }

    public boolean Initialise(String scpFileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Open()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderOSGBToolNative.jni_Initialise(this.getHandle(), scpFileName);
    }

    public boolean setCompressType(int nCompressType) {
        return CacheBuilderOSGBToolNative.jni_setCompressType(this.getHandle(), nCompressType);
    }

    public boolean osgb2s3m(String inputPath, String outputPath) {
        return CacheBuilderOSGBToolNative.jni_osgb2s3m(this.getHandle(), inputPath, outputPath);
    }

    public static boolean modifyCenter(String scpFileName, String outputFolder, Point3D pointNewCenter) {
        if (scpFileName == null || scpFileName.isEmpty()) {
            String string = InternalResource.loadString("scpFileName", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (pointNewCenter == null) {
            String string = InternalResource.loadString("pointNewCenter", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        return CacheBuilderOSGBToolNative.jni_ModifyCenter(scpFileName, outputFolder, pointNewCenter.getX(), pointNewCenter.getY(), pointNewCenter.getZ());
    }

    public static boolean generateProxyOSGBFiles(String inScpFileName, String outScpFileName, int level) {
        if (inScpFileName == null || inScpFileName.isEmpty()) {
            String string = InternalResource.loadString("inScpFileName", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        return CacheBuilderOSGBToolNative.jni_GenerateProxyOSGBFiles(inScpFileName, outScpFileName, level);
    }

    public static boolean osgbCreateHistoryFiles(ArrayList<String> scpFileNames, ArrayList<Calendar> dateTimes, String scpCurrentFileName, String outputFolder) {
        if (scpFileNames == null) {
            String string = InternalResource.loadString("scpFileNames", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (dateTimes == null) {
            String string = InternalResource.loadString("dataTimes", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        String[] stringArray = new String[scpFileNames.size()];
        for (int i = 0; i < scpFileNames.size(); ++i) {
            stringArray[i] = scpFileNames.get(i);
        }
        String[] stringArray2 = new String[dateTimes.size()];
        for (int i = 0; i < dateTimes.size(); ++i) {
            String string;
            stringArray2[i] = string = String.format("%1$tY-%1$tm-%1$td %1$tT", dateTimes.get(i));
        }
        return CacheBuilderOSGBToolNative.jni_OSGBCreateHistoryFiles(stringArray, stringArray2, scpCurrentFileName, outputFolder);
    }

    public static boolean objToosgb(String xmlFileName, String outputFolder) {
        return CacheBuilderOSGBToolNative.jni_OBJToOSGB(xmlFileName, outputFolder);
    }

    public static boolean objToosgb(String xmlFileName, String outputFolder, Point3D pointSrc, Point3D pointDest, ObjRotateOption option) {
        if (pointSrc == null) {
            String string = InternalResource.loadString("pointSrc", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (pointDest == null) {
            String string = InternalResource.loadString("pointDest", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        return CacheBuilderOSGBToolNative.jni_OBJToOSGB2(xmlFileName, outputFolder, pointSrc.getX(), pointSrc.getY(), pointSrc.getZ(), pointDest.getX(), pointDest.getY(), pointDest.getZ(), option.value());
    }

    public static boolean osgbTodae(String scpFileName, String outputFolder) {
        return CacheBuilderOSGBToolNative.jni_OSGBToDAE(scpFileName, outputFolder);
    }

    public static boolean objQuarterTos3mb(String jsonFileName, String outputFolder) {
        return CacheBuilderOSGBToolNative.jni_OBJQuarterToS3MB(jsonFileName, outputFolder);
    }

    public static boolean osgbToCompactFile(String scpFileName, String outputFolder) {
        return CacheBuilderOSGBToolNative.jni_OSGBToCompactFile(scpFileName, outputFolder);
    }

    public static int splitScpFile(String scpFileName, int count) {
        return CacheBuilderOSGBToolNative.jni_SplitScpFile(scpFileName, count);
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "OP3DModelTools";
        boolean bl = InternalToolkitProcessing.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string, bl);
        CacheBuilderOSGBTool.fireStepped(steppedEvent);
        InternalToolkitProcessing.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static {
        Environment.LoadWrapJ();
    }
}

