/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.AggregationType;
import com.supermap.analyst.spatialanalyst.BoundaryCleanSortType;
import com.supermap.analyst.spatialanalyst.ConversionAnalystNative;
import com.supermap.analyst.spatialanalyst.DissolveParameter;
import com.supermap.analyst.spatialanalyst.EliminateMode;
import com.supermap.analyst.spatialanalyst.GeneralizeAnalystNative;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetImage;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.MajorityDefinition;
import com.supermap.analyst.spatialanalyst.NeighborNumber;
import com.supermap.analyst.spatialanalyst.ReclassMappingTable;
import com.supermap.analyst.spatialanalyst.ReclassPixelFormat;
import com.supermap.analyst.spatialanalyst.ReclassSegment;
import com.supermap.analyst.spatialanalyst.ReclassType;
import com.supermap.analyst.spatialanalyst.RegionGroupResult;
import com.supermap.analyst.spatialanalyst.ResampleMode;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.PixelFormat;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;

public class GeneralizeAnalyst {
    private static License m_license;
    private static transient Vector m_steppedListeners;
    private static GridAnalystSetting m_gridAnalystSetting;

    private GeneralizeAnalyst() {
        m_gridAnalystSetting = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return m_gridAnalystSetting;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            m_gridAnalystSetting = null;
            return;
        }
        if (m_gridAnalystSetting == null) {
            m_gridAnalystSetting = new GridAnalystSetting();
        }
        m_gridAnalystSetting.setBounds(gridAnalystSetting.getBounds());
        m_gridAnalystSetting.setBoundsType(gridAnalystSetting.getBoundsType());
        m_gridAnalystSetting.setCellSizeType(gridAnalystSetting.getCellSizeType());
        m_gridAnalystSetting.setCellSize(gridAnalystSetting.getCellSize());
        m_gridAnalystSetting.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        m_gridAnalystSetting.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        m_gridAnalystSetting.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        m_gridAnalystSetting.setValidRegion(gridAnalystSetting.getValidRegion());
        m_gridAnalystSetting.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static DatasetGrid aggregate(DatasetGrid sourceDataset, int scale, AggregationType aggregationType, boolean isExpanded, boolean isIgnoreNoValue, Datasource targetDatasource, String targetDatasetName) {
        GeneralizeAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        int n = InternalEnum.getUGCValue(aggregationType);
        long l3 = GeneralizeAnalystNative.jni_New();
        if (null != m_gridAnalystSetting) {
            GeneralizeAnalystNative.jni_SetShowProgress(l3, m_gridAnalystSetting.isShowProgress());
            Rectangle2D rectangle2D = m_gridAnalystSetting.getBounds();
            GeneralizeAnalystNative.jni_SetTargetBounds(l3, m_gridAnalystSetting.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
        long l4 = GeneralizeAnalystNative.jni_Aggregate(l3, l, scale, n, isExpanded, isIgnoreNoValue, l2, targetDatasetName);
        GeneralizeAnalystNative.jni_Delete(l3);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static Dataset resample(Dataset sourceDataset, double newCellSize, ResampleMode resampleMode, Datasource targetDatasource, String targetDatasetName) {
        GeneralizeAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        int n = InternalEnum.getUGCValue(resampleMode);
        long l3 = GeneralizeAnalystNative.jni_New();
        if (null != m_gridAnalystSetting) {
            GeneralizeAnalystNative.jni_SetShowProgress(l3, m_gridAnalystSetting.isShowProgress());
            Rectangle2D rectangle2D = m_gridAnalystSetting.getBounds();
            GeneralizeAnalystNative.jni_SetTargetBounds(l3, m_gridAnalystSetting.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
        long l4 = GeneralizeAnalystNative.jni_Resample(l3, l, newCellSize, n, l2, targetDatasetName);
        GeneralizeAnalystNative.jni_Delete(l3);
        if (l4 != 0L) {
            if (sourceDataset.getType() == DatasetType.IMAGE) {
                DatasetImage datasetImage = InternalDatasetImage.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetImage);
                return datasetImage;
            }
            DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            return datasetGrid;
        }
        return null;
    }

    public static DatasetGrid reclass(DatasetGrid sourceDataset, ReclassMappingTable reclassMappingTable, ReclassPixelFormat reclassPixelFormat, Datasource targetDatasource, String targetDatasetName) {
        GeneralizeAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (reclassMappingTable == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)reclassMappingTable) == 0L) {
            String string = InternalResource.loadString("reclassMappingTable", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        if (reclassMappingTable.getReclassType() == ReclassType.RANGE) {
            ReclassSegment[] reclassSegmentArray = reclassMappingTable.getSegments();
            for (int i = 0; i < reclassSegmentArray.length; ++i) {
                if (!(reclassSegmentArray[i].getStartValue() > reclassSegmentArray[i].getEndValue())) continue;
                String string = InternalResource.loadString("Segments[" + i + "]:EndValue < StartValue", "ArgumentInvalid", "spatialanalyst_resources");
                throw new IllegalStateException(string);
            }
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)reclassMappingTable);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        int n = InternalEnum.getUGCValue(reclassPixelFormat);
        long l4 = GeneralizeAnalystNative.jni_New();
        if (null != m_gridAnalystSetting) {
            GeneralizeAnalystNative.jni_SetShowProgress(l4, m_gridAnalystSetting.isShowProgress());
            Rectangle2D rectangle2D = m_gridAnalystSetting.getBounds();
            GeneralizeAnalystNative.jni_SetTargetBounds(l4, m_gridAnalystSetting.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
        long l5 = GeneralizeAnalystNative.jni_Reclass(l4, l, l2, n, l3, targetDatasetName);
        GeneralizeAnalystNative.jni_Delete(l4);
        DatasetGrid datasetGrid = null;
        if (l5 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l5, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)reclassMappingTable));
        return datasetGrid;
    }

    public static DatasetGrid replace(DatasetGrid sourceDataset, Map<Double, Double> replaceTable, Datasource targetDatasource, String targetDatasetName) {
        GeneralizeAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (replaceTable == null || replaceTable.size() == 0) {
            String string = InternalResource.loadString("replaceTable", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        Object[] objectArray = replaceTable.keySet().toArray();
        int n = objectArray.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (Double)objectArray[i];
            dArray2[i] = replaceTable.get(dArray[i]);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = GeneralizeAnalystNative.jni_New();
        if (null != m_gridAnalystSetting) {
            GeneralizeAnalystNative.jni_SetShowProgress(l3, m_gridAnalystSetting.isShowProgress());
        }
        long l4 = GeneralizeAnalystNative.jni_Replace(l3, l, dArray, dArray2, l2, targetDatasetName);
        GeneralizeAnalystNative.jni_Delete(l3);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid slice(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, int numberZones, int baseOutputZones) {
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (numberZones < 1) {
            String string = InternalResource.loadString("numberZones", "Global_ArgumentNull", "GlobalGreaterThanZero");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("numberZones", "Global_ArgumentNull", "GlobalDatasetNameInvalid");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = GeneralizeAnalystNative.jni_Slice(l, l2, targetDatasetName, numberZones, baseOutputZones);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static double[] ComputeRange(DatasetGrid sourceDataset, int count) {
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (count < 1) {
            String string = InternalResource.loadString("count", "Global_ArgumentNull", "GlobalGreaterThanZero");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        double[] dArray = GeneralizeAnalystNative.jni_ComputeRange(l, count);
        return dArray;
    }

    public static double[] ComputeRange(DatasetVector sourceDataset, String field, int count) {
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (count < 1) {
            String string = InternalResource.loadString("count", "Global_ArgumentNull", "GlobalGreaterThanZero");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        double[] dArray = GeneralizeAnalystNative.jni_ComputeRange1(l, field, count);
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "GeneralizeAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        GeneralizeAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    @Deprecated
    public static DatasetVector dissolve(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, DissolveParameter dissolveParameter) {
        GeneralizeAnalyst.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (dissolveParameter == null) {
            String string = InternalResource.loadString("dissolveParameter", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dissolveParameter);
        long l4 = GeneralizeAnalystNative.jni_Dissolve(l, l2, targetDatasetName, l3);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)dissolveParameter));
        return datasetVector;
    }

    @Deprecated
    public static boolean eliminate(DatasetVector sourceDatasetVector, double regionTolerance, double vertexTolerance, EliminateMode eliminateMode, boolean isDeleteSingleRegion) {
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceDatasetVector", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (regionTolerance < 0.0) {
            String string = InternalResource.loadString("regionTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (vertexTolerance < 0.0) {
            String string = InternalResource.loadString("vertexTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (eliminateMode == null) {
            String string = InternalResource.loadString("eliminateMode", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        boolean bl = false;
        bl = GeneralizeAnalystNative.jni_Eliminate(l, regionTolerance, vertexTolerance, eliminateMode.value(), isDeleteSingleRegion);
        return bl;
    }

    public static DatasetGrid majorityFilter(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, NeighborNumber neighborNumber, MajorityDefinition majorityDefinition) {
        GeneralizeAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getPixelFormat() != PixelFormat.BIT8 && sourceDataset.getPixelFormat() != PixelFormat.BIT16 && sourceDataset.getPixelFormat() != PixelFormat.BIT32 && sourceDataset.getPixelFormat() != PixelFormat.BIT64 && sourceDataset.getPixelFormat() != PixelFormat.UBIT1 && sourceDataset.getPixelFormat() != PixelFormat.UBIT4 && sourceDataset.getPixelFormat() != PixelFormat.UBIT8 && sourceDataset.getPixelFormat() != PixelFormat.UBIT16 && sourceDataset.getPixelFormat() != PixelFormat.UBIT32) {
            String string = InternalResource.loadString("sourceDataset", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = GeneralizeAnalystNative.jni_MajorityFilter(l, l2, targetDatasetName, InternalEnum.getUGCValue(neighborNumber), InternalEnum.getUGCValue(majorityDefinition));
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid expand(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, NeighborNumber method, int cellNumber, int[] zoneValues) {
        GeneralizeAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (zoneValues == null || zoneValues.length < 1) {
            String string = InternalResource.loadString("zoneValues", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getPixelFormat() != PixelFormat.BIT8 && sourceDataset.getPixelFormat() != PixelFormat.BIT16 && sourceDataset.getPixelFormat() != PixelFormat.BIT32 && sourceDataset.getPixelFormat() != PixelFormat.BIT64 && sourceDataset.getPixelFormat() != PixelFormat.UBIT1 && sourceDataset.getPixelFormat() != PixelFormat.UBIT4 && sourceDataset.getPixelFormat() != PixelFormat.UBIT8 && sourceDataset.getPixelFormat() != PixelFormat.UBIT16 && sourceDataset.getPixelFormat() != PixelFormat.UBIT32) {
            String string = InternalResource.loadString("sourceDataset", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = GeneralizeAnalystNative.jni_Expand(l, l2, targetDatasetName, InternalEnum.getUGCValue(method), cellNumber, zoneValues);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid shrink(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, NeighborNumber method, int cellNumber, int[] zoneValues) {
        GeneralizeAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (zoneValues == null || zoneValues.length < 1) {
            String string = InternalResource.loadString("zoneValues", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceDataset.getPixelFormat() != PixelFormat.BIT8 && sourceDataset.getPixelFormat() != PixelFormat.BIT16 && sourceDataset.getPixelFormat() != PixelFormat.BIT32 && sourceDataset.getPixelFormat() != PixelFormat.BIT64 && sourceDataset.getPixelFormat() != PixelFormat.UBIT1 && sourceDataset.getPixelFormat() != PixelFormat.UBIT4 && sourceDataset.getPixelFormat() != PixelFormat.UBIT8 && sourceDataset.getPixelFormat() != PixelFormat.UBIT16 && sourceDataset.getPixelFormat() != PixelFormat.UBIT32) {
            String string = InternalResource.loadString("sourceDataset", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = GeneralizeAnalystNative.jni_Shrink(l, l2, targetDatasetName, InternalEnum.getUGCValue(method), cellNumber, zoneValues);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static RegionGroupResult regionGroup(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, NeighborNumber neighborNumber, boolean isSaveLinkValue, boolean isLinkByNeighbor, int excludedValue) {
        GeneralizeAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getPixelFormat() != PixelFormat.BIT8 && sourceDataset.getPixelFormat() != PixelFormat.BIT16 && sourceDataset.getPixelFormat() != PixelFormat.BIT32 && sourceDataset.getPixelFormat() != PixelFormat.BIT64 && sourceDataset.getPixelFormat() != PixelFormat.UBIT1 && sourceDataset.getPixelFormat() != PixelFormat.UBIT4 && sourceDataset.getPixelFormat() != PixelFormat.UBIT8 && sourceDataset.getPixelFormat() != PixelFormat.UBIT16 && sourceDataset.getPixelFormat() != PixelFormat.UBIT32) {
            String string = InternalResource.loadString("sourceDataset", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        int[] nArray = new int[]{excludedValue};
        long[] lArray = GeneralizeAnalystNative.jni_RegionGroup(l, l2, targetDatasetName, InternalEnum.getUGCValue(neighborNumber), isSaveLinkValue, isLinkByNeighbor, nArray);
        DatasetGrid datasetGrid = null;
        DatasetVector datasetVector = null;
        RegionGroupResult regionGroupResult = null;
        if (lArray != null && lArray.length == 2) {
            if (lArray[0] != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(lArray[0], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            if (lArray[1] != 0L) {
                datasetVector = InternalDatasetVector.createInstance(lArray[1], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            }
        }
        regionGroupResult = new RegionGroupResult(datasetGrid, datasetVector);
        return regionGroupResult;
    }

    public static RegionGroupResult regionGroup(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, NeighborNumber neighborNumber, boolean isSaveLinkValue) {
        GeneralizeAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getPixelFormat() != PixelFormat.BIT8 && sourceDataset.getPixelFormat() != PixelFormat.BIT16 && sourceDataset.getPixelFormat() != PixelFormat.BIT32 && sourceDataset.getPixelFormat() != PixelFormat.BIT64 && sourceDataset.getPixelFormat() != PixelFormat.UBIT1 && sourceDataset.getPixelFormat() != PixelFormat.UBIT4 && sourceDataset.getPixelFormat() != PixelFormat.UBIT8 && sourceDataset.getPixelFormat() != PixelFormat.UBIT16 && sourceDataset.getPixelFormat() != PixelFormat.UBIT32) {
            String string = InternalResource.loadString("sourceDataset", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        int[] nArray = new int[]{};
        long[] lArray = GeneralizeAnalystNative.jni_RegionGroup(l, l2, targetDatasetName, InternalEnum.getUGCValue(neighborNumber), isSaveLinkValue, true, nArray);
        DatasetGrid datasetGrid = null;
        DatasetVector datasetVector = null;
        RegionGroupResult regionGroupResult = null;
        if (lArray != null && lArray.length == 2) {
            if (lArray[0] != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(lArray[0], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            if (lArray[1] != 0L) {
                datasetVector = InternalDatasetVector.createInstance(lArray[1], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            }
        }
        regionGroupResult = new RegionGroupResult(datasetGrid, datasetVector);
        return regionGroupResult;
    }

    public static DatasetGrid nibble(DatasetGrid sourceDataset, DatasetGrid maskDataset, DatasetGrid zoneDataset, Datasource targetDatasource, String targetDatasetName, boolean isMaskNoValue, boolean isNibbleNoValue) {
        GeneralizeAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (maskDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)maskDataset) == 0L) {
            String string = InternalResource.loadString("maskDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)maskDataset);
        long l4 = 0L;
        if (zoneDataset != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)zoneDataset) != 0L) {
            l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)zoneDataset);
        }
        long l5 = GeneralizeAnalystNative.jni_Nibble(l, l3, l4, l2, targetDatasetName, isMaskNoValue, isNibbleNoValue);
        DatasetGrid datasetGrid = null;
        if (l5 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l5, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid boundaryClean(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, BoundaryCleanSortType sortType, boolean isRunTwoTimes) {
        GeneralizeAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getPixelFormat() != PixelFormat.BIT8 && sourceDataset.getPixelFormat() != PixelFormat.BIT16 && sourceDataset.getPixelFormat() != PixelFormat.BIT32 && sourceDataset.getPixelFormat() != PixelFormat.BIT64 && sourceDataset.getPixelFormat() != PixelFormat.UBIT1 && sourceDataset.getPixelFormat() != PixelFormat.UBIT4 && sourceDataset.getPixelFormat() != PixelFormat.UBIT8 && sourceDataset.getPixelFormat() != PixelFormat.UBIT16 && sourceDataset.getPixelFormat() != PixelFormat.UBIT32) {
            String string = InternalResource.loadString("sourceDataset", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = GeneralizeAnalystNative.jni_BoundaryClean(l, l2, targetDatasetName, InternalEnum.getUGCValue(sortType), isRunTwoTimes);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid thin(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, long backOrNoValue) {
        GeneralizeAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l3 = ConversionAnalystNative.jni_ThinRasterBinary(l2, l, targetDatasetName, backOrNoValue, true);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

