/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.ImageAnalystNative;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.Datasource;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.Vector;

public class ImageAnalyst {
    private static transient Vector m_steppedListeners;

    private ImageAnalyst() {
    }

    public static DatasetGrid NDVI(DatasetImage sourceDataset, int nirIndex, int redIndex, String targetDatasetName, Datasource targetDatasource) {
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (nirIndex < 0) {
            String string = InternalResource.loadString("nirIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!sourceDataset.isOpen()) {
            sourceDataset.open();
        }
        if (nirIndex >= sourceDataset.getBandCount()) {
            String string = InternalResource.loadString("nirIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (redIndex < 0) {
            String string = InternalResource.loadString("redIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (redIndex >= sourceDataset.getBandCount()) {
            String string = InternalResource.loadString("redIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGrid datasetGrid = null;
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l3 = ImageAnalystNative.jni_NDVI(l2, nirIndex, redIndex, targetDatasetName, l);
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid NDVI(DatasetImage nirDataset, int nirIndex, DatasetImage redDataset, int redIndex, String targetDatasetName, Datasource targetDatasource) {
        return ImageAnalyst.NDVI(nirDataset, nirIndex, redDataset, redIndex, targetDatasetName, targetDatasource, -9999.0);
    }

    public static DatasetGrid NDVI(DatasetImage nirDataset, int nirIndex, DatasetImage redDataset, int redIndex, String targetDatasetName, Datasource targetDatasource, double noValue) {
        long l;
        if (nirDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)nirDataset) == 0L) {
            String string = InternalResource.loadString("nirDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (redDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)redDataset) == 0L) {
            String string = InternalResource.loadString("redDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!nirDataset.isOpen()) {
            nirDataset.open();
        }
        if (!redDataset.isOpen()) {
            redDataset.open();
        }
        if (nirIndex < 0) {
            String string = InternalResource.loadString("nirIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (nirIndex >= nirDataset.getBandCount()) {
            String string = InternalResource.loadString("nirIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (redIndex < 0) {
            String string = InternalResource.loadString("redIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (redIndex >= redDataset.getBandCount()) {
            String string = InternalResource.loadString("redIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGrid datasetGrid = null;
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)nirDataset);
        long l4 = ImageAnalystNative.jni_NDVITwo(l3, nirIndex, l = InternalHandle.getHandle((com.supermap.data.InternalHandle)redDataset), redIndex, targetDatasetName, l2, noValue);
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid NDWI(DatasetImage sourceDataset, int nirIndex, int greenIndex, String targetDatasetName, Datasource targetDatasource) {
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!sourceDataset.isOpen()) {
            sourceDataset.open();
        }
        if (nirIndex < 0) {
            String string = InternalResource.loadString("nirIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (greenIndex < 0) {
            String string = InternalResource.loadString("greenIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (nirIndex >= sourceDataset.getBandCount()) {
            String string = InternalResource.loadString("nirIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (greenIndex >= sourceDataset.getBandCount()) {
            String string = InternalResource.loadString("greenIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGrid datasetGrid = null;
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l3 = ImageAnalystNative.jni_NDVI(l2, greenIndex, nirIndex, targetDatasetName, l);
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid NDWI(DatasetImage nirDataset, int nirIndex, DatasetImage greenDataset, int greenIndex, String targetDatasetName, Datasource targetDatasource) {
        return ImageAnalyst.NDWI(nirDataset, nirIndex, greenDataset, greenIndex, targetDatasetName, targetDatasource, -9999.0);
    }

    public static DatasetGrid NDWI(DatasetImage nirDataset, int nirIndex, DatasetImage greenDataset, int greenIndex, String targetDatasetName, Datasource targetDatasource, double noValue) {
        if (nirDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)nirDataset) == 0L) {
            String string = InternalResource.loadString("nirDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (greenDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)greenDataset) == 0L) {
            String string = InternalResource.loadString("greenDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!nirDataset.isOpen()) {
            nirDataset.open();
        }
        if (!greenDataset.isOpen()) {
            greenDataset.open();
        }
        if (nirIndex < 0) {
            String string = InternalResource.loadString("nirIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (greenIndex < 0) {
            String string = InternalResource.loadString("greenIndex", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (nirIndex >= nirDataset.getBandCount()) {
            String string = InternalResource.loadString("nirIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (greenIndex >= greenDataset.getBandCount()) {
            String string = InternalResource.loadString("greenIndex", "Global_IndexOutOfBounds", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGrid datasetGrid = null;
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)nirDataset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)greenDataset);
        long l4 = ImageAnalystNative.jni_NDVITwo(l3, greenIndex, l2, nirIndex, targetDatasetName, l, noValue);
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "Generalization";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        ImageAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }
}

