/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.CalibrateOptions;
import com.supermap.analyst.spatialanalyst.CreateMarkPointsParameter;
import com.supermap.analyst.spatialanalyst.EventDissolveType;
import com.supermap.analyst.spatialanalyst.EventOverlayType;
import com.supermap.analyst.spatialanalyst.GenerateEventTableParameter;
import com.supermap.analyst.spatialanalyst.GenerateRoutesParameter;
import com.supermap.analyst.spatialanalyst.GenerateSpatialDataParameter;
import com.supermap.analyst.spatialanalyst.GenerateType;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.LinearReferencingNative;
import com.supermap.analyst.spatialanalyst.RouteEventsParameter;
import com.supermap.analyst.spatialanalyst.StatisticsType;
import com.supermap.data.CalibrateMode;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.DynamicSegmentInfo;
import com.supermap.data.DynamicSegmentManager;
import com.supermap.data.FieldType;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.Vector;

public class LinearReferencing {
    private static transient Vector m_steppedListeners;

    private LinearReferencing() {
    }

    public static DatasetVector generateRoutes(DatasetVector referenceLine, GenerateRoutesParameter parameter) {
        String string;
        if (referenceLine == null) {
            String string2 = InternalResource.loadString("referenceLine", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (parameter == null) {
            String string3 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        Datasource datasource = null;
        datasource = parameter.getOutputDatasource() != null ? parameter.getOutputDatasource() : referenceLine.getDatasource();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        String string4 = parameter.getOutputDatasetName();
        if (!datasource.getDatasets().isAvailableDatasetName(string4)) {
            String string5 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)referenceLine);
        double d = parameter.getMeasureOffset();
        double d2 = parameter.getRatio();
        boolean bl = parameter.getIgnoringGaps();
        boolean bl2 = LinearReferencing.isShowProgress();
        GenerateType generateType = parameter.getType();
        long l3 = 0L;
        if (generateType == GenerateType.BY_LENGTH) {
            l3 = LinearReferencingNative.jni_GenerateRoutesByLength(l2, l, string4, d, d2, bl, bl2);
        } else if (generateType == GenerateType.BY_SINGLE_FIELD) {
            string = parameter.getMeasureEndField();
            if (referenceLine.getFieldInfos().indexOf(string) == -1) {
                String string6 = InternalResource.loadString("measureEndField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
            if (referenceLine.getFieldInfos().get(string).getType() == FieldType.BOOLEAN || referenceLine.getFieldInfos().get(string).getType() == FieldType.BYTE || referenceLine.getFieldInfos().get(string).getType() == FieldType.DATETIME || referenceLine.getFieldInfos().get(string).getType() == FieldType.LONGBINARY) {
                String string7 = InternalResource.loadString("measureEndField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string7);
            }
            String string8 = parameter.getLineRouteIDField();
            if (referenceLine.getFieldInfos().indexOf(string8) != -1) {
                if (referenceLine.getFieldInfos().get(string8).getType() == FieldType.BOOLEAN || referenceLine.getFieldInfos().get(string8).getType() == FieldType.BYTE || referenceLine.getFieldInfos().get(string8).getType() == FieldType.DATETIME || referenceLine.getFieldInfos().get(string8).getType() == FieldType.LONGBINARY || referenceLine.getFieldInfos().get(string8).getType() == FieldType.DOUBLE || referenceLine.getFieldInfos().get(string8).getType() == FieldType.SINGLE) {
                    String string9 = InternalResource.loadString("strFieldRoadRouteID", "FieldInfos_Unsupported", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string9);
                }
            } else {
                string8 = null;
            }
            l3 = LinearReferencingNative.jni_GenerateRoutesByField(l2, l, string4, string, null, string8, d, d2, bl, bl2);
        } else if (generateType == GenerateType.BY_DOUBLE_FIELDS) {
            string = parameter.getMeasureStartField();
            String string10 = parameter.getMeasureEndField();
            if (referenceLine.getFieldInfos().indexOf(string) == -1) {
                String string11 = InternalResource.loadString("measureStartField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string11);
            }
            if (referenceLine.getFieldInfos().indexOf(string10) == -1) {
                String string12 = InternalResource.loadString("measureEndField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string12);
            }
            if (referenceLine.getFieldInfos().get(string).getType() == FieldType.BOOLEAN || referenceLine.getFieldInfos().get(string).getType() == FieldType.BYTE || referenceLine.getFieldInfos().get(string).getType() == FieldType.DATETIME || referenceLine.getFieldInfos().get(string).getType() == FieldType.LONGBINARY) {
                String string13 = InternalResource.loadString("measureStartField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string13);
            }
            if (referenceLine.getFieldInfos().get(string10).getType() == FieldType.BOOLEAN || referenceLine.getFieldInfos().get(string10).getType() == FieldType.BYTE || referenceLine.getFieldInfos().get(string10).getType() == FieldType.DATETIME || referenceLine.getFieldInfos().get(string10).getType() == FieldType.LONGBINARY) {
                String string14 = InternalResource.loadString("measureEndField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string14);
            }
            String string15 = parameter.getLineRouteIDField();
            if (referenceLine.getFieldInfos().indexOf(string15) != -1) {
                if (referenceLine.getFieldInfos().get(string15).getType() == FieldType.BOOLEAN || referenceLine.getFieldInfos().get(string15).getType() == FieldType.BYTE || referenceLine.getFieldInfos().get(string15).getType() == FieldType.DATETIME || referenceLine.getFieldInfos().get(string15).getType() == FieldType.LONGBINARY || referenceLine.getFieldInfos().get(string15).getType() == FieldType.DOUBLE || referenceLine.getFieldInfos().get(string15).getType() == FieldType.SINGLE) {
                    String string16 = InternalResource.loadString("strFieldRoadRouteID", "FieldInfos_Unsupported", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string16);
                }
            } else {
                string15 = null;
            }
            l3 = LinearReferencingNative.jni_GenerateRoutesByField(l2, l, string4, string, string10, string15, d, d2, bl, bl2);
        } else if (generateType == GenerateType.BY_POINT) {
            string = parameter.getDatasetPoint();
            if (string == null) {
                String string17 = InternalResource.loadString("referencePoint", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string17);
            }
            String string18 = parameter.getMeasureField();
            if (string.getFieldInfos().indexOf(string18) == -1) {
                String string19 = InternalResource.loadString("measureField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string19);
            }
            if (string.getFieldInfos().get(string18).getType() == FieldType.BOOLEAN || string.getFieldInfos().get(string18).getType() == FieldType.BYTE || string.getFieldInfos().get(string18).getType() == FieldType.DATETIME || string.getFieldInfos().get(string18).getType() == FieldType.LONGBINARY) {
                String string20 = InternalResource.loadString("measureField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string20);
            }
            String string21 = parameter.getLineRouteIDField();
            if (referenceLine.getFieldInfos().indexOf(string21) == -1) {
                String string22 = InternalResource.loadString("strFieldRoadRouteID", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string22);
            }
            if (referenceLine.getFieldInfos().get(string21).getType() == FieldType.BOOLEAN || referenceLine.getFieldInfos().get(string21).getType() == FieldType.BYTE || referenceLine.getFieldInfos().get(string21).getType() == FieldType.DATETIME || referenceLine.getFieldInfos().get(string21).getType() == FieldType.LONGBINARY || referenceLine.getFieldInfos().get(string21).getType() == FieldType.DOUBLE || referenceLine.getFieldInfos().get(string21).getType() == FieldType.SINGLE) {
                String string23 = InternalResource.loadString("strFieldRoadRouteID", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string23);
            }
            String string24 = parameter.getPointRouteIDField();
            if (string.getFieldInfos().indexOf(string24) == -1) {
                String string25 = InternalResource.loadString("strFieldPointRouteID", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string25);
            }
            if (string.getFieldInfos().get(string24).getType() == FieldType.BOOLEAN || string.getFieldInfos().get(string24).getType() == FieldType.BYTE || string.getFieldInfos().get(string24).getType() == FieldType.DATETIME || string.getFieldInfos().get(string24).getType() == FieldType.LONGBINARY || string.getFieldInfos().get(string24).getType() == FieldType.DOUBLE || string.getFieldInfos().get(string24).getType() == FieldType.SINGLE) {
                String string26 = InternalResource.loadString("strFieldPointRouteID", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string26);
            }
            long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)string);
            String string27 = parameter.getErrorInfoField();
            double d3 = parameter.getTolerance();
            if (parameter.getToleranceUnit() != null) {
                d3 = d3 * (double)parameter.getToleranceUnit().value() / (double)referenceLine.getPrjCoordSys().getCoordUnit().value();
            }
            l3 = LinearReferencingNative.jni_GenerateRoutesByPoint(l2, string21, l4, string24, string18, string27, l, string4, d, d2, bl, d3, bl2);
            string.close();
            string.open();
        }
        string = null;
        if (l3 != 0L) {
            string = InternalDatasetVector.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)string);
        }
        return string;
    }

    public static DatasetVector calibrateRoutes(DatasetVector referenceLineM, String routeIDField, DatasetVector calibratePointDataset, String calibrateRouteID, String measureField, CalibrateOptions options, Datasource outputDatasource, String outputDatasetName) {
        if (referenceLineM == null) {
            String string = InternalResource.loadString("referenceLineM", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (calibratePointDataset == null) {
            String string = InternalResource.loadString("calibratePointDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (referenceLineM.getFieldInfos().indexOf(routeIDField) == -1) {
            String string = InternalResource.loadString("routeIDField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (referenceLineM.getFieldInfos().get(routeIDField).getType() == FieldType.BOOLEAN || referenceLineM.getFieldInfos().get(routeIDField).getType() == FieldType.BYTE || referenceLineM.getFieldInfos().get(routeIDField).getType() == FieldType.DATETIME || referenceLineM.getFieldInfos().get(routeIDField).getType() == FieldType.LONGBINARY || referenceLineM.getFieldInfos().get(routeIDField).getType() == FieldType.DOUBLE || referenceLineM.getFieldInfos().get(routeIDField).getType() == FieldType.SINGLE) {
            String string = InternalResource.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (calibratePointDataset.getFieldInfos().indexOf(calibrateRouteID) == -1) {
            String string = InternalResource.loadString("calibrateRouteID", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (calibratePointDataset.getFieldInfos().get(calibrateRouteID).getType() == FieldType.BOOLEAN || calibratePointDataset.getFieldInfos().get(calibrateRouteID).getType() == FieldType.BYTE || calibratePointDataset.getFieldInfos().get(calibrateRouteID).getType() == FieldType.DATETIME || calibratePointDataset.getFieldInfos().get(calibrateRouteID).getType() == FieldType.LONGBINARY || calibratePointDataset.getFieldInfos().get(calibrateRouteID).getType() == FieldType.DOUBLE || calibratePointDataset.getFieldInfos().get(calibrateRouteID).getType() == FieldType.SINGLE) {
            String string = InternalResource.loadString("calibrateRouteID", "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (calibratePointDataset.getFieldInfos().indexOf(measureField) == -1) {
            String string = InternalResource.loadString("measureField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (calibratePointDataset.getFieldInfos().get(measureField).getType() == FieldType.BOOLEAN || calibratePointDataset.getFieldInfos().get(measureField).getType() == FieldType.BYTE || calibratePointDataset.getFieldInfos().get(measureField).getType() == FieldType.DATETIME || calibratePointDataset.getFieldInfos().get(measureField).getType() == FieldType.LONGBINARY) {
            String string = InternalResource.loadString("measureField", "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            outputDatasource = referenceLineM.getDatasource();
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        CalibrateMode calibrateMode = options.getRouteCalibrationMode();
        int n = calibrateMode.value();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)referenceLineM);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)calibratePointDataset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        double d = options.getTolerance();
        boolean bl = options.getRetainingAllRoutes();
        String string = options.getErrorInfoField();
        boolean bl2 = options.getIgnoringGaps();
        boolean bl3 = LinearReferencing.isShowProgress();
        if (options.getToleranceUnit() != null) {
            d = d * (double)options.getToleranceUnit().value() / (double)referenceLineM.getPrjCoordSys().getCoordUnit().value();
        }
        long l4 = LinearReferencingNative.jni_CalibrateRoutes(l, routeIDField, l2, calibrateRouteID, measureField, l3, outputDatasetName, d, n, bl, true, true, true, string, bl2, bl3);
        calibratePointDataset.close();
        calibratePointDataset.open();
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector generateEventTable(DatasetVector referenceLineM, GenerateEventTableParameter parameter) {
        if (referenceLineM == null) {
            String string = InternalResource.loadString("referenceLineM", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (referenceLineM.getFieldInfos().indexOf(parameter.getRouteIDField()) == -1) {
            String string = InternalResource.loadString("routeIDField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (referenceLineM.getFieldInfos().get(parameter.getRouteIDField()).getType() == FieldType.BOOLEAN || referenceLineM.getFieldInfos().get(parameter.getRouteIDField()).getType() == FieldType.BYTE || referenceLineM.getFieldInfos().get(parameter.getRouteIDField()).getType() == FieldType.DATETIME || referenceLineM.getFieldInfos().get(parameter.getRouteIDField()).getType() == FieldType.LONGBINARY || referenceLineM.getFieldInfos().get(parameter.getRouteIDField()).getType() == FieldType.DOUBLE || referenceLineM.getFieldInfos().get(parameter.getRouteIDField()).getType() == FieldType.SINGLE) {
            String string = InternalResource.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        Datasource datasource = null;
        datasource = parameter.getOutputDatasource() != null ? parameter.getOutputDatasource() : referenceLineM.getDatasource();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)referenceLineM);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getEventDataset());
        String string = parameter.getOutputDatasetName();
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string2 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = parameter.getOutputDatasetRouteField();
        String string4 = parameter.getMeasureStartField();
        String string5 = parameter.getMeasureEndField();
        String string6 = parameter.getMeasureField();
        String string7 = parameter.getRouteIDField();
        boolean bl = parameter.getRetainingAllFields();
        double d = parameter.getSearchRadius();
        boolean bl2 = parameter.hasDistanceField();
        boolean bl3 = parameter.getFindingClosestRoute();
        boolean bl4 = LinearReferencing.isShowProgress();
        int n = 0;
        if (parameter.getEventDataset().getType() == DatasetType.POINT) {
            n = 1;
        } else if (parameter.getEventDataset().getType() == DatasetType.LINE) {
            n = 2;
        }
        d = d * (double)parameter.getSearchRadiusUnit().value() / (double)referenceLineM.getPrjCoordSys().getCoordUnit().value();
        if (n == 1) {
            // empty if block
        }
        if (n == 2) {
            // empty if block
        }
        long l4 = LinearReferencingNative.jni_GenerateEventTable(l, string7, l3, l2, string, n, string3, string4, string5, string6, bl, d, bl2, bl3, bl4);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector generateSpatialData(GenerateSpatialDataParameter parameter) {
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (parameter.getReferenceLineM() == null) {
            String string = InternalResource.loadString("referenceLineM", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        String string = parameter.getRouteIDField();
        if (parameter.getReferenceLineM().getFieldInfos().indexOf(string) == -1) {
            String string2 = InternalResource.loadString("RouteIDField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        if (parameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.BOOLEAN || parameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.BYTE || parameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.DATETIME || parameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.LONGBINARY || parameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.DOUBLE || parameter.getReferenceLineM().getFieldInfos().get(string).getType() == FieldType.SINGLE) {
            String string3 = InternalResource.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getReferenceLineM());
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getEventTable());
        if (parameter.getReferenceLineM().getDatasource() != parameter.getEventTable().getDatasource()) {
            String string4 = InternalResource.loadString("ReferenceLineM and EventTable", "Datasource_MustBe_Same", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        DynamicSegmentInfo[] dynamicSegmentInfoArray = DynamicSegmentManager.getDynamicSegmentInfos((DatasetVector)parameter.getEventTable());
        if (dynamicSegmentInfoArray != null) {
            String string5 = InternalResource.loadString("EventTable", "Relation_Has_Exist", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        String string6 = parameter.getErrorInfoField();
        Datasource datasource = null;
        datasource = parameter.getReferenceLineM().getDatasource();
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        String string7 = parameter.getOutputDatasetName();
        if (!datasource.getDatasets().isAvailableDatasetName(string7)) {
            String string8 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        String string9 = parameter.getEventRouteIDField();
        String string10 = parameter.getMeasureStartField();
        String string11 = parameter.getMeasureEndField();
        String string12 = parameter.getMeasureField();
        String string13 = parameter.getMeasureOffsetField();
        if (!(string13 == null || string13.trim().equals("") || parameter.getEventTable().getFieldInfos().get(string13).getType() != FieldType.BOOLEAN && parameter.getEventTable().getFieldInfos().get(string13).getType() != FieldType.BYTE && parameter.getEventTable().getFieldInfos().get(string13).getType() != FieldType.DATETIME && parameter.getEventTable().getFieldInfos().get(string13).getType() != FieldType.LONGBINARY)) {
            String string14 = InternalResource.loadString("MeasureOffsetField", "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string14);
        }
        boolean bl = true;
        if (string12 == null) {
            if (string10 == null || string11 == null) {
                String string15 = InternalResource.loadString("MeasureStartField or measureEndField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string15);
            }
            if (parameter.getEventTable().getFieldInfos().get(string10).getType() == FieldType.BOOLEAN || parameter.getEventTable().getFieldInfos().get(string10).getType() == FieldType.BYTE || parameter.getEventTable().getFieldInfos().get(string10).getType() == FieldType.DATETIME || parameter.getEventTable().getFieldInfos().get(string10).getType() == FieldType.LONGBINARY) {
                String string16 = InternalResource.loadString("MeasureStartField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string16);
            }
            if (parameter.getEventTable().getFieldInfos().get(string11).getType() == FieldType.BOOLEAN || parameter.getEventTable().getFieldInfos().get(string11).getType() == FieldType.BYTE || parameter.getEventTable().getFieldInfos().get(string11).getType() == FieldType.DATETIME || parameter.getEventTable().getFieldInfos().get(string11).getType() == FieldType.LONGBINARY) {
                String string17 = InternalResource.loadString("MeasureEndField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string17);
            }
            bl = false;
        } else {
            if (parameter.getEventTable().getFieldInfos().get(string12).getType() == FieldType.BOOLEAN || parameter.getEventTable().getFieldInfos().get(string12).getType() == FieldType.BYTE || parameter.getEventTable().getFieldInfos().get(string12).getType() == FieldType.DATETIME || parameter.getEventTable().getFieldInfos().get(string12).getType() == FieldType.LONGBINARY) {
                String string18 = InternalResource.loadString("MeasureField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string18);
            }
            bl = true;
        }
        String[] stringArray = parameter.getRetainedFields();
        boolean bl2 = LinearReferencing.isShowProgress();
        long l4 = LinearReferencingNative.jni_GenerateSpatialData(l, l2, string6, l3, string7, string9, string10, string11, string12, string, string13, stringArray, bl2, bl);
        parameter.getEventTable().close();
        parameter.getEventTable().open();
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector dissolveRouteEvents(RouteEventsParameter inputEventsParameter, String[] dissolveFields, EventDissolveType eventDissolveType, Datasource outputDatasource, String outputDatasetName, RouteEventsParameter resultEventsParameter, String[] statisticFields, StatisticsType[] statisticModes, double tolerance) {
        int n;
        int n2;
        if (inputEventsParameter == null) {
            String string = InternalResource.loadString("routeEventsParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (inputEventsParameter.getEventDataset() == null) {
            String string = InternalResource.loadString("inputEventsParameter.getEventDataset()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (outputDatasource == null) {
            outputDatasource = inputEventsParameter.getEventDataset().getDatasource();
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("datasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (dissolveFields.length < 1) {
            String string = InternalResource.loadString("dissolveFields", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        String[] stringArray = new String[4];
        String[] stringArray2 = new String[4];
        int n3 = inputEventsParameter.getType().value();
        stringArray[0] = inputEventsParameter.getRouteIDField();
        stringArray[1] = inputEventsParameter.getMeasureField();
        stringArray[2] = inputEventsParameter.getMeasureStartField();
        stringArray[3] = inputEventsParameter.getMeasureEndField();
        for (n2 = 0; n2 < 4; ++n2) {
            if (n3 == 1 && (n2 == 2 || n2 == 3) || n3 == 2 && n2 == 1) continue;
            if (stringArray[n2] == null || stringArray[n2].trim().length() == 0) {
                String string = InternalResource.loadString(stringArray[n2], "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (inputEventsParameter.getEventDataset().getFieldInfos().indexOf(stringArray[n2]) == -1) {
                String string = InternalResource.loadString(stringArray[n2], "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (n2 == 0) {
                if (inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.BOOLEAN && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.BYTE && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.DATETIME && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.LONGBINARY && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.DOUBLE && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.SINGLE) continue;
                String string = InternalResource.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.BOOLEAN && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.BYTE && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.DATETIME && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n2]).getType() != FieldType.LONGBINARY) continue;
            String string = InternalResource.loadString(stringArray[n2], "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        n2 = eventDissolveType.value();
        stringArray2[0] = resultEventsParameter.getRouteIDField();
        stringArray2[1] = resultEventsParameter.getMeasureField();
        stringArray2[2] = resultEventsParameter.getMeasureStartField();
        stringArray2[3] = resultEventsParameter.getMeasureEndField();
        if (stringArray2[0].trim().equals("")) {
            stringArray2[0] = stringArray[0];
        }
        if (stringArray2[1].trim().equals("")) {
            stringArray2[1] = stringArray[1];
        }
        if (stringArray2[2].trim().equals("")) {
            stringArray2[2] = stringArray[2];
        }
        if (stringArray2[3].trim().equals("")) {
            stringArray2[3] = stringArray[3];
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)inputEventsParameter.getEventDataset());
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        int n4 = statisticModes.length;
        int[] nArray = new int[n4];
        for (n = 0; n < n4; n += 1) {
            nArray[n] = statisticModes[n].value();
        }
        n = LinearReferencing.isShowProgress() ? 1 : 0;
        long l3 = LinearReferencingNative.jni_DissolveRouteEvents(l, dissolveFields, l2, outputDatasetName, stringArray, stringArray2, statisticFields, nArray, n2, tolerance, n3, n != 0);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector overlayRouteEvents(RouteEventsParameter inputEventsParameter, RouteEventsParameter overlayEventParameter, EventOverlayType eventOverlayType, Datasource outputDatasource, String outputDatasetName, RouteEventsParameter resultEventsParameter, double tolerance, boolean isKeepField, boolean isKeepZeroLengthEvents) {
        if (inputEventsParameter == null || overlayEventParameter == null) {
            return null;
        }
        if (inputEventsParameter.getEventDataset() == null) {
            String string = InternalResource.loadString("inputEventsParameter.getEventDataset()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (overlayEventParameter.getEventDataset() == null) {
            String string = InternalResource.loadString("overlayEventParameter.getEventDataset()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (outputDatasource == null) {
            outputDatasource = inputEventsParameter.getEventDataset().getDatasource();
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("datasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = new String[4];
        String[] stringArray2 = new String[4];
        String[] stringArray3 = new String[4];
        int n = 0;
        int n2 = eventOverlayType.value();
        int n3 = inputEventsParameter.getType().value();
        int n4 = overlayEventParameter.getType().value();
        stringArray[0] = inputEventsParameter.getRouteIDField();
        stringArray[1] = inputEventsParameter.getMeasureField();
        stringArray[2] = inputEventsParameter.getMeasureStartField();
        stringArray[3] = inputEventsParameter.getMeasureEndField();
        for (n = 0; n < 4; ++n) {
            if (n3 == 1 && (n == 2 || n == 3) || n3 == 2 && n == 1) continue;
            if (stringArray[n] == null || stringArray[n].trim().length() == 0) {
                String string = InternalResource.loadString(stringArray[n], "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (inputEventsParameter.getEventDataset().getFieldInfos().indexOf(stringArray[n]) == -1) {
                String string = InternalResource.loadString(stringArray[n], "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (n == 0) {
                if (inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.BOOLEAN && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.BYTE && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.DATETIME && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.LONGBINARY && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.DOUBLE && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.SINGLE) continue;
                String string = InternalResource.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.BOOLEAN && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.BYTE && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.DATETIME && inputEventsParameter.getEventDataset().getFieldInfos().get(stringArray[n]).getType() != FieldType.LONGBINARY) continue;
            String string = InternalResource.loadString(stringArray[n], "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        stringArray2[0] = overlayEventParameter.getRouteIDField();
        stringArray2[1] = overlayEventParameter.getMeasureField();
        stringArray2[2] = overlayEventParameter.getMeasureStartField();
        stringArray2[3] = overlayEventParameter.getMeasureEndField();
        for (n = 0; n < 4; ++n) {
            if (n4 == 1 && (n == 2 || n == 3) || n4 == 2 && n == 1) continue;
            if (stringArray2[n] == null || stringArray2[n].trim().length() == 0) {
                String string = InternalResource.loadString(stringArray2[n], "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (overlayEventParameter.getEventDataset().getFieldInfos().indexOf(stringArray2[n]) == -1) {
                String string = InternalResource.loadString(stringArray2[n], "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (n == 0) {
                if (overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.BOOLEAN && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.BYTE && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.DATETIME && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.LONGBINARY && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.DOUBLE && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.SINGLE) continue;
                String string = InternalResource.loadString("routeIDField", "FieldInfos_Unsupported", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.BOOLEAN && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.BYTE && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.DATETIME && overlayEventParameter.getEventDataset().getFieldInfos().get(stringArray2[n]).getType() != FieldType.LONGBINARY) continue;
            String string = InternalResource.loadString(stringArray2[n], "FieldInfos_Unsupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        stringArray3[0] = resultEventsParameter.getRouteIDField();
        stringArray3[1] = resultEventsParameter.getMeasureField();
        stringArray3[2] = resultEventsParameter.getMeasureStartField();
        stringArray3[3] = resultEventsParameter.getMeasureEndField();
        if (n3 == 1) {
            if (stringArray3[0].trim().equals("")) {
                stringArray3[0] = stringArray2[0];
            }
            if (stringArray3[1].trim().equals("")) {
                stringArray3[1] = stringArray2[1];
            }
            if (stringArray3[2].trim().equals("")) {
                stringArray3[2] = stringArray2[2];
            }
            if (stringArray3[3].trim().equals("")) {
                stringArray3[3] = stringArray2[3];
            }
        } else {
            if (stringArray3[0].trim().equals("")) {
                stringArray3[0] = stringArray[0];
            }
            if (stringArray3[1].trim().equals("")) {
                stringArray3[1] = stringArray[1];
            }
            if (stringArray3[2].trim().equals("")) {
                stringArray3[2] = stringArray[2];
            }
            if (stringArray3[3].trim().equals("")) {
                stringArray3[3] = stringArray[3];
            }
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)inputEventsParameter.getEventDataset());
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)overlayEventParameter.getEventDataset());
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        boolean bl = LinearReferencing.isShowProgress();
        long l4 = LinearReferencingNative.jni_OverlayRouteEvents(l, l2, n2, l3, outputDatasetName, stringArray, stringArray2, stringArray3, tolerance, isKeepField, n3, n4, isKeepZeroLengthEvents, bl);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static boolean rebuildSpatialData(DatasetVector eventTable) {
        if (eventTable == null) {
            String string = InternalResource.loadString("eventTable", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)eventTable);
        DynamicSegmentInfo[] dynamicSegmentInfoArray = DynamicSegmentManager.getDynamicSegmentInfos((DatasetVector)eventTable);
        if (dynamicSegmentInfoArray == null) {
            String string = InternalResource.loadString("EventTable", "Relation_Has_Not_Exist", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = LinearReferencing.isShowProgress();
        boolean bl2 = LinearReferencingNative.jni_RebuildSpatialData(l, null, bl);
        return bl2;
    }

    static boolean rebuildSpatialData(DatasetVector eventTable, String Errorfield) {
        if (eventTable == null) {
            String string = InternalResource.loadString("eventTable", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)eventTable);
        DynamicSegmentInfo[] dynamicSegmentInfoArray = DynamicSegmentManager.getDynamicSegmentInfos((DatasetVector)eventTable);
        if (dynamicSegmentInfoArray == null) {
            String string = InternalResource.loadString("EventTable", "Relation_Has_Not_Exist", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = LinearReferencing.isShowProgress();
        boolean bl2 = LinearReferencingNative.jni_RebuildSpatialData(l, Errorfield, bl);
        return bl2;
    }

    public static DatasetVector createMarkPoints(CreateMarkPointsParameter parameter) {
        DatasetVector datasetVector = parameter.getLineMDataset();
        if (datasetVector == null) {
            String string = InternalResource.loadString("parameter.getLineMDataset()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (datasetVector.getFieldInfos().indexOf(parameter.getRouteIDField()) == -1) {
            String string = InternalResource.loadString("routeIDField", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        Datasource datasource = parameter.getOutputDatasource();
        if (datasource == null) {
            datasource = datasetVector.getDatasource();
        }
        if (!datasource.getDatasets().isAvailableDatasetName(parameter.getOutputDatasetName())) {
            String string = InternalResource.loadString("datasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = LinearReferencingNative.jni_CreateMarkPoints(l, parameter.getRouteIDField(), l2, parameter.getOutputDatasetName(), parameter.getMarkScale());
        DatasetVector datasetVector2 = null;
        if (l3 != 0L) {
            datasetVector2 = InternalDatasetVector.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector2);
        }
        return datasetVector2;
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "LinearReferencing";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        LinearReferencing.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    private static boolean isShowProgress() {
        return m_steppedListeners != null;
    }
}

