/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.SolarRadiationNative;
import com.supermap.analyst.spatialanalyst.SolarRadiationParameter;
import com.supermap.analyst.spatialanalyst.SolarRadiationResult;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Datasource;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class SolarRadiation {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private SolarRadiation() {
    }

    public static SolarRadiationResult areaSolarRadiation(DatasetGrid sourceDatasetGrid, SolarRadiationParameter parameter, Datasource targetDatasource, String totalGridName, String directGridName, String diffuseGridName, String durationGridName) {
        if (sourceDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (parameter == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter) == 0L) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (totalGridName == null) {
            String string = InternalResource.loadString("totalGridName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(totalGridName)) {
            String string = InternalResource.loadString("totalGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (directGridName != null && !directGridName.isEmpty() && !targetDatasource.getDatasets().isAvailableDatasetName(directGridName)) {
            String string = InternalResource.loadString("directGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (diffuseGridName != null && !diffuseGridName.isEmpty() && !targetDatasource.getDatasets().isAvailableDatasetName(diffuseGridName)) {
            String string = InternalResource.loadString("diffuseGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (durationGridName != null && !durationGridName.isEmpty() && !targetDatasource.getDatasets().isAvailableDatasetName(durationGridName)) {
            String string = InternalResource.loadString("durationGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (parameter.getHourStart() > parameter.getHourEnd()) {
            String string = InternalResource.loadString("parameter", "StartHourCannotGreaterThanEndHour", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long[] lArray = SolarRadiationNative.jni_AreaSolarRadiation(l2, l, l3, totalGridName, directGridName, diffuseGridName, durationGridName);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
        SolarRadiationResult solarRadiationResult = null;
        if (lArray != null && lArray.length == 4 && lArray[0] != 0L) {
            DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(lArray[0], targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            DatasetGrid datasetGrid2 = null;
            if (lArray[1] != 0L) {
                datasetGrid2 = InternalDatasetGrid.createInstance(lArray[1], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid2);
            }
            DatasetGrid datasetGrid3 = null;
            if (lArray[2] != 0L) {
                datasetGrid3 = InternalDatasetGrid.createInstance(lArray[2], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid3);
            }
            DatasetGrid datasetGrid4 = null;
            if (lArray[3] != 0L) {
                datasetGrid4 = InternalDatasetGrid.createInstance(lArray[3], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid4);
            }
            solarRadiationResult = new SolarRadiationResult(datasetGrid, datasetGrid2, datasetGrid3, datasetGrid4);
        }
        return solarRadiationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "SolarRadiation";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SolarRadiation.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

