/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Enum;
import com.supermap.data.GeoStyle;
import com.supermap.data.InternalHandle;
import com.supermap.data.Unit;
import com.supermap.mapping.ChartSettingNative;
import com.supermap.mapping.ColourModeChart;
import com.supermap.mapping.DisplayModeChart;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import java.util.LinkedHashMap;
import java.util.Map;

public class ChartSetting
extends InternalHandle {
    private GeoStyle m_selectionStyle = null;

    ChartSetting(long handle) {
        this.setHandle(handle);
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    public void setDisplayModeChart(DisplayModeChart mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayModeChart()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetDisplayModeChart(this.getHandle(), mode.value());
    }

    public DisplayModeChart getDisplayModeChart() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDisplayModeChart()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ChartSettingNative.jni_GetDisplayModeChart(this.getHandle());
        return (DisplayModeChart)InternalEnum.parseUGCValue(DisplayModeChart.class, n);
    }

    public void setColourModeChart(ColourModeChart mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColourModeChart()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetColourModeChart(this.getHandle(), mode.value());
    }

    public ColourModeChart getColourModeChart() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDisplayModeChart()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ChartSettingNative.jni_GetColourModeChart(this.getHandle());
        return (ColourModeChart)InternalEnum.parseUGCValue(ColourModeChart.class, n);
    }

    public void setDisplayTypeName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayTypeName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetDisplayTypeName(this.getHandle(), value);
    }

    public String getDisplayTypeName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDisplayTypeName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_GetDisplayTypeName(this.getHandle());
    }

    public void setFontName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFontName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetFontName(this.getHandle(), value);
    }

    public String getFontName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFontName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_GetFontName(this.getHandle());
    }

    public void setFontSize(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFontSize()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetFontSize(this.getHandle(), value);
    }

    public double getFontSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFontSize()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_GetFontSize(this.getHandle());
    }

    public void setSimplifiedMarker(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSimplifiedMarker()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetSimplifiedMarker(this.getHandle(), value);
    }

    public boolean isSimplifiedMarker() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSimplifiedMarker()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_IsSimplifiedMarker(this.getHandle());
    }

    public void setSymbolizedAreaBoundary(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolizedAreaBoundary()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetSymbolizedAreaBoundary(this.getHandle(), value);
    }

    public boolean isSymbolizedAreaBoundary() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSymbolizedAreaBoundary()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_IsSymbolizedAreaBoundary(this.getHandle());
    }

    public void setDisplayTextMessage(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayTextMessage()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetDisplayTextMessage(this.getHandle(), value);
    }

    public boolean isDisplayTextMessage() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDisplayTextMessage()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_IsDisplayTextMessage(this.getHandle());
    }

    public void setDisplaySounding(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplaySounding()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetDisplaySounding(this.getHandle(), value);
    }

    public boolean isDisplaySounding() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDisplaySounding()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_IsDisplaySounding(this.getHandle());
    }

    public void setMinVisibleScaleEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinVisibleScaleEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetMinVisibleScaleEnabled(this.getHandle(), value);
    }

    public boolean isMinVisibleScaleEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMinVisibleScaleEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_IsMinVisibleScaleEnabled(this.getHandle());
    }

    public void setLocalizationDisplayText(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLocalizationDisplayText()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetLocalizationDisplayText(this.getHandle(), value);
    }

    public boolean isLocalizationDisplayText() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLocalizationDisplayText()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_IsLocalizationDisplayText(this.getHandle());
    }

    public boolean isDisplayMetaObject() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsDisplayMetaObject()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_IsDisplayMetaObject(this.getHandle());
    }

    public void setDisplayMetaObject(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetDisplayMetaObject()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetDisplayMetaObject(this.getHandle(), value);
    }

    public boolean isDisplayCellName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsDisplayCellName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_IsDisplayCellName(this.getHandle());
    }

    public void setDisplayCellName(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetDisplayCellName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetDisplayCellName(this.getHandle(), value);
    }

    public void setDisplaySafetyContourLabel(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplaySafetyContourLabel()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetDisplaySafetyContourLabel(this.getHandle(), value);
    }

    public boolean isDisplaySafetyContourLabel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDisplaySafetyContourLabel()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_IsDisplaySafetyContourLabel(this.getHandle());
    }

    public void setSafetyContour(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSafetyContour()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetSafetyContour(this.getHandle(), value);
    }

    public double getSafetyContour() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSafetyContour()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_GetSafetyContour(this.getHandle());
    }

    public void setShallowContour(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShallowContour()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetShallowContour(this.getHandle(), value);
    }

    public double getShallowContour() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getShallowContour()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_GetShallowContour(this.getHandle());
    }

    public void setDeepContour(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDeepContour()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetDeepContour(this.getHandle(), value);
    }

    public double getDeepContour() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDeepContour()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_GetDeepContour(this.getHandle());
    }

    public void setSafetyDepth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetSafetyDepth()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetSafetyDepth(this.getHandle(), value);
    }

    public double getSafetyDepth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetSafetyDepth()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_GetSafetyDepth(this.getHandle());
    }

    public void setDisplayOtherContourLabel(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetDisplayOtherContourLabel()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetDisplayOtherContourLabel(this.getHandle(), value);
    }

    public boolean isDisplayOtherContourLabel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsDisplayOtherContourLabel()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_IsDisplayOtherContourLabel(this.getHandle());
    }

    public void setDisplayTwoShades(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetDisplayTwoShades()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetDisplayTwoShades(this.getHandle(), value);
    }

    public boolean isDisplayTwoShades() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsDisplayTwoShades()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_IsDisplayTwoShades(this.getHandle());
    }

    public void setDepthUnit(Unit value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDepthUnit(Unit value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue((Enum)value);
        ChartSettingNative.jni_SetDepthUnit(this.getHandle(), n);
    }

    public Unit getDepthUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDepthUnit()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ChartSettingNative.jni_GetDepthUnit(this.getHandle());
        return (Unit)InternalEnum.parseUGCValue(Unit.class, n);
    }

    public void setTextClipRegionEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextClipRegionEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetTextClipRegionEnabled(this.getHandle(), value);
    }

    public boolean isTextClipRegionEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTextClipRegionEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_IsTextClipRegionEnabled(this.getHandle());
    }

    public void setDisplayableFeature(Map<String, Boolean> value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayFeature(HashMap<String, Boolean> value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        Object[] objectArray = value.keySet().toArray();
        int n = objectArray.length;
        boolean[] blArray = new boolean[n];
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string;
            stringArray[i] = string = (String)objectArray[i];
            blArray[i] = value.get(string);
        }
        ChartSettingNative.jni_SetDisplayableFeature(this.getHandle(), stringArray, blArray);
    }

    public Map<String, Boolean> getDisplayableFeature() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDisplayFeature()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ChartSettingNative.jni_GetDisplayableFeatureCount(this.getHandle());
        LinkedHashMap<String, Boolean> linkedHashMap = new LinkedHashMap<String, Boolean>();
        String[] stringArray = new String[n];
        boolean[] blArray = new boolean[n];
        ChartSettingNative.jni_GetDisplayableFeature(this.getHandle(), stringArray, blArray);
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            Boolean bl = blArray[i];
            linkedHashMap.put(string, bl);
        }
        return linkedHashMap;
    }

    public void setSelectableFeature(Map<String, Boolean> value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSelectableFeature(HashMap<String, Boolean> value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        Object[] objectArray = value.keySet().toArray();
        int n = objectArray.length;
        boolean[] blArray = new boolean[n];
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string;
            stringArray[i] = string = (String)objectArray[i];
            blArray[i] = value.get(string);
        }
        ChartSettingNative.jni_SetSelectableFeature(this.getHandle(), stringArray, blArray);
    }

    public Map<String, Boolean> getSelectableFeature() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelectableFeature()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ChartSettingNative.jni_GetSelectableFeatureCount(this.getHandle());
        LinkedHashMap<String, Boolean> linkedHashMap = new LinkedHashMap<String, Boolean>();
        String[] stringArray = new String[n];
        boolean[] blArray = new boolean[n];
        ChartSettingNative.jni_GetSelectableFeature(this.getHandle(), stringArray, blArray);
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            Boolean bl = blArray[i];
            linkedHashMap.put(string, bl);
        }
        return linkedHashMap;
    }

    public GeoStyle getSelectionStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelectionStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_selectionStyle == null && (l = ChartSettingNative.jni_GetSelectionStyle(this.getHandle())) != 0L) {
            this.m_selectionStyle = InternalGeoStyle.createInstance(l);
        }
        return this.m_selectionStyle;
    }

    public void setSelectionStyle(GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSelectionStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ChartSettingNative.jni_SetSelectionStyle(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
    }

    public boolean isDisplayLowAccurateMarker() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDisplayLowAccurateMarker()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_IsDisplayLowAccurateMarker(this.getHandle());
    }

    public void setDisplayLowAccurateMarker(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayLowAccurateMarker(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetDisplayLowAccurateMarker(this.getHandle(), value);
    }

    public double getDisplayScaleFactor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDisplayScaleFactor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_GetDisplayScaleFactor(this.getHandle());
    }

    public void setDisplayScaleFactor(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayScaleFactor(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldNotBeNegative", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetDisplayScaleFactor(this.getHandle(), value);
    }

    public boolean isDisplayBorder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDisplayBorder()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartSettingNative.jni_IsDisplayBorder(this.getHandle());
    }

    public void setDisplayBorder(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayBorder(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartSettingNative.jni_SetDisplayBorder(this.getHandle(), value);
    }
}

