/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.mapping.InternalGeometry;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Map;
import com.supermap.mapping.ScreenLayerAddedEvent;
import com.supermap.mapping.ScreenLayerAddedListener;
import com.supermap.mapping.ScreenLayerClearedEvent;
import com.supermap.mapping.ScreenLayerClearedListener;
import com.supermap.mapping.ScreenLayerGeometryChangedEvent;
import com.supermap.mapping.ScreenLayerGeometryChangedListener;
import com.supermap.mapping.ScreenLayerNative;
import com.supermap.mapping.ScreenLayerRemovedEvent;
import com.supermap.mapping.ScreenLayerRemovedListener;
import com.supermap.mapping.ScreenLayerTagChangedEvent;
import com.supermap.mapping.ScreenLayerTagChangedListener;
import com.supermap.mapping.ScreenLayerVisibleChangedEvent;
import com.supermap.mapping.ScreenLayerVisibleChangedListener;
import java.util.Vector;

public class ScreenLayer
extends InternalHandle {
    Map m_map;
    transient Vector m_screenLayerAddedListeners;
    transient Vector m_screenLayerRemovedListeners;
    transient Vector m_screenLayerGeometryChangedListeners;
    transient Vector m_screenLayerTagChangedListeners;
    transient Vector m_screenLayerClearedListeners;
    transient Vector m_screenLayerVisibleChangedListeners;

    private ScreenLayer(long handle, Map map) {
        this.setHandle(handle);
        this.m_map = map;
        this.reset();
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ScreenLayerNative.jni_GetCount(this.getHandle());
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ScreenLayerNative.jni_GetIsVisible(this.getHandle());
    }

    public void setVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ScreenLayerNative.jni_SetIsVisible(this.getHandle(), value);
        ScreenLayerVisibleChangedEvent screenLayerVisibleChangedEvent = new ScreenLayerVisibleChangedEvent((Object)this, value);
        this.fireScreenLayerVisibleChanged(screenLayerVisibleChangedEvent);
    }

    public boolean isAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ScreenLayerNative.jni_GetIsAntialias(this.getHandle());
    }

    public void setAntialias(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAntialias(value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ScreenLayerNative.jni_SetAntialias(this.getHandle(), value);
    }

    public int add(Geometry geometry, String tag) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Geometry geometry, String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (tag == null) {
            tag = "";
        }
        if ((n = ScreenLayerNative.jni_Add(this.getHandle(), l, tag)) != -1) {
            ScreenLayerAddedEvent screenLayerAddedEvent = new ScreenLayerAddedEvent((Object)this, n, geometry, tag);
            this.fireScreenLayerAdded(screenLayerAddedEvent);
        }
        this.makeSureNativeObjectLive((com.supermap.data.InternalHandleDisposable)geometry);
        return n;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("delete(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = ScreenLayerNative.jni_Delete(this.getHandle(), index);
        if (bl) {
            ScreenLayerRemovedEvent screenLayerRemovedEvent = new ScreenLayerRemovedEvent((Object)this, index);
            this.fireScreenLayerRemoved(screenLayerRemovedEvent);
        }
        return bl;
    }

    public Geometry get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry = null;
        long l = ScreenLayerNative.jni_Get(this.getHandle(), index);
        if (l != 0L) {
            geometry = InternalGeometry.createInstance2(l, this.m_map.getWorkspace());
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, true);
        }
        return geometry;
    }

    public boolean set(int index, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ScreenLayerNative.jni_Set(this.getHandle(), index, l);
        if (bl) {
            ScreenLayerGeometryChangedEvent screenLayerGeometryChangedEvent = new ScreenLayerGeometryChangedEvent((Object)this, index, geometry);
            this.fireScreenLayerGeometryChanged(screenLayerGeometryChangedEvent);
        }
        return bl;
    }

    public String getTag(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTag(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return ScreenLayerNative.jni_GetTag(this.getHandle(), index);
    }

    public boolean setTag(int index, String tag) {
        boolean bl;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTag(int index, String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (tag == null) {
            tag = "";
        }
        if (bl = ScreenLayerNative.jni_SetTag(this.getHandle(), index, tag)) {
            ScreenLayerTagChangedEvent screenLayerTagChangedEvent = new ScreenLayerTagChangedEvent((Object)this, index, tag);
            this.fireScreenLayerTagChanged(screenLayerTagChangedEvent);
        }
        return bl;
    }

    public int indexOf(String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (tag == null) {
            String string = InternalResource.loadString("indexOf(String tag)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return ScreenLayerNative.jni_IndexOf(this.getHandle(), tag);
    }

    public boolean setEditBulk(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEditBulk(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ScreenLayerNative.jni_SetEditBulk(this.getHandle(), value);
    }

    public boolean flushBulkEdit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("FlushBulkEdit()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ScreenLayerNative.jni_FlushBulkEdit(this.getHandle());
    }

    @Deprecated
    public boolean cancleBulkOperated() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CancleBulkOperated()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ScreenLayerNative.jni_CancleBulkOperated(this.getHandle());
    }

    public boolean cancelBulkOperated() {
        return this.cancleBulkOperated();
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ScreenLayerNative.jni_Clear(this.getHandle());
        ScreenLayerClearedEvent screenLayerClearedEvent = new ScreenLayerClearedEvent((Object)this);
        this.fireScreenLayerCleared(screenLayerClearedEvent);
    }

    public int hitTest(Point2D point, double tolerance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D point, double tolerance)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "ScreenLayer_InvalidTolerance", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return ScreenLayerNative.jni_HitTest(this.getHandle(), point.getX(), point.getY(), tolerance);
    }

    protected static ScreenLayer createInstance(long handle, Map map) {
        return new ScreenLayer(handle, map);
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    @Deprecated
    public synchronized void addSreenLayerAddedListeners(ScreenLayerAddedListener l) {
        this.addScreenLayerAddedListener(l);
    }

    public synchronized void addScreenLayerAddedListener(ScreenLayerAddedListener l) {
        if (this.m_screenLayerAddedListeners == null) {
            this.m_screenLayerAddedListeners = new Vector();
        }
        if (!this.m_screenLayerAddedListeners.contains(l)) {
            this.m_screenLayerAddedListeners.insertElementAt(l, 0);
        }
    }

    @Deprecated
    public synchronized void removeSreenLayerAddedListeners(ScreenLayerAddedListener l) {
        this.removeScreenLayerAddedListener(l);
    }

    public synchronized void removeScreenLayerAddedListener(ScreenLayerAddedListener l) {
        if (this.m_screenLayerAddedListeners != null && this.m_screenLayerAddedListeners.contains(l)) {
            this.m_screenLayerAddedListeners.remove(l);
        }
    }

    protected void fireScreenLayerAdded(ScreenLayerAddedEvent event) {
        if (this.m_screenLayerAddedListeners != null) {
            Vector vector = this.m_screenLayerAddedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ScreenLayerAddedListener)vector.elementAt(i)).screenLayerAdded(event);
            }
        }
    }

    @Deprecated
    public synchronized void addSreenLayerRemovedListeners(ScreenLayerRemovedListener l) {
        this.addScreenLayerRemovedListener(l);
    }

    public synchronized void addScreenLayerRemovedListener(ScreenLayerRemovedListener l) {
        if (this.m_screenLayerRemovedListeners == null) {
            this.m_screenLayerRemovedListeners = new Vector();
        }
        if (!this.m_screenLayerRemovedListeners.contains(l)) {
            this.m_screenLayerRemovedListeners.insertElementAt(l, 0);
        }
    }

    @Deprecated
    public synchronized void removeSreenLayerRemovedListeners(ScreenLayerRemovedListener l) {
        this.removeScreenLayerRemovedListener(l);
    }

    public synchronized void removeScreenLayerRemovedListener(ScreenLayerRemovedListener l) {
        if (this.m_screenLayerRemovedListeners != null && this.m_screenLayerRemovedListeners.contains(l)) {
            this.m_screenLayerRemovedListeners.remove(l);
        }
    }

    protected void fireScreenLayerRemoved(ScreenLayerRemovedEvent event) {
        if (this.m_screenLayerRemovedListeners != null) {
            Vector vector = this.m_screenLayerRemovedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ScreenLayerRemovedListener)vector.elementAt(i)).screenLayerRemoved(event);
            }
        }
    }

    @Deprecated
    public synchronized void addSreenLayerGeometryChangedListeners(ScreenLayerGeometryChangedListener l) {
        this.addScreenLayerGeometryChangedListener(l);
    }

    public synchronized void addScreenLayerGeometryChangedListener(ScreenLayerGeometryChangedListener l) {
        if (this.m_screenLayerGeometryChangedListeners == null) {
            this.m_screenLayerGeometryChangedListeners = new Vector();
        }
        if (!this.m_screenLayerGeometryChangedListeners.contains(l)) {
            this.m_screenLayerGeometryChangedListeners.insertElementAt(l, 0);
        }
    }

    @Deprecated
    public synchronized void removeSreenLayerGeometryChangedListeners(ScreenLayerGeometryChangedListener l) {
        this.removeScreenLayerGeometryChangedListener(l);
    }

    public synchronized void removeScreenLayerGeometryChangedListener(ScreenLayerGeometryChangedListener l) {
        if (this.m_screenLayerGeometryChangedListeners != null && this.m_screenLayerGeometryChangedListeners.contains(l)) {
            this.m_screenLayerGeometryChangedListeners.remove(l);
        }
    }

    protected void fireScreenLayerGeometryChanged(ScreenLayerGeometryChangedEvent event) {
        if (this.m_screenLayerGeometryChangedListeners != null) {
            Vector vector = this.m_screenLayerGeometryChangedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ScreenLayerGeometryChangedListener)vector.elementAt(i)).screenLayerGeometryChanged(event);
            }
        }
    }

    @Deprecated
    public synchronized void addSreenLayerTagChangedListeners(ScreenLayerTagChangedListener l) {
        this.addScreenLayerTagChangedListener(l);
    }

    public synchronized void addScreenLayerTagChangedListener(ScreenLayerTagChangedListener l) {
        if (this.m_screenLayerTagChangedListeners == null) {
            this.m_screenLayerTagChangedListeners = new Vector();
        }
        if (!this.m_screenLayerTagChangedListeners.contains(l)) {
            this.m_screenLayerTagChangedListeners.insertElementAt(l, 0);
        }
    }

    @Deprecated
    public synchronized void removeSreenLayerTagChangedListeners(ScreenLayerTagChangedListener l) {
        this.removeScreenLayerTagChangedListener(l);
    }

    public synchronized void removeScreenLayerTagChangedListener(ScreenLayerTagChangedListener l) {
        if (this.m_screenLayerTagChangedListeners != null && this.m_screenLayerTagChangedListeners.contains(l)) {
            this.m_screenLayerTagChangedListeners.remove(l);
        }
    }

    protected void fireScreenLayerTagChanged(ScreenLayerTagChangedEvent event) {
        if (this.m_screenLayerTagChangedListeners != null) {
            Vector vector = this.m_screenLayerTagChangedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ScreenLayerTagChangedListener)vector.elementAt(i)).screenLayerTagChanged(event);
            }
        }
    }

    @Deprecated
    public synchronized void addSreenLayerClearedListeners(ScreenLayerClearedListener l) {
        this.addScreenLayerClearedListener(l);
    }

    public synchronized void addScreenLayerClearedListener(ScreenLayerClearedListener l) {
        if (this.m_screenLayerClearedListeners == null) {
            this.m_screenLayerClearedListeners = new Vector();
        }
        if (!this.m_screenLayerClearedListeners.contains(l)) {
            this.m_screenLayerClearedListeners.insertElementAt(l, 0);
        }
    }

    @Deprecated
    public synchronized void removeSreenLayerClearedListeners(ScreenLayerClearedListener l) {
        this.removeScreenLayerClearedListener(l);
    }

    public synchronized void removeScreenLayerClearedListener(ScreenLayerClearedListener l) {
        if (this.m_screenLayerClearedListeners != null && this.m_screenLayerClearedListeners.contains(l)) {
            this.m_screenLayerClearedListeners.remove(l);
        }
    }

    protected void fireScreenLayerCleared(ScreenLayerClearedEvent event) {
        if (this.m_screenLayerClearedListeners != null) {
            Vector vector = this.m_screenLayerClearedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ScreenLayerClearedListener)vector.elementAt(i)).screenLayerCleared(event);
            }
        }
    }

    @Deprecated
    public synchronized void addScreenLayerVisibleChangedListeners(ScreenLayerVisibleChangedListener l) {
        this.addScreenLayerVisibleChangedListener(l);
    }

    public synchronized void addScreenLayerVisibleChangedListener(ScreenLayerVisibleChangedListener l) {
        if (this.m_screenLayerVisibleChangedListeners == null) {
            this.m_screenLayerVisibleChangedListeners = new Vector();
        }
        if (!this.m_screenLayerVisibleChangedListeners.contains(l)) {
            this.m_screenLayerVisibleChangedListeners.insertElementAt(l, 0);
        }
    }

    @Deprecated
    public synchronized void removeScreenLayerVisibleChangedListeners(ScreenLayerVisibleChangedListener l) {
        this.removeScreenLayerVisibleChangedListener(l);
    }

    public synchronized void removeScreenLayerVisibleChangedListener(ScreenLayerVisibleChangedListener l) {
        if (this.m_screenLayerVisibleChangedListeners != null && this.m_screenLayerVisibleChangedListeners.contains(l)) {
            this.m_screenLayerVisibleChangedListeners.remove(l);
        }
    }

    protected void fireScreenLayerVisibleChanged(ScreenLayerVisibleChangedEvent event) {
        if (this.m_screenLayerVisibleChangedListeners != null) {
            Vector vector = this.m_screenLayerVisibleChangedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ScreenLayerVisibleChangedListener)vector.elementAt(i)).visibleChanged(event);
            }
        }
    }

    private void reset() {
        ScreenLayerNative.jni_Reset(this.getHandle());
    }

    private void makeSureNativeObjectLive(com.supermap.data.InternalHandleDisposable obj) {
        InternalHandle.getHandle((com.supermap.data.InternalHandle)obj);
    }
}

