/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Layer;
import com.supermap.mapping.ThemeCustom;
import com.supermap.mapping.ThemeDotDensity;
import com.supermap.mapping.ThemeGraduatedSymbol;
import com.supermap.mapping.ThemeGraph;
import com.supermap.mapping.ThemeGridRange;
import com.supermap.mapping.ThemeGridUnique;
import com.supermap.mapping.ThemeLabel;
import com.supermap.mapping.ThemeNative;
import com.supermap.mapping.ThemeRange;
import com.supermap.mapping.ThemeType;
import com.supermap.mapping.ThemeUnique;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Theme
extends InternalHandleDisposable {
    ReentrantLock m_lock = new ReentrantLock();
    protected Layer m_layer = null;

    protected Theme() {
    }

    public ThemeType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeNative.jni_GetType(this.getHandle());
        return (ThemeType)InternalEnum.parseUGCValue(ThemeType.class, n);
    }

    public Map<String, String> getMemoryData() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMemoryData()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeNative.jni_GetMemoryDataCount(this.getHandle());
        HashMap<String, String> hashMap = null;
        if (n > 0) {
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            ThemeNative.jni_GetMemoryData(this.getHandle(), stringArray, stringArray2);
            hashMap = new HashMap<String, String>();
            for (int i = 0; i < n; ++i) {
                hashMap.put(stringArray[i], stringArray2[i]);
            }
        }
        return hashMap;
    }

    public void setMemoryData(Map<String, String> map) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMemoryData(java.util.Map<?, ?> map)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (map == null) {
            ThemeNative.jni_SetMemoryData(this.getHandle(), null, null);
        } else {
            Object[] objectArray = map.keySet().toArray();
            int n = objectArray.length;
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)objectArray[i];
                stringArray2[i] = map.get(stringArray[i]);
            }
            ThemeNative.jni_SetMemoryData(this.getHandle(), stringArray, stringArray2);
        }
    }

    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (xml != null && xml.trim().length() != 0) {
            bl = ThemeNative.jni_FromXML(this.getHandle(), xml, 0);
        }
        return bl;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeNative.jni_ToXML(this.getHandle(), 0);
    }

    public abstract String toString();

    protected void clearHandle() {
    }

    static final Theme createInstance(long handle, Layer layer) {
        if (handle == 0L) {
            return null;
        }
        int n = ThemeNative.jni_GetType(handle);
        ThemeType themeType = null;
        try {
            themeType = (ThemeType)InternalEnum.parseUGCValue(ThemeType.class, n);
        }
        catch (RuntimeException runtimeException) {
            System.out.println("\u6682\u4e0d\u652f\u6301\u7684\u4e13\u9898\u56fe\u7c7b\u578b");
            return null;
        }
        Theme theme = null;
        if (themeType.equals((Object)ThemeType.UNIQUE)) {
            theme = new ThemeUnique(handle, false);
        } else if (themeType.equals((Object)ThemeType.LABEL)) {
            theme = new ThemeLabel(handle, false);
        } else if (themeType.equals((Object)ThemeType.RANGE)) {
            theme = new ThemeRange(handle, false);
        } else if (themeType.equals((Object)ThemeType.GRIDRANGE)) {
            theme = new ThemeGridRange(handle, false);
        } else if (themeType.equals((Object)ThemeType.GRIDUNIQUE)) {
            theme = new ThemeGridUnique(handle, false);
        } else if (themeType.equals((Object)ThemeType.DOTDENSITY)) {
            theme = new ThemeDotDensity(handle, false);
        } else if (themeType.equals((Object)ThemeType.GRADUATEDSYMBOL)) {
            theme = new ThemeGraduatedSymbol(handle, false);
        } else if (themeType.equals((Object)ThemeType.GRAPH)) {
            theme = new ThemeGraph(handle, false);
        } else if (themeType.equals((Object)ThemeType.CUSTOM)) {
            theme = new ThemeCustom(handle, false);
        }
        if (theme != null && layer != null) {
            theme.m_layer = layer;
            theme.m_lock = layer.m_lock;
        }
        return theme;
    }

    static final Theme clone(Theme theme) {
        Theme theme2 = null;
        ThemeType themeType = theme.getType();
        if (themeType.equals((Object)ThemeType.LABEL)) {
            theme2 = new ThemeLabel((ThemeLabel)theme);
        } else if (themeType.equals((Object)ThemeType.UNIQUE)) {
            theme2 = new ThemeUnique((ThemeUnique)theme);
        } else if (themeType.equals((Object)ThemeType.RANGE)) {
            theme2 = new ThemeRange((ThemeRange)theme);
        } else if (themeType.equals((Object)ThemeType.GRIDRANGE)) {
            theme2 = new ThemeGridRange((ThemeGridRange)theme);
        } else if (themeType.equals((Object)ThemeType.GRIDUNIQUE)) {
            theme2 = new ThemeGridUnique((ThemeGridUnique)theme);
        } else if (themeType.equals((Object)ThemeType.DOTDENSITY)) {
            theme2 = new ThemeDotDensity((ThemeDotDensity)theme);
        } else if (themeType.equals((Object)ThemeType.GRADUATEDSYMBOL)) {
            theme2 = new ThemeGraduatedSymbol((ThemeGraduatedSymbol)theme);
        } else if (themeType.equals((Object)ThemeType.GRAPH)) {
            theme2 = new ThemeGraph((ThemeGraph)theme);
        } else if (themeType.equals((Object)ThemeType.CUSTOM)) {
            theme2 = new ThemeCustom((ThemeCustom)theme);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)theme));
        return theme2;
    }
}

