/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy;

import java.io.File;
import java.io.FileFilter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;

public final class JarLoader {
    private static boolean isLoad = false;

    public JarLoader() {
        JarLoader.loadJars();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadJars() {
        if (isLoad) {
            return;
        }
        String jarName = JarLoader.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        File jarPath = null;
        try {
            jarPath = new File(URLDecoder.decode(jarName, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return;
        }
        String jarParentPath = jarPath.getParent();
        File[] files = new File(jarParentPath).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().toLowerCase().endsWith(".jar");
            }
        });
        Method method = null;
        try {
            method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        }
        catch (NoSuchMethodException | SecurityException e1) {
            e1.printStackTrace();
            return;
        }
        boolean accessible = method.isAccessible();
        method.setAccessible(true);
        ClassLoader classLoader = method.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (!(classLoader instanceof URLClassLoader)) {
            throw new RuntimeException("class loader must be URLClassLoader");
        }
        try {
            for (File file : files) {
                if (file.getName().compareToIgnoreCase(jarPath.getName()) == 0) continue;
                method.invoke((Object)classLoader, file.toURI().toURL());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            method.setAccessible(accessible);
        }
        isLoad = true;
    }
}

