/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer.impl;

import com.supermap.jsuperpy.serializer.DataSerializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DoubleArraySerializer
extends DataSerializer {
    @Override
    public Class getValueClass() {
        return double[].class;
    }

    @Override
    public String getTypeName() {
        return "dL";
    }

    @Override
    public byte[] encode(Object value) {
        if (value instanceof double[]) {
            double[] values = (double[])value;
            int count = values.length;
            ByteBuffer byteBuffer = ByteBuffer.allocate(count * 8).order(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < count; ++i) {
                byteBuffer.putDouble(values[i]);
            }
            return byteBuffer.array();
        }
        if (value instanceof Double[]) {
            Double[] values = (Double[])value;
            int count = values.length;
            ByteBuffer byteBuffer = ByteBuffer.allocate(count * 8).order(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < count; ++i) {
                byteBuffer.putDouble(values[i]);
            }
            return byteBuffer.array();
        }
        return new byte[0];
    }

    public double[] decode(byte[] bys) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bys);
        double[] values = new double[byteBuffer.limit() / 8];
        for (int i = 0; i < values.length; ++i) {
            values[i] = byteBuffer.getDouble();
        }
        return values;
    }
}

