/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer.impl;

import com.supermap.jsuperpy.serializer.DataSerializer;
import com.supermap.jsuperpy.serializer.DataSerializers;
import com.supermap.jsuperpy.serializer.SerializerUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class MapSerializer
extends DataSerializer {
    @Override
    public Class getValueClass() {
        return Map.class;
    }

    @Override
    public String getTypeName() {
        return "M";
    }

    private void writeBytesAndLength(OutputStream stream, byte[] bytes) {
        try {
            stream.write(SerializerUtil.encodeInt(bytes.length));
            stream.write(bytes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private byte[] readBytesAndLength(InputStream stream) {
        try {
            int nLenBytes;
            byte[] bytes;
            byte[] len = new byte[4];
            if (stream.read(len) == 4 && stream.read(bytes = new byte[nLenBytes = SerializerUtil.decodeInt(len).intValue()]) == nLenBytes) {
                return bytes;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new byte[0];
    }

    @Override
    public byte[] encode(Object value) {
        if (value instanceof Map) {
            Map values = (Map)value;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (Object key : values.keySet()) {
                this.writeBytesAndLength(stream, DataSerializers.serialize(key));
                this.writeBytesAndLength(stream, DataSerializers.serialize(values.get(key)));
            }
            return stream.toByteArray();
        }
        return new byte[0];
    }

    @Override
    public Map<Object, Object> decode(byte[] bys) {
        byte[] valueBytes;
        byte[] keyBytes;
        ByteArrayInputStream stream = new ByteArrayInputStream(bys);
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        while ((keyBytes = this.readBytesAndLength(stream)).length != 0 && (valueBytes = this.readBytesAndLength(stream)).length != 0) {
            results.put(DataSerializers.deserialize(keyBytes), DataSerializer.deserialize(valueBytes));
        }
        return results;
    }
}

